/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the first IP address in an HTTP header as an aggregate key for a rate-based rule. Each distinct forwarded
 * IP address contributes to the aggregation instance.
 * </p>
 * <p>
 * This setting is used only in the <code>RateBasedStatementCustomKey</code> specification of a rate-based rule
 * statement. When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one
 * other key to use. You can aggregate on only the forwarded IP address by specifying <code>FORWARDED_IP</code> in your
 * rate-based statement's <code>AggregateKeyType</code>.
 * </p>
 * <p>
 * This data type supports using the forwarded IP address in the web request aggregation for a rate-based rule, in
 * <code>RateBasedStatementCustomKey</code>. The JSON specification for using the forwarded IP address doesn't
 * explicitly use this data type.
 * </p>
 * <p>
 * JSON specification: <code>"ForwardedIP": {}</code>
 * </p>
 * <p>
 * When you use this specification, you must also configure the forwarded IP address in the rate-based statement's
 * <code>ForwardedIPConfig</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RateLimitForwardedIP implements SdkPojo, Serializable,
        ToCopyableBuilder<RateLimitForwardedIP.Builder, RateLimitForwardedIP> {
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList());

    private static final long serialVersionUID = 1L;

    private RateLimitForwardedIP(BuilderImpl builder) {
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RateLimitForwardedIP)) {
            return false;
        }
        return true;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RateLimitForwardedIP").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RateLimitForwardedIP> {
    }

    static final class BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(RateLimitForwardedIP model) {
        }

        @Override
        public RateLimitForwardedIP build() {
            return new RateLimitForwardedIP(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
