/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.wafv2.model.AssociateWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.AssociateWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.CheckCapacityRequest;
import software.amazon.awssdk.services.wafv2.model.CheckCapacityResponse;
import software.amazon.awssdk.services.wafv2.model.CreateApiKeyRequest;
import software.amazon.awssdk.services.wafv2.model.CreateApiKeyResponse;
import software.amazon.awssdk.services.wafv2.model.CreateIpSetRequest;
import software.amazon.awssdk.services.wafv2.model.CreateIpSetResponse;
import software.amazon.awssdk.services.wafv2.model.CreateRegexPatternSetRequest;
import software.amazon.awssdk.services.wafv2.model.CreateRegexPatternSetResponse;
import software.amazon.awssdk.services.wafv2.model.CreateRuleGroupRequest;
import software.amazon.awssdk.services.wafv2.model.CreateRuleGroupResponse;
import software.amazon.awssdk.services.wafv2.model.CreateWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.CreateWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteFirewallManagerRuleGroupsRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteFirewallManagerRuleGroupsResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteIpSetRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteIpSetResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteLoggingConfigurationRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteLoggingConfigurationResponse;
import software.amazon.awssdk.services.wafv2.model.DeletePermissionPolicyRequest;
import software.amazon.awssdk.services.wafv2.model.DeletePermissionPolicyResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteRegexPatternSetRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteRegexPatternSetResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteRuleGroupRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteRuleGroupResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.DescribeAllManagedProductsRequest;
import software.amazon.awssdk.services.wafv2.model.DescribeAllManagedProductsResponse;
import software.amazon.awssdk.services.wafv2.model.DescribeManagedProductsByVendorRequest;
import software.amazon.awssdk.services.wafv2.model.DescribeManagedProductsByVendorResponse;
import software.amazon.awssdk.services.wafv2.model.DescribeManagedRuleGroupRequest;
import software.amazon.awssdk.services.wafv2.model.DescribeManagedRuleGroupResponse;
import software.amazon.awssdk.services.wafv2.model.DisassociateWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.DisassociateWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.GenerateMobileSdkReleaseUrlRequest;
import software.amazon.awssdk.services.wafv2.model.GenerateMobileSdkReleaseUrlResponse;
import software.amazon.awssdk.services.wafv2.model.GetDecryptedApiKeyRequest;
import software.amazon.awssdk.services.wafv2.model.GetDecryptedApiKeyResponse;
import software.amazon.awssdk.services.wafv2.model.GetIpSetRequest;
import software.amazon.awssdk.services.wafv2.model.GetIpSetResponse;
import software.amazon.awssdk.services.wafv2.model.GetLoggingConfigurationRequest;
import software.amazon.awssdk.services.wafv2.model.GetLoggingConfigurationResponse;
import software.amazon.awssdk.services.wafv2.model.GetManagedRuleSetRequest;
import software.amazon.awssdk.services.wafv2.model.GetManagedRuleSetResponse;
import software.amazon.awssdk.services.wafv2.model.GetMobileSdkReleaseRequest;
import software.amazon.awssdk.services.wafv2.model.GetMobileSdkReleaseResponse;
import software.amazon.awssdk.services.wafv2.model.GetPermissionPolicyRequest;
import software.amazon.awssdk.services.wafv2.model.GetPermissionPolicyResponse;
import software.amazon.awssdk.services.wafv2.model.GetRateBasedStatementManagedKeysRequest;
import software.amazon.awssdk.services.wafv2.model.GetRateBasedStatementManagedKeysResponse;
import software.amazon.awssdk.services.wafv2.model.GetRegexPatternSetRequest;
import software.amazon.awssdk.services.wafv2.model.GetRegexPatternSetResponse;
import software.amazon.awssdk.services.wafv2.model.GetRuleGroupRequest;
import software.amazon.awssdk.services.wafv2.model.GetRuleGroupResponse;
import software.amazon.awssdk.services.wafv2.model.GetSampledRequestsRequest;
import software.amazon.awssdk.services.wafv2.model.GetSampledRequestsResponse;
import software.amazon.awssdk.services.wafv2.model.GetWebAclForResourceRequest;
import software.amazon.awssdk.services.wafv2.model.GetWebAclForResourceResponse;
import software.amazon.awssdk.services.wafv2.model.GetWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.GetWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.ListApiKeysRequest;
import software.amazon.awssdk.services.wafv2.model.ListApiKeysResponse;
import software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupVersionsRequest;
import software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse;
import software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupsRequest;
import software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupsResponse;
import software.amazon.awssdk.services.wafv2.model.ListIpSetsRequest;
import software.amazon.awssdk.services.wafv2.model.ListIpSetsResponse;
import software.amazon.awssdk.services.wafv2.model.ListLoggingConfigurationsRequest;
import software.amazon.awssdk.services.wafv2.model.ListLoggingConfigurationsResponse;
import software.amazon.awssdk.services.wafv2.model.ListManagedRuleSetsRequest;
import software.amazon.awssdk.services.wafv2.model.ListManagedRuleSetsResponse;
import software.amazon.awssdk.services.wafv2.model.ListMobileSdkReleasesRequest;
import software.amazon.awssdk.services.wafv2.model.ListMobileSdkReleasesResponse;
import software.amazon.awssdk.services.wafv2.model.ListRegexPatternSetsRequest;
import software.amazon.awssdk.services.wafv2.model.ListRegexPatternSetsResponse;
import software.amazon.awssdk.services.wafv2.model.ListResourcesForWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.ListResourcesForWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.ListRuleGroupsRequest;
import software.amazon.awssdk.services.wafv2.model.ListRuleGroupsResponse;
import software.amazon.awssdk.services.wafv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.wafv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.wafv2.model.ListWebAcLsRequest;
import software.amazon.awssdk.services.wafv2.model.ListWebAcLsResponse;
import software.amazon.awssdk.services.wafv2.model.PutLoggingConfigurationRequest;
import software.amazon.awssdk.services.wafv2.model.PutLoggingConfigurationResponse;
import software.amazon.awssdk.services.wafv2.model.PutManagedRuleSetVersionsRequest;
import software.amazon.awssdk.services.wafv2.model.PutManagedRuleSetVersionsResponse;
import software.amazon.awssdk.services.wafv2.model.PutPermissionPolicyRequest;
import software.amazon.awssdk.services.wafv2.model.PutPermissionPolicyResponse;
import software.amazon.awssdk.services.wafv2.model.TagResourceRequest;
import software.amazon.awssdk.services.wafv2.model.TagResourceResponse;
import software.amazon.awssdk.services.wafv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.wafv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.wafv2.model.UpdateIpSetRequest;
import software.amazon.awssdk.services.wafv2.model.UpdateIpSetResponse;
import software.amazon.awssdk.services.wafv2.model.UpdateManagedRuleSetVersionExpiryDateRequest;
import software.amazon.awssdk.services.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse;
import software.amazon.awssdk.services.wafv2.model.UpdateRegexPatternSetRequest;
import software.amazon.awssdk.services.wafv2.model.UpdateRegexPatternSetResponse;
import software.amazon.awssdk.services.wafv2.model.UpdateRuleGroupRequest;
import software.amazon.awssdk.services.wafv2.model.UpdateRuleGroupResponse;
import software.amazon.awssdk.services.wafv2.model.UpdateWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.UpdateWebAclResponse;

/**
 * Service client for accessing WAFV2 asynchronously. This can be created using the static {@link #builder()} method.
 *
 * <fullname>WAF</fullname> <note>
 * <p>
 * This is the latest version of the <b>WAF</b> API, released in November, 2019. The names of the entities that you use
 * to access this API, like endpoints and namespaces, all have the versioning information added, like "V2" or "v2", to
 * distinguish from the prior version. We recommend migrating your resources to this version, because it has a number of
 * significant improvements.
 * </p>
 * <p>
 * If you used WAF prior to this release, you can't use this WAFV2 API to access any WAF resources that you created
 * before. You can access your old rules, web ACLs, and other WAF resources only through the WAF Classic APIs. The WAF
 * Classic APIs have retained the prior names, endpoints, and namespaces.
 * </p>
 * <p>
 * For information, including how to migrate your WAF resources to this version, see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>.
 * </p>
 * </note>
 * <p>
 * WAF is a web application firewall that lets you monitor the HTTP and HTTPS requests that are forwarded to an Amazon
 * CloudFront distribution, Amazon API Gateway REST API, Application Load Balancer, AppSync GraphQL API, Amazon Cognito
 * user pool, App Runner service, or Amazon Web Services Verified Access instance. WAF also lets you control access to
 * your content, to protect the Amazon Web Services resource that WAF is monitoring. Based on conditions that you
 * specify, such as the IP addresses that requests originate from or the values of query strings, the protected resource
 * responds to requests with either the requested content, an HTTP 403 status code (Forbidden), or with a custom
 * response.
 * </p>
 * <p>
 * This API guide is for developers who need detailed information about WAF API actions, data types, and errors. For
 * detailed information about WAF features and guidance for configuring and using WAF, see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html">WAF Developer Guide</a>.
 * </p>
 * <p>
 * You can make calls using the endpoints listed in <a href="https://docs.aws.amazon.com/general/latest/gr/waf.html">WAF
 * endpoints and quotas</a>.
 * </p>
 * <ul>
 * <li>
 * <p>
 * For regional applications, you can use any of the endpoints in the list. A regional application can be an Application
 * Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App
 * Runner service, or an Amazon Web Services Verified Access instance.
 * </p>
 * </li>
 * <li>
 * <p>
 * For Amazon CloudFront applications, you must use the API endpoint listed for US East (N. Virginia): us-east-1.
 * </p>
 * </li>
 * </ul>
 * <p>
 * Alternatively, you can use one of the Amazon Web Services SDKs to access an API that's tailored to the programming
 * language or platform that you're using. For more information, see <a href="http://aws.amazon.com/tools/#SDKs">Amazon
 * Web Services SDKs</a>.
 * </p>
 * <p>
 * We currently provide two versions of the WAF API: this API and the prior versions, the classic WAF APIs. This new API
 * provides the same functionality as the older versions, with the following major improvements:
 * </p>
 * <ul>
 * <li>
 * <p>
 * You use one API for both global and regional applications. Where you need to distinguish the scope, you specify a
 * <code>Scope</code> parameter and set it to <code>CLOUDFRONT</code> or <code>REGIONAL</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * You can define a web ACL or rule group with a single call, and update it with a single call. You define all rule
 * specifications in JSON format, and pass them to your rule group or web ACL calls.
 * </p>
 * </li>
 * <li>
 * <p>
 * The limits WAF places on the use of rules more closely reflects the cost of running each type of rule. Rule groups
 * include capacity settings, so you know the maximum cost of a rule group when you use it.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface Wafv2AsyncClient extends AwsClient {
    String SERVICE_NAME = "wafv2";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "wafv2";

    /**
     * <p>
     * Associates a web ACL with a regional application resource, to protect the resource. A regional application can be
     * an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito
     * user pool, an App Runner service, or an Amazon Web Services Verified Access instance.
     * </p>
     * <p>
     * For Amazon CloudFront, don't use this call. Instead, use your CloudFront distribution configuration. To associate
     * a web ACL, in the CloudFront call <code>UpdateDistribution</code>, set the web ACL ID to the Amazon Resource Name
     * (ARN) of the web ACL. For information, see <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html"
     * >UpdateDistribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes
     * everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but
     * there might be a brief period of inconsistency when the changes have arrived in some places and not in others.
     * So, for example, if you change a rule action setting, the action might be the old action in one area and the new
     * action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might
     * briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you
     * first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already
     * associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     * </p>
     *
     * @param associateWebAclRequest
     * @return A Java Future containing the result of the AssociateWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafUnavailableEntityException WAF couldn’t retrieve a resource that you specified for this operation.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate. Verify the
     *         resources that you are specifying in your request parameters and then retry the operation.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.AssociateWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/AssociateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateWebAclResponse> associateWebACL(AssociateWebAclRequest associateWebAclRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a web ACL with a regional application resource, to protect the resource. A regional application can be
     * an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito
     * user pool, an App Runner service, or an Amazon Web Services Verified Access instance.
     * </p>
     * <p>
     * For Amazon CloudFront, don't use this call. Instead, use your CloudFront distribution configuration. To associate
     * a web ACL, in the CloudFront call <code>UpdateDistribution</code>, set the web ACL ID to the Amazon Resource Name
     * (ARN) of the web ACL. For information, see <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html"
     * >UpdateDistribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes
     * everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but
     * there might be a brief period of inconsistency when the changes have arrived in some places and not in others.
     * So, for example, if you change a rule action setting, the action might be the old action in one area and the new
     * action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might
     * briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you
     * first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already
     * associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateWebAclRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateWebAclRequest#builder()}
     * </p>
     *
     * @param associateWebAclRequest
     *        A {@link Consumer} that will call methods on {@link AssociateWebACLRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AssociateWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafUnavailableEntityException WAF couldn’t retrieve a resource that you specified for this operation.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate. Verify the
     *         resources that you are specifying in your request parameters and then retry the operation.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.AssociateWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/AssociateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateWebAclResponse> associateWebACL(
            Consumer<AssociateWebAclRequest.Builder> associateWebAclRequest) {
        return associateWebACL(AssociateWebAclRequest.builder().applyMutation(associateWebAclRequest).build());
    }

    /**
     * <p>
     * Returns the web ACL capacity unit (WCU) requirements for a specified scope and set of rules. You can use this to
     * check the capacity requirements for the rules you want to use in a <a>RuleGroup</a> or <a>WebACL</a>.
     * </p>
     * <p>
     * WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and
     * web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule.
     * Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule
     * group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-waf-capacity-units.html">WAF web ACL capacity
     * units (WCU)</a> in the <i>WAF Developer Guide</i>.
     * </p>
     *
     * @param checkCapacityRequest
     * @return A Java Future containing the result of the CheckCapacity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafLimitsExceededException WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon
     *         Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF
     *         Developer Guide</i>.</li>
     *         <li>WafInvalidResourceException WAF couldn’t perform the operation because the resource that you
     *         requested isn’t valid. Check the resource, and try again.</li>
     *         <li>WafUnavailableEntityException WAF couldn’t retrieve a resource that you specified for this operation.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate. Verify the
     *         resources that you are specifying in your request parameters and then retry the operation.</li>
     *         <li>WafSubscriptionNotFoundException You tried to use a managed rule group that's available by
     *         subscription, but you aren't subscribed to it yet.</li>
     *         <li>WafExpiredManagedRuleGroupVersionException The operation failed because the specified version for the
     *         managed rule group has expired. You can retrieve the available versions for the managed rule group by
     *         calling <a>ListAvailableManagedRuleGroupVersions</a>.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.CheckCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CheckCapacity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CheckCapacityResponse> checkCapacity(CheckCapacityRequest checkCapacityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the web ACL capacity unit (WCU) requirements for a specified scope and set of rules. You can use this to
     * check the capacity requirements for the rules you want to use in a <a>RuleGroup</a> or <a>WebACL</a>.
     * </p>
     * <p>
     * WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and
     * web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule.
     * Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule
     * group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-waf-capacity-units.html">WAF web ACL capacity
     * units (WCU)</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CheckCapacityRequest.Builder} avoiding the need to
     * create one manually via {@link CheckCapacityRequest#builder()}
     * </p>
     *
     * @param checkCapacityRequest
     *        A {@link Consumer} that will call methods on {@link CheckCapacityRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CheckCapacity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafLimitsExceededException WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon
     *         Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF
     *         Developer Guide</i>.</li>
     *         <li>WafInvalidResourceException WAF couldn’t perform the operation because the resource that you
     *         requested isn’t valid. Check the resource, and try again.</li>
     *         <li>WafUnavailableEntityException WAF couldn’t retrieve a resource that you specified for this operation.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate. Verify the
     *         resources that you are specifying in your request parameters and then retry the operation.</li>
     *         <li>WafSubscriptionNotFoundException You tried to use a managed rule group that's available by
     *         subscription, but you aren't subscribed to it yet.</li>
     *         <li>WafExpiredManagedRuleGroupVersionException The operation failed because the specified version for the
     *         managed rule group has expired. You can retrieve the available versions for the managed rule group by
     *         calling <a>ListAvailableManagedRuleGroupVersions</a>.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.CheckCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CheckCapacity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CheckCapacityResponse> checkCapacity(Consumer<CheckCapacityRequest.Builder> checkCapacityRequest) {
        return checkCapacity(CheckCapacityRequest.builder().applyMutation(checkCapacityRequest).build());
    }

    /**
     * <p>
     * Creates an API key that contains a set of token domains.
     * </p>
     * <p>
     * API keys are required for the integration of the CAPTCHA API in your JavaScript client applications. The API lets
     * you customize the placement and characteristics of the CAPTCHA puzzle for your end users. For more information
     * about the CAPTCHA JavaScript integration, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client
     * application integration</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * <p>
     * You can use a single key for up to 5 domains. After you generate a key, you can copy it for use in your
     * JavaScript integration.
     * </p>
     *
     * @param createApiKeyRequest
     * @return A Java Future containing the result of the CreateAPIKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>WafLimitsExceededException WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon
     *         Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF
     *         Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.CreateAPIKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateAPIKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateApiKeyResponse> createAPIKey(CreateApiKeyRequest createApiKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an API key that contains a set of token domains.
     * </p>
     * <p>
     * API keys are required for the integration of the CAPTCHA API in your JavaScript client applications. The API lets
     * you customize the placement and characteristics of the CAPTCHA puzzle for your end users. For more information
     * about the CAPTCHA JavaScript integration, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client
     * application integration</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * <p>
     * You can use a single key for up to 5 domains. After you generate a key, you can copy it for use in your
     * JavaScript integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApiKeyRequest.Builder} avoiding the need to
     * create one manually via {@link CreateApiKeyRequest#builder()}
     * </p>
     *
     * @param createApiKeyRequest
     *        A {@link Consumer} that will call methods on {@link CreateAPIKeyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateAPIKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>WafLimitsExceededException WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon
     *         Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF
     *         Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.CreateAPIKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateAPIKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateApiKeyResponse> createAPIKey(Consumer<CreateApiKeyRequest.Builder> createApiKeyRequest) {
        return createAPIKey(CreateApiKeyRequest.builder().applyMutation(createApiKeyRequest).build());
    }

    /**
     * <p>
     * Creates an <a>IPSet</a>, which you use to identify web requests that originate from specific IP addresses or
     * ranges of IP addresses. For example, if you're receiving a lot of requests from a ranges of IP addresses, you can
     * configure WAF to block them using an IPSet that lists those IP addresses.
     * </p>
     *
     * @param createIpSetRequest
     * @return A Java Future containing the result of the CreateIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafDuplicateItemException WAF couldn’t perform the operation because the resource that you tried to
     *         save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon
     *         Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF
     *         Developer Guide</i>.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.CreateIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIpSetResponse> createIPSet(CreateIpSetRequest createIpSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an <a>IPSet</a>, which you use to identify web requests that originate from specific IP addresses or
     * ranges of IP addresses. For example, if you're receiving a lot of requests from a ranges of IP addresses, you can
     * configure WAF to block them using an IPSet that lists those IP addresses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIpSetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateIpSetRequest#builder()}
     * </p>
     *
     * @param createIpSetRequest
     *        A {@link Consumer} that will call methods on {@link CreateIPSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafDuplicateItemException WAF couldn’t perform the operation because the resource that you tried to
     *         save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon
     *         Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF
     *         Developer Guide</i>.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.CreateIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIpSetResponse> createIPSet(Consumer<CreateIpSetRequest.Builder> createIpSetRequest) {
        return createIPSet(CreateIpSetRequest.builder().applyMutation(createIpSetRequest).build());
    }

    /**
     * <p>
     * Creates a <a>RegexPatternSet</a>, which you reference in a <a>RegexPatternSetReferenceStatement</a>, to have WAF
     * inspect a web request component for the specified patterns.
     * </p>
     *
     * @param createRegexPatternSetRequest
     * @return A Java Future containing the result of the CreateRegexPatternSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafDuplicateItemException WAF couldn’t perform the operation because the resource that you tried to
     *         save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon
     *         Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF
     *         Developer Guide</i>.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.CreateRegexPatternSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateRegexPatternSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateRegexPatternSetResponse> createRegexPatternSet(
            CreateRegexPatternSetRequest createRegexPatternSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <a>RegexPatternSet</a>, which you reference in a <a>RegexPatternSetReferenceStatement</a>, to have WAF
     * inspect a web request component for the specified patterns.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRegexPatternSetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRegexPatternSetRequest#builder()}
     * </p>
     *
     * @param createRegexPatternSetRequest
     *        A {@link Consumer} that will call methods on {@link CreateRegexPatternSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateRegexPatternSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafDuplicateItemException WAF couldn’t perform the operation because the resource that you tried to
     *         save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon
     *         Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF
     *         Developer Guide</i>.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.CreateRegexPatternSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateRegexPatternSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateRegexPatternSetResponse> createRegexPatternSet(
            Consumer<CreateRegexPatternSetRequest.Builder> createRegexPatternSetRequest) {
        return createRegexPatternSet(CreateRegexPatternSetRequest.builder().applyMutation(createRegexPatternSetRequest).build());
    }

    /**
     * <p>
     * Creates a <a>RuleGroup</a> per the specifications provided.
     * </p>
     * <p>
     * A rule group defines a collection of rules to inspect and control web requests that you can use in a
     * <a>WebACL</a>. When you create a rule group, you define an immutable capacity limit. If you update a rule group,
     * you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity
     * requirements.
     * </p>
     *
     * @param createRuleGroupRequest
     * @return A Java Future containing the result of the CreateRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafDuplicateItemException WAF couldn’t perform the operation because the resource that you tried to
     *         save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon
     *         Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF
     *         Developer Guide</i>.</li>
     *         <li>WafUnavailableEntityException WAF couldn’t retrieve a resource that you specified for this operation.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate. Verify the
     *         resources that you are specifying in your request parameters and then retry the operation.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafSubscriptionNotFoundException You tried to use a managed rule group that's available by
     *         subscription, but you aren't subscribed to it yet.</li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.CreateRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRuleGroupResponse> createRuleGroup(CreateRuleGroupRequest createRuleGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <a>RuleGroup</a> per the specifications provided.
     * </p>
     * <p>
     * A rule group defines a collection of rules to inspect and control web requests that you can use in a
     * <a>WebACL</a>. When you create a rule group, you define an immutable capacity limit. If you update a rule group,
     * you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity
     * requirements.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRuleGroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateRuleGroupRequest#builder()}
     * </p>
     *
     * @param createRuleGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateRuleGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafDuplicateItemException WAF couldn’t perform the operation because the resource that you tried to
     *         save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon
     *         Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF
     *         Developer Guide</i>.</li>
     *         <li>WafUnavailableEntityException WAF couldn’t retrieve a resource that you specified for this operation.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate. Verify the
     *         resources that you are specifying in your request parameters and then retry the operation.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafSubscriptionNotFoundException You tried to use a managed rule group that's available by
     *         subscription, but you aren't subscribed to it yet.</li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.CreateRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRuleGroupResponse> createRuleGroup(
            Consumer<CreateRuleGroupRequest.Builder> createRuleGroupRequest) {
        return createRuleGroup(CreateRuleGroupRequest.builder().applyMutation(createRuleGroupRequest).build());
    }

    /**
     * <p>
     * Creates a <a>WebACL</a> per the specifications provided.
     * </p>
     * <p>
     * A web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action
     * defined (allow, block, or count) for requests that match the statement of the rule. In the web ACL, you assign a
     * default action to take (allow, block) for any request that does not match any of the rules. The rules in a web
     * ACL can be a combination of the types <a>Rule</a>, <a>RuleGroup</a>, and managed rule group. You can associate a
     * web ACL with one or more Amazon Web Services resources to protect. The resources can be an Amazon CloudFront
     * distribution, an Amazon API Gateway REST API, an Application Load Balancer, an AppSync GraphQL API, an Amazon
     * Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance.
     * </p>
     *
     * @param createWebAclRequest
     * @return A Java Future containing the result of the CreateWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafDuplicateItemException WAF couldn’t perform the operation because the resource that you tried to
     *         save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon
     *         Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF
     *         Developer Guide</i>.</li>
     *         <li>WafInvalidResourceException WAF couldn’t perform the operation because the resource that you
     *         requested isn’t valid. Check the resource, and try again.</li>
     *         <li>WafUnavailableEntityException WAF couldn’t retrieve a resource that you specified for this operation.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate. Verify the
     *         resources that you are specifying in your request parameters and then retry the operation.</li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafSubscriptionNotFoundException You tried to use a managed rule group that's available by
     *         subscription, but you aren't subscribed to it yet.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>WafConfigurationWarningException The operation failed because you are inspecting the web request
     *         body, headers, or cookies without specifying how to handle oversize components. Rules that inspect the
     *         body must either provide an <code>OversizeHandling</code> configuration or they must be preceded by a
     *         <code>SizeConstraintStatement</code> that blocks the body content from being too large. Rules that
     *         inspect the headers or cookies must provide an <code>OversizeHandling</code> configuration. </p>
     *         <p>
     *         Provide the handling configuration and retry your operation.
     *         </p>
     *         <p>
     *         Alternately, you can suppress this warning by adding the following tag to the resource that you provide
     *         to this operation: <code>Tag</code> (key:<code>WAF:OversizeFieldsHandlingConstraintOptOut</code>, value:
     *         <code>true</code>).</li>
     *         <li>WafExpiredManagedRuleGroupVersionException The operation failed because the specified version for the
     *         managed rule group has expired. You can retrieve the available versions for the managed rule group by
     *         calling <a>ListAvailableManagedRuleGroupVersions</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.CreateWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWebAclResponse> createWebACL(CreateWebAclRequest createWebAclRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <a>WebACL</a> per the specifications provided.
     * </p>
     * <p>
     * A web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action
     * defined (allow, block, or count) for requests that match the statement of the rule. In the web ACL, you assign a
     * default action to take (allow, block) for any request that does not match any of the rules. The rules in a web
     * ACL can be a combination of the types <a>Rule</a>, <a>RuleGroup</a>, and managed rule group. You can associate a
     * web ACL with one or more Amazon Web Services resources to protect. The resources can be an Amazon CloudFront
     * distribution, an Amazon API Gateway REST API, an Application Load Balancer, an AppSync GraphQL API, an Amazon
     * Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWebAclRequest.Builder} avoiding the need to
     * create one manually via {@link CreateWebAclRequest#builder()}
     * </p>
     *
     * @param createWebAclRequest
     *        A {@link Consumer} that will call methods on {@link CreateWebACLRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafDuplicateItemException WAF couldn’t perform the operation because the resource that you tried to
     *         save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon
     *         Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF
     *         Developer Guide</i>.</li>
     *         <li>WafInvalidResourceException WAF couldn’t perform the operation because the resource that you
     *         requested isn’t valid. Check the resource, and try again.</li>
     *         <li>WafUnavailableEntityException WAF couldn’t retrieve a resource that you specified for this operation.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate. Verify the
     *         resources that you are specifying in your request parameters and then retry the operation.</li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafSubscriptionNotFoundException You tried to use a managed rule group that's available by
     *         subscription, but you aren't subscribed to it yet.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>WafConfigurationWarningException The operation failed because you are inspecting the web request
     *         body, headers, or cookies without specifying how to handle oversize components. Rules that inspect the
     *         body must either provide an <code>OversizeHandling</code> configuration or they must be preceded by a
     *         <code>SizeConstraintStatement</code> that blocks the body content from being too large. Rules that
     *         inspect the headers or cookies must provide an <code>OversizeHandling</code> configuration. </p>
     *         <p>
     *         Provide the handling configuration and retry your operation.
     *         </p>
     *         <p>
     *         Alternately, you can suppress this warning by adding the following tag to the resource that you provide
     *         to this operation: <code>Tag</code> (key:<code>WAF:OversizeFieldsHandlingConstraintOptOut</code>, value:
     *         <code>true</code>).</li>
     *         <li>WafExpiredManagedRuleGroupVersionException The operation failed because the specified version for the
     *         managed rule group has expired. You can retrieve the available versions for the managed rule group by
     *         calling <a>ListAvailableManagedRuleGroupVersions</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.CreateWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWebAclResponse> createWebACL(Consumer<CreateWebAclRequest.Builder> createWebAclRequest) {
        return createWebACL(CreateWebAclRequest.builder().applyMutation(createWebAclRequest).build());
    }

    /**
     * <p>
     * Deletes all rule groups that are managed by Firewall Manager for the specified web ACL.
     * </p>
     * <p>
     * You can only use this if <code>ManagedByFirewallManager</code> is false in the specified <a>WebACL</a>.
     * </p>
     *
     * @param deleteFirewallManagerRuleGroupsRequest
     * @return A Java Future containing the result of the DeleteFirewallManagerRuleGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeleteFirewallManagerRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteFirewallManagerRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFirewallManagerRuleGroupsResponse> deleteFirewallManagerRuleGroups(
            DeleteFirewallManagerRuleGroupsRequest deleteFirewallManagerRuleGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes all rule groups that are managed by Firewall Manager for the specified web ACL.
     * </p>
     * <p>
     * You can only use this if <code>ManagedByFirewallManager</code> is false in the specified <a>WebACL</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFirewallManagerRuleGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteFirewallManagerRuleGroupsRequest#builder()}
     * </p>
     *
     * @param deleteFirewallManagerRuleGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFirewallManagerRuleGroupsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteFirewallManagerRuleGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeleteFirewallManagerRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteFirewallManagerRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFirewallManagerRuleGroupsResponse> deleteFirewallManagerRuleGroups(
            Consumer<DeleteFirewallManagerRuleGroupsRequest.Builder> deleteFirewallManagerRuleGroupsRequest) {
        return deleteFirewallManagerRuleGroups(DeleteFirewallManagerRuleGroupsRequest.builder()
                .applyMutation(deleteFirewallManagerRuleGroupsRequest).build());
    }

    /**
     * <p>
     * Deletes the specified <a>IPSet</a>.
     * </p>
     *
     * @param deleteIpSetRequest
     * @return A Java Future containing the result of the DeleteIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafAssociatedItemException WAF couldn’t perform the operation because your resource is being used by
     *         another resource or it’s associated with another resource.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeleteIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIpSetResponse> deleteIPSet(DeleteIpSetRequest deleteIpSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified <a>IPSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIpSetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteIpSetRequest#builder()}
     * </p>
     *
     * @param deleteIpSetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIPSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafAssociatedItemException WAF couldn’t perform the operation because your resource is being used by
     *         another resource or it’s associated with another resource.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeleteIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIpSetResponse> deleteIPSet(Consumer<DeleteIpSetRequest.Builder> deleteIpSetRequest) {
        return deleteIPSet(DeleteIpSetRequest.builder().applyMutation(deleteIpSetRequest).build());
    }

    /**
     * <p>
     * Deletes the <a>LoggingConfiguration</a> from the specified web ACL.
     * </p>
     *
     * @param deleteLoggingConfigurationRequest
     * @return A Java Future containing the result of the DeleteLoggingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeleteLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLoggingConfigurationResponse> deleteLoggingConfiguration(
            DeleteLoggingConfigurationRequest deleteLoggingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the <a>LoggingConfiguration</a> from the specified web ACL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLoggingConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLoggingConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteLoggingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeleteLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLoggingConfigurationResponse> deleteLoggingConfiguration(
            Consumer<DeleteLoggingConfigurationRequest.Builder> deleteLoggingConfigurationRequest) {
        return deleteLoggingConfiguration(DeleteLoggingConfigurationRequest.builder()
                .applyMutation(deleteLoggingConfigurationRequest).build());
    }

    /**
     * <p>
     * Permanently deletes an IAM policy from the specified rule group.
     * </p>
     * <p>
     * You must be the owner of the rule group to perform this operation.
     * </p>
     *
     * @param deletePermissionPolicyRequest
     * @return A Java Future containing the result of the DeletePermissionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeletePermissionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeletePermissionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePermissionPolicyResponse> deletePermissionPolicy(
            DeletePermissionPolicyRequest deletePermissionPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Permanently deletes an IAM policy from the specified rule group.
     * </p>
     * <p>
     * You must be the owner of the rule group to perform this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePermissionPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePermissionPolicyRequest#builder()}
     * </p>
     *
     * @param deletePermissionPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeletePermissionPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePermissionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeletePermissionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeletePermissionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePermissionPolicyResponse> deletePermissionPolicy(
            Consumer<DeletePermissionPolicyRequest.Builder> deletePermissionPolicyRequest) {
        return deletePermissionPolicy(DeletePermissionPolicyRequest.builder().applyMutation(deletePermissionPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified <a>RegexPatternSet</a>.
     * </p>
     *
     * @param deleteRegexPatternSetRequest
     * @return A Java Future containing the result of the DeleteRegexPatternSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafAssociatedItemException WAF couldn’t perform the operation because your resource is being used by
     *         another resource or it’s associated with another resource.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeleteRegexPatternSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteRegexPatternSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteRegexPatternSetResponse> deleteRegexPatternSet(
            DeleteRegexPatternSetRequest deleteRegexPatternSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified <a>RegexPatternSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRegexPatternSetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRegexPatternSetRequest#builder()}
     * </p>
     *
     * @param deleteRegexPatternSetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRegexPatternSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteRegexPatternSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafAssociatedItemException WAF couldn’t perform the operation because your resource is being used by
     *         another resource or it’s associated with another resource.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeleteRegexPatternSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteRegexPatternSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteRegexPatternSetResponse> deleteRegexPatternSet(
            Consumer<DeleteRegexPatternSetRequest.Builder> deleteRegexPatternSetRequest) {
        return deleteRegexPatternSet(DeleteRegexPatternSetRequest.builder().applyMutation(deleteRegexPatternSetRequest).build());
    }

    /**
     * <p>
     * Deletes the specified <a>RuleGroup</a>.
     * </p>
     *
     * @param deleteRuleGroupRequest
     * @return A Java Future containing the result of the DeleteRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafAssociatedItemException WAF couldn’t perform the operation because your resource is being used by
     *         another resource or it’s associated with another resource.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeleteRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRuleGroupResponse> deleteRuleGroup(DeleteRuleGroupRequest deleteRuleGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified <a>RuleGroup</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRuleGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteRuleGroupRequest#builder()}
     * </p>
     *
     * @param deleteRuleGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRuleGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafAssociatedItemException WAF couldn’t perform the operation because your resource is being used by
     *         another resource or it’s associated with another resource.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeleteRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRuleGroupResponse> deleteRuleGroup(
            Consumer<DeleteRuleGroupRequest.Builder> deleteRuleGroupRequest) {
        return deleteRuleGroup(DeleteRuleGroupRequest.builder().applyMutation(deleteRuleGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified <a>WebACL</a>.
     * </p>
     * <p>
     * You can only use this if <code>ManagedByFirewallManager</code> is false in the specified <a>WebACL</a>.
     * </p>
     * <note>
     * <p>
     * Before deleting any web ACL, first disassociate it from all resources.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve a list of the resources that are associated with a web ACL, use the following calls:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For regional resources, call <a>ListResourcesForWebACL</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Amazon CloudFront distributions, use the CloudFront call <code>ListDistributionsByWebACLId</code>. For
     * information, see <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_ListDistributionsByWebACLId.html"
     * >ListDistributionsByWebACLId</a> in the <i>Amazon CloudFront API Reference</i>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * To disassociate a resource from a web ACL, use the following calls:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For regional resources, call <a>DisassociateWebACL</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Amazon CloudFront distributions, provide an empty web ACL ID in the CloudFront call
     * <code>UpdateDistribution</code>. For information, see <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html"
     * >UpdateDistribution</a> in the <i>Amazon CloudFront API Reference</i>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </note>
     *
     * @param deleteWebAclRequest
     * @return A Java Future containing the result of the DeleteWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafAssociatedItemException WAF couldn’t perform the operation because your resource is being used by
     *         another resource or it’s associated with another resource.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeleteWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWebAclResponse> deleteWebACL(DeleteWebAclRequest deleteWebAclRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified <a>WebACL</a>.
     * </p>
     * <p>
     * You can only use this if <code>ManagedByFirewallManager</code> is false in the specified <a>WebACL</a>.
     * </p>
     * <note>
     * <p>
     * Before deleting any web ACL, first disassociate it from all resources.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve a list of the resources that are associated with a web ACL, use the following calls:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For regional resources, call <a>ListResourcesForWebACL</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Amazon CloudFront distributions, use the CloudFront call <code>ListDistributionsByWebACLId</code>. For
     * information, see <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_ListDistributionsByWebACLId.html"
     * >ListDistributionsByWebACLId</a> in the <i>Amazon CloudFront API Reference</i>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * To disassociate a resource from a web ACL, use the following calls:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For regional resources, call <a>DisassociateWebACL</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Amazon CloudFront distributions, provide an empty web ACL ID in the CloudFront call
     * <code>UpdateDistribution</code>. For information, see <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html"
     * >UpdateDistribution</a> in the <i>Amazon CloudFront API Reference</i>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWebAclRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWebAclRequest#builder()}
     * </p>
     *
     * @param deleteWebAclRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWebACLRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafAssociatedItemException WAF couldn’t perform the operation because your resource is being used by
     *         another resource or it’s associated with another resource.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeleteWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWebAclResponse> deleteWebACL(Consumer<DeleteWebAclRequest.Builder> deleteWebAclRequest) {
        return deleteWebACL(DeleteWebAclRequest.builder().applyMutation(deleteWebAclRequest).build());
    }

    /**
     * <p>
     * Provides high-level information for the Amazon Web Services Managed Rules rule groups and Amazon Web Services
     * Marketplace managed rule groups.
     * </p>
     *
     * @param describeAllManagedProductsRequest
     * @return A Java Future containing the result of the DescribeAllManagedProducts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DescribeAllManagedProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DescribeAllManagedProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAllManagedProductsResponse> describeAllManagedProducts(
            DescribeAllManagedProductsRequest describeAllManagedProductsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides high-level information for the Amazon Web Services Managed Rules rule groups and Amazon Web Services
     * Marketplace managed rule groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAllManagedProductsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAllManagedProductsRequest#builder()}
     * </p>
     *
     * @param describeAllManagedProductsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAllManagedProductsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAllManagedProducts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DescribeAllManagedProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DescribeAllManagedProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAllManagedProductsResponse> describeAllManagedProducts(
            Consumer<DescribeAllManagedProductsRequest.Builder> describeAllManagedProductsRequest) {
        return describeAllManagedProducts(DescribeAllManagedProductsRequest.builder()
                .applyMutation(describeAllManagedProductsRequest).build());
    }

    /**
     * <p>
     * Provides high-level information for the managed rule groups owned by a specific vendor.
     * </p>
     *
     * @param describeManagedProductsByVendorRequest
     * @return A Java Future containing the result of the DescribeManagedProductsByVendor operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DescribeManagedProductsByVendor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DescribeManagedProductsByVendor"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeManagedProductsByVendorResponse> describeManagedProductsByVendor(
            DescribeManagedProductsByVendorRequest describeManagedProductsByVendorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides high-level information for the managed rule groups owned by a specific vendor.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeManagedProductsByVendorRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeManagedProductsByVendorRequest#builder()}
     * </p>
     *
     * @param describeManagedProductsByVendorRequest
     *        A {@link Consumer} that will call methods on {@link DescribeManagedProductsByVendorRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeManagedProductsByVendor operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DescribeManagedProductsByVendor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DescribeManagedProductsByVendor"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeManagedProductsByVendorResponse> describeManagedProductsByVendor(
            Consumer<DescribeManagedProductsByVendorRequest.Builder> describeManagedProductsByVendorRequest) {
        return describeManagedProductsByVendor(DescribeManagedProductsByVendorRequest.builder()
                .applyMutation(describeManagedProductsByVendorRequest).build());
    }

    /**
     * <p>
     * Provides high-level information for a managed rule group, including descriptions of the rules.
     * </p>
     *
     * @param describeManagedRuleGroupRequest
     * @return A Java Future containing the result of the DescribeManagedRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidResourceException WAF couldn’t perform the operation because the resource that you
     *         requested isn’t valid. Check the resource, and try again.</li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>WafExpiredManagedRuleGroupVersionException The operation failed because the specified version for the
     *         managed rule group has expired. You can retrieve the available versions for the managed rule group by
     *         calling <a>ListAvailableManagedRuleGroupVersions</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DescribeManagedRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DescribeManagedRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeManagedRuleGroupResponse> describeManagedRuleGroup(
            DescribeManagedRuleGroupRequest describeManagedRuleGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides high-level information for a managed rule group, including descriptions of the rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeManagedRuleGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeManagedRuleGroupRequest#builder()}
     * </p>
     *
     * @param describeManagedRuleGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeManagedRuleGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeManagedRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidResourceException WAF couldn’t perform the operation because the resource that you
     *         requested isn’t valid. Check the resource, and try again.</li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>WafExpiredManagedRuleGroupVersionException The operation failed because the specified version for the
     *         managed rule group has expired. You can retrieve the available versions for the managed rule group by
     *         calling <a>ListAvailableManagedRuleGroupVersions</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DescribeManagedRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DescribeManagedRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeManagedRuleGroupResponse> describeManagedRuleGroup(
            Consumer<DescribeManagedRuleGroupRequest.Builder> describeManagedRuleGroupRequest) {
        return describeManagedRuleGroup(DescribeManagedRuleGroupRequest.builder().applyMutation(describeManagedRuleGroupRequest)
                .build());
    }

    /**
     * <p>
     * Disassociates the specified regional application resource from any existing web ACL association. A resource can
     * have at most one web ACL association. A regional application can be an Application Load Balancer (ALB), an Amazon
     * API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon
     * Web Services Verified Access instance.
     * </p>
     * <p>
     * For Amazon CloudFront, don't use this call. Instead, use your CloudFront distribution configuration. To
     * disassociate a web ACL, provide an empty web ACL ID in the CloudFront call <code>UpdateDistribution</code>. For
     * information, see <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html">
     * UpdateDistribution</a> in the <i>Amazon CloudFront API Reference</i>.
     * </p>
     *
     * @param disassociateWebAclRequest
     * @return A Java Future containing the result of the DisassociateWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DisassociateWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DisassociateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisassociateWebAclResponse> disassociateWebACL(DisassociateWebAclRequest disassociateWebAclRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified regional application resource from any existing web ACL association. A resource can
     * have at most one web ACL association. A regional application can be an Application Load Balancer (ALB), an Amazon
     * API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon
     * Web Services Verified Access instance.
     * </p>
     * <p>
     * For Amazon CloudFront, don't use this call. Instead, use your CloudFront distribution configuration. To
     * disassociate a web ACL, provide an empty web ACL ID in the CloudFront call <code>UpdateDistribution</code>. For
     * information, see <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html">
     * UpdateDistribution</a> in the <i>Amazon CloudFront API Reference</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateWebAclRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateWebAclRequest#builder()}
     * </p>
     *
     * @param disassociateWebAclRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateWebACLRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DisassociateWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DisassociateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisassociateWebAclResponse> disassociateWebACL(
            Consumer<DisassociateWebAclRequest.Builder> disassociateWebAclRequest) {
        return disassociateWebACL(DisassociateWebAclRequest.builder().applyMutation(disassociateWebAclRequest).build());
    }

    /**
     * <p>
     * Generates a presigned download URL for the specified release of the mobile SDK.
     * </p>
     * <p>
     * The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish
     * and manage WAF tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client
     * application integration</a> in the <i>WAF Developer Guide</i>.
     * </p>
     *
     * @param generateMobileSdkReleaseUrlRequest
     * @return A Java Future containing the result of the GenerateMobileSdkReleaseUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GenerateMobileSdkReleaseUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GenerateMobileSdkReleaseUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GenerateMobileSdkReleaseUrlResponse> generateMobileSdkReleaseUrl(
            GenerateMobileSdkReleaseUrlRequest generateMobileSdkReleaseUrlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a presigned download URL for the specified release of the mobile SDK.
     * </p>
     * <p>
     * The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish
     * and manage WAF tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client
     * application integration</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GenerateMobileSdkReleaseUrlRequest.Builder}
     * avoiding the need to create one manually via {@link GenerateMobileSdkReleaseUrlRequest#builder()}
     * </p>
     *
     * @param generateMobileSdkReleaseUrlRequest
     *        A {@link Consumer} that will call methods on {@link GenerateMobileSdkReleaseUrlRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GenerateMobileSdkReleaseUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GenerateMobileSdkReleaseUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GenerateMobileSdkReleaseUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GenerateMobileSdkReleaseUrlResponse> generateMobileSdkReleaseUrl(
            Consumer<GenerateMobileSdkReleaseUrlRequest.Builder> generateMobileSdkReleaseUrlRequest) {
        return generateMobileSdkReleaseUrl(GenerateMobileSdkReleaseUrlRequest.builder()
                .applyMutation(generateMobileSdkReleaseUrlRequest).build());
    }

    /**
     * <p>
     * Returns your API key in decrypted form. Use this to check the token domains that you have defined for the key.
     * </p>
     * <p>
     * API keys are required for the integration of the CAPTCHA API in your JavaScript client applications. The API lets
     * you customize the placement and characteristics of the CAPTCHA puzzle for your end users. For more information
     * about the CAPTCHA JavaScript integration, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client
     * application integration</a> in the <i>WAF Developer Guide</i>.
     * </p>
     *
     * @param getDecryptedApiKeyRequest
     * @return A Java Future containing the result of the GetDecryptedAPIKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>WafInvalidResourceException WAF couldn’t perform the operation because the resource that you
     *         requested isn’t valid. Check the resource, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetDecryptedAPIKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetDecryptedAPIKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDecryptedApiKeyResponse> getDecryptedAPIKey(GetDecryptedApiKeyRequest getDecryptedApiKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns your API key in decrypted form. Use this to check the token domains that you have defined for the key.
     * </p>
     * <p>
     * API keys are required for the integration of the CAPTCHA API in your JavaScript client applications. The API lets
     * you customize the placement and characteristics of the CAPTCHA puzzle for your end users. For more information
     * about the CAPTCHA JavaScript integration, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client
     * application integration</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDecryptedApiKeyRequest.Builder} avoiding the
     * need to create one manually via {@link GetDecryptedApiKeyRequest#builder()}
     * </p>
     *
     * @param getDecryptedApiKeyRequest
     *        A {@link Consumer} that will call methods on {@link GetDecryptedAPIKeyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDecryptedAPIKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>WafInvalidResourceException WAF couldn’t perform the operation because the resource that you
     *         requested isn’t valid. Check the resource, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetDecryptedAPIKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetDecryptedAPIKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDecryptedApiKeyResponse> getDecryptedAPIKey(
            Consumer<GetDecryptedApiKeyRequest.Builder> getDecryptedApiKeyRequest) {
        return getDecryptedAPIKey(GetDecryptedApiKeyRequest.builder().applyMutation(getDecryptedApiKeyRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified <a>IPSet</a>.
     * </p>
     *
     * @param getIpSetRequest
     * @return A Java Future containing the result of the GetIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetIpSetResponse> getIPSet(GetIpSetRequest getIpSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified <a>IPSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIpSetRequest.Builder} avoiding the need to
     * create one manually via {@link GetIpSetRequest#builder()}
     * </p>
     *
     * @param getIpSetRequest
     *        A {@link Consumer} that will call methods on {@link GetIPSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetIpSetResponse> getIPSet(Consumer<GetIpSetRequest.Builder> getIpSetRequest) {
        return getIPSet(GetIpSetRequest.builder().applyMutation(getIpSetRequest).build());
    }

    /**
     * <p>
     * Returns the <a>LoggingConfiguration</a> for the specified web ACL.
     * </p>
     *
     * @param getLoggingConfigurationRequest
     * @return A Java Future containing the result of the GetLoggingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetLoggingConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLoggingConfigurationResponse> getLoggingConfiguration(
            GetLoggingConfigurationRequest getLoggingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the <a>LoggingConfiguration</a> for the specified web ACL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLoggingConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param getLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetLoggingConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetLoggingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetLoggingConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLoggingConfigurationResponse> getLoggingConfiguration(
            Consumer<GetLoggingConfigurationRequest.Builder> getLoggingConfigurationRequest) {
        return getLoggingConfiguration(GetLoggingConfigurationRequest.builder().applyMutation(getLoggingConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the specified managed rule set.
     * </p>
     * <note>
     * <p>
     * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web
     * Services Marketplace sellers.
     * </p>
     * <p>
     * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group
     * offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>,
     * <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.
     * </p>
     * </note>
     *
     * @param getManagedRuleSetRequest
     * @return A Java Future containing the result of the GetManagedRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetManagedRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetManagedRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetManagedRuleSetResponse> getManagedRuleSet(GetManagedRuleSetRequest getManagedRuleSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified managed rule set.
     * </p>
     * <note>
     * <p>
     * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web
     * Services Marketplace sellers.
     * </p>
     * <p>
     * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group
     * offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>,
     * <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetManagedRuleSetRequest.Builder} avoiding the need
     * to create one manually via {@link GetManagedRuleSetRequest#builder()}
     * </p>
     *
     * @param getManagedRuleSetRequest
     *        A {@link Consumer} that will call methods on {@link GetManagedRuleSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetManagedRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetManagedRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetManagedRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetManagedRuleSetResponse> getManagedRuleSet(
            Consumer<GetManagedRuleSetRequest.Builder> getManagedRuleSetRequest) {
        return getManagedRuleSet(GetManagedRuleSetRequest.builder().applyMutation(getManagedRuleSetRequest).build());
    }

    /**
     * <p>
     * Retrieves information for the specified mobile SDK release, including release notes and tags.
     * </p>
     * <p>
     * The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish
     * and manage WAF tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client
     * application integration</a> in the <i>WAF Developer Guide</i>.
     * </p>
     *
     * @param getMobileSdkReleaseRequest
     * @return A Java Future containing the result of the GetMobileSdkRelease operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetMobileSdkRelease
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetMobileSdkRelease" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMobileSdkReleaseResponse> getMobileSdkRelease(
            GetMobileSdkReleaseRequest getMobileSdkReleaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information for the specified mobile SDK release, including release notes and tags.
     * </p>
     * <p>
     * The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish
     * and manage WAF tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client
     * application integration</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMobileSdkReleaseRequest.Builder} avoiding the
     * need to create one manually via {@link GetMobileSdkReleaseRequest#builder()}
     * </p>
     *
     * @param getMobileSdkReleaseRequest
     *        A {@link Consumer} that will call methods on {@link GetMobileSdkReleaseRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetMobileSdkRelease operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetMobileSdkRelease
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetMobileSdkRelease" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMobileSdkReleaseResponse> getMobileSdkRelease(
            Consumer<GetMobileSdkReleaseRequest.Builder> getMobileSdkReleaseRequest) {
        return getMobileSdkRelease(GetMobileSdkReleaseRequest.builder().applyMutation(getMobileSdkReleaseRequest).build());
    }

    /**
     * <p>
     * Returns the IAM policy that is attached to the specified rule group.
     * </p>
     * <p>
     * You must be the owner of the rule group to perform this operation.
     * </p>
     *
     * @param getPermissionPolicyRequest
     * @return A Java Future containing the result of the GetPermissionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetPermissionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetPermissionPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPermissionPolicyResponse> getPermissionPolicy(
            GetPermissionPolicyRequest getPermissionPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the IAM policy that is attached to the specified rule group.
     * </p>
     * <p>
     * You must be the owner of the rule group to perform this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPermissionPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetPermissionPolicyRequest#builder()}
     * </p>
     *
     * @param getPermissionPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetPermissionPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetPermissionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetPermissionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetPermissionPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPermissionPolicyResponse> getPermissionPolicy(
            Consumer<GetPermissionPolicyRequest.Builder> getPermissionPolicyRequest) {
        return getPermissionPolicy(GetPermissionPolicyRequest.builder().applyMutation(getPermissionPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves the IP addresses that are currently blocked by a rate-based rule instance. This is only available for
     * rate-based rules that aggregate solely on the IP address or on the forwarded IP address.
     * </p>
     * <p>
     * The maximum number of addresses that can be blocked for a single rate-based rule instance is 10,000. If more than
     * 10,000 addresses exceed the rate limit, those with the highest rates are blocked.
     * </p>
     * <p>
     * For a rate-based rule that you've defined inside a rule group, provide the name of the rule group reference
     * statement in your request, in addition to the rate-based rule name and the web ACL name.
     * </p>
     * <p>
     * WAF monitors web requests and manages keys independently for each unique combination of web ACL, optional rule
     * group, and rate-based rule. For example, if you define a rate-based rule inside a rule group, and then use the
     * rule group in a web ACL, WAF monitors web requests and manages keys for that web ACL, rule group reference
     * statement, and rate-based rule instance. If you use the same rule group in a second web ACL, WAF monitors web
     * requests and manages keys for this second usage completely independent of your first.
     * </p>
     *
     * @param getRateBasedStatementManagedKeysRequest
     * @return A Java Future containing the result of the GetRateBasedStatementManagedKeys operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>WafUnsupportedAggregateKeyTypeException The rule that you've named doesn't aggregate solely on the IP
     *         address or solely on the forwarded IP address. This call is only available for rate-based rules with an
     *         <code>AggregateKeyType</code> setting of <code>IP</code> or <code>FORWARDED_IP</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetRateBasedStatementManagedKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetRateBasedStatementManagedKeys"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRateBasedStatementManagedKeysResponse> getRateBasedStatementManagedKeys(
            GetRateBasedStatementManagedKeysRequest getRateBasedStatementManagedKeysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the IP addresses that are currently blocked by a rate-based rule instance. This is only available for
     * rate-based rules that aggregate solely on the IP address or on the forwarded IP address.
     * </p>
     * <p>
     * The maximum number of addresses that can be blocked for a single rate-based rule instance is 10,000. If more than
     * 10,000 addresses exceed the rate limit, those with the highest rates are blocked.
     * </p>
     * <p>
     * For a rate-based rule that you've defined inside a rule group, provide the name of the rule group reference
     * statement in your request, in addition to the rate-based rule name and the web ACL name.
     * </p>
     * <p>
     * WAF monitors web requests and manages keys independently for each unique combination of web ACL, optional rule
     * group, and rate-based rule. For example, if you define a rate-based rule inside a rule group, and then use the
     * rule group in a web ACL, WAF monitors web requests and manages keys for that web ACL, rule group reference
     * statement, and rate-based rule instance. If you use the same rule group in a second web ACL, WAF monitors web
     * requests and manages keys for this second usage completely independent of your first.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRateBasedStatementManagedKeysRequest.Builder}
     * avoiding the need to create one manually via {@link GetRateBasedStatementManagedKeysRequest#builder()}
     * </p>
     *
     * @param getRateBasedStatementManagedKeysRequest
     *        A {@link Consumer} that will call methods on {@link GetRateBasedStatementManagedKeysRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetRateBasedStatementManagedKeys operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>WafUnsupportedAggregateKeyTypeException The rule that you've named doesn't aggregate solely on the IP
     *         address or solely on the forwarded IP address. This call is only available for rate-based rules with an
     *         <code>AggregateKeyType</code> setting of <code>IP</code> or <code>FORWARDED_IP</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetRateBasedStatementManagedKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetRateBasedStatementManagedKeys"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRateBasedStatementManagedKeysResponse> getRateBasedStatementManagedKeys(
            Consumer<GetRateBasedStatementManagedKeysRequest.Builder> getRateBasedStatementManagedKeysRequest) {
        return getRateBasedStatementManagedKeys(GetRateBasedStatementManagedKeysRequest.builder()
                .applyMutation(getRateBasedStatementManagedKeysRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified <a>RegexPatternSet</a>.
     * </p>
     *
     * @param getRegexPatternSetRequest
     * @return A Java Future containing the result of the GetRegexPatternSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetRegexPatternSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetRegexPatternSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRegexPatternSetResponse> getRegexPatternSet(GetRegexPatternSetRequest getRegexPatternSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified <a>RegexPatternSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRegexPatternSetRequest.Builder} avoiding the
     * need to create one manually via {@link GetRegexPatternSetRequest#builder()}
     * </p>
     *
     * @param getRegexPatternSetRequest
     *        A {@link Consumer} that will call methods on {@link GetRegexPatternSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetRegexPatternSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetRegexPatternSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetRegexPatternSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRegexPatternSetResponse> getRegexPatternSet(
            Consumer<GetRegexPatternSetRequest.Builder> getRegexPatternSetRequest) {
        return getRegexPatternSet(GetRegexPatternSetRequest.builder().applyMutation(getRegexPatternSetRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified <a>RuleGroup</a>.
     * </p>
     *
     * @param getRuleGroupRequest
     * @return A Java Future containing the result of the GetRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRuleGroupResponse> getRuleGroup(GetRuleGroupRequest getRuleGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified <a>RuleGroup</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRuleGroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetRuleGroupRequest#builder()}
     * </p>
     *
     * @param getRuleGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetRuleGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRuleGroupResponse> getRuleGroup(Consumer<GetRuleGroupRequest.Builder> getRuleGroupRequest) {
        return getRuleGroup(GetRuleGroupRequest.builder().applyMutation(getRuleGroupRequest).build());
    }

    /**
     * <p>
     * Gets detailed information about a specified number of requests--a sample--that WAF randomly selects from among
     * the first 5,000 requests that your Amazon Web Services resource received during a time range that you choose. You
     * can specify a sample size of up to 500 requests, and you can specify any time range in the previous three hours.
     * </p>
     * <p>
     * <code>GetSampledRequests</code> returns a time range, which is usually the time range that you specified.
     * However, if your resource (such as a CloudFront distribution) received 5,000 requests before the specified time
     * range elapsed, <code>GetSampledRequests</code> returns an updated time range. This new time range indicates the
     * actual period during which WAF selected the requests in the sample.
     * </p>
     *
     * @param getSampledRequestsRequest
     * @return A Java Future containing the result of the GetSampledRequests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetSampledRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetSampledRequests" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSampledRequestsResponse> getSampledRequests(GetSampledRequestsRequest getSampledRequestsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets detailed information about a specified number of requests--a sample--that WAF randomly selects from among
     * the first 5,000 requests that your Amazon Web Services resource received during a time range that you choose. You
     * can specify a sample size of up to 500 requests, and you can specify any time range in the previous three hours.
     * </p>
     * <p>
     * <code>GetSampledRequests</code> returns a time range, which is usually the time range that you specified.
     * However, if your resource (such as a CloudFront distribution) received 5,000 requests before the specified time
     * range elapsed, <code>GetSampledRequests</code> returns an updated time range. This new time range indicates the
     * actual period during which WAF selected the requests in the sample.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSampledRequestsRequest.Builder} avoiding the
     * need to create one manually via {@link GetSampledRequestsRequest#builder()}
     * </p>
     *
     * @param getSampledRequestsRequest
     *        A {@link Consumer} that will call methods on {@link GetSampledRequestsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSampledRequests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetSampledRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetSampledRequests" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSampledRequestsResponse> getSampledRequests(
            Consumer<GetSampledRequestsRequest.Builder> getSampledRequestsRequest) {
        return getSampledRequests(GetSampledRequestsRequest.builder().applyMutation(getSampledRequestsRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified <a>WebACL</a>.
     * </p>
     *
     * @param getWebAclRequest
     * @return A Java Future containing the result of the GetWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetWebAclResponse> getWebACL(GetWebAclRequest getWebAclRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified <a>WebACL</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWebAclRequest.Builder} avoiding the need to
     * create one manually via {@link GetWebAclRequest#builder()}
     * </p>
     *
     * @param getWebAclRequest
     *        A {@link Consumer} that will call methods on {@link GetWebACLRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetWebAclResponse> getWebACL(Consumer<GetWebAclRequest.Builder> getWebAclRequest) {
        return getWebACL(GetWebAclRequest.builder().applyMutation(getWebAclRequest).build());
    }

    /**
     * <p>
     * Retrieves the <a>WebACL</a> for the specified resource.
     * </p>
     *
     * @param getWebAclForResourceRequest
     * @return A Java Future containing the result of the GetWebACLForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafUnavailableEntityException WAF couldn’t retrieve a resource that you specified for this operation.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate. Verify the
     *         resources that you are specifying in your request parameters and then retry the operation.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetWebACLForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetWebACLForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetWebAclForResourceResponse> getWebACLForResource(
            GetWebAclForResourceRequest getWebAclForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the <a>WebACL</a> for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWebAclForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link GetWebAclForResourceRequest#builder()}
     * </p>
     *
     * @param getWebAclForResourceRequest
     *        A {@link Consumer} that will call methods on {@link GetWebACLForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetWebACLForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafUnavailableEntityException WAF couldn’t retrieve a resource that you specified for this operation.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate. Verify the
     *         resources that you are specifying in your request parameters and then retry the operation.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetWebACLForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetWebACLForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetWebAclForResourceResponse> getWebACLForResource(
            Consumer<GetWebAclForResourceRequest.Builder> getWebAclForResourceRequest) {
        return getWebACLForResource(GetWebAclForResourceRequest.builder().applyMutation(getWebAclForResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of the API keys that you've defined for the specified scope.
     * </p>
     * <p>
     * API keys are required for the integration of the CAPTCHA API in your JavaScript client applications. The API lets
     * you customize the placement and characteristics of the CAPTCHA puzzle for your end users. For more information
     * about the CAPTCHA JavaScript integration, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client
     * application integration</a> in the <i>WAF Developer Guide</i>.
     * </p>
     *
     * @param listApiKeysRequest
     * @return A Java Future containing the result of the ListAPIKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>WafInvalidResourceException WAF couldn’t perform the operation because the resource that you
     *         requested isn’t valid. Check the resource, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListAPIKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListAPIKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListApiKeysResponse> listAPIKeys(ListApiKeysRequest listApiKeysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of the API keys that you've defined for the specified scope.
     * </p>
     * <p>
     * API keys are required for the integration of the CAPTCHA API in your JavaScript client applications. The API lets
     * you customize the placement and characteristics of the CAPTCHA puzzle for your end users. For more information
     * about the CAPTCHA JavaScript integration, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client
     * application integration</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApiKeysRequest.Builder} avoiding the need to
     * create one manually via {@link ListApiKeysRequest#builder()}
     * </p>
     *
     * @param listApiKeysRequest
     *        A {@link Consumer} that will call methods on {@link ListAPIKeysRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAPIKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>WafInvalidResourceException WAF couldn’t perform the operation because the resource that you
     *         requested isn’t valid. Check the resource, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListAPIKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListAPIKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListApiKeysResponse> listAPIKeys(Consumer<ListApiKeysRequest.Builder> listApiKeysRequest) {
        return listAPIKeys(ListApiKeysRequest.builder().applyMutation(listApiKeysRequest).build());
    }

    /**
     * <p>
     * Returns a list of the available versions for the specified managed rule group.
     * </p>
     *
     * @param listAvailableManagedRuleGroupVersionsRequest
     * @return A Java Future containing the result of the ListAvailableManagedRuleGroupVersions operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListAvailableManagedRuleGroupVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListAvailableManagedRuleGroupVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAvailableManagedRuleGroupVersionsResponse> listAvailableManagedRuleGroupVersions(
            ListAvailableManagedRuleGroupVersionsRequest listAvailableManagedRuleGroupVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the available versions for the specified managed rule group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAvailableManagedRuleGroupVersionsRequest.Builder} avoiding the need to create one manually via
     * {@link ListAvailableManagedRuleGroupVersionsRequest#builder()}
     * </p>
     *
     * @param listAvailableManagedRuleGroupVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListAvailableManagedRuleGroupVersionsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListAvailableManagedRuleGroupVersions operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListAvailableManagedRuleGroupVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListAvailableManagedRuleGroupVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAvailableManagedRuleGroupVersionsResponse> listAvailableManagedRuleGroupVersions(
            Consumer<ListAvailableManagedRuleGroupVersionsRequest.Builder> listAvailableManagedRuleGroupVersionsRequest) {
        return listAvailableManagedRuleGroupVersions(ListAvailableManagedRuleGroupVersionsRequest.builder()
                .applyMutation(listAvailableManagedRuleGroupVersionsRequest).build());
    }

    /**
     * <p>
     * Retrieves an array of managed rule groups that are available for you to use. This list includes all Amazon Web
     * Services Managed Rules rule groups and all of the Amazon Web Services Marketplace managed rule groups that you're
     * subscribed to.
     * </p>
     *
     * @param listAvailableManagedRuleGroupsRequest
     * @return A Java Future containing the result of the ListAvailableManagedRuleGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListAvailableManagedRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListAvailableManagedRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAvailableManagedRuleGroupsResponse> listAvailableManagedRuleGroups(
            ListAvailableManagedRuleGroupsRequest listAvailableManagedRuleGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an array of managed rule groups that are available for you to use. This list includes all Amazon Web
     * Services Managed Rules rule groups and all of the Amazon Web Services Marketplace managed rule groups that you're
     * subscribed to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAvailableManagedRuleGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAvailableManagedRuleGroupsRequest#builder()}
     * </p>
     *
     * @param listAvailableManagedRuleGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListAvailableManagedRuleGroupsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAvailableManagedRuleGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListAvailableManagedRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListAvailableManagedRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAvailableManagedRuleGroupsResponse> listAvailableManagedRuleGroups(
            Consumer<ListAvailableManagedRuleGroupsRequest.Builder> listAvailableManagedRuleGroupsRequest) {
        return listAvailableManagedRuleGroups(ListAvailableManagedRuleGroupsRequest.builder()
                .applyMutation(listAvailableManagedRuleGroupsRequest).build());
    }

    /**
     * <p>
     * Retrieves an array of <a>IPSetSummary</a> objects for the IP sets that you manage.
     * </p>
     *
     * @param listIpSetsRequest
     * @return A Java Future containing the result of the ListIPSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListIPSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListIPSets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIpSetsResponse> listIPSets(ListIpSetsRequest listIpSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an array of <a>IPSetSummary</a> objects for the IP sets that you manage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIpSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListIpSetsRequest#builder()}
     * </p>
     *
     * @param listIpSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListIPSetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListIPSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListIPSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListIPSets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIpSetsResponse> listIPSets(Consumer<ListIpSetsRequest.Builder> listIpSetsRequest) {
        return listIPSets(ListIpSetsRequest.builder().applyMutation(listIpSetsRequest).build());
    }

    /**
     * <p>
     * Retrieves an array of your <a>LoggingConfiguration</a> objects.
     * </p>
     *
     * @param listLoggingConfigurationsRequest
     * @return A Java Future containing the result of the ListLoggingConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListLoggingConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListLoggingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLoggingConfigurationsResponse> listLoggingConfigurations(
            ListLoggingConfigurationsRequest listLoggingConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an array of your <a>LoggingConfiguration</a> objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLoggingConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListLoggingConfigurationsRequest#builder()}
     * </p>
     *
     * @param listLoggingConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListLoggingConfigurationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListLoggingConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListLoggingConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListLoggingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLoggingConfigurationsResponse> listLoggingConfigurations(
            Consumer<ListLoggingConfigurationsRequest.Builder> listLoggingConfigurationsRequest) {
        return listLoggingConfigurations(ListLoggingConfigurationsRequest.builder()
                .applyMutation(listLoggingConfigurationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the managed rule sets that you own.
     * </p>
     * <note>
     * <p>
     * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web
     * Services Marketplace sellers.
     * </p>
     * <p>
     * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group
     * offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>,
     * <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.
     * </p>
     * </note>
     *
     * @param listManagedRuleSetsRequest
     * @return A Java Future containing the result of the ListManagedRuleSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListManagedRuleSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListManagedRuleSets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListManagedRuleSetsResponse> listManagedRuleSets(
            ListManagedRuleSetsRequest listManagedRuleSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the managed rule sets that you own.
     * </p>
     * <note>
     * <p>
     * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web
     * Services Marketplace sellers.
     * </p>
     * <p>
     * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group
     * offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>,
     * <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedRuleSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListManagedRuleSetsRequest#builder()}
     * </p>
     *
     * @param listManagedRuleSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListManagedRuleSetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListManagedRuleSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListManagedRuleSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListManagedRuleSets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListManagedRuleSetsResponse> listManagedRuleSets(
            Consumer<ListManagedRuleSetsRequest.Builder> listManagedRuleSetsRequest) {
        return listManagedRuleSets(ListManagedRuleSetsRequest.builder().applyMutation(listManagedRuleSetsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of the available releases for the mobile SDK and the specified device platform.
     * </p>
     * <p>
     * The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish
     * and manage WAF tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client
     * application integration</a> in the <i>WAF Developer Guide</i>.
     * </p>
     *
     * @param listMobileSdkReleasesRequest
     * @return A Java Future containing the result of the ListMobileSdkReleases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListMobileSdkReleases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListMobileSdkReleases" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListMobileSdkReleasesResponse> listMobileSdkReleases(
            ListMobileSdkReleasesRequest listMobileSdkReleasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of the available releases for the mobile SDK and the specified device platform.
     * </p>
     * <p>
     * The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish
     * and manage WAF tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client
     * application integration</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMobileSdkReleasesRequest.Builder} avoiding the
     * need to create one manually via {@link ListMobileSdkReleasesRequest#builder()}
     * </p>
     *
     * @param listMobileSdkReleasesRequest
     *        A {@link Consumer} that will call methods on {@link ListMobileSdkReleasesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListMobileSdkReleases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListMobileSdkReleases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListMobileSdkReleases" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListMobileSdkReleasesResponse> listMobileSdkReleases(
            Consumer<ListMobileSdkReleasesRequest.Builder> listMobileSdkReleasesRequest) {
        return listMobileSdkReleases(ListMobileSdkReleasesRequest.builder().applyMutation(listMobileSdkReleasesRequest).build());
    }

    /**
     * <p>
     * Retrieves an array of <a>RegexPatternSetSummary</a> objects for the regex pattern sets that you manage.
     * </p>
     *
     * @param listRegexPatternSetsRequest
     * @return A Java Future containing the result of the ListRegexPatternSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListRegexPatternSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListRegexPatternSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListRegexPatternSetsResponse> listRegexPatternSets(
            ListRegexPatternSetsRequest listRegexPatternSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an array of <a>RegexPatternSetSummary</a> objects for the regex pattern sets that you manage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRegexPatternSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRegexPatternSetsRequest#builder()}
     * </p>
     *
     * @param listRegexPatternSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListRegexPatternSetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListRegexPatternSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListRegexPatternSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListRegexPatternSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListRegexPatternSetsResponse> listRegexPatternSets(
            Consumer<ListRegexPatternSetsRequest.Builder> listRegexPatternSetsRequest) {
        return listRegexPatternSets(ListRegexPatternSetsRequest.builder().applyMutation(listRegexPatternSetsRequest).build());
    }

    /**
     * <p>
     * Retrieves an array of the Amazon Resource Names (ARNs) for the regional resources that are associated with the
     * specified web ACL. If you want the list of Amazon CloudFront resources, use the CloudFront call
     * <code>ListDistributionsByWebACLId</code>.
     * </p>
     *
     * @param listResourcesForWebAclRequest
     * @return A Java Future containing the result of the ListResourcesForWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListResourcesForWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListResourcesForWebACL" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListResourcesForWebAclResponse> listResourcesForWebACL(
            ListResourcesForWebAclRequest listResourcesForWebAclRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an array of the Amazon Resource Names (ARNs) for the regional resources that are associated with the
     * specified web ACL. If you want the list of Amazon CloudFront resources, use the CloudFront call
     * <code>ListDistributionsByWebACLId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcesForWebAclRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourcesForWebAclRequest#builder()}
     * </p>
     *
     * @param listResourcesForWebAclRequest
     *        A {@link Consumer} that will call methods on {@link ListResourcesForWebACLRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListResourcesForWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListResourcesForWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListResourcesForWebACL" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListResourcesForWebAclResponse> listResourcesForWebACL(
            Consumer<ListResourcesForWebAclRequest.Builder> listResourcesForWebAclRequest) {
        return listResourcesForWebACL(ListResourcesForWebAclRequest.builder().applyMutation(listResourcesForWebAclRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves an array of <a>RuleGroupSummary</a> objects for the rule groups that you manage.
     * </p>
     *
     * @param listRuleGroupsRequest
     * @return A Java Future containing the result of the ListRuleGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListRuleGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRuleGroupsResponse> listRuleGroups(ListRuleGroupsRequest listRuleGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an array of <a>RuleGroupSummary</a> objects for the rule groups that you manage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRuleGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRuleGroupsRequest#builder()}
     * </p>
     *
     * @param listRuleGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListRuleGroupsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRuleGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListRuleGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRuleGroupsResponse> listRuleGroups(Consumer<ListRuleGroupsRequest.Builder> listRuleGroupsRequest) {
        return listRuleGroups(ListRuleGroupsRequest.builder().applyMutation(listRuleGroupsRequest).build());
    }

    /**
     * <p>
     * Retrieves the <a>TagInfoForResource</a> for the specified resource. Tags are key:value pairs that you can use to
     * categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule groups, IP sets, and
     * regex pattern sets. You can't manage or view tags through the WAF console.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the <a>TagInfoForResource</a> for the specified resource. Tags are key:value pairs that you can use to
     * categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule groups, IP sets, and
     * regex pattern sets. You can't manage or view tags through the WAF console.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves an array of <a>WebACLSummary</a> objects for the web ACLs that you manage.
     * </p>
     *
     * @param listWebAcLsRequest
     * @return A Java Future containing the result of the ListWebACLs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListWebACLs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListWebACLs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListWebAcLsResponse> listWebACLs(ListWebAcLsRequest listWebAcLsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an array of <a>WebACLSummary</a> objects for the web ACLs that you manage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWebAcLsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWebAcLsRequest#builder()}
     * </p>
     *
     * @param listWebAcLsRequest
     *        A {@link Consumer} that will call methods on {@link ListWebACLsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListWebACLs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListWebACLs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListWebACLs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListWebAcLsResponse> listWebACLs(Consumer<ListWebAcLsRequest.Builder> listWebAcLsRequest) {
        return listWebACLs(ListWebAcLsRequest.builder().applyMutation(listWebAcLsRequest).build());
    }

    /**
     * <p>
     * Enables the specified <a>LoggingConfiguration</a>, to start logging from a web ACL, according to the
     * configuration provided.
     * </p>
     * <note>
     * <p>
     * This operation completely replaces any mutable specifications that you already have for a logging configuration
     * with the ones that you provide to this call.
     * </p>
     * <p>
     * To modify an existing logging configuration, do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Retrieve it by calling <a>GetLoggingConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * Update its settings as needed
     * </p>
     * </li>
     * <li>
     * <p>
     * Provide the complete logging configuration specification to this call
     * </p>
     * </li>
     * </ol>
     * </note> <note>
     * <p>
     * You can define one logging destination per web ACL.
     * </p>
     * </note>
     * <p>
     * You can access information about the traffic that WAF inspects using the following steps:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Create your logging destination. You can use an Amazon CloudWatch Logs log group, an Amazon Simple Storage
     * Service (Amazon S3) bucket, or an Amazon Kinesis Data Firehose.
     * </p>
     * <p>
     * The name that you give the destination must start with <code>aws-waf-logs-</code>. Depending on the type of
     * destination, you might need to configure additional settings or permissions.
     * </p>
     * <p>
     * For configuration requirements and pricing information for each destination type, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging web ACL traffic</a> in the
     * <i>WAF Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Associate your logging destination to your web ACL using a <code>PutLoggingConfiguration</code> request.
     * </p>
     * </li>
     * </ol>
     * <p>
     * When you successfully enable logging using a <code>PutLoggingConfiguration</code> request, WAF creates an
     * additional role or policy that is required to write logs to the logging destination. For an Amazon CloudWatch
     * Logs log group, WAF creates a resource policy on the log group. For an Amazon S3 bucket, WAF creates a bucket
     * policy. For an Amazon Kinesis Data Firehose, WAF creates a service-linked role.
     * </p>
     * <p>
     * For additional information about web ACL logging, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging web ACL traffic information</a>
     * in the <i>WAF Developer Guide</i>.
     * </p>
     *
     * @param putLoggingConfigurationRequest
     * @return A Java Future containing the result of the PutLoggingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafServiceLinkedRoleErrorException WAF is not able to access the service linked role. This can be
     *         caused by a previous <code>PutLoggingConfiguration</code> request, which can lock the service linked role
     *         for about 20 seconds. Please try your request again. The service linked role can also be locked by a
     *         previous <code>DeleteServiceLinkedRole</code> request, which can lock the role for 15 minutes or more. If
     *         you recently made a call to <code>DeleteServiceLinkedRole</code>, wait at least 15 minutes and try the
     *         request again. If you receive this same exception again, you will have to wait additional time until the
     *         role is unlocked.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>WafLimitsExceededException WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon
     *         Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF
     *         Developer Guide</i>.</li>
     *         <li>WafLogDestinationPermissionIssueException The operation failed because you don't have the permissions
     *         that your logging configuration requires. For information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging web ACL traffic
     *         information</a> in the <i>WAF Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.PutLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/PutLoggingConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutLoggingConfigurationResponse> putLoggingConfiguration(
            PutLoggingConfigurationRequest putLoggingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the specified <a>LoggingConfiguration</a>, to start logging from a web ACL, according to the
     * configuration provided.
     * </p>
     * <note>
     * <p>
     * This operation completely replaces any mutable specifications that you already have for a logging configuration
     * with the ones that you provide to this call.
     * </p>
     * <p>
     * To modify an existing logging configuration, do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Retrieve it by calling <a>GetLoggingConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * Update its settings as needed
     * </p>
     * </li>
     * <li>
     * <p>
     * Provide the complete logging configuration specification to this call
     * </p>
     * </li>
     * </ol>
     * </note> <note>
     * <p>
     * You can define one logging destination per web ACL.
     * </p>
     * </note>
     * <p>
     * You can access information about the traffic that WAF inspects using the following steps:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Create your logging destination. You can use an Amazon CloudWatch Logs log group, an Amazon Simple Storage
     * Service (Amazon S3) bucket, or an Amazon Kinesis Data Firehose.
     * </p>
     * <p>
     * The name that you give the destination must start with <code>aws-waf-logs-</code>. Depending on the type of
     * destination, you might need to configure additional settings or permissions.
     * </p>
     * <p>
     * For configuration requirements and pricing information for each destination type, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging web ACL traffic</a> in the
     * <i>WAF Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Associate your logging destination to your web ACL using a <code>PutLoggingConfiguration</code> request.
     * </p>
     * </li>
     * </ol>
     * <p>
     * When you successfully enable logging using a <code>PutLoggingConfiguration</code> request, WAF creates an
     * additional role or policy that is required to write logs to the logging destination. For an Amazon CloudWatch
     * Logs log group, WAF creates a resource policy on the log group. For an Amazon S3 bucket, WAF creates a bucket
     * policy. For an Amazon Kinesis Data Firehose, WAF creates a service-linked role.
     * </p>
     * <p>
     * For additional information about web ACL logging, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging web ACL traffic information</a>
     * in the <i>WAF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutLoggingConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link PutLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param putLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link PutLoggingConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutLoggingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafServiceLinkedRoleErrorException WAF is not able to access the service linked role. This can be
     *         caused by a previous <code>PutLoggingConfiguration</code> request, which can lock the service linked role
     *         for about 20 seconds. Please try your request again. The service linked role can also be locked by a
     *         previous <code>DeleteServiceLinkedRole</code> request, which can lock the role for 15 minutes or more. If
     *         you recently made a call to <code>DeleteServiceLinkedRole</code>, wait at least 15 minutes and try the
     *         request again. If you receive this same exception again, you will have to wait additional time until the
     *         role is unlocked.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>WafLimitsExceededException WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon
     *         Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF
     *         Developer Guide</i>.</li>
     *         <li>WafLogDestinationPermissionIssueException The operation failed because you don't have the permissions
     *         that your logging configuration requires. For information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging web ACL traffic
     *         information</a> in the <i>WAF Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.PutLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/PutLoggingConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutLoggingConfigurationResponse> putLoggingConfiguration(
            Consumer<PutLoggingConfigurationRequest.Builder> putLoggingConfigurationRequest) {
        return putLoggingConfiguration(PutLoggingConfigurationRequest.builder().applyMutation(putLoggingConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Defines the versions of your managed rule set that you are offering to the customers. Customers see your
     * offerings as managed rule groups with versioning.
     * </p>
     * <note>
     * <p>
     * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web
     * Services Marketplace sellers.
     * </p>
     * <p>
     * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group
     * offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>,
     * <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.
     * </p>
     * </note>
     * <p>
     * Customers retrieve their managed rule group list by calling <a>ListAvailableManagedRuleGroups</a>. The name that
     * you provide here for your managed rule set is the name the customer sees for the corresponding managed rule
     * group. Customers can retrieve the available versions for a managed rule group by calling
     * <a>ListAvailableManagedRuleGroupVersions</a>. You provide a rule group specification for each version. For each
     * managed rule set, you must specify a version that you recommend using.
     * </p>
     * <p>
     * To initiate the expiration of a managed rule group version, use <a>UpdateManagedRuleSetVersionExpiryDate</a>.
     * </p>
     *
     * @param putManagedRuleSetVersionsRequest
     * @return A Java Future containing the result of the PutManagedRuleSetVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.PutManagedRuleSetVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/PutManagedRuleSetVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutManagedRuleSetVersionsResponse> putManagedRuleSetVersions(
            PutManagedRuleSetVersionsRequest putManagedRuleSetVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines the versions of your managed rule set that you are offering to the customers. Customers see your
     * offerings as managed rule groups with versioning.
     * </p>
     * <note>
     * <p>
     * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web
     * Services Marketplace sellers.
     * </p>
     * <p>
     * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group
     * offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>,
     * <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.
     * </p>
     * </note>
     * <p>
     * Customers retrieve their managed rule group list by calling <a>ListAvailableManagedRuleGroups</a>. The name that
     * you provide here for your managed rule set is the name the customer sees for the corresponding managed rule
     * group. Customers can retrieve the available versions for a managed rule group by calling
     * <a>ListAvailableManagedRuleGroupVersions</a>. You provide a rule group specification for each version. For each
     * managed rule set, you must specify a version that you recommend using.
     * </p>
     * <p>
     * To initiate the expiration of a managed rule group version, use <a>UpdateManagedRuleSetVersionExpiryDate</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutManagedRuleSetVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link PutManagedRuleSetVersionsRequest#builder()}
     * </p>
     *
     * @param putManagedRuleSetVersionsRequest
     *        A {@link Consumer} that will call methods on {@link PutManagedRuleSetVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutManagedRuleSetVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.PutManagedRuleSetVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/PutManagedRuleSetVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutManagedRuleSetVersionsResponse> putManagedRuleSetVersions(
            Consumer<PutManagedRuleSetVersionsRequest.Builder> putManagedRuleSetVersionsRequest) {
        return putManagedRuleSetVersions(PutManagedRuleSetVersionsRequest.builder()
                .applyMutation(putManagedRuleSetVersionsRequest).build());
    }

    /**
     * <p>
     * Attaches an IAM policy to the specified resource. Use this to share a rule group across accounts.
     * </p>
     * <p>
     * You must be the owner of the rule group to perform this operation.
     * </p>
     * <p>
     * This action is subject to the following restrictions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can attach only one policy with each <code>PutPermissionPolicy</code> request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The ARN in the request must be a valid WAF <a>RuleGroup</a> ARN and the rule group must exist in the same Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * The user making the request must be the owner of the rule group.
     * </p>
     * </li>
     * </ul>
     *
     * @param putPermissionPolicyRequest
     * @return A Java Future containing the result of the PutPermissionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidPermissionPolicyException The operation failed because the specified policy isn't in the
     *         proper format. </p>
     *         <p>
     *         The policy specifications must conform to the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The policy must be composed using IAM Policy version 2012-10-17.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The policy must include specifications for <code>Effect</code>, <code>Action</code>, and
     *         <code>Principal</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Effect</code> must specify <code>Allow</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Action</code> must specify <code>wafv2:CreateWebACL</code>, <code>wafv2:UpdateWebACL</code>, and
     *         <code>wafv2:PutFirewallManagerRuleGroups</code> and may optionally specify
     *         <code>wafv2:GetRuleGroup</code>. WAF rejects any extra actions or wildcard actions in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The policy must not include a <code>Resource</code> parameter.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html">IAM Policies</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.PutPermissionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/PutPermissionPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutPermissionPolicyResponse> putPermissionPolicy(
            PutPermissionPolicyRequest putPermissionPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches an IAM policy to the specified resource. Use this to share a rule group across accounts.
     * </p>
     * <p>
     * You must be the owner of the rule group to perform this operation.
     * </p>
     * <p>
     * This action is subject to the following restrictions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can attach only one policy with each <code>PutPermissionPolicy</code> request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The ARN in the request must be a valid WAF <a>RuleGroup</a> ARN and the rule group must exist in the same Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * The user making the request must be the owner of the rule group.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutPermissionPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutPermissionPolicyRequest#builder()}
     * </p>
     *
     * @param putPermissionPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutPermissionPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutPermissionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidPermissionPolicyException The operation failed because the specified policy isn't in the
     *         proper format. </p>
     *         <p>
     *         The policy specifications must conform to the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The policy must be composed using IAM Policy version 2012-10-17.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The policy must include specifications for <code>Effect</code>, <code>Action</code>, and
     *         <code>Principal</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Effect</code> must specify <code>Allow</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Action</code> must specify <code>wafv2:CreateWebACL</code>, <code>wafv2:UpdateWebACL</code>, and
     *         <code>wafv2:PutFirewallManagerRuleGroups</code> and may optionally specify
     *         <code>wafv2:GetRuleGroup</code>. WAF rejects any extra actions or wildcard actions in the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The policy must not include a <code>Resource</code> parameter.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html">IAM Policies</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.PutPermissionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/PutPermissionPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutPermissionPolicyResponse> putPermissionPolicy(
            Consumer<PutPermissionPolicyRequest.Builder> putPermissionPolicyRequest) {
        return putPermissionPolicy(PutPermissionPolicyRequest.builder().applyMutation(putPermissionPolicyRequest).build());
    }

    /**
     * <p>
     * Associates tags with the specified Amazon Web Services resource. Tags are key:value pairs that you can use to
     * categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule groups, IP sets, and
     * regex pattern sets. You can't manage or view tags through the WAF console.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafLimitsExceededException WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon
     *         Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF
     *         Developer Guide</i>.</li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates tags with the specified Amazon Web Services resource. Tags are key:value pairs that you can use to
     * categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule groups, IP sets, and
     * regex pattern sets. You can't manage or view tags through the WAF console.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafLimitsExceededException WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon
     *         Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF
     *         Developer Guide</i>.</li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Disassociates tags from an Amazon Web Services resource. Tags are key:value pairs that you can associate with
     * Amazon Web Services resources. For example, the tag key might be "customer" and the tag value might be
     * "companyA." You can specify one or more tags to add to each container. You can add up to 50 tags to each Amazon
     * Web Services resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates tags from an Amazon Web Services resource. Tags are key:value pairs that you can associate with
     * Amazon Web Services resources. For example, the tag key might be "customer" and the tag value might be
     * "companyA." You can specify one or more tags to add to each container. You can add up to 50 tags to each Amazon
     * Web Services resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the specified <a>IPSet</a>.
     * </p>
     * <note>
     * <p>
     * This operation completely replaces the mutable specifications that you already have for the IP set with the ones
     * that you provide to this call.
     * </p>
     * <p>
     * To modify an IP set, do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Retrieve it by calling <a>GetIPSet</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * Update its settings as needed
     * </p>
     * </li>
     * <li>
     * <p>
     * Provide the complete IP set specification to this call
     * </p>
     * </li>
     * </ol>
     * </note>
     * <p>
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes
     * everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but
     * there might be a brief period of inconsistency when the changes have arrived in some places and not in others.
     * So, for example, if you change a rule action setting, the action might be the old action in one area and the new
     * action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might
     * briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you
     * first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already
     * associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     * </p>
     *
     * @param updateIpSetRequest
     * @return A Java Future containing the result of the UpdateIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafDuplicateItemException WAF couldn’t perform the operation because the resource that you tried to
     *         save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon
     *         Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF
     *         Developer Guide</i>.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.UpdateIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateIpSetResponse> updateIPSet(UpdateIpSetRequest updateIpSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified <a>IPSet</a>.
     * </p>
     * <note>
     * <p>
     * This operation completely replaces the mutable specifications that you already have for the IP set with the ones
     * that you provide to this call.
     * </p>
     * <p>
     * To modify an IP set, do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Retrieve it by calling <a>GetIPSet</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * Update its settings as needed
     * </p>
     * </li>
     * <li>
     * <p>
     * Provide the complete IP set specification to this call
     * </p>
     * </li>
     * </ol>
     * </note>
     * <p>
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes
     * everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but
     * there might be a brief period of inconsistency when the changes have arrived in some places and not in others.
     * So, for example, if you change a rule action setting, the action might be the old action in one area and the new
     * action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might
     * briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you
     * first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already
     * associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIpSetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateIpSetRequest#builder()}
     * </p>
     *
     * @param updateIpSetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateIPSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafDuplicateItemException WAF couldn’t perform the operation because the resource that you tried to
     *         save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon
     *         Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF
     *         Developer Guide</i>.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.UpdateIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateIpSetResponse> updateIPSet(Consumer<UpdateIpSetRequest.Builder> updateIpSetRequest) {
        return updateIPSet(UpdateIpSetRequest.builder().applyMutation(updateIpSetRequest).build());
    }

    /**
     * <p>
     * Updates the expiration information for your managed rule set. Use this to initiate the expiration of a managed
     * rule group version. After you initiate expiration for a version, WAF excludes it from the response to
     * <a>ListAvailableManagedRuleGroupVersions</a> for the managed rule group.
     * </p>
     * <note>
     * <p>
     * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web
     * Services Marketplace sellers.
     * </p>
     * <p>
     * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group
     * offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>,
     * <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.
     * </p>
     * </note>
     *
     * @param updateManagedRuleSetVersionExpiryDateRequest
     * @return A Java Future containing the result of the UpdateManagedRuleSetVersionExpiryDate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.UpdateManagedRuleSetVersionExpiryDate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateManagedRuleSetVersionExpiryDate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateManagedRuleSetVersionExpiryDateResponse> updateManagedRuleSetVersionExpiryDate(
            UpdateManagedRuleSetVersionExpiryDateRequest updateManagedRuleSetVersionExpiryDateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the expiration information for your managed rule set. Use this to initiate the expiration of a managed
     * rule group version. After you initiate expiration for a version, WAF excludes it from the response to
     * <a>ListAvailableManagedRuleGroupVersions</a> for the managed rule group.
     * </p>
     * <note>
     * <p>
     * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web
     * Services Marketplace sellers.
     * </p>
     * <p>
     * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group
     * offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>,
     * <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateManagedRuleSetVersionExpiryDateRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateManagedRuleSetVersionExpiryDateRequest#builder()}
     * </p>
     *
     * @param updateManagedRuleSetVersionExpiryDateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateManagedRuleSetVersionExpiryDateRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateManagedRuleSetVersionExpiryDate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.UpdateManagedRuleSetVersionExpiryDate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateManagedRuleSetVersionExpiryDate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateManagedRuleSetVersionExpiryDateResponse> updateManagedRuleSetVersionExpiryDate(
            Consumer<UpdateManagedRuleSetVersionExpiryDateRequest.Builder> updateManagedRuleSetVersionExpiryDateRequest) {
        return updateManagedRuleSetVersionExpiryDate(UpdateManagedRuleSetVersionExpiryDateRequest.builder()
                .applyMutation(updateManagedRuleSetVersionExpiryDateRequest).build());
    }

    /**
     * <p>
     * Updates the specified <a>RegexPatternSet</a>.
     * </p>
     * <note>
     * <p>
     * This operation completely replaces the mutable specifications that you already have for the regex pattern set
     * with the ones that you provide to this call.
     * </p>
     * <p>
     * To modify a regex pattern set, do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Retrieve it by calling <a>GetRegexPatternSet</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * Update its settings as needed
     * </p>
     * </li>
     * <li>
     * <p>
     * Provide the complete regex pattern set specification to this call
     * </p>
     * </li>
     * </ol>
     * </note>
     * <p>
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes
     * everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but
     * there might be a brief period of inconsistency when the changes have arrived in some places and not in others.
     * So, for example, if you change a rule action setting, the action might be the old action in one area and the new
     * action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might
     * briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you
     * first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already
     * associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     * </p>
     *
     * @param updateRegexPatternSetRequest
     * @return A Java Future containing the result of the UpdateRegexPatternSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafDuplicateItemException WAF couldn’t perform the operation because the resource that you tried to
     *         save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon
     *         Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF
     *         Developer Guide</i>.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.UpdateRegexPatternSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateRegexPatternSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateRegexPatternSetResponse> updateRegexPatternSet(
            UpdateRegexPatternSetRequest updateRegexPatternSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified <a>RegexPatternSet</a>.
     * </p>
     * <note>
     * <p>
     * This operation completely replaces the mutable specifications that you already have for the regex pattern set
     * with the ones that you provide to this call.
     * </p>
     * <p>
     * To modify a regex pattern set, do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Retrieve it by calling <a>GetRegexPatternSet</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * Update its settings as needed
     * </p>
     * </li>
     * <li>
     * <p>
     * Provide the complete regex pattern set specification to this call
     * </p>
     * </li>
     * </ol>
     * </note>
     * <p>
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes
     * everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but
     * there might be a brief period of inconsistency when the changes have arrived in some places and not in others.
     * So, for example, if you change a rule action setting, the action might be the old action in one area and the new
     * action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might
     * briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you
     * first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already
     * associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRegexPatternSetRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRegexPatternSetRequest#builder()}
     * </p>
     *
     * @param updateRegexPatternSetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRegexPatternSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateRegexPatternSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafDuplicateItemException WAF couldn’t perform the operation because the resource that you tried to
     *         save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon
     *         Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF
     *         Developer Guide</i>.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.UpdateRegexPatternSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateRegexPatternSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateRegexPatternSetResponse> updateRegexPatternSet(
            Consumer<UpdateRegexPatternSetRequest.Builder> updateRegexPatternSetRequest) {
        return updateRegexPatternSet(UpdateRegexPatternSetRequest.builder().applyMutation(updateRegexPatternSetRequest).build());
    }

    /**
     * <p>
     * Updates the specified <a>RuleGroup</a>.
     * </p>
     * <note>
     * <p>
     * This operation completely replaces the mutable specifications that you already have for the rule group with the
     * ones that you provide to this call.
     * </p>
     * <p>
     * To modify a rule group, do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Retrieve it by calling <a>GetRuleGroup</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * Update its settings as needed
     * </p>
     * </li>
     * <li>
     * <p>
     * Provide the complete rule group specification to this call
     * </p>
     * </li>
     * </ol>
     * </note>
     * <p>
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes
     * everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but
     * there might be a brief period of inconsistency when the changes have arrived in some places and not in others.
     * So, for example, if you change a rule action setting, the action might be the old action in one area and the new
     * action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might
     * briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you
     * first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already
     * associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     * </p>
     * <p>
     * A rule group defines a collection of rules to inspect and control web requests that you can use in a
     * <a>WebACL</a>. When you create a rule group, you define an immutable capacity limit. If you update a rule group,
     * you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity
     * requirements.
     * </p>
     *
     * @param updateRuleGroupRequest
     * @return A Java Future containing the result of the UpdateRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafDuplicateItemException WAF couldn’t perform the operation because the resource that you tried to
     *         save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon
     *         Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF
     *         Developer Guide</i>.</li>
     *         <li>WafUnavailableEntityException WAF couldn’t retrieve a resource that you specified for this operation.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate. Verify the
     *         resources that you are specifying in your request parameters and then retry the operation.</li>
     *         <li>WafSubscriptionNotFoundException You tried to use a managed rule group that's available by
     *         subscription, but you aren't subscribed to it yet.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>WafConfigurationWarningException The operation failed because you are inspecting the web request
     *         body, headers, or cookies without specifying how to handle oversize components. Rules that inspect the
     *         body must either provide an <code>OversizeHandling</code> configuration or they must be preceded by a
     *         <code>SizeConstraintStatement</code> that blocks the body content from being too large. Rules that
     *         inspect the headers or cookies must provide an <code>OversizeHandling</code> configuration. </p>
     *         <p>
     *         Provide the handling configuration and retry your operation.
     *         </p>
     *         <p>
     *         Alternately, you can suppress this warning by adding the following tag to the resource that you provide
     *         to this operation: <code>Tag</code> (key:<code>WAF:OversizeFieldsHandlingConstraintOptOut</code>, value:
     *         <code>true</code>).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.UpdateRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRuleGroupResponse> updateRuleGroup(UpdateRuleGroupRequest updateRuleGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified <a>RuleGroup</a>.
     * </p>
     * <note>
     * <p>
     * This operation completely replaces the mutable specifications that you already have for the rule group with the
     * ones that you provide to this call.
     * </p>
     * <p>
     * To modify a rule group, do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Retrieve it by calling <a>GetRuleGroup</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * Update its settings as needed
     * </p>
     * </li>
     * <li>
     * <p>
     * Provide the complete rule group specification to this call
     * </p>
     * </li>
     * </ol>
     * </note>
     * <p>
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes
     * everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but
     * there might be a brief period of inconsistency when the changes have arrived in some places and not in others.
     * So, for example, if you change a rule action setting, the action might be the old action in one area and the new
     * action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might
     * briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you
     * first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already
     * associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     * </p>
     * <p>
     * A rule group defines a collection of rules to inspect and control web requests that you can use in a
     * <a>WebACL</a>. When you create a rule group, you define an immutable capacity limit. If you update a rule group,
     * you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity
     * requirements.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRuleGroupRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateRuleGroupRequest#builder()}
     * </p>
     *
     * @param updateRuleGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRuleGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafDuplicateItemException WAF couldn’t perform the operation because the resource that you tried to
     *         save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon
     *         Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF
     *         Developer Guide</i>.</li>
     *         <li>WafUnavailableEntityException WAF couldn’t retrieve a resource that you specified for this operation.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate. Verify the
     *         resources that you are specifying in your request parameters and then retry the operation.</li>
     *         <li>WafSubscriptionNotFoundException You tried to use a managed rule group that's available by
     *         subscription, but you aren't subscribed to it yet.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>WafConfigurationWarningException The operation failed because you are inspecting the web request
     *         body, headers, or cookies without specifying how to handle oversize components. Rules that inspect the
     *         body must either provide an <code>OversizeHandling</code> configuration or they must be preceded by a
     *         <code>SizeConstraintStatement</code> that blocks the body content from being too large. Rules that
     *         inspect the headers or cookies must provide an <code>OversizeHandling</code> configuration. </p>
     *         <p>
     *         Provide the handling configuration and retry your operation.
     *         </p>
     *         <p>
     *         Alternately, you can suppress this warning by adding the following tag to the resource that you provide
     *         to this operation: <code>Tag</code> (key:<code>WAF:OversizeFieldsHandlingConstraintOptOut</code>, value:
     *         <code>true</code>).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.UpdateRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRuleGroupResponse> updateRuleGroup(
            Consumer<UpdateRuleGroupRequest.Builder> updateRuleGroupRequest) {
        return updateRuleGroup(UpdateRuleGroupRequest.builder().applyMutation(updateRuleGroupRequest).build());
    }

    /**
     * <p>
     * Updates the specified <a>WebACL</a>. While updating a web ACL, WAF provides continuous coverage to the resources
     * that you have associated with the web ACL.
     * </p>
     * <note>
     * <p>
     * This operation completely replaces the mutable specifications that you already have for the web ACL with the ones
     * that you provide to this call.
     * </p>
     * <p>
     * To modify a web ACL, do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Retrieve it by calling <a>GetWebACL</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * Update its settings as needed
     * </p>
     * </li>
     * <li>
     * <p>
     * Provide the complete web ACL specification to this call
     * </p>
     * </li>
     * </ol>
     * </note>
     * <p>
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes
     * everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but
     * there might be a brief period of inconsistency when the changes have arrived in some places and not in others.
     * So, for example, if you change a rule action setting, the action might be the old action in one area and the new
     * action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might
     * briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you
     * first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already
     * associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     * </p>
     * <p>
     * A web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action
     * defined (allow, block, or count) for requests that match the statement of the rule. In the web ACL, you assign a
     * default action to take (allow, block) for any request that does not match any of the rules. The rules in a web
     * ACL can be a combination of the types <a>Rule</a>, <a>RuleGroup</a>, and managed rule group. You can associate a
     * web ACL with one or more Amazon Web Services resources to protect. The resources can be an Amazon CloudFront
     * distribution, an Amazon API Gateway REST API, an Application Load Balancer, an AppSync GraphQL API, an Amazon
     * Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance.
     * </p>
     *
     * @param updateWebAclRequest
     * @return A Java Future containing the result of the UpdateWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafDuplicateItemException WAF couldn’t perform the operation because the resource that you tried to
     *         save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon
     *         Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF
     *         Developer Guide</i>.</li>
     *         <li>WafInvalidResourceException WAF couldn’t perform the operation because the resource that you
     *         requested isn’t valid. Check the resource, and try again.</li>
     *         <li>WafUnavailableEntityException WAF couldn’t retrieve a resource that you specified for this operation.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate. Verify the
     *         resources that you are specifying in your request parameters and then retry the operation.</li>
     *         <li>WafSubscriptionNotFoundException You tried to use a managed rule group that's available by
     *         subscription, but you aren't subscribed to it yet.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>WafExpiredManagedRuleGroupVersionException The operation failed because the specified version for the
     *         managed rule group has expired. You can retrieve the available versions for the managed rule group by
     *         calling <a>ListAvailableManagedRuleGroupVersions</a>.</li>
     *         <li>WafConfigurationWarningException The operation failed because you are inspecting the web request
     *         body, headers, or cookies without specifying how to handle oversize components. Rules that inspect the
     *         body must either provide an <code>OversizeHandling</code> configuration or they must be preceded by a
     *         <code>SizeConstraintStatement</code> that blocks the body content from being too large. Rules that
     *         inspect the headers or cookies must provide an <code>OversizeHandling</code> configuration. </p>
     *         <p>
     *         Provide the handling configuration and retry your operation.
     *         </p>
     *         <p>
     *         Alternately, you can suppress this warning by adding the following tag to the resource that you provide
     *         to this operation: <code>Tag</code> (key:<code>WAF:OversizeFieldsHandlingConstraintOptOut</code>, value:
     *         <code>true</code>).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.UpdateWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateWebAclResponse> updateWebACL(UpdateWebAclRequest updateWebAclRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified <a>WebACL</a>. While updating a web ACL, WAF provides continuous coverage to the resources
     * that you have associated with the web ACL.
     * </p>
     * <note>
     * <p>
     * This operation completely replaces the mutable specifications that you already have for the web ACL with the ones
     * that you provide to this call.
     * </p>
     * <p>
     * To modify a web ACL, do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Retrieve it by calling <a>GetWebACL</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * Update its settings as needed
     * </p>
     * </li>
     * <li>
     * <p>
     * Provide the complete web ACL specification to this call
     * </p>
     * </li>
     * </ol>
     * </note>
     * <p>
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes
     * everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but
     * there might be a brief period of inconsistency when the changes have arrived in some places and not in others.
     * So, for example, if you change a rule action setting, the action might be the old action in one area and the new
     * action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might
     * briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you
     * first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already
     * associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     * </p>
     * <p>
     * A web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action
     * defined (allow, block, or count) for requests that match the statement of the rule. In the web ACL, you assign a
     * default action to take (allow, block) for any request that does not match any of the rules. The rules in a web
     * ACL can be a combination of the types <a>Rule</a>, <a>RuleGroup</a>, and managed rule group. You can associate a
     * web ACL with one or more Amazon Web Services resources to protect. The resources can be an Amazon CloudFront
     * distribution, an Amazon API Gateway REST API, an Application Load Balancer, an AppSync GraphQL API, an Amazon
     * Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWebAclRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateWebAclRequest#builder()}
     * </p>
     *
     * @param updateWebAclRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWebACLRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but WAF couldn’t perform the operation because of a
     *         system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified a parameter name or value that isn't valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't
     *         be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException WAF couldn’t perform the operation because your resource doesn't exist.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate.</li>
     *         <li>WafDuplicateItemException WAF couldn’t perform the operation because the resource that you tried to
     *         save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon
     *         Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF
     *         Developer Guide</i>.</li>
     *         <li>WafInvalidResourceException WAF couldn’t perform the operation because the resource that you
     *         requested isn’t valid. Check the resource, and try again.</li>
     *         <li>WafUnavailableEntityException WAF couldn’t retrieve a resource that you specified for this operation.
     *         If you've just created a resource that you're using in this operation, you might just need to wait a few
     *         minutes. It can take from a few seconds to a number of minutes for changes to propagate. Verify the
     *         resources that you are specifying in your request parameters and then retry the operation.</li>
     *         <li>WafSubscriptionNotFoundException You tried to use a managed rule group that's available by
     *         subscription, but you aren't subscribed to it yet.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>WafExpiredManagedRuleGroupVersionException The operation failed because the specified version for the
     *         managed rule group has expired. You can retrieve the available versions for the managed rule group by
     *         calling <a>ListAvailableManagedRuleGroupVersions</a>.</li>
     *         <li>WafConfigurationWarningException The operation failed because you are inspecting the web request
     *         body, headers, or cookies without specifying how to handle oversize components. Rules that inspect the
     *         body must either provide an <code>OversizeHandling</code> configuration or they must be preceded by a
     *         <code>SizeConstraintStatement</code> that blocks the body content from being too large. Rules that
     *         inspect the headers or cookies must provide an <code>OversizeHandling</code> configuration. </p>
     *         <p>
     *         Provide the handling configuration and retry your operation.
     *         </p>
     *         <p>
     *         Alternately, you can suppress this warning by adding the following tag to the resource that you provide
     *         to this operation: <code>Tag</code> (key:<code>WAF:OversizeFieldsHandlingConstraintOptOut</code>, value:
     *         <code>true</code>).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.UpdateWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateWebAclResponse> updateWebACL(Consumer<UpdateWebAclRequest.Builder> updateWebAclRequest) {
        return updateWebACL(UpdateWebAclRequest.builder().applyMutation(updateWebAclRequest).build());
    }

    @Override
    default Wafv2ServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link Wafv2AsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static Wafv2AsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link Wafv2AsyncClient}.
     */
    static Wafv2AsyncClientBuilder builder() {
        return new DefaultWafv2AsyncClientBuilder();
    }
}
