/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.FieldToMatch;
import software.amazon.awssdk.services.wafv2.model.PositionalConstraint;
import software.amazon.awssdk.services.wafv2.model.TextTransformation;
import software.amazon.awssdk.services.wafv2.model.TextTransformationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ByteMatchStatement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ByteMatchStatement> {
    private static final SdkField<SdkBytes> SEARCH_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("SearchString").getter(ByteMatchStatement.getter(ByteMatchStatement::searchString)).setter(ByteMatchStatement.setter(Builder::searchString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchString").build()}).build();
    private static final SdkField<FieldToMatch> FIELD_TO_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FieldToMatch").getter(ByteMatchStatement.getter(ByteMatchStatement::fieldToMatch)).setter(ByteMatchStatement.setter(Builder::fieldToMatch)).constructor(FieldToMatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldToMatch").build()}).build();
    private static final SdkField<List<TextTransformation>> TEXT_TRANSFORMATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TextTransformations").getter(ByteMatchStatement.getter(ByteMatchStatement::textTransformations)).setter(ByteMatchStatement.setter(Builder::textTransformations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextTransformations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TextTransformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> POSITIONAL_CONSTRAINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PositionalConstraint").getter(ByteMatchStatement.getter(ByteMatchStatement::positionalConstraintAsString)).setter(ByteMatchStatement.setter(Builder::positionalConstraint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PositionalConstraint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCH_STRING_FIELD, FIELD_TO_MATCH_FIELD, TEXT_TRANSFORMATIONS_FIELD, POSITIONAL_CONSTRAINT_FIELD));
    private static final long serialVersionUID = 1L;
    private final SdkBytes searchString;
    private final FieldToMatch fieldToMatch;
    private final List<TextTransformation> textTransformations;
    private final String positionalConstraint;

    private ByteMatchStatement(BuilderImpl builder) {
        this.searchString = builder.searchString;
        this.fieldToMatch = builder.fieldToMatch;
        this.textTransformations = builder.textTransformations;
        this.positionalConstraint = builder.positionalConstraint;
    }

    public final SdkBytes searchString() {
        return this.searchString;
    }

    public final FieldToMatch fieldToMatch() {
        return this.fieldToMatch;
    }

    public final boolean hasTextTransformations() {
        return this.textTransformations != null && !(this.textTransformations instanceof SdkAutoConstructList);
    }

    public final List<TextTransformation> textTransformations() {
        return this.textTransformations;
    }

    public final PositionalConstraint positionalConstraint() {
        return PositionalConstraint.fromValue(this.positionalConstraint);
    }

    public final String positionalConstraintAsString() {
        return this.positionalConstraint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.searchString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldToMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTextTransformations() ? this.textTransformations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.positionalConstraintAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByteMatchStatement)) {
            return false;
        }
        ByteMatchStatement other = (ByteMatchStatement)obj;
        return Objects.equals(this.searchString(), other.searchString()) && Objects.equals(this.fieldToMatch(), other.fieldToMatch()) && this.hasTextTransformations() == other.hasTextTransformations() && Objects.equals(this.textTransformations(), other.textTransformations()) && Objects.equals(this.positionalConstraintAsString(), other.positionalConstraintAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ByteMatchStatement").add("SearchString", (Object)this.searchString()).add("FieldToMatch", (Object)this.fieldToMatch()).add("TextTransformations", this.hasTextTransformations() ? this.textTransformations() : null).add("PositionalConstraint", (Object)this.positionalConstraintAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SearchString": {
                return Optional.ofNullable(clazz.cast(this.searchString()));
            }
            case "FieldToMatch": {
                return Optional.ofNullable(clazz.cast(this.fieldToMatch()));
            }
            case "TextTransformations": {
                return Optional.ofNullable(clazz.cast(this.textTransformations()));
            }
            case "PositionalConstraint": {
                return Optional.ofNullable(clazz.cast(this.positionalConstraintAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ByteMatchStatement, T> g) {
        return obj -> g.apply((ByteMatchStatement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes searchString;
        private FieldToMatch fieldToMatch;
        private List<TextTransformation> textTransformations = DefaultSdkAutoConstructList.getInstance();
        private String positionalConstraint;

        private BuilderImpl() {
        }

        private BuilderImpl(ByteMatchStatement model) {
            this.searchString(model.searchString);
            this.fieldToMatch(model.fieldToMatch);
            this.textTransformations(model.textTransformations);
            this.positionalConstraint(model.positionalConstraint);
        }

        public final ByteBuffer getSearchString() {
            return this.searchString == null ? null : this.searchString.asByteBuffer();
        }

        public final void setSearchString(ByteBuffer searchString) {
            this.searchString(searchString == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)searchString));
        }

        @Override
        @Transient
        public final Builder searchString(SdkBytes searchString) {
            this.searchString = searchString;
            return this;
        }

        public final FieldToMatch.Builder getFieldToMatch() {
            return this.fieldToMatch != null ? this.fieldToMatch.toBuilder() : null;
        }

        public final void setFieldToMatch(FieldToMatch.BuilderImpl fieldToMatch) {
            this.fieldToMatch = fieldToMatch != null ? fieldToMatch.build() : null;
        }

        @Override
        @Transient
        public final Builder fieldToMatch(FieldToMatch fieldToMatch) {
            this.fieldToMatch = fieldToMatch;
            return this;
        }

        public final List<TextTransformation.Builder> getTextTransformations() {
            List<TextTransformation.Builder> result = TextTransformationsCopier.copyToBuilder(this.textTransformations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTextTransformations(Collection<TextTransformation.BuilderImpl> textTransformations) {
            this.textTransformations = TextTransformationsCopier.copyFromBuilder(textTransformations);
        }

        @Override
        @Transient
        public final Builder textTransformations(Collection<TextTransformation> textTransformations) {
            this.textTransformations = TextTransformationsCopier.copy(textTransformations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder textTransformations(TextTransformation ... textTransformations) {
            this.textTransformations(Arrays.asList(textTransformations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder textTransformations(Consumer<TextTransformation.Builder> ... textTransformations) {
            this.textTransformations(Stream.of(textTransformations).map(c -> (TextTransformation)((TextTransformation.Builder)TextTransformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPositionalConstraint() {
            return this.positionalConstraint;
        }

        public final void setPositionalConstraint(String positionalConstraint) {
            this.positionalConstraint = positionalConstraint;
        }

        @Override
        @Transient
        public final Builder positionalConstraint(String positionalConstraint) {
            this.positionalConstraint = positionalConstraint;
            return this;
        }

        @Override
        @Transient
        public final Builder positionalConstraint(PositionalConstraint positionalConstraint) {
            this.positionalConstraint(positionalConstraint == null ? null : positionalConstraint.toString());
            return this;
        }

        public ByteMatchStatement build() {
            return new ByteMatchStatement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ByteMatchStatement> {
        public Builder searchString(SdkBytes var1);

        public Builder fieldToMatch(FieldToMatch var1);

        default public Builder fieldToMatch(Consumer<FieldToMatch.Builder> fieldToMatch) {
            return this.fieldToMatch((FieldToMatch)((FieldToMatch.Builder)FieldToMatch.builder().applyMutation(fieldToMatch)).build());
        }

        public Builder textTransformations(Collection<TextTransformation> var1);

        public Builder textTransformations(TextTransformation ... var1);

        public Builder textTransformations(Consumer<TextTransformation.Builder> ... var1);

        public Builder positionalConstraint(String var1);

        public Builder positionalConstraint(PositionalConstraint var1);
    }
}

