/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.ReleaseSummariesCopier;
import software.amazon.awssdk.services.wafv2.model.ReleaseSummary;
import software.amazon.awssdk.services.wafv2.model.Wafv2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMobileSdkReleasesResponse
extends Wafv2Response
implements ToCopyableBuilder<Builder, ListMobileSdkReleasesResponse> {
    private static final SdkField<List<ReleaseSummary>> RELEASE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReleaseSummaries").getter(ListMobileSdkReleasesResponse.getter(ListMobileSdkReleasesResponse::releaseSummaries)).setter(ListMobileSdkReleasesResponse.setter(Builder::releaseSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReleaseSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListMobileSdkReleasesResponse.getter(ListMobileSdkReleasesResponse::nextMarker)).setter(ListMobileSdkReleasesResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELEASE_SUMMARIES_FIELD, NEXT_MARKER_FIELD));
    private final List<ReleaseSummary> releaseSummaries;
    private final String nextMarker;

    private ListMobileSdkReleasesResponse(BuilderImpl builder) {
        super(builder);
        this.releaseSummaries = builder.releaseSummaries;
        this.nextMarker = builder.nextMarker;
    }

    public final boolean hasReleaseSummaries() {
        return this.releaseSummaries != null && !(this.releaseSummaries instanceof SdkAutoConstructList);
    }

    public final List<ReleaseSummary> releaseSummaries() {
        return this.releaseSummaries;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReleaseSummaries() ? this.releaseSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMobileSdkReleasesResponse)) {
            return false;
        }
        ListMobileSdkReleasesResponse other = (ListMobileSdkReleasesResponse)((Object)obj);
        return this.hasReleaseSummaries() == other.hasReleaseSummaries() && Objects.equals(this.releaseSummaries(), other.releaseSummaries()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public final String toString() {
        return ToString.builder((String)"ListMobileSdkReleasesResponse").add("ReleaseSummaries", this.hasReleaseSummaries() ? this.releaseSummaries() : null).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReleaseSummaries": {
                return Optional.ofNullable(clazz.cast(this.releaseSummaries()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMobileSdkReleasesResponse, T> g) {
        return obj -> g.apply((ListMobileSdkReleasesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Wafv2Response.BuilderImpl
    implements Builder {
        private List<ReleaseSummary> releaseSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMobileSdkReleasesResponse model) {
            super(model);
            this.releaseSummaries(model.releaseSummaries);
            this.nextMarker(model.nextMarker);
        }

        public final List<ReleaseSummary.Builder> getReleaseSummaries() {
            List<ReleaseSummary.Builder> result = ReleaseSummariesCopier.copyToBuilder(this.releaseSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReleaseSummaries(Collection<ReleaseSummary.BuilderImpl> releaseSummaries) {
            this.releaseSummaries = ReleaseSummariesCopier.copyFromBuilder(releaseSummaries);
        }

        @Override
        @Transient
        public final Builder releaseSummaries(Collection<ReleaseSummary> releaseSummaries) {
            this.releaseSummaries = ReleaseSummariesCopier.copy(releaseSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder releaseSummaries(ReleaseSummary ... releaseSummaries) {
            this.releaseSummaries(Arrays.asList(releaseSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder releaseSummaries(Consumer<ReleaseSummary.Builder> ... releaseSummaries) {
            this.releaseSummaries(Stream.of(releaseSummaries).map(c -> (ReleaseSummary)((ReleaseSummary.Builder)ReleaseSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        @Transient
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public ListMobileSdkReleasesResponse build() {
            return new ListMobileSdkReleasesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Wafv2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMobileSdkReleasesResponse> {
        public Builder releaseSummaries(Collection<ReleaseSummary> var1);

        public Builder releaseSummaries(ReleaseSummary ... var1);

        public Builder releaseSummaries(Consumer<ReleaseSummary.Builder> ... var1);

        public Builder nextMarker(String var1);
    }
}

