/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourcesForWebAclRequest extends Wafv2Request implements
        ToCopyableBuilder<ListResourcesForWebAclRequest.Builder, ListResourcesForWebAclRequest> {
    private static final SdkField<String> WEB_ACL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebACLArn").getter(getter(ListResourcesForWebAclRequest::webACLArn)).setter(setter(Builder::webACLArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACLArn").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ListResourcesForWebAclRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_ACL_ARN_FIELD,
            RESOURCE_TYPE_FIELD));

    private final String webACLArn;

    private final String resourceType;

    private ListResourcesForWebAclRequest(BuilderImpl builder) {
        super(builder);
        this.webACLArn = builder.webACLArn;
        this.resourceType = builder.resourceType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Web ACL.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Web ACL.
     */
    public final String webACLArn() {
        return webACLArn;
    }

    /**
     * <p>
     * Used for web ACLs that are scoped for regional applications. A regional application can be an Application Load
     * Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Used for web ACLs that are scoped for regional applications. A regional application can be an Application
     *         Load Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL API.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * Used for web ACLs that are scoped for regional applications. A regional application can be an Application Load
     * Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Used for web ACLs that are scoped for regional applications. A regional application can be an Application
     *         Load Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL API.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(webACLArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourcesForWebAclRequest)) {
            return false;
        }
        ListResourcesForWebAclRequest other = (ListResourcesForWebAclRequest) obj;
        return Objects.equals(webACLArn(), other.webACLArn())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResourcesForWebAclRequest").add("WebACLArn", webACLArn())
                .add("ResourceType", resourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebACLArn":
            return Optional.ofNullable(clazz.cast(webACLArn()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourcesForWebAclRequest, T> g) {
        return obj -> g.apply((ListResourcesForWebAclRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Wafv2Request.Builder, SdkPojo, CopyableBuilder<Builder, ListResourcesForWebAclRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Web ACL.
         * </p>
         * 
         * @param webACLArn
         *        The Amazon Resource Name (ARN) of the Web ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webACLArn(String webACLArn);

        /**
         * <p>
         * Used for web ACLs that are scoped for regional applications. A regional application can be an Application
         * Load Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL API.
         * </p>
         * 
         * @param resourceType
         *        Used for web ACLs that are scoped for regional applications. A regional application can be an
         *        Application Load Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL API.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Used for web ACLs that are scoped for regional applications. A regional application can be an Application
         * Load Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL API.
         * </p>
         * 
         * @param resourceType
         *        Used for web ACLs that are scoped for regional applications. A regional application can be an
         *        Application Load Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL API.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Wafv2Request.BuilderImpl implements Builder {
        private String webACLArn;

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourcesForWebAclRequest model) {
            super(model);
            webACLArn(model.webACLArn);
            resourceType(model.resourceType);
        }

        public final String getWebACLArn() {
            return webACLArn;
        }

        @Override
        public final Builder webACLArn(String webACLArn) {
            this.webACLArn = webACLArn;
            return this;
        }

        public final void setWebACLArn(String webACLArn) {
            this.webACLArn = webACLArn;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListResourcesForWebAclRequest build() {
            return new ListResourcesForWebAclRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
