/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The patterns to look for in the JSON body. AWS WAF inspects the results of these pattern matches against the rule
 * inspection criteria. This is used with the <a>FieldToMatch</a> option <code>JsonBody</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JsonMatchPattern implements SdkPojo, Serializable,
        ToCopyableBuilder<JsonMatchPattern.Builder, JsonMatchPattern> {
    private static final SdkField<All> ALL_FIELD = SdkField.<All> builder(MarshallingType.SDK_POJO).memberName("All")
            .getter(getter(JsonMatchPattern::all)).setter(setter(Builder::all)).constructor(All::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("All").build()).build();

    private static final SdkField<List<String>> INCLUDED_PATHS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IncludedPaths")
            .getter(getter(JsonMatchPattern::includedPaths))
            .setter(setter(Builder::includedPaths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludedPaths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALL_FIELD,
            INCLUDED_PATHS_FIELD));

    private static final long serialVersionUID = 1L;

    private final All all;

    private final List<String> includedPaths;

    private JsonMatchPattern(BuilderImpl builder) {
        this.all = builder.all;
        this.includedPaths = builder.includedPaths;
    }

    /**
     * <p>
     * Match all of the elements. See also <code>MatchScope</code> in <a>JsonBody</a>.
     * </p>
     * <p>
     * You must specify either this setting or the <code>IncludedPaths</code> setting, but not both.
     * </p>
     * 
     * @return Match all of the elements. See also <code>MatchScope</code> in <a>JsonBody</a>. </p>
     *         <p>
     *         You must specify either this setting or the <code>IncludedPaths</code> setting, but not both.
     */
    public final All all() {
        return all;
    }

    /**
     * Returns true if the IncludedPaths property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasIncludedPaths() {
        return includedPaths != null && !(includedPaths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Match only the specified include paths. See also <code>MatchScope</code> in <a>JsonBody</a>.
     * </p>
     * <p>
     * Provide the include paths using JSON Pointer syntax. For example,
     * <code>"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]</code>. For information about this syntax, see the
     * Internet Engineering Task Force (IETF) documentation <a href="https://tools.ietf.org/html/rfc6901">JavaScript
     * Object Notation (JSON) Pointer</a>.
     * </p>
     * <p>
     * You must specify either this setting or the <code>All</code> setting, but not both.
     * </p>
     * <note>
     * <p>
     * Don't use this option to include all paths. Instead, use the <code>All</code> setting.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIncludedPaths()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Match only the specified include paths. See also <code>MatchScope</code> in <a>JsonBody</a>. </p>
     *         <p>
     *         Provide the include paths using JSON Pointer syntax. For example,
     *         <code>"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]</code>. For information about this syntax, see
     *         the Internet Engineering Task Force (IETF) documentation <a
     *         href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
     *         </p>
     *         <p>
     *         You must specify either this setting or the <code>All</code> setting, but not both.
     *         </p>
     *         <note>
     *         <p>
     *         Don't use this option to include all paths. Instead, use the <code>All</code> setting.
     *         </p>
     */
    public final List<String> includedPaths() {
        return includedPaths;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(all());
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludedPaths() ? includedPaths() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JsonMatchPattern)) {
            return false;
        }
        JsonMatchPattern other = (JsonMatchPattern) obj;
        return Objects.equals(all(), other.all()) && hasIncludedPaths() == other.hasIncludedPaths()
                && Objects.equals(includedPaths(), other.includedPaths());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JsonMatchPattern").add("All", all())
                .add("IncludedPaths", hasIncludedPaths() ? includedPaths() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "All":
            return Optional.ofNullable(clazz.cast(all()));
        case "IncludedPaths":
            return Optional.ofNullable(clazz.cast(includedPaths()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JsonMatchPattern, T> g) {
        return obj -> g.apply((JsonMatchPattern) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JsonMatchPattern> {
        /**
         * <p>
         * Match all of the elements. See also <code>MatchScope</code> in <a>JsonBody</a>.
         * </p>
         * <p>
         * You must specify either this setting or the <code>IncludedPaths</code> setting, but not both.
         * </p>
         * 
         * @param all
         *        Match all of the elements. See also <code>MatchScope</code> in <a>JsonBody</a>. </p>
         *        <p>
         *        You must specify either this setting or the <code>IncludedPaths</code> setting, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder all(All all);

        /**
         * <p>
         * Match all of the elements. See also <code>MatchScope</code> in <a>JsonBody</a>.
         * </p>
         * <p>
         * You must specify either this setting or the <code>IncludedPaths</code> setting, but not both.
         * </p>
         * This is a convenience that creates an instance of the {@link All.Builder} avoiding the need to create one
         * manually via {@link All#builder()}.
         *
         * When the {@link Consumer} completes, {@link All.Builder#build()} is called immediately and its result is
         * passed to {@link #all(All)}.
         * 
         * @param all
         *        a consumer that will call methods on {@link All.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #all(All)
         */
        default Builder all(Consumer<All.Builder> all) {
            return all(All.builder().applyMutation(all).build());
        }

        /**
         * <p>
         * Match only the specified include paths. See also <code>MatchScope</code> in <a>JsonBody</a>.
         * </p>
         * <p>
         * Provide the include paths using JSON Pointer syntax. For example,
         * <code>"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]</code>. For information about this syntax, see the
         * Internet Engineering Task Force (IETF) documentation <a href="https://tools.ietf.org/html/rfc6901">JavaScript
         * Object Notation (JSON) Pointer</a>.
         * </p>
         * <p>
         * You must specify either this setting or the <code>All</code> setting, but not both.
         * </p>
         * <note>
         * <p>
         * Don't use this option to include all paths. Instead, use the <code>All</code> setting.
         * </p>
         * </note>
         * 
         * @param includedPaths
         *        Match only the specified include paths. See also <code>MatchScope</code> in <a>JsonBody</a>. </p>
         *        <p>
         *        Provide the include paths using JSON Pointer syntax. For example,
         *        <code>"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]</code>. For information about this syntax, see
         *        the Internet Engineering Task Force (IETF) documentation <a
         *        href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
         *        </p>
         *        <p>
         *        You must specify either this setting or the <code>All</code> setting, but not both.
         *        </p>
         *        <note>
         *        <p>
         *        Don't use this option to include all paths. Instead, use the <code>All</code> setting.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includedPaths(Collection<String> includedPaths);

        /**
         * <p>
         * Match only the specified include paths. See also <code>MatchScope</code> in <a>JsonBody</a>.
         * </p>
         * <p>
         * Provide the include paths using JSON Pointer syntax. For example,
         * <code>"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]</code>. For information about this syntax, see the
         * Internet Engineering Task Force (IETF) documentation <a href="https://tools.ietf.org/html/rfc6901">JavaScript
         * Object Notation (JSON) Pointer</a>.
         * </p>
         * <p>
         * You must specify either this setting or the <code>All</code> setting, but not both.
         * </p>
         * <note>
         * <p>
         * Don't use this option to include all paths. Instead, use the <code>All</code> setting.
         * </p>
         * </note>
         * 
         * @param includedPaths
         *        Match only the specified include paths. See also <code>MatchScope</code> in <a>JsonBody</a>. </p>
         *        <p>
         *        Provide the include paths using JSON Pointer syntax. For example,
         *        <code>"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]</code>. For information about this syntax, see
         *        the Internet Engineering Task Force (IETF) documentation <a
         *        href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
         *        </p>
         *        <p>
         *        You must specify either this setting or the <code>All</code> setting, but not both.
         *        </p>
         *        <note>
         *        <p>
         *        Don't use this option to include all paths. Instead, use the <code>All</code> setting.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includedPaths(String... includedPaths);
    }

    static final class BuilderImpl implements Builder {
        private All all;

        private List<String> includedPaths = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JsonMatchPattern model) {
            all(model.all);
            includedPaths(model.includedPaths);
        }

        public final All.Builder getAll() {
            return all != null ? all.toBuilder() : null;
        }

        @Override
        public final Builder all(All all) {
            this.all = all;
            return this;
        }

        public final void setAll(All.BuilderImpl all) {
            this.all = all != null ? all.build() : null;
        }

        public final Collection<String> getIncludedPaths() {
            if (includedPaths instanceof SdkAutoConstructList) {
                return null;
            }
            return includedPaths;
        }

        @Override
        public final Builder includedPaths(Collection<String> includedPaths) {
            this.includedPaths = JsonPointerPathsCopier.copy(includedPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedPaths(String... includedPaths) {
            includedPaths(Arrays.asList(includedPaths));
            return this;
        }

        public final void setIncludedPaths(Collection<String> includedPaths) {
            this.includedPaths = JsonPointerPathsCopier.copy(includedPaths);
        }

        @Override
        public JsonMatchPattern build() {
            return new JsonMatchPattern(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
