/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSampledRequestsRequest extends Wafv2Request implements
        ToCopyableBuilder<GetSampledRequestsRequest.Builder, GetSampledRequestsRequest> {
    private static final SdkField<String> WEB_ACL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebAclArn").getter(getter(GetSampledRequestsRequest::webAclArn)).setter(setter(Builder::webAclArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAclArn").build()).build();

    private static final SdkField<String> RULE_METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleMetricName").getter(getter(GetSampledRequestsRequest::ruleMetricName))
            .setter(setter(Builder::ruleMetricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleMetricName").build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Scope")
            .getter(getter(GetSampledRequestsRequest::scopeAsString)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()).build();

    private static final SdkField<TimeWindow> TIME_WINDOW_FIELD = SdkField.<TimeWindow> builder(MarshallingType.SDK_POJO)
            .memberName("TimeWindow").getter(getter(GetSampledRequestsRequest::timeWindow)).setter(setter(Builder::timeWindow))
            .constructor(TimeWindow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeWindow").build()).build();

    private static final SdkField<Long> MAX_ITEMS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("MaxItems")
            .getter(getter(GetSampledRequestsRequest::maxItems)).setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_ACL_ARN_FIELD,
            RULE_METRIC_NAME_FIELD, SCOPE_FIELD, TIME_WINDOW_FIELD, MAX_ITEMS_FIELD));

    private final String webAclArn;

    private final String ruleMetricName;

    private final String scope;

    private final TimeWindow timeWindow;

    private final Long maxItems;

    private GetSampledRequestsRequest(BuilderImpl builder) {
        super(builder);
        this.webAclArn = builder.webAclArn;
        this.ruleMetricName = builder.ruleMetricName;
        this.scope = builder.scope;
        this.timeWindow = builder.timeWindow;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) of the <code>WebACL</code> for which you want a sample of requests.
     * </p>
     * 
     * @return The Amazon resource name (ARN) of the <code>WebACL</code> for which you want a sample of requests.
     */
    public final String webAclArn() {
        return webAclArn;
    }

    /**
     * <p>
     * The metric name assigned to the <code>Rule</code> or <code>RuleGroup</code> for which you want a sample of
     * requests.
     * </p>
     * 
     * @return The metric name assigned to the <code>Rule</code> or <code>RuleGroup</code> for which you want a sample
     *         of requests.
     */
    public final String ruleMetricName() {
        return ruleMetricName;
    }

    /**
     * <p>
     * Specifies whether this is for an AWS CloudFront distribution or for a regional application. A regional
     * application can be an Application Load Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL API.
     * </p>
     * <p>
     * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * API and SDKs - For all calls, use the Region endpoint us-east-1.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Specifies whether this is for an AWS CloudFront distribution or for a regional application. A regional
     *         application can be an Application Load Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL
     *         API. </p>
     *         <p>
     *         To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CLI - Specify the Region when you use the CloudFront scope:
     *         <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         API and SDKs - For all calls, use the Region endpoint us-east-1.
     *         </p>
     *         </li>
     * @see Scope
     */
    public final Scope scope() {
        return Scope.fromValue(scope);
    }

    /**
     * <p>
     * Specifies whether this is for an AWS CloudFront distribution or for a regional application. A regional
     * application can be an Application Load Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL API.
     * </p>
     * <p>
     * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * API and SDKs - For all calls, use the Region endpoint us-east-1.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Specifies whether this is for an AWS CloudFront distribution or for a regional application. A regional
     *         application can be an Application Load Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL
     *         API. </p>
     *         <p>
     *         To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CLI - Specify the Region when you use the CloudFront scope:
     *         <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         API and SDKs - For all calls, use the Region endpoint us-east-1.
     *         </p>
     *         </li>
     * @see Scope
     */
    public final String scopeAsString() {
        return scope;
    }

    /**
     * <p>
     * The start date and time and the end date and time of the range for which you want <code>GetSampledRequests</code>
     * to return a sample of requests. You must specify the times in Coordinated Universal Time (UTC) format. UTC format
     * includes the special designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify
     * any time range in the previous three hours. If you specify a start time that's earlier than three hours ago, AWS
     * WAF sets it to three hours ago.
     * </p>
     * 
     * @return The start date and time and the end date and time of the range for which you want
     *         <code>GetSampledRequests</code> to return a sample of requests. You must specify the times in Coordinated
     *         Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example,
     *         <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours. If you
     *         specify a start time that's earlier than three hours ago, AWS WAF sets it to three hours ago.
     */
    public final TimeWindow timeWindow() {
        return timeWindow;
    }

    /**
     * <p>
     * The number of requests that you want AWS WAF to return from among the first 5,000 requests that your AWS resource
     * received during the time range. If your resource received fewer requests than the value of <code>MaxItems</code>,
     * <code>GetSampledRequests</code> returns information about all of them.
     * </p>
     * 
     * @return The number of requests that you want AWS WAF to return from among the first 5,000 requests that your AWS
     *         resource received during the time range. If your resource received fewer requests than the value of
     *         <code>MaxItems</code>, <code>GetSampledRequests</code> returns information about all of them.
     */
    public final Long maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(webAclArn());
        hashCode = 31 * hashCode + Objects.hashCode(ruleMetricName());
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timeWindow());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSampledRequestsRequest)) {
            return false;
        }
        GetSampledRequestsRequest other = (GetSampledRequestsRequest) obj;
        return Objects.equals(webAclArn(), other.webAclArn()) && Objects.equals(ruleMetricName(), other.ruleMetricName())
                && Objects.equals(scopeAsString(), other.scopeAsString()) && Objects.equals(timeWindow(), other.timeWindow())
                && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSampledRequestsRequest").add("WebAclArn", webAclArn())
                .add("RuleMetricName", ruleMetricName()).add("Scope", scopeAsString()).add("TimeWindow", timeWindow())
                .add("MaxItems", maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebAclArn":
            return Optional.ofNullable(clazz.cast(webAclArn()));
        case "RuleMetricName":
            return Optional.ofNullable(clazz.cast(ruleMetricName()));
        case "Scope":
            return Optional.ofNullable(clazz.cast(scopeAsString()));
        case "TimeWindow":
            return Optional.ofNullable(clazz.cast(timeWindow()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSampledRequestsRequest, T> g) {
        return obj -> g.apply((GetSampledRequestsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Wafv2Request.Builder, SdkPojo, CopyableBuilder<Builder, GetSampledRequestsRequest> {
        /**
         * <p>
         * The Amazon resource name (ARN) of the <code>WebACL</code> for which you want a sample of requests.
         * </p>
         * 
         * @param webAclArn
         *        The Amazon resource name (ARN) of the <code>WebACL</code> for which you want a sample of requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webAclArn(String webAclArn);

        /**
         * <p>
         * The metric name assigned to the <code>Rule</code> or <code>RuleGroup</code> for which you want a sample of
         * requests.
         * </p>
         * 
         * @param ruleMetricName
         *        The metric name assigned to the <code>Rule</code> or <code>RuleGroup</code> for which you want a
         *        sample of requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleMetricName(String ruleMetricName);

        /**
         * <p>
         * Specifies whether this is for an AWS CloudFront distribution or for a regional application. A regional
         * application can be an Application Load Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL API.
         * </p>
         * <p>
         * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CLI - Specify the Region when you use the CloudFront scope:
         * <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * API and SDKs - For all calls, use the Region endpoint us-east-1.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scope
         *        Specifies whether this is for an AWS CloudFront distribution or for a regional application. A regional
         *        application can be an Application Load Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL
         *        API. </p>
         *        <p>
         *        To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CLI - Specify the Region when you use the CloudFront scope:
         *        <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        API and SDKs - For all calls, use the Region endpoint us-east-1.
         *        </p>
         *        </li>
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(String scope);

        /**
         * <p>
         * Specifies whether this is for an AWS CloudFront distribution or for a regional application. A regional
         * application can be an Application Load Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL API.
         * </p>
         * <p>
         * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CLI - Specify the Region when you use the CloudFront scope:
         * <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * API and SDKs - For all calls, use the Region endpoint us-east-1.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scope
         *        Specifies whether this is for an AWS CloudFront distribution or for a regional application. A regional
         *        application can be an Application Load Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL
         *        API. </p>
         *        <p>
         *        To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CLI - Specify the Region when you use the CloudFront scope:
         *        <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        API and SDKs - For all calls, use the Region endpoint us-east-1.
         *        </p>
         *        </li>
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(Scope scope);

        /**
         * <p>
         * The start date and time and the end date and time of the range for which you want
         * <code>GetSampledRequests</code> to return a sample of requests. You must specify the times in Coordinated
         * Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example,
         * <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours. If you specify
         * a start time that's earlier than three hours ago, AWS WAF sets it to three hours ago.
         * </p>
         * 
         * @param timeWindow
         *        The start date and time and the end date and time of the range for which you want
         *        <code>GetSampledRequests</code> to return a sample of requests. You must specify the times in
         *        Coordinated Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>.
         *        For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three
         *        hours. If you specify a start time that's earlier than three hours ago, AWS WAF sets it to three hours
         *        ago.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeWindow(TimeWindow timeWindow);

        /**
         * <p>
         * The start date and time and the end date and time of the range for which you want
         * <code>GetSampledRequests</code> to return a sample of requests. You must specify the times in Coordinated
         * Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example,
         * <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours. If you specify
         * a start time that's earlier than three hours ago, AWS WAF sets it to three hours ago.
         * </p>
         * This is a convenience that creates an instance of the {@link TimeWindow.Builder} avoiding the need to create
         * one manually via {@link TimeWindow#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimeWindow.Builder#build()} is called immediately and its result
         * is passed to {@link #timeWindow(TimeWindow)}.
         * 
         * @param timeWindow
         *        a consumer that will call methods on {@link TimeWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeWindow(TimeWindow)
         */
        default Builder timeWindow(Consumer<TimeWindow.Builder> timeWindow) {
            return timeWindow(TimeWindow.builder().applyMutation(timeWindow).build());
        }

        /**
         * <p>
         * The number of requests that you want AWS WAF to return from among the first 5,000 requests that your AWS
         * resource received during the time range. If your resource received fewer requests than the value of
         * <code>MaxItems</code>, <code>GetSampledRequests</code> returns information about all of them.
         * </p>
         * 
         * @param maxItems
         *        The number of requests that you want AWS WAF to return from among the first 5,000 requests that your
         *        AWS resource received during the time range. If your resource received fewer requests than the value
         *        of <code>MaxItems</code>, <code>GetSampledRequests</code> returns information about all of them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Long maxItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Wafv2Request.BuilderImpl implements Builder {
        private String webAclArn;

        private String ruleMetricName;

        private String scope;

        private TimeWindow timeWindow;

        private Long maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSampledRequestsRequest model) {
            super(model);
            webAclArn(model.webAclArn);
            ruleMetricName(model.ruleMetricName);
            scope(model.scope);
            timeWindow(model.timeWindow);
            maxItems(model.maxItems);
        }

        public final String getWebAclArn() {
            return webAclArn;
        }

        @Override
        public final Builder webAclArn(String webAclArn) {
            this.webAclArn = webAclArn;
            return this;
        }

        public final void setWebAclArn(String webAclArn) {
            this.webAclArn = webAclArn;
        }

        public final String getRuleMetricName() {
            return ruleMetricName;
        }

        @Override
        public final Builder ruleMetricName(String ruleMetricName) {
            this.ruleMetricName = ruleMetricName;
            return this;
        }

        public final void setRuleMetricName(String ruleMetricName) {
            this.ruleMetricName = ruleMetricName;
        }

        public final String getScope() {
            return scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        public final TimeWindow.Builder getTimeWindow() {
            return timeWindow != null ? timeWindow.toBuilder() : null;
        }

        @Override
        public final Builder timeWindow(TimeWindow timeWindow) {
            this.timeWindow = timeWindow;
            return this;
        }

        public final void setTimeWindow(TimeWindow.BuilderImpl timeWindow) {
            this.timeWindow = timeWindow != null ? timeWindow.build() : null;
        }

        public final Long getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(Long maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Long maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSampledRequestsRequest build() {
            return new GetSampledRequestsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
