/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information, including
 * how to migrate your AWS WAF resources from the prior release, see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
 * </p>
 * </note>
 * <p>
 * The set of IP addresses that are currently blocked for a rate-based statement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RateBasedStatementManagedKeysIPSet implements SdkPojo, Serializable,
        ToCopyableBuilder<RateBasedStatementManagedKeysIPSet.Builder, RateBasedStatementManagedKeysIPSet> {
    private static final SdkField<String> IP_ADDRESS_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RateBasedStatementManagedKeysIPSet::ipAddressVersionAsString))
            .setter(setter(Builder::ipAddressVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPAddressVersion").build()).build();

    private static final SdkField<List<String>> ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(RateBasedStatementManagedKeysIPSet::addresses))
            .setter(setter(Builder::addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ADDRESS_VERSION_FIELD,
            ADDRESSES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ipAddressVersion;

    private final List<String> addresses;

    private RateBasedStatementManagedKeysIPSet(BuilderImpl builder) {
        this.ipAddressVersion = builder.ipAddressVersion;
        this.addresses = builder.addresses;
    }

    /**
     * Returns the value of the IPAddressVersion property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressVersion}
     * will return {@link IPAddressVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ipAddressVersionAsString}.
     * </p>
     * 
     * @return The value of the IPAddressVersion property for this object.
     * @see IPAddressVersion
     */
    public IPAddressVersion ipAddressVersion() {
        return IPAddressVersion.fromValue(ipAddressVersion);
    }

    /**
     * Returns the value of the IPAddressVersion property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressVersion}
     * will return {@link IPAddressVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ipAddressVersionAsString}.
     * </p>
     * 
     * @return The value of the IPAddressVersion property for this object.
     * @see IPAddressVersion
     */
    public String ipAddressVersionAsString() {
        return ipAddressVersion;
    }

    /**
     * Returns true if the Addresses property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAddresses() {
        return addresses != null && !(addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IP addresses that are currently blocked.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAddresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IP addresses that are currently blocked.
     */
    public List<String> addresses() {
        return addresses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(addresses());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RateBasedStatementManagedKeysIPSet)) {
            return false;
        }
        RateBasedStatementManagedKeysIPSet other = (RateBasedStatementManagedKeysIPSet) obj;
        return Objects.equals(ipAddressVersionAsString(), other.ipAddressVersionAsString())
                && Objects.equals(addresses(), other.addresses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RateBasedStatementManagedKeysIPSet").add("IPAddressVersion", ipAddressVersionAsString())
                .add("Addresses", addresses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IPAddressVersion":
            return Optional.ofNullable(clazz.cast(ipAddressVersionAsString()));
        case "Addresses":
            return Optional.ofNullable(clazz.cast(addresses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RateBasedStatementManagedKeysIPSet, T> g) {
        return obj -> g.apply((RateBasedStatementManagedKeysIPSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RateBasedStatementManagedKeysIPSet> {
        /**
         * Sets the value of the IPAddressVersion property for this object.
         *
         * @param ipAddressVersion
         *        The new value for the IPAddressVersion property for this object.
         * @see IPAddressVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IPAddressVersion
         */
        Builder ipAddressVersion(String ipAddressVersion);

        /**
         * Sets the value of the IPAddressVersion property for this object.
         *
         * @param ipAddressVersion
         *        The new value for the IPAddressVersion property for this object.
         * @see IPAddressVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IPAddressVersion
         */
        Builder ipAddressVersion(IPAddressVersion ipAddressVersion);

        /**
         * <p>
         * The IP addresses that are currently blocked.
         * </p>
         * 
         * @param addresses
         *        The IP addresses that are currently blocked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addresses(Collection<String> addresses);

        /**
         * <p>
         * The IP addresses that are currently blocked.
         * </p>
         * 
         * @param addresses
         *        The IP addresses that are currently blocked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addresses(String... addresses);
    }

    static final class BuilderImpl implements Builder {
        private String ipAddressVersion;

        private List<String> addresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RateBasedStatementManagedKeysIPSet model) {
            ipAddressVersion(model.ipAddressVersion);
            addresses(model.addresses);
        }

        public final String getIpAddressVersion() {
            return ipAddressVersion;
        }

        @Override
        public final Builder ipAddressVersion(String ipAddressVersion) {
            this.ipAddressVersion = ipAddressVersion;
            return this;
        }

        @Override
        public final Builder ipAddressVersion(IPAddressVersion ipAddressVersion) {
            this.ipAddressVersion(ipAddressVersion == null ? null : ipAddressVersion.toString());
            return this;
        }

        public final void setIpAddressVersion(String ipAddressVersion) {
            this.ipAddressVersion = ipAddressVersion;
        }

        public final Collection<String> getAddresses() {
            return addresses;
        }

        @Override
        public final Builder addresses(Collection<String> addresses) {
            this.addresses = IPAddressesCopier.copy(addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addresses(String... addresses) {
            addresses(Arrays.asList(addresses));
            return this;
        }

        public final void setAddresses(Collection<String> addresses) {
            this.addresses = IPAddressesCopier.copy(addresses);
        }

        @Override
        public RateBasedStatementManagedKeysIPSet build() {
            return new RateBasedStatementManagedKeysIPSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
