/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information, including
 * how to migrate your AWS WAF resources from the prior release, see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
 * </p>
 * </note>
 * <p>
 * Defines and enables Amazon CloudWatch metrics and web request sample collection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VisibilityConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<VisibilityConfig.Builder, VisibilityConfig> {
    private static final SdkField<Boolean> SAMPLED_REQUESTS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(VisibilityConfig::sampledRequestsEnabled)).setter(setter(Builder::sampledRequestsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampledRequestsEnabled").build())
            .build();

    private static final SdkField<Boolean> CLOUD_WATCH_METRICS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).getter(getter(VisibilityConfig::cloudWatchMetricsEnabled))
            .setter(setter(Builder::cloudWatchMetricsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchMetricsEnabled").build())
            .build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VisibilityConfig::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SAMPLED_REQUESTS_ENABLED_FIELD, CLOUD_WATCH_METRICS_ENABLED_FIELD, METRIC_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean sampledRequestsEnabled;

    private final Boolean cloudWatchMetricsEnabled;

    private final String metricName;

    private VisibilityConfig(BuilderImpl builder) {
        this.sampledRequestsEnabled = builder.sampledRequestsEnabled;
        this.cloudWatchMetricsEnabled = builder.cloudWatchMetricsEnabled;
        this.metricName = builder.metricName;
    }

    /**
     * <p>
     * A boolean indicating whether AWS WAF should store a sampling of the web requests that match the rules. You can
     * view the sampled requests through the AWS WAF console.
     * </p>
     * 
     * @return A boolean indicating whether AWS WAF should store a sampling of the web requests that match the rules.
     *         You can view the sampled requests through the AWS WAF console.
     */
    public Boolean sampledRequestsEnabled() {
        return sampledRequestsEnabled;
    }

    /**
     * <p>
     * A boolean indicating whether the associated resource sends metrics to CloudWatch. For the list of available
     * metrics, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics">AWS WAF
     * Metrics</a>.
     * </p>
     * 
     * @return A boolean indicating whether the associated resource sends metrics to CloudWatch. For the list of
     *         available metrics, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics">AWS
     *         WAF Metrics</a>.
     */
    public Boolean cloudWatchMetricsEnabled() {
        return cloudWatchMetricsEnabled;
    }

    /**
     * <p>
     * A friendly name of the CloudWatch metric. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with
     * length from one to 128 characters. It can't contain whitespace or metric names reserved for AWS WAF, for example
     * "All" and "Default_Action." You can't change a <code>MetricName</code> after you create a
     * <code>VisibilityConfig</code>.
     * </p>
     * 
     * @return A friendly name of the CloudWatch metric. The name can contain only alphanumeric characters (A-Z, a-z,
     *         0-9), with length from one to 128 characters. It can't contain whitespace or metric names reserved for
     *         AWS WAF, for example "All" and "Default_Action." You can't change a <code>MetricName</code> after you
     *         create a <code>VisibilityConfig</code>.
     */
    public String metricName() {
        return metricName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sampledRequestsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchMetricsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VisibilityConfig)) {
            return false;
        }
        VisibilityConfig other = (VisibilityConfig) obj;
        return Objects.equals(sampledRequestsEnabled(), other.sampledRequestsEnabled())
                && Objects.equals(cloudWatchMetricsEnabled(), other.cloudWatchMetricsEnabled())
                && Objects.equals(metricName(), other.metricName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VisibilityConfig").add("SampledRequestsEnabled", sampledRequestsEnabled())
                .add("CloudWatchMetricsEnabled", cloudWatchMetricsEnabled()).add("MetricName", metricName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SampledRequestsEnabled":
            return Optional.ofNullable(clazz.cast(sampledRequestsEnabled()));
        case "CloudWatchMetricsEnabled":
            return Optional.ofNullable(clazz.cast(cloudWatchMetricsEnabled()));
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VisibilityConfig, T> g) {
        return obj -> g.apply((VisibilityConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VisibilityConfig> {
        /**
         * <p>
         * A boolean indicating whether AWS WAF should store a sampling of the web requests that match the rules. You
         * can view the sampled requests through the AWS WAF console.
         * </p>
         * 
         * @param sampledRequestsEnabled
         *        A boolean indicating whether AWS WAF should store a sampling of the web requests that match the rules.
         *        You can view the sampled requests through the AWS WAF console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampledRequestsEnabled(Boolean sampledRequestsEnabled);

        /**
         * <p>
         * A boolean indicating whether the associated resource sends metrics to CloudWatch. For the list of available
         * metrics, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics">AWS WAF
         * Metrics</a>.
         * </p>
         * 
         * @param cloudWatchMetricsEnabled
         *        A boolean indicating whether the associated resource sends metrics to CloudWatch. For the list of
         *        available metrics, see <a
         *        href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics"
         *        >AWS WAF Metrics</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled);

        /**
         * <p>
         * A friendly name of the CloudWatch metric. The name can contain only alphanumeric characters (A-Z, a-z, 0-9),
         * with length from one to 128 characters. It can't contain whitespace or metric names reserved for AWS WAF, for
         * example "All" and "Default_Action." You can't change a <code>MetricName</code> after you create a
         * <code>VisibilityConfig</code>.
         * </p>
         * 
         * @param metricName
         *        A friendly name of the CloudWatch metric. The name can contain only alphanumeric characters (A-Z, a-z,
         *        0-9), with length from one to 128 characters. It can't contain whitespace or metric names reserved for
         *        AWS WAF, for example "All" and "Default_Action." You can't change a <code>MetricName</code> after you
         *        create a <code>VisibilityConfig</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);
    }

    static final class BuilderImpl implements Builder {
        private Boolean sampledRequestsEnabled;

        private Boolean cloudWatchMetricsEnabled;

        private String metricName;

        private BuilderImpl() {
        }

        private BuilderImpl(VisibilityConfig model) {
            sampledRequestsEnabled(model.sampledRequestsEnabled);
            cloudWatchMetricsEnabled(model.cloudWatchMetricsEnabled);
            metricName(model.metricName);
        }

        public final Boolean getSampledRequestsEnabled() {
            return sampledRequestsEnabled;
        }

        @Override
        public final Builder sampledRequestsEnabled(Boolean sampledRequestsEnabled) {
            this.sampledRequestsEnabled = sampledRequestsEnabled;
            return this;
        }

        public final void setSampledRequestsEnabled(Boolean sampledRequestsEnabled) {
            this.sampledRequestsEnabled = sampledRequestsEnabled;
        }

        public final Boolean getCloudWatchMetricsEnabled() {
            return cloudWatchMetricsEnabled;
        }

        @Override
        public final Builder cloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled) {
            this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
            return this;
        }

        public final void setCloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled) {
            this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public VisibilityConfig build() {
            return new VisibilityConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
