/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information, including
 * how to migrate your AWS WAF resources from the prior release, see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
 * </p>
 * </note>
 * <p>
 * A rule statement used to run the rules that are defined in a <a>RuleGroup</a>. To use this, create a rule group with
 * your rules, then provide the ARN of the rule group in this statement.
 * </p>
 * <p>
 * You cannot nest a <code>RuleGroupReferenceStatement</code>, for example for use inside a <code>NotStatement</code> or
 * <code>OrStatement</code>. It can only be referenced as a top-level statement within a rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleGroupReferenceStatement implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleGroupReferenceStatement.Builder, RuleGroupReferenceStatement> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RuleGroupReferenceStatement::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final SdkField<List<ExcludedRule>> EXCLUDED_RULES_FIELD = SdkField
            .<List<ExcludedRule>> builder(MarshallingType.LIST)
            .getter(getter(RuleGroupReferenceStatement::excludedRules))
            .setter(setter(Builder::excludedRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExcludedRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExcludedRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            EXCLUDED_RULES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final List<ExcludedRule> excludedRules;

    private RuleGroupReferenceStatement(BuilderImpl builder) {
        this.arn = builder.arn;
        this.excludedRules = builder.excludedRules;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the entity.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the entity.
     */
    public String arn() {
        return arn;
    }

    /**
     * Returns true if the ExcludedRules property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasExcludedRules() {
        return excludedRules != null && !(excludedRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of rules that are in the referenced rule group, but that you want AWS WAF to exclude from processing
     * for this rule statement.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExcludedRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The names of rules that are in the referenced rule group, but that you want AWS WAF to exclude from
     *         processing for this rule statement.
     */
    public List<ExcludedRule> excludedRules() {
        return excludedRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(excludedRules());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupReferenceStatement)) {
            return false;
        }
        RuleGroupReferenceStatement other = (RuleGroupReferenceStatement) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(excludedRules(), other.excludedRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RuleGroupReferenceStatement").add("ARN", arn()).add("ExcludedRules", excludedRules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ExcludedRules":
            return Optional.ofNullable(clazz.cast(excludedRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupReferenceStatement, T> g) {
        return obj -> g.apply((RuleGroupReferenceStatement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleGroupReferenceStatement> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the entity.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The names of rules that are in the referenced rule group, but that you want AWS WAF to exclude from
         * processing for this rule statement.
         * </p>
         * 
         * @param excludedRules
         *        The names of rules that are in the referenced rule group, but that you want AWS WAF to exclude from
         *        processing for this rule statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedRules(Collection<ExcludedRule> excludedRules);

        /**
         * <p>
         * The names of rules that are in the referenced rule group, but that you want AWS WAF to exclude from
         * processing for this rule statement.
         * </p>
         * 
         * @param excludedRules
         *        The names of rules that are in the referenced rule group, but that you want AWS WAF to exclude from
         *        processing for this rule statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedRules(ExcludedRule... excludedRules);

        /**
         * <p>
         * The names of rules that are in the referenced rule group, but that you want AWS WAF to exclude from
         * processing for this rule statement.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ExcludedRule>.Builder} avoiding the need to
         * create one manually via {@link List<ExcludedRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExcludedRule>.Builder#build()} is called immediately and its
         * result is passed to {@link #excludedRules(List<ExcludedRule>)}.
         * 
         * @param excludedRules
         *        a consumer that will call methods on {@link List<ExcludedRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludedRules(List<ExcludedRule>)
         */
        Builder excludedRules(Consumer<ExcludedRule.Builder>... excludedRules);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private List<ExcludedRule> excludedRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupReferenceStatement model) {
            arn(model.arn);
            excludedRules(model.excludedRules);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Collection<ExcludedRule.Builder> getExcludedRules() {
            return excludedRules != null ? excludedRules.stream().map(ExcludedRule::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder excludedRules(Collection<ExcludedRule> excludedRules) {
            this.excludedRules = ExcludedRulesCopier.copy(excludedRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedRules(ExcludedRule... excludedRules) {
            excludedRules(Arrays.asList(excludedRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedRules(Consumer<ExcludedRule.Builder>... excludedRules) {
            excludedRules(Stream.of(excludedRules).map(c -> ExcludedRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setExcludedRules(Collection<ExcludedRule.BuilderImpl> excludedRules) {
            this.excludedRules = ExcludedRulesCopier.copyFromBuilder(excludedRules);
        }

        @Override
        public RuleGroupReferenceStatement build() {
            return new RuleGroupReferenceStatement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
