/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information, including
 * how to migrate your AWS WAF resources from the prior release, see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
 * </p>
 * </note>
 * <p>
 * A single regular expression. This is used in a <a>RegexPatternSet</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Regex implements SdkPojo, Serializable, ToCopyableBuilder<Regex.Builder, Regex> {
    private static final SdkField<String> REGEX_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Regex::regexString)).setter(setter(Builder::regexString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexString").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGEX_STRING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String regexString;

    private Regex(BuilderImpl builder) {
        this.regexString = builder.regexString;
    }

    /**
     * <p>
     * The string representing the regular expression.
     * </p>
     * 
     * @return The string representing the regular expression.
     */
    public String regexString() {
        return regexString;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regexString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Regex)) {
            return false;
        }
        Regex other = (Regex) obj;
        return Objects.equals(regexString(), other.regexString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Regex").add("RegexString", regexString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegexString":
            return Optional.ofNullable(clazz.cast(regexString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Regex, T> g) {
        return obj -> g.apply((Regex) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Regex> {
        /**
         * <p>
         * The string representing the regular expression.
         * </p>
         * 
         * @param regexString
         *        The string representing the regular expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexString(String regexString);
    }

    static final class BuilderImpl implements Builder {
        private String regexString;

        private BuilderImpl() {
        }

        private BuilderImpl(Regex model) {
            regexString(model.regexString);
        }

        public final String getRegexString() {
            return regexString;
        }

        @Override
        public final Builder regexString(String regexString) {
            this.regexString = regexString;
            return this;
        }

        public final void setRegexString(String regexString) {
            this.regexString = regexString;
        }

        @Override
        public Regex build() {
            return new Regex(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
