/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourcesForWebAclResponse extends Wafv2Response implements
        ToCopyableBuilder<ListResourcesForWebAclResponse.Builder, ListResourcesForWebAclResponse> {
    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListResourcesForWebAclResponse::resourceArns))
            .setter(setter(Builder::resourceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARNS_FIELD));

    private final List<String> resourceArns;

    private ListResourcesForWebAclResponse(BuilderImpl builder) {
        super(builder);
        this.resourceArns = builder.resourceArns;
    }

    /**
     * Returns true if the ResourceArns property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResourceArns() {
        return resourceArns != null && !(resourceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of Amazon Resource Names (ARNs) of the associated resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The array of Amazon Resource Names (ARNs) of the associated resources.
     */
    public List<String> resourceArns() {
        return resourceArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArns());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourcesForWebAclResponse)) {
            return false;
        }
        ListResourcesForWebAclResponse other = (ListResourcesForWebAclResponse) obj;
        return Objects.equals(resourceArns(), other.resourceArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListResourcesForWebAclResponse").add("ResourceArns", resourceArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArns":
            return Optional.ofNullable(clazz.cast(resourceArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourcesForWebAclResponse, T> g) {
        return obj -> g.apply((ListResourcesForWebAclResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Wafv2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListResourcesForWebAclResponse> {
        /**
         * <p>
         * The array of Amazon Resource Names (ARNs) of the associated resources.
         * </p>
         * 
         * @param resourceArns
         *        The array of Amazon Resource Names (ARNs) of the associated resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(Collection<String> resourceArns);

        /**
         * <p>
         * The array of Amazon Resource Names (ARNs) of the associated resources.
         * </p>
         * 
         * @param resourceArns
         *        The array of Amazon Resource Names (ARNs) of the associated resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(String... resourceArns);
    }

    static final class BuilderImpl extends Wafv2Response.BuilderImpl implements Builder {
        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourcesForWebAclResponse model) {
            super(model);
            resourceArns(model.resourceArns);
        }

        public final Collection<String> getResourceArns() {
            return resourceArns;
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnsCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String... resourceArns) {
            resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnsCopier.copy(resourceArns);
        }

        @Override
        public ListResourcesForWebAclResponse build() {
            return new ListResourcesForWebAclResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
