/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWebAclResponse extends Wafv2Response implements
        ToCopyableBuilder<GetWebAclResponse.Builder, GetWebAclResponse> {
    private static final SdkField<WebACL> WEB_ACL_FIELD = SdkField.<WebACL> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetWebAclResponse::webACL)).setter(setter(Builder::webACL)).constructor(WebACL::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACL").build()).build();

    private static final SdkField<String> LOCK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetWebAclResponse::lockToken)).setter(setter(Builder::lockToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_ACL_FIELD,
            LOCK_TOKEN_FIELD));

    private final WebACL webACL;

    private final String lockToken;

    private GetWebAclResponse(BuilderImpl builder) {
        super(builder);
        this.webACL = builder.webACL;
        this.lockToken = builder.lockToken;
    }

    /**
     * <p>
     * The Web ACL specification. You can modify the settings in this Web ACL and use it to update this Web ACL or
     * create a new one.
     * </p>
     * 
     * @return The Web ACL specification. You can modify the settings in this Web ACL and use it to update this Web ACL
     *         or create a new one.
     */
    public WebACL webACL() {
        return webACL;
    }

    /**
     * <p>
     * A token used for optimistic locking. AWS WAF returns a token to your get and list requests, to mark the state of
     * the entity at the time of the request. To make changes to the entity associated with the token, you provide the
     * token to operations like update and delete. AWS WAF uses the token to ensure that no changes have been made to
     * the entity since you last retrieved it. If a change has been made, the update fails with a
     * <code>WAFOptimisticLockException</code>. If this happens, perform another get, and use the new token returned by
     * that operation.
     * </p>
     * 
     * @return A token used for optimistic locking. AWS WAF returns a token to your get and list requests, to mark the
     *         state of the entity at the time of the request. To make changes to the entity associated with the token,
     *         you provide the token to operations like update and delete. AWS WAF uses the token to ensure that no
     *         changes have been made to the entity since you last retrieved it. If a change has been made, the update
     *         fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another get, and use the
     *         new token returned by that operation.
     */
    public String lockToken() {
        return lockToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(webACL());
        hashCode = 31 * hashCode + Objects.hashCode(lockToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWebAclResponse)) {
            return false;
        }
        GetWebAclResponse other = (GetWebAclResponse) obj;
        return Objects.equals(webACL(), other.webACL()) && Objects.equals(lockToken(), other.lockToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetWebAclResponse").add("WebACL", webACL()).add("LockToken", lockToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebACL":
            return Optional.ofNullable(clazz.cast(webACL()));
        case "LockToken":
            return Optional.ofNullable(clazz.cast(lockToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWebAclResponse, T> g) {
        return obj -> g.apply((GetWebAclResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Wafv2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetWebAclResponse> {
        /**
         * <p>
         * The Web ACL specification. You can modify the settings in this Web ACL and use it to update this Web ACL or
         * create a new one.
         * </p>
         * 
         * @param webACL
         *        The Web ACL specification. You can modify the settings in this Web ACL and use it to update this Web
         *        ACL or create a new one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webACL(WebACL webACL);

        /**
         * <p>
         * The Web ACL specification. You can modify the settings in this Web ACL and use it to update this Web ACL or
         * create a new one.
         * </p>
         * This is a convenience that creates an instance of the {@link WebACL.Builder} avoiding the need to create one
         * manually via {@link WebACL#builder()}.
         *
         * When the {@link Consumer} completes, {@link WebACL.Builder#build()} is called immediately and its result is
         * passed to {@link #webACL(WebACL)}.
         * 
         * @param webACL
         *        a consumer that will call methods on {@link WebACL.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webACL(WebACL)
         */
        default Builder webACL(Consumer<WebACL.Builder> webACL) {
            return webACL(WebACL.builder().applyMutation(webACL).build());
        }

        /**
         * <p>
         * A token used for optimistic locking. AWS WAF returns a token to your get and list requests, to mark the state
         * of the entity at the time of the request. To make changes to the entity associated with the token, you
         * provide the token to operations like update and delete. AWS WAF uses the token to ensure that no changes have
         * been made to the entity since you last retrieved it. If a change has been made, the update fails with a
         * <code>WAFOptimisticLockException</code>. If this happens, perform another get, and use the new token returned
         * by that operation.
         * </p>
         * 
         * @param lockToken
         *        A token used for optimistic locking. AWS WAF returns a token to your get and list requests, to mark
         *        the state of the entity at the time of the request. To make changes to the entity associated with the
         *        token, you provide the token to operations like update and delete. AWS WAF uses the token to ensure
         *        that no changes have been made to the entity since you last retrieved it. If a change has been made,
         *        the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another get,
         *        and use the new token returned by that operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lockToken(String lockToken);
    }

    static final class BuilderImpl extends Wafv2Response.BuilderImpl implements Builder {
        private WebACL webACL;

        private String lockToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWebAclResponse model) {
            super(model);
            webACL(model.webACL);
            lockToken(model.lockToken);
        }

        public final WebACL.Builder getWebACL() {
            return webACL != null ? webACL.toBuilder() : null;
        }

        @Override
        public final Builder webACL(WebACL webACL) {
            this.webACL = webACL;
            return this;
        }

        public final void setWebACL(WebACL.BuilderImpl webACL) {
            this.webACL = webACL != null ? webACL.build() : null;
        }

        public final String getLockToken() {
            return lockToken;
        }

        @Override
        public final Builder lockToken(String lockToken) {
            this.lockToken = lockToken;
            return this;
        }

        public final void setLockToken(String lockToken) {
            this.lockToken = lockToken;
        }

        @Override
        public GetWebAclResponse build() {
            return new GetWebAclResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
