/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information, including
 * how to migrate your AWS WAF resources from the prior release, see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
 * </p>
 * </note>
 * <p>
 * The part of a web request that you want AWS WAF to inspect. Include the <code>FieldToMatch</code> types that you want
 * to inspect, with additional specifications as needed, according to the type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldToMatch implements SdkPojo, Serializable, ToCopyableBuilder<FieldToMatch.Builder, FieldToMatch> {
    private static final SdkField<SingleHeader> SINGLE_HEADER_FIELD = SdkField.<SingleHeader> builder(MarshallingType.SDK_POJO)
            .getter(getter(FieldToMatch::singleHeader)).setter(setter(Builder::singleHeader)).constructor(SingleHeader::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleHeader").build()).build();

    private static final SdkField<SingleQueryArgument> SINGLE_QUERY_ARGUMENT_FIELD = SdkField
            .<SingleQueryArgument> builder(MarshallingType.SDK_POJO).getter(getter(FieldToMatch::singleQueryArgument))
            .setter(setter(Builder::singleQueryArgument)).constructor(SingleQueryArgument::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleQueryArgument").build())
            .build();

    private static final SdkField<AllQueryArguments> ALL_QUERY_ARGUMENTS_FIELD = SdkField
            .<AllQueryArguments> builder(MarshallingType.SDK_POJO).getter(getter(FieldToMatch::allQueryArguments))
            .setter(setter(Builder::allQueryArguments)).constructor(AllQueryArguments::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllQueryArguments").build()).build();

    private static final SdkField<UriPath> URI_PATH_FIELD = SdkField.<UriPath> builder(MarshallingType.SDK_POJO)
            .getter(getter(FieldToMatch::uriPath)).setter(setter(Builder::uriPath)).constructor(UriPath::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UriPath").build()).build();

    private static final SdkField<QueryString> QUERY_STRING_FIELD = SdkField.<QueryString> builder(MarshallingType.SDK_POJO)
            .getter(getter(FieldToMatch::queryString)).setter(setter(Builder::queryString)).constructor(QueryString::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()).build();

    private static final SdkField<Body> BODY_FIELD = SdkField.<Body> builder(MarshallingType.SDK_POJO)
            .getter(getter(FieldToMatch::body)).setter(setter(Builder::body)).constructor(Body::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()).build();

    private static final SdkField<Method> METHOD_FIELD = SdkField.<Method> builder(MarshallingType.SDK_POJO)
            .getter(getter(FieldToMatch::method)).setter(setter(Builder::method)).constructor(Method::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Method").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(SINGLE_HEADER_FIELD, SINGLE_QUERY_ARGUMENT_FIELD, ALL_QUERY_ARGUMENTS_FIELD,
                    URI_PATH_FIELD, QUERY_STRING_FIELD, BODY_FIELD, METHOD_FIELD));

    private static final long serialVersionUID = 1L;

    private final SingleHeader singleHeader;

    private final SingleQueryArgument singleQueryArgument;

    private final AllQueryArguments allQueryArguments;

    private final UriPath uriPath;

    private final QueryString queryString;

    private final Body body;

    private final Method method;

    private FieldToMatch(BuilderImpl builder) {
        this.singleHeader = builder.singleHeader;
        this.singleQueryArgument = builder.singleQueryArgument;
        this.allQueryArguments = builder.allQueryArguments;
        this.uriPath = builder.uriPath;
        this.queryString = builder.queryString;
        this.body = builder.body;
        this.method = builder.method;
    }

    /**
     * <p>
     * Inspect a single header. Provide the name of the header to inspect, for example, <code>User-Agent</code> or
     * <code>Referer</code>. This setting isn't case sensitive.
     * </p>
     * 
     * @return Inspect a single header. Provide the name of the header to inspect, for example, <code>User-Agent</code>
     *         or <code>Referer</code>. This setting isn't case sensitive.
     */
    public SingleHeader singleHeader() {
        return singleHeader;
    }

    /**
     * <p>
     * Inspect a single query argument. Provide the name of the query argument to inspect, such as <i>UserName</i> or
     * <i>SalesRegion</i>. The name can be up to 30 characters long and isn't case sensitive.
     * </p>
     * 
     * @return Inspect a single query argument. Provide the name of the query argument to inspect, such as
     *         <i>UserName</i> or <i>SalesRegion</i>. The name can be up to 30 characters long and isn't case sensitive.
     */
    public SingleQueryArgument singleQueryArgument() {
        return singleQueryArgument;
    }

    /**
     * <p>
     * Inspect all query arguments.
     * </p>
     * 
     * @return Inspect all query arguments.
     */
    public AllQueryArguments allQueryArguments() {
        return allQueryArguments;
    }

    /**
     * <p>
     * Inspect the request URI path. This is the part of a web request that identifies a resource, for example,
     * <code>/images/daily-ad.jpg</code>.
     * </p>
     * 
     * @return Inspect the request URI path. This is the part of a web request that identifies a resource, for example,
     *         <code>/images/daily-ad.jpg</code>.
     */
    public UriPath uriPath() {
        return uriPath;
    }

    /**
     * <p>
     * Inspect the query string. This is the part of a URL that appears after a <code>?</code> character, if any.
     * </p>
     * 
     * @return Inspect the query string. This is the part of a URL that appears after a <code>?</code> character, if
     *         any.
     */
    public QueryString queryString() {
        return queryString;
    }

    /**
     * <p>
     * Inspect the request body, which immediately follows the request headers. This is the part of a request that
     * contains any additional data that you want to send to your web server as the HTTP request body, such as data from
     * a form.
     * </p>
     * <p>
     * Note that only the first 8 KB (8192 bytes) of the request body are forwarded to AWS WAF for inspection. If you
     * don't need to inspect more than 8 KB, you can guarantee that you don't allow additional bytes in by combining a
     * statement that inspects the body of the web request, such as <a>ByteMatchStatement</a> or
     * <a>RegexPatternSetReferenceStatement</a>, with a <a>SizeConstraintStatement</a> that enforces an 8 KB size limit
     * on the body of the request. AWS WAF doesn't support inspecting the entire contents of web requests whose bodies
     * exceed the 8 KB limit.
     * </p>
     * 
     * @return Inspect the request body, which immediately follows the request headers. This is the part of a request
     *         that contains any additional data that you want to send to your web server as the HTTP request body, such
     *         as data from a form. </p>
     *         <p>
     *         Note that only the first 8 KB (8192 bytes) of the request body are forwarded to AWS WAF for inspection.
     *         If you don't need to inspect more than 8 KB, you can guarantee that you don't allow additional bytes in
     *         by combining a statement that inspects the body of the web request, such as <a>ByteMatchStatement</a> or
     *         <a>RegexPatternSetReferenceStatement</a>, with a <a>SizeConstraintStatement</a> that enforces an 8 KB
     *         size limit on the body of the request. AWS WAF doesn't support inspecting the entire contents of web
     *         requests whose bodies exceed the 8 KB limit.
     */
    public Body body() {
        return body;
    }

    /**
     * <p>
     * Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to
     * perform.
     * </p>
     * 
     * @return Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin
     *         to perform.
     */
    public Method method() {
        return method;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(singleHeader());
        hashCode = 31 * hashCode + Objects.hashCode(singleQueryArgument());
        hashCode = 31 * hashCode + Objects.hashCode(allQueryArguments());
        hashCode = 31 * hashCode + Objects.hashCode(uriPath());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(method());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldToMatch)) {
            return false;
        }
        FieldToMatch other = (FieldToMatch) obj;
        return Objects.equals(singleHeader(), other.singleHeader())
                && Objects.equals(singleQueryArgument(), other.singleQueryArgument())
                && Objects.equals(allQueryArguments(), other.allQueryArguments()) && Objects.equals(uriPath(), other.uriPath())
                && Objects.equals(queryString(), other.queryString()) && Objects.equals(body(), other.body())
                && Objects.equals(method(), other.method());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FieldToMatch").add("SingleHeader", singleHeader())
                .add("SingleQueryArgument", singleQueryArgument()).add("AllQueryArguments", allQueryArguments())
                .add("UriPath", uriPath()).add("QueryString", queryString()).add("Body", body()).add("Method", method()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SingleHeader":
            return Optional.ofNullable(clazz.cast(singleHeader()));
        case "SingleQueryArgument":
            return Optional.ofNullable(clazz.cast(singleQueryArgument()));
        case "AllQueryArguments":
            return Optional.ofNullable(clazz.cast(allQueryArguments()));
        case "UriPath":
            return Optional.ofNullable(clazz.cast(uriPath()));
        case "QueryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "Method":
            return Optional.ofNullable(clazz.cast(method()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FieldToMatch, T> g) {
        return obj -> g.apply((FieldToMatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldToMatch> {
        /**
         * <p>
         * Inspect a single header. Provide the name of the header to inspect, for example, <code>User-Agent</code> or
         * <code>Referer</code>. This setting isn't case sensitive.
         * </p>
         * 
         * @param singleHeader
         *        Inspect a single header. Provide the name of the header to inspect, for example,
         *        <code>User-Agent</code> or <code>Referer</code>. This setting isn't case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleHeader(SingleHeader singleHeader);

        /**
         * <p>
         * Inspect a single header. Provide the name of the header to inspect, for example, <code>User-Agent</code> or
         * <code>Referer</code>. This setting isn't case sensitive.
         * </p>
         * This is a convenience that creates an instance of the {@link SingleHeader.Builder} avoiding the need to
         * create one manually via {@link SingleHeader#builder()}.
         *
         * When the {@link Consumer} completes, {@link SingleHeader.Builder#build()} is called immediately and its
         * result is passed to {@link #singleHeader(SingleHeader)}.
         * 
         * @param singleHeader
         *        a consumer that will call methods on {@link SingleHeader.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #singleHeader(SingleHeader)
         */
        default Builder singleHeader(Consumer<SingleHeader.Builder> singleHeader) {
            return singleHeader(SingleHeader.builder().applyMutation(singleHeader).build());
        }

        /**
         * <p>
         * Inspect a single query argument. Provide the name of the query argument to inspect, such as <i>UserName</i>
         * or <i>SalesRegion</i>. The name can be up to 30 characters long and isn't case sensitive.
         * </p>
         * 
         * @param singleQueryArgument
         *        Inspect a single query argument. Provide the name of the query argument to inspect, such as
         *        <i>UserName</i> or <i>SalesRegion</i>. The name can be up to 30 characters long and isn't case
         *        sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleQueryArgument(SingleQueryArgument singleQueryArgument);

        /**
         * <p>
         * Inspect a single query argument. Provide the name of the query argument to inspect, such as <i>UserName</i>
         * or <i>SalesRegion</i>. The name can be up to 30 characters long and isn't case sensitive.
         * </p>
         * This is a convenience that creates an instance of the {@link SingleQueryArgument.Builder} avoiding the need
         * to create one manually via {@link SingleQueryArgument#builder()}.
         *
         * When the {@link Consumer} completes, {@link SingleQueryArgument.Builder#build()} is called immediately and
         * its result is passed to {@link #singleQueryArgument(SingleQueryArgument)}.
         * 
         * @param singleQueryArgument
         *        a consumer that will call methods on {@link SingleQueryArgument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #singleQueryArgument(SingleQueryArgument)
         */
        default Builder singleQueryArgument(Consumer<SingleQueryArgument.Builder> singleQueryArgument) {
            return singleQueryArgument(SingleQueryArgument.builder().applyMutation(singleQueryArgument).build());
        }

        /**
         * <p>
         * Inspect all query arguments.
         * </p>
         * 
         * @param allQueryArguments
         *        Inspect all query arguments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allQueryArguments(AllQueryArguments allQueryArguments);

        /**
         * <p>
         * Inspect all query arguments.
         * </p>
         * This is a convenience that creates an instance of the {@link AllQueryArguments.Builder} avoiding the need to
         * create one manually via {@link AllQueryArguments#builder()}.
         *
         * When the {@link Consumer} completes, {@link AllQueryArguments.Builder#build()} is called immediately and its
         * result is passed to {@link #allQueryArguments(AllQueryArguments)}.
         * 
         * @param allQueryArguments
         *        a consumer that will call methods on {@link AllQueryArguments.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allQueryArguments(AllQueryArguments)
         */
        default Builder allQueryArguments(Consumer<AllQueryArguments.Builder> allQueryArguments) {
            return allQueryArguments(AllQueryArguments.builder().applyMutation(allQueryArguments).build());
        }

        /**
         * <p>
         * Inspect the request URI path. This is the part of a web request that identifies a resource, for example,
         * <code>/images/daily-ad.jpg</code>.
         * </p>
         * 
         * @param uriPath
         *        Inspect the request URI path. This is the part of a web request that identifies a resource, for
         *        example, <code>/images/daily-ad.jpg</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uriPath(UriPath uriPath);

        /**
         * <p>
         * Inspect the request URI path. This is the part of a web request that identifies a resource, for example,
         * <code>/images/daily-ad.jpg</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link UriPath.Builder} avoiding the need to create one
         * manually via {@link UriPath#builder()}.
         *
         * When the {@link Consumer} completes, {@link UriPath.Builder#build()} is called immediately and its result is
         * passed to {@link #uriPath(UriPath)}.
         * 
         * @param uriPath
         *        a consumer that will call methods on {@link UriPath.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uriPath(UriPath)
         */
        default Builder uriPath(Consumer<UriPath.Builder> uriPath) {
            return uriPath(UriPath.builder().applyMutation(uriPath).build());
        }

        /**
         * <p>
         * Inspect the query string. This is the part of a URL that appears after a <code>?</code> character, if any.
         * </p>
         * 
         * @param queryString
         *        Inspect the query string. This is the part of a URL that appears after a <code>?</code> character, if
         *        any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(QueryString queryString);

        /**
         * <p>
         * Inspect the query string. This is the part of a URL that appears after a <code>?</code> character, if any.
         * </p>
         * This is a convenience that creates an instance of the {@link QueryString.Builder} avoiding the need to create
         * one manually via {@link QueryString#builder()}.
         *
         * When the {@link Consumer} completes, {@link QueryString.Builder#build()} is called immediately and its result
         * is passed to {@link #queryString(QueryString)}.
         * 
         * @param queryString
         *        a consumer that will call methods on {@link QueryString.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryString(QueryString)
         */
        default Builder queryString(Consumer<QueryString.Builder> queryString) {
            return queryString(QueryString.builder().applyMutation(queryString).build());
        }

        /**
         * <p>
         * Inspect the request body, which immediately follows the request headers. This is the part of a request that
         * contains any additional data that you want to send to your web server as the HTTP request body, such as data
         * from a form.
         * </p>
         * <p>
         * Note that only the first 8 KB (8192 bytes) of the request body are forwarded to AWS WAF for inspection. If
         * you don't need to inspect more than 8 KB, you can guarantee that you don't allow additional bytes in by
         * combining a statement that inspects the body of the web request, such as <a>ByteMatchStatement</a> or
         * <a>RegexPatternSetReferenceStatement</a>, with a <a>SizeConstraintStatement</a> that enforces an 8 KB size
         * limit on the body of the request. AWS WAF doesn't support inspecting the entire contents of web requests
         * whose bodies exceed the 8 KB limit.
         * </p>
         * 
         * @param body
         *        Inspect the request body, which immediately follows the request headers. This is the part of a request
         *        that contains any additional data that you want to send to your web server as the HTTP request body,
         *        such as data from a form. </p>
         *        <p>
         *        Note that only the first 8 KB (8192 bytes) of the request body are forwarded to AWS WAF for
         *        inspection. If you don't need to inspect more than 8 KB, you can guarantee that you don't allow
         *        additional bytes in by combining a statement that inspects the body of the web request, such as
         *        <a>ByteMatchStatement</a> or <a>RegexPatternSetReferenceStatement</a>, with a
         *        <a>SizeConstraintStatement</a> that enforces an 8 KB size limit on the body of the request. AWS WAF
         *        doesn't support inspecting the entire contents of web requests whose bodies exceed the 8 KB limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(Body body);

        /**
         * <p>
         * Inspect the request body, which immediately follows the request headers. This is the part of a request that
         * contains any additional data that you want to send to your web server as the HTTP request body, such as data
         * from a form.
         * </p>
         * <p>
         * Note that only the first 8 KB (8192 bytes) of the request body are forwarded to AWS WAF for inspection. If
         * you don't need to inspect more than 8 KB, you can guarantee that you don't allow additional bytes in by
         * combining a statement that inspects the body of the web request, such as <a>ByteMatchStatement</a> or
         * <a>RegexPatternSetReferenceStatement</a>, with a <a>SizeConstraintStatement</a> that enforces an 8 KB size
         * limit on the body of the request. AWS WAF doesn't support inspecting the entire contents of web requests
         * whose bodies exceed the 8 KB limit.
         * </p>
         * This is a convenience that creates an instance of the {@link Body.Builder} avoiding the need to create one
         * manually via {@link Body#builder()}.
         *
         * When the {@link Consumer} completes, {@link Body.Builder#build()} is called immediately and its result is
         * passed to {@link #body(Body)}.
         * 
         * @param body
         *        a consumer that will call methods on {@link Body.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #body(Body)
         */
        default Builder body(Consumer<Body.Builder> body) {
            return body(Body.builder().applyMutation(body).build());
        }

        /**
         * <p>
         * Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to
         * perform.
         * </p>
         * 
         * @param method
         *        Inspect the HTTP method. The method indicates the type of operation that the request is asking the
         *        origin to perform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder method(Method method);

        /**
         * <p>
         * Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to
         * perform.
         * </p>
         * This is a convenience that creates an instance of the {@link Method.Builder} avoiding the need to create one
         * manually via {@link Method#builder()}.
         *
         * When the {@link Consumer} completes, {@link Method.Builder#build()} is called immediately and its result is
         * passed to {@link #method(Method)}.
         * 
         * @param method
         *        a consumer that will call methods on {@link Method.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #method(Method)
         */
        default Builder method(Consumer<Method.Builder> method) {
            return method(Method.builder().applyMutation(method).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SingleHeader singleHeader;

        private SingleQueryArgument singleQueryArgument;

        private AllQueryArguments allQueryArguments;

        private UriPath uriPath;

        private QueryString queryString;

        private Body body;

        private Method method;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldToMatch model) {
            singleHeader(model.singleHeader);
            singleQueryArgument(model.singleQueryArgument);
            allQueryArguments(model.allQueryArguments);
            uriPath(model.uriPath);
            queryString(model.queryString);
            body(model.body);
            method(model.method);
        }

        public final SingleHeader.Builder getSingleHeader() {
            return singleHeader != null ? singleHeader.toBuilder() : null;
        }

        @Override
        public final Builder singleHeader(SingleHeader singleHeader) {
            this.singleHeader = singleHeader;
            return this;
        }

        public final void setSingleHeader(SingleHeader.BuilderImpl singleHeader) {
            this.singleHeader = singleHeader != null ? singleHeader.build() : null;
        }

        public final SingleQueryArgument.Builder getSingleQueryArgument() {
            return singleQueryArgument != null ? singleQueryArgument.toBuilder() : null;
        }

        @Override
        public final Builder singleQueryArgument(SingleQueryArgument singleQueryArgument) {
            this.singleQueryArgument = singleQueryArgument;
            return this;
        }

        public final void setSingleQueryArgument(SingleQueryArgument.BuilderImpl singleQueryArgument) {
            this.singleQueryArgument = singleQueryArgument != null ? singleQueryArgument.build() : null;
        }

        public final AllQueryArguments.Builder getAllQueryArguments() {
            return allQueryArguments != null ? allQueryArguments.toBuilder() : null;
        }

        @Override
        public final Builder allQueryArguments(AllQueryArguments allQueryArguments) {
            this.allQueryArguments = allQueryArguments;
            return this;
        }

        public final void setAllQueryArguments(AllQueryArguments.BuilderImpl allQueryArguments) {
            this.allQueryArguments = allQueryArguments != null ? allQueryArguments.build() : null;
        }

        public final UriPath.Builder getUriPath() {
            return uriPath != null ? uriPath.toBuilder() : null;
        }

        @Override
        public final Builder uriPath(UriPath uriPath) {
            this.uriPath = uriPath;
            return this;
        }

        public final void setUriPath(UriPath.BuilderImpl uriPath) {
            this.uriPath = uriPath != null ? uriPath.build() : null;
        }

        public final QueryString.Builder getQueryString() {
            return queryString != null ? queryString.toBuilder() : null;
        }

        @Override
        public final Builder queryString(QueryString queryString) {
            this.queryString = queryString;
            return this;
        }

        public final void setQueryString(QueryString.BuilderImpl queryString) {
            this.queryString = queryString != null ? queryString.build() : null;
        }

        public final Body.Builder getBody() {
            return body != null ? body.toBuilder() : null;
        }

        @Override
        public final Builder body(Body body) {
            this.body = body;
            return this;
        }

        public final void setBody(Body.BuilderImpl body) {
            this.body = body != null ? body.build() : null;
        }

        public final Method.Builder getMethod() {
            return method != null ? method.toBuilder() : null;
        }

        @Override
        public final Builder method(Method method) {
            this.method = method;
            return this;
        }

        public final void setMethod(Method.BuilderImpl method) {
            this.method = method != null ? method.build() : null;
        }

        @Override
        public FieldToMatch build() {
            return new FieldToMatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
