/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.wafv2.model.AssociateWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.AssociateWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.CheckCapacityRequest;
import software.amazon.awssdk.services.wafv2.model.CheckCapacityResponse;
import software.amazon.awssdk.services.wafv2.model.CreateIpSetRequest;
import software.amazon.awssdk.services.wafv2.model.CreateIpSetResponse;
import software.amazon.awssdk.services.wafv2.model.CreateRegexPatternSetRequest;
import software.amazon.awssdk.services.wafv2.model.CreateRegexPatternSetResponse;
import software.amazon.awssdk.services.wafv2.model.CreateRuleGroupRequest;
import software.amazon.awssdk.services.wafv2.model.CreateRuleGroupResponse;
import software.amazon.awssdk.services.wafv2.model.CreateWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.CreateWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteIpSetRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteIpSetResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteLoggingConfigurationRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteLoggingConfigurationResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteRegexPatternSetRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteRegexPatternSetResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteRuleGroupRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteRuleGroupResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.DescribeManagedRuleGroupRequest;
import software.amazon.awssdk.services.wafv2.model.DescribeManagedRuleGroupResponse;
import software.amazon.awssdk.services.wafv2.model.DisassociateWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.DisassociateWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.GetIpSetRequest;
import software.amazon.awssdk.services.wafv2.model.GetIpSetResponse;
import software.amazon.awssdk.services.wafv2.model.GetLoggingConfigurationRequest;
import software.amazon.awssdk.services.wafv2.model.GetLoggingConfigurationResponse;
import software.amazon.awssdk.services.wafv2.model.GetRateBasedStatementManagedKeysRequest;
import software.amazon.awssdk.services.wafv2.model.GetRateBasedStatementManagedKeysResponse;
import software.amazon.awssdk.services.wafv2.model.GetRegexPatternSetRequest;
import software.amazon.awssdk.services.wafv2.model.GetRegexPatternSetResponse;
import software.amazon.awssdk.services.wafv2.model.GetRuleGroupRequest;
import software.amazon.awssdk.services.wafv2.model.GetRuleGroupResponse;
import software.amazon.awssdk.services.wafv2.model.GetSampledRequestsRequest;
import software.amazon.awssdk.services.wafv2.model.GetSampledRequestsResponse;
import software.amazon.awssdk.services.wafv2.model.GetWebAclForResourceRequest;
import software.amazon.awssdk.services.wafv2.model.GetWebAclForResourceResponse;
import software.amazon.awssdk.services.wafv2.model.GetWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.GetWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupsRequest;
import software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupsResponse;
import software.amazon.awssdk.services.wafv2.model.ListIpSetsRequest;
import software.amazon.awssdk.services.wafv2.model.ListIpSetsResponse;
import software.amazon.awssdk.services.wafv2.model.ListLoggingConfigurationsRequest;
import software.amazon.awssdk.services.wafv2.model.ListLoggingConfigurationsResponse;
import software.amazon.awssdk.services.wafv2.model.ListRegexPatternSetsRequest;
import software.amazon.awssdk.services.wafv2.model.ListRegexPatternSetsResponse;
import software.amazon.awssdk.services.wafv2.model.ListResourcesForWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.ListResourcesForWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.ListRuleGroupsRequest;
import software.amazon.awssdk.services.wafv2.model.ListRuleGroupsResponse;
import software.amazon.awssdk.services.wafv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.wafv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.wafv2.model.ListWebAcLsRequest;
import software.amazon.awssdk.services.wafv2.model.ListWebAcLsResponse;
import software.amazon.awssdk.services.wafv2.model.PutLoggingConfigurationRequest;
import software.amazon.awssdk.services.wafv2.model.PutLoggingConfigurationResponse;
import software.amazon.awssdk.services.wafv2.model.TagResourceRequest;
import software.amazon.awssdk.services.wafv2.model.TagResourceResponse;
import software.amazon.awssdk.services.wafv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.wafv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.wafv2.model.UpdateIpSetRequest;
import software.amazon.awssdk.services.wafv2.model.UpdateIpSetResponse;
import software.amazon.awssdk.services.wafv2.model.UpdateRegexPatternSetRequest;
import software.amazon.awssdk.services.wafv2.model.UpdateRegexPatternSetResponse;
import software.amazon.awssdk.services.wafv2.model.UpdateRuleGroupRequest;
import software.amazon.awssdk.services.wafv2.model.UpdateRuleGroupResponse;
import software.amazon.awssdk.services.wafv2.model.UpdateWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.UpdateWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.WafAssociatedItemException;
import software.amazon.awssdk.services.wafv2.model.WafDuplicateItemException;
import software.amazon.awssdk.services.wafv2.model.WafInternalErrorException;
import software.amazon.awssdk.services.wafv2.model.WafInvalidParameterException;
import software.amazon.awssdk.services.wafv2.model.WafInvalidResourceException;
import software.amazon.awssdk.services.wafv2.model.WafLimitsExceededException;
import software.amazon.awssdk.services.wafv2.model.WafNonexistentItemException;
import software.amazon.awssdk.services.wafv2.model.WafOptimisticLockException;
import software.amazon.awssdk.services.wafv2.model.WafServiceLinkedRoleErrorException;
import software.amazon.awssdk.services.wafv2.model.WafTagOperationException;
import software.amazon.awssdk.services.wafv2.model.WafTagOperationInternalErrorException;
import software.amazon.awssdk.services.wafv2.model.WafUnavailableEntityException;
import software.amazon.awssdk.services.wafv2.model.Wafv2Exception;

/**
 * Service client for accessing WAFV2. This can be created using the static {@link #builder()} method.
 *
 * <note>
 * <p>
 * This is the latest version of the <b>AWS WAF</b> API, released in November, 2019. The names of the entities that you
 * use to access this API, like endpoints and namespaces, all have the versioning information added, like "V2" or "v2",
 * to distinguish from the prior version. We recommend migrating your resources to this version, because it has a number
 * of significant improvements.
 * </p>
 * <p>
 * If you used AWS WAF prior to this release, you can't use this AWS WAFV2 API to access any AWS WAF resources that you
 * created before. You can access your old rules, web ACLs, and other AWS WAF resources only through the AWS WAF Classic
 * APIs. The AWS WAF Classic APIs have retained the prior names, endpoints, and namespaces.
 * </p>
 * <p>
 * For information, including how to migrate your AWS WAF resources to this version, see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
 * </p>
 * </note>
 * <p>
 * AWS WAF is a web application firewall that lets you monitor the HTTP and HTTPS requests that are forwarded to Amazon
 * CloudFront, an Amazon API Gateway API, or an Application Load Balancer. AWS WAF also lets you control access to your
 * content. Based on conditions that you specify, such as the IP addresses that requests originate from or the values of
 * query strings, API Gateway, CloudFront, or the Application Load Balancer responds to requests either with the
 * requested content or with an HTTP 403 status code (Forbidden). You also can configure CloudFront to return a custom
 * error page when a request is blocked.
 * </p>
 * <p>
 * This API guide is for developers who need detailed information about AWS WAF API actions, data types, and errors. For
 * detailed information about AWS WAF features and an overview of how to use AWS WAF, see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.
 * </p>
 * <p>
 * You can make API calls using the endpoints listed in <a
 * href="https://docs.aws.amazon.com/general/latest/gr/rande.html#waf_region">AWS Service Endpoints for AWS WAF</a>.
 * </p>
 * <ul>
 * <li>
 * <p>
 * For regional applications, you can use any of the endpoints in the list. A regional application can be an Application
 * Load Balancer (ALB) or an API Gateway stage.
 * </p>
 * </li>
 * <li>
 * <p>
 * For AWS CloudFront applications, you must use the API endpoint listed for US East (N. Virginia): us-east-1.
 * </p>
 * </li>
 * </ul>
 * <p>
 * Alternatively, you can use one of the AWS SDKs to access an API that's tailored to the programming language or
 * platform that you're using. For more information, see <a href="http://aws.amazon.com/tools/#SDKs">AWS SDKs</a>.
 * </p>
 * <p>
 * We currently provide two versions of the AWS WAF API: this API and the prior versions, the classic AWS WAF APIs. This
 * new API provides the same functionality as the older versions, with the following major improvements:
 * </p>
 * <ul>
 * <li>
 * <p>
 * You use one API for both global and regional applications. Where you need to distinguish the scope, you specify a
 * <code>Scope</code> parameter and set it to <code>CLOUDFRONT</code> or <code>REGIONAL</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * You can define a Web ACL or rule group with a single API call, and update it with a single call. You define all rule
 * specifications in JSON format, and pass them to your rule group or Web ACL API calls.
 * </p>
 * </li>
 * <li>
 * <p>
 * The limits AWS WAF places on the use of rules more closely reflects the cost of running each type of rule. Rule
 * groups include capacity settings, so you know the maximum cost of a rule group when you use it.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public interface Wafv2Client extends SdkClient {
    String SERVICE_NAME = "wafv2";

    /**
     * Create a {@link Wafv2Client} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static Wafv2Client create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link Wafv2Client}.
     */
    static Wafv2ClientBuilder builder() {
        return new DefaultWafv2ClientBuilder();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Associates a Web ACL with a regional application resource, to protect the resource. A regional application can be
     * an Application Load Balancer (ALB) or an API Gateway stage.
     * </p>
     * <p>
     * For AWS CloudFront, you can associate the Web ACL by providing the <code>Id</code> of the <a>WebACL</a> to the
     * CloudFront API call <code>UpdateDistribution</code>. For information, see <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html"
     * >UpdateDistribution</a>.
     * </p>
     *
     * @param associateWebAclRequest
     * @return Result of the AssociateWebACL operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafUnavailableEntityException
     *         AWS WAF couldn’t retrieve the resource that you requested. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.AssociateWebACL
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/AssociateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateWebAclResponse associateWebACL(AssociateWebAclRequest associateWebAclRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException,
            WafUnavailableEntityException, AwsServiceException, SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Associates a Web ACL with a regional application resource, to protect the resource. A regional application can be
     * an Application Load Balancer (ALB) or an API Gateway stage.
     * </p>
     * <p>
     * For AWS CloudFront, you can associate the Web ACL by providing the <code>Id</code> of the <a>WebACL</a> to the
     * CloudFront API call <code>UpdateDistribution</code>. For information, see <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html"
     * >UpdateDistribution</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateWebAclRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateWebAclRequest#builder()}
     * </p>
     *
     * @param associateWebAclRequest
     *        A {@link Consumer} that will call methods on {@link AssociateWebACLRequest.Builder} to create a request.
     * @return Result of the AssociateWebACL operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafUnavailableEntityException
     *         AWS WAF couldn’t retrieve the resource that you requested. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.AssociateWebACL
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/AssociateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateWebAclResponse associateWebACL(Consumer<AssociateWebAclRequest.Builder> associateWebAclRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException,
            WafUnavailableEntityException, AwsServiceException, SdkClientException, Wafv2Exception {
        return associateWebACL(AssociateWebAclRequest.builder().applyMutation(associateWebAclRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Returns the web ACL capacity unit (WCU) requirements for a specified scope and set of rules. You can use this to
     * check the capacity requirements for the rules you want to use in a <a>RuleGroup</a> or <a>WebACL</a>.
     * </p>
     * <p>
     * AWS WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups,
     * and web ACLs. AWS WAF calculates capacity differently for each rule type, to reflect the relative cost of each
     * rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power.
     * Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule
     * group. The WCU limit for web ACLs is 1,500.
     * </p>
     *
     * @param checkCapacityRequest
     * @return Result of the CheckCapacity operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafLimitsExceededException
     *         AWS WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see
     *         <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.
     * @throws WafInvalidResourceException
     *         AWS WAF couldn’t perform the operation because the resource that you requested isn’t valid. Check the
     *         resource, and try again.
     * @throws WafUnavailableEntityException
     *         AWS WAF couldn’t retrieve the resource that you requested. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.CheckCapacity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CheckCapacity" target="_top">AWS API
     *      Documentation</a>
     */
    default CheckCapacityResponse checkCapacity(CheckCapacityRequest checkCapacityRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafNonexistentItemException, WafLimitsExceededException, WafInvalidResourceException,
            WafUnavailableEntityException, AwsServiceException, SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Returns the web ACL capacity unit (WCU) requirements for a specified scope and set of rules. You can use this to
     * check the capacity requirements for the rules you want to use in a <a>RuleGroup</a> or <a>WebACL</a>.
     * </p>
     * <p>
     * AWS WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups,
     * and web ACLs. AWS WAF calculates capacity differently for each rule type, to reflect the relative cost of each
     * rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power.
     * Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule
     * group. The WCU limit for web ACLs is 1,500.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CheckCapacityRequest.Builder} avoiding the need to
     * create one manually via {@link CheckCapacityRequest#builder()}
     * </p>
     *
     * @param checkCapacityRequest
     *        A {@link Consumer} that will call methods on {@link CheckCapacityRequest.Builder} to create a request.
     * @return Result of the CheckCapacity operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafLimitsExceededException
     *         AWS WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see
     *         <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.
     * @throws WafInvalidResourceException
     *         AWS WAF couldn’t perform the operation because the resource that you requested isn’t valid. Check the
     *         resource, and try again.
     * @throws WafUnavailableEntityException
     *         AWS WAF couldn’t retrieve the resource that you requested. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.CheckCapacity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CheckCapacity" target="_top">AWS API
     *      Documentation</a>
     */
    default CheckCapacityResponse checkCapacity(Consumer<CheckCapacityRequest.Builder> checkCapacityRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException,
            WafLimitsExceededException, WafInvalidResourceException, WafUnavailableEntityException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        return checkCapacity(CheckCapacityRequest.builder().applyMutation(checkCapacityRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Creates an <a>IPSet</a>, which you use to identify web requests that originate from specific IP addresses or
     * ranges of IP addresses. For example, if you're receiving a lot of requests from a ranges of IP addresses, you can
     * configure AWS WAF to block them using an IPSet that lists those IP addresses.
     * </p>
     *
     * @param createIpSetRequest
     * @return Result of the CreateIPSet operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafDuplicateItemException
     *         AWS WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an
     *         existing one.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws WafLimitsExceededException
     *         AWS WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see
     *         <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         AWS WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.CreateIPSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateIpSetResponse createIPSet(CreateIpSetRequest createIpSetRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafDuplicateItemException, WafOptimisticLockException, WafLimitsExceededException,
            WafTagOperationException, WafTagOperationInternalErrorException, AwsServiceException, SdkClientException,
            Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Creates an <a>IPSet</a>, which you use to identify web requests that originate from specific IP addresses or
     * ranges of IP addresses. For example, if you're receiving a lot of requests from a ranges of IP addresses, you can
     * configure AWS WAF to block them using an IPSet that lists those IP addresses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIpSetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateIpSetRequest#builder()}
     * </p>
     *
     * @param createIpSetRequest
     *        A {@link Consumer} that will call methods on {@link CreateIPSetRequest.Builder} to create a request.
     * @return Result of the CreateIPSet operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafDuplicateItemException
     *         AWS WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an
     *         existing one.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws WafLimitsExceededException
     *         AWS WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see
     *         <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         AWS WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.CreateIPSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateIpSetResponse createIPSet(Consumer<CreateIpSetRequest.Builder> createIpSetRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafDuplicateItemException,
            WafOptimisticLockException, WafLimitsExceededException, WafTagOperationException,
            WafTagOperationInternalErrorException, AwsServiceException, SdkClientException, Wafv2Exception {
        return createIPSet(CreateIpSetRequest.builder().applyMutation(createIpSetRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Creates a <a>RegexPatternSet</a> per the specifications provided.
     * </p>
     *
     * @param createRegexPatternSetRequest
     * @return Result of the CreateRegexPatternSet operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafDuplicateItemException
     *         AWS WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an
     *         existing one.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws WafLimitsExceededException
     *         AWS WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see
     *         <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         AWS WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.CreateRegexPatternSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateRegexPatternSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateRegexPatternSetResponse createRegexPatternSet(CreateRegexPatternSetRequest createRegexPatternSetRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafDuplicateItemException,
            WafOptimisticLockException, WafLimitsExceededException, WafTagOperationException,
            WafTagOperationInternalErrorException, AwsServiceException, SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Creates a <a>RegexPatternSet</a> per the specifications provided.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRegexPatternSetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRegexPatternSetRequest#builder()}
     * </p>
     *
     * @param createRegexPatternSetRequest
     *        A {@link Consumer} that will call methods on {@link CreateRegexPatternSetRequest.Builder} to create a
     *        request.
     * @return Result of the CreateRegexPatternSet operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafDuplicateItemException
     *         AWS WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an
     *         existing one.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws WafLimitsExceededException
     *         AWS WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see
     *         <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         AWS WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.CreateRegexPatternSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateRegexPatternSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateRegexPatternSetResponse createRegexPatternSet(
            Consumer<CreateRegexPatternSetRequest.Builder> createRegexPatternSetRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafDuplicateItemException, WafOptimisticLockException, WafLimitsExceededException,
            WafTagOperationException, WafTagOperationInternalErrorException, AwsServiceException, SdkClientException,
            Wafv2Exception {
        return createRegexPatternSet(CreateRegexPatternSetRequest.builder().applyMutation(createRegexPatternSetRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Creates a <a>RuleGroup</a> per the specifications provided.
     * </p>
     * <p>
     * A rule group defines a collection of rules to inspect and control web requests that you can use in a
     * <a>WebACL</a>. When you create a rule group, you define an immutable capacity limit. If you update a rule group,
     * you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity
     * requirements.
     * </p>
     *
     * @param createRuleGroupRequest
     * @return Result of the CreateRuleGroup operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafDuplicateItemException
     *         AWS WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an
     *         existing one.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws WafLimitsExceededException
     *         AWS WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see
     *         <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.
     * @throws WafUnavailableEntityException
     *         AWS WAF couldn’t retrieve the resource that you requested. Retry your request.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         AWS WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.CreateRuleGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRuleGroupResponse createRuleGroup(CreateRuleGroupRequest createRuleGroupRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafDuplicateItemException,
            WafOptimisticLockException, WafLimitsExceededException, WafUnavailableEntityException, WafTagOperationException,
            WafTagOperationInternalErrorException, AwsServiceException, SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Creates a <a>RuleGroup</a> per the specifications provided.
     * </p>
     * <p>
     * A rule group defines a collection of rules to inspect and control web requests that you can use in a
     * <a>WebACL</a>. When you create a rule group, you define an immutable capacity limit. If you update a rule group,
     * you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity
     * requirements.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRuleGroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateRuleGroupRequest#builder()}
     * </p>
     *
     * @param createRuleGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateRuleGroupRequest.Builder} to create a request.
     * @return Result of the CreateRuleGroup operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafDuplicateItemException
     *         AWS WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an
     *         existing one.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws WafLimitsExceededException
     *         AWS WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see
     *         <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.
     * @throws WafUnavailableEntityException
     *         AWS WAF couldn’t retrieve the resource that you requested. Retry your request.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         AWS WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.CreateRuleGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRuleGroupResponse createRuleGroup(Consumer<CreateRuleGroupRequest.Builder> createRuleGroupRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafDuplicateItemException,
            WafOptimisticLockException, WafLimitsExceededException, WafUnavailableEntityException, WafTagOperationException,
            WafTagOperationInternalErrorException, AwsServiceException, SdkClientException, Wafv2Exception {
        return createRuleGroup(CreateRuleGroupRequest.builder().applyMutation(createRuleGroupRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Creates a <a>WebACL</a> per the specifications provided.
     * </p>
     * <p>
     * A Web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action
     * defined (allow, block, or count) for requests that match the statement of the rule. In the Web ACL, you assign a
     * default action to take (allow, block) for any request that does not match any of the rules. The rules in a Web
     * ACL can be a combination of the types <a>Rule</a>, <a>RuleGroup</a>, and managed rule group. You can associate a
     * Web ACL with one or more AWS resources to protect. The resources can be Amazon CloudFront, an Amazon API Gateway
     * API, or an Application Load Balancer.
     * </p>
     *
     * @param createWebAclRequest
     * @return Result of the CreateWebACL operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafDuplicateItemException
     *         AWS WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an
     *         existing one.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws WafLimitsExceededException
     *         AWS WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see
     *         <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.
     * @throws WafInvalidResourceException
     *         AWS WAF couldn’t perform the operation because the resource that you requested isn’t valid. Check the
     *         resource, and try again.
     * @throws WafUnavailableEntityException
     *         AWS WAF couldn’t retrieve the resource that you requested. Retry your request.
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         AWS WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.CreateWebACL
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateWebAclResponse createWebACL(CreateWebAclRequest createWebAclRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafDuplicateItemException, WafOptimisticLockException, WafLimitsExceededException,
            WafInvalidResourceException, WafUnavailableEntityException, WafNonexistentItemException, WafTagOperationException,
            WafTagOperationInternalErrorException, AwsServiceException, SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Creates a <a>WebACL</a> per the specifications provided.
     * </p>
     * <p>
     * A Web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action
     * defined (allow, block, or count) for requests that match the statement of the rule. In the Web ACL, you assign a
     * default action to take (allow, block) for any request that does not match any of the rules. The rules in a Web
     * ACL can be a combination of the types <a>Rule</a>, <a>RuleGroup</a>, and managed rule group. You can associate a
     * Web ACL with one or more AWS resources to protect. The resources can be Amazon CloudFront, an Amazon API Gateway
     * API, or an Application Load Balancer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWebAclRequest.Builder} avoiding the need to
     * create one manually via {@link CreateWebAclRequest#builder()}
     * </p>
     *
     * @param createWebAclRequest
     *        A {@link Consumer} that will call methods on {@link CreateWebACLRequest.Builder} to create a request.
     * @return Result of the CreateWebACL operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafDuplicateItemException
     *         AWS WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an
     *         existing one.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws WafLimitsExceededException
     *         AWS WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see
     *         <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.
     * @throws WafInvalidResourceException
     *         AWS WAF couldn’t perform the operation because the resource that you requested isn’t valid. Check the
     *         resource, and try again.
     * @throws WafUnavailableEntityException
     *         AWS WAF couldn’t retrieve the resource that you requested. Retry your request.
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         AWS WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.CreateWebACL
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateWebAclResponse createWebACL(Consumer<CreateWebAclRequest.Builder> createWebAclRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafDuplicateItemException,
            WafOptimisticLockException, WafLimitsExceededException, WafInvalidResourceException, WafUnavailableEntityException,
            WafNonexistentItemException, WafTagOperationException, WafTagOperationInternalErrorException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        return createWebACL(CreateWebAclRequest.builder().applyMutation(createWebAclRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Deletes the specified <a>IPSet</a>.
     * </p>
     *
     * @param deleteIpSetRequest
     * @return Result of the DeleteIPSet operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         AWS WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.DeleteIPSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteIpSetResponse deleteIPSet(DeleteIpSetRequest deleteIpSetRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafNonexistentItemException, WafOptimisticLockException, WafTagOperationException,
            WafTagOperationInternalErrorException, AwsServiceException, SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Deletes the specified <a>IPSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIpSetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteIpSetRequest#builder()}
     * </p>
     *
     * @param deleteIpSetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIPSetRequest.Builder} to create a request.
     * @return Result of the DeleteIPSet operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         AWS WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.DeleteIPSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteIpSetResponse deleteIPSet(Consumer<DeleteIpSetRequest.Builder> deleteIpSetRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException,
            WafOptimisticLockException, WafTagOperationException, WafTagOperationInternalErrorException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        return deleteIPSet(DeleteIpSetRequest.builder().applyMutation(deleteIpSetRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Deletes the <a>LoggingConfiguration</a> from the specified web ACL.
     * </p>
     *
     * @param deleteLoggingConfigurationRequest
     * @return Result of the DeleteLoggingConfiguration operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.DeleteLoggingConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLoggingConfigurationResponse deleteLoggingConfiguration(
            DeleteLoggingConfigurationRequest deleteLoggingConfigurationRequest) throws WafInternalErrorException,
            WafNonexistentItemException, WafOptimisticLockException, AwsServiceException, SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Deletes the <a>LoggingConfiguration</a> from the specified web ACL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLoggingConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLoggingConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteLoggingConfiguration operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.DeleteLoggingConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLoggingConfigurationResponse deleteLoggingConfiguration(
            Consumer<DeleteLoggingConfigurationRequest.Builder> deleteLoggingConfigurationRequest)
            throws WafInternalErrorException, WafNonexistentItemException, WafOptimisticLockException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        return deleteLoggingConfiguration(DeleteLoggingConfigurationRequest.builder()
                .applyMutation(deleteLoggingConfigurationRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Deletes the specified <a>RegexPatternSet</a>.
     * </p>
     *
     * @param deleteRegexPatternSetRequest
     * @return Result of the DeleteRegexPatternSet operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         AWS WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.DeleteRegexPatternSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteRegexPatternSet" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteRegexPatternSetResponse deleteRegexPatternSet(DeleteRegexPatternSetRequest deleteRegexPatternSetRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException,
            WafOptimisticLockException, WafTagOperationException, WafTagOperationInternalErrorException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Deletes the specified <a>RegexPatternSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRegexPatternSetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRegexPatternSetRequest#builder()}
     * </p>
     *
     * @param deleteRegexPatternSetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRegexPatternSetRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteRegexPatternSet operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         AWS WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.DeleteRegexPatternSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteRegexPatternSet" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteRegexPatternSetResponse deleteRegexPatternSet(
            Consumer<DeleteRegexPatternSetRequest.Builder> deleteRegexPatternSetRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafNonexistentItemException, WafOptimisticLockException, WafTagOperationException,
            WafTagOperationInternalErrorException, AwsServiceException, SdkClientException, Wafv2Exception {
        return deleteRegexPatternSet(DeleteRegexPatternSetRequest.builder().applyMutation(deleteRegexPatternSetRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Deletes the specified <a>RuleGroup</a>.
     * </p>
     *
     * @param deleteRuleGroupRequest
     * @return Result of the DeleteRuleGroup operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         AWS WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.DeleteRuleGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRuleGroupResponse deleteRuleGroup(DeleteRuleGroupRequest deleteRuleGroupRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException,
            WafOptimisticLockException, WafTagOperationException, WafTagOperationInternalErrorException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Deletes the specified <a>RuleGroup</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRuleGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteRuleGroupRequest#builder()}
     * </p>
     *
     * @param deleteRuleGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRuleGroupRequest.Builder} to create a request.
     * @return Result of the DeleteRuleGroup operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         AWS WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.DeleteRuleGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRuleGroupResponse deleteRuleGroup(Consumer<DeleteRuleGroupRequest.Builder> deleteRuleGroupRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException,
            WafOptimisticLockException, WafTagOperationException, WafTagOperationInternalErrorException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        return deleteRuleGroup(DeleteRuleGroupRequest.builder().applyMutation(deleteRuleGroupRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Deletes the specified <a>WebACL</a>.
     * </p>
     *
     * @param deleteWebAclRequest
     * @return Result of the DeleteWebACL operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws WafAssociatedItemException
     *         AWS WAF couldn’t perform the operation because your resource is being used by another resource or it’s
     *         associated with another resource.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         AWS WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.DeleteWebACL
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteWebAclResponse deleteWebACL(DeleteWebAclRequest deleteWebAclRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafNonexistentItemException, WafOptimisticLockException, WafAssociatedItemException,
            WafTagOperationException, WafTagOperationInternalErrorException, AwsServiceException, SdkClientException,
            Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Deletes the specified <a>WebACL</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWebAclRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWebAclRequest#builder()}
     * </p>
     *
     * @param deleteWebAclRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWebACLRequest.Builder} to create a request.
     * @return Result of the DeleteWebACL operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws WafAssociatedItemException
     *         AWS WAF couldn’t perform the operation because your resource is being used by another resource or it’s
     *         associated with another resource.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         AWS WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.DeleteWebACL
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteWebAclResponse deleteWebACL(Consumer<DeleteWebAclRequest.Builder> deleteWebAclRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException,
            WafOptimisticLockException, WafAssociatedItemException, WafTagOperationException,
            WafTagOperationInternalErrorException, AwsServiceException, SdkClientException, Wafv2Exception {
        return deleteWebACL(DeleteWebAclRequest.builder().applyMutation(deleteWebAclRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Provides high-level information for a managed rule group, including descriptions of the rules.
     * </p>
     *
     * @param describeManagedRuleGroupRequest
     * @return Result of the DescribeManagedRuleGroup operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafInvalidResourceException
     *         AWS WAF couldn’t perform the operation because the resource that you requested isn’t valid. Check the
     *         resource, and try again.
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.DescribeManagedRuleGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DescribeManagedRuleGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeManagedRuleGroupResponse describeManagedRuleGroup(
            DescribeManagedRuleGroupRequest describeManagedRuleGroupRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafInvalidResourceException, WafNonexistentItemException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Provides high-level information for a managed rule group, including descriptions of the rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeManagedRuleGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeManagedRuleGroupRequest#builder()}
     * </p>
     *
     * @param describeManagedRuleGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeManagedRuleGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeManagedRuleGroup operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafInvalidResourceException
     *         AWS WAF couldn’t perform the operation because the resource that you requested isn’t valid. Check the
     *         resource, and try again.
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.DescribeManagedRuleGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DescribeManagedRuleGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeManagedRuleGroupResponse describeManagedRuleGroup(
            Consumer<DescribeManagedRuleGroupRequest.Builder> describeManagedRuleGroupRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafInvalidResourceException, WafNonexistentItemException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        return describeManagedRuleGroup(DescribeManagedRuleGroupRequest.builder().applyMutation(describeManagedRuleGroupRequest)
                .build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Disassociates a Web ACL from a regional application resource. A regional application can be an Application Load
     * Balancer (ALB) or an API Gateway stage.
     * </p>
     * <p>
     * For AWS CloudFront, you can disassociate the Web ACL by providing an empty <code>WebACLId</code> in the
     * CloudFront API call <code>UpdateDistribution</code>. For information, see <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html"
     * >UpdateDistribution</a>.
     * </p>
     *
     * @param disassociateWebAclRequest
     * @return Result of the DisassociateWebACL operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.DisassociateWebACL
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DisassociateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default DisassociateWebAclResponse disassociateWebACL(DisassociateWebAclRequest disassociateWebAclRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Disassociates a Web ACL from a regional application resource. A regional application can be an Application Load
     * Balancer (ALB) or an API Gateway stage.
     * </p>
     * <p>
     * For AWS CloudFront, you can disassociate the Web ACL by providing an empty <code>WebACLId</code> in the
     * CloudFront API call <code>UpdateDistribution</code>. For information, see <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html"
     * >UpdateDistribution</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateWebAclRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateWebAclRequest#builder()}
     * </p>
     *
     * @param disassociateWebAclRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateWebACLRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateWebACL operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.DisassociateWebACL
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DisassociateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default DisassociateWebAclResponse disassociateWebACL(Consumer<DisassociateWebAclRequest.Builder> disassociateWebAclRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        return disassociateWebACL(DisassociateWebAclRequest.builder().applyMutation(disassociateWebAclRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves the specified <a>IPSet</a>.
     * </p>
     *
     * @param getIpSetRequest
     * @return Result of the GetIPSet operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetIPSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default GetIpSetResponse getIPSet(GetIpSetRequest getIpSetRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafNonexistentItemException, AwsServiceException, SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves the specified <a>IPSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIpSetRequest.Builder} avoiding the need to
     * create one manually via {@link GetIpSetRequest#builder()}
     * </p>
     *
     * @param getIpSetRequest
     *        A {@link Consumer} that will call methods on {@link GetIPSetRequest.Builder} to create a request.
     * @return Result of the GetIPSet operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetIPSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default GetIpSetResponse getIPSet(Consumer<GetIpSetRequest.Builder> getIpSetRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafNonexistentItemException, AwsServiceException, SdkClientException, Wafv2Exception {
        return getIPSet(GetIpSetRequest.builder().applyMutation(getIpSetRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Returns the <a>LoggingConfiguration</a> for the specified web ACL.
     * </p>
     *
     * @param getLoggingConfigurationRequest
     * @return Result of the GetLoggingConfiguration operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetLoggingConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetLoggingConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLoggingConfigurationResponse getLoggingConfiguration(GetLoggingConfigurationRequest getLoggingConfigurationRequest)
            throws WafInternalErrorException, WafNonexistentItemException, AwsServiceException, SdkClientException,
            Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Returns the <a>LoggingConfiguration</a> for the specified web ACL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLoggingConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param getLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetLoggingConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the GetLoggingConfiguration operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetLoggingConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetLoggingConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLoggingConfigurationResponse getLoggingConfiguration(
            Consumer<GetLoggingConfigurationRequest.Builder> getLoggingConfigurationRequest) throws WafInternalErrorException,
            WafNonexistentItemException, AwsServiceException, SdkClientException, Wafv2Exception {
        return getLoggingConfiguration(GetLoggingConfigurationRequest.builder().applyMutation(getLoggingConfigurationRequest)
                .build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves the keys that are currently blocked by a rate-based rule. The maximum number of managed keys that can
     * be blocked for a single rate-based rule is 10,000. If more than 10,000 addresses exceed the rate limit, those
     * with the highest rates are blocked.
     * </p>
     *
     * @param getRateBasedStatementManagedKeysRequest
     * @return Result of the GetRateBasedStatementManagedKeys operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetRateBasedStatementManagedKeys
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetRateBasedStatementManagedKeys"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRateBasedStatementManagedKeysResponse getRateBasedStatementManagedKeys(
            GetRateBasedStatementManagedKeysRequest getRateBasedStatementManagedKeysRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafNonexistentItemException, AwsServiceException, SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves the keys that are currently blocked by a rate-based rule. The maximum number of managed keys that can
     * be blocked for a single rate-based rule is 10,000. If more than 10,000 addresses exceed the rate limit, those
     * with the highest rates are blocked.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRateBasedStatementManagedKeysRequest.Builder}
     * avoiding the need to create one manually via {@link GetRateBasedStatementManagedKeysRequest#builder()}
     * </p>
     *
     * @param getRateBasedStatementManagedKeysRequest
     *        A {@link Consumer} that will call methods on {@link GetRateBasedStatementManagedKeysRequest.Builder} to
     *        create a request.
     * @return Result of the GetRateBasedStatementManagedKeys operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetRateBasedStatementManagedKeys
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetRateBasedStatementManagedKeys"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRateBasedStatementManagedKeysResponse getRateBasedStatementManagedKeys(
            Consumer<GetRateBasedStatementManagedKeysRequest.Builder> getRateBasedStatementManagedKeysRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        return getRateBasedStatementManagedKeys(GetRateBasedStatementManagedKeysRequest.builder()
                .applyMutation(getRateBasedStatementManagedKeysRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves the specified <a>RegexPatternSet</a>.
     * </p>
     *
     * @param getRegexPatternSetRequest
     * @return Result of the GetRegexPatternSet operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetRegexPatternSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetRegexPatternSet" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRegexPatternSetResponse getRegexPatternSet(GetRegexPatternSetRequest getRegexPatternSetRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves the specified <a>RegexPatternSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRegexPatternSetRequest.Builder} avoiding the
     * need to create one manually via {@link GetRegexPatternSetRequest#builder()}
     * </p>
     *
     * @param getRegexPatternSetRequest
     *        A {@link Consumer} that will call methods on {@link GetRegexPatternSetRequest.Builder} to create a
     *        request.
     * @return Result of the GetRegexPatternSet operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetRegexPatternSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetRegexPatternSet" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRegexPatternSetResponse getRegexPatternSet(Consumer<GetRegexPatternSetRequest.Builder> getRegexPatternSetRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        return getRegexPatternSet(GetRegexPatternSetRequest.builder().applyMutation(getRegexPatternSetRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves the specified <a>RuleGroup</a>.
     * </p>
     *
     * @param getRuleGroupRequest
     * @return Result of the GetRuleGroup operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetRuleGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRuleGroupResponse getRuleGroup(GetRuleGroupRequest getRuleGroupRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafNonexistentItemException, AwsServiceException, SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves the specified <a>RuleGroup</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRuleGroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetRuleGroupRequest#builder()}
     * </p>
     *
     * @param getRuleGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetRuleGroupRequest.Builder} to create a request.
     * @return Result of the GetRuleGroup operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetRuleGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRuleGroupResponse getRuleGroup(Consumer<GetRuleGroupRequest.Builder> getRuleGroupRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        return getRuleGroup(GetRuleGroupRequest.builder().applyMutation(getRuleGroupRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Gets detailed information about a specified number of requests--a sample--that AWS WAF randomly selects from
     * among the first 5,000 requests that your AWS resource received during a time range that you choose. You can
     * specify a sample size of up to 500 requests, and you can specify any time range in the previous three hours.
     * </p>
     * <p>
     * <code>GetSampledRequests</code> returns a time range, which is usually the time range that you specified.
     * However, if your resource (such as a CloudFront distribution) received 5,000 requests before the specified time
     * range elapsed, <code>GetSampledRequests</code> returns an updated time range. This new time range indicates the
     * actual period during which AWS WAF selected the requests in the sample.
     * </p>
     *
     * @param getSampledRequestsRequest
     * @return Result of the GetSampledRequests operation returned by the service.
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetSampledRequests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetSampledRequests" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSampledRequestsResponse getSampledRequests(GetSampledRequestsRequest getSampledRequestsRequest)
            throws WafNonexistentItemException, WafInternalErrorException, WafInvalidParameterException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Gets detailed information about a specified number of requests--a sample--that AWS WAF randomly selects from
     * among the first 5,000 requests that your AWS resource received during a time range that you choose. You can
     * specify a sample size of up to 500 requests, and you can specify any time range in the previous three hours.
     * </p>
     * <p>
     * <code>GetSampledRequests</code> returns a time range, which is usually the time range that you specified.
     * However, if your resource (such as a CloudFront distribution) received 5,000 requests before the specified time
     * range elapsed, <code>GetSampledRequests</code> returns an updated time range. This new time range indicates the
     * actual period during which AWS WAF selected the requests in the sample.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSampledRequestsRequest.Builder} avoiding the
     * need to create one manually via {@link GetSampledRequestsRequest#builder()}
     * </p>
     *
     * @param getSampledRequestsRequest
     *        A {@link Consumer} that will call methods on {@link GetSampledRequestsRequest.Builder} to create a
     *        request.
     * @return Result of the GetSampledRequests operation returned by the service.
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetSampledRequests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetSampledRequests" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSampledRequestsResponse getSampledRequests(Consumer<GetSampledRequestsRequest.Builder> getSampledRequestsRequest)
            throws WafNonexistentItemException, WafInternalErrorException, WafInvalidParameterException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        return getSampledRequests(GetSampledRequestsRequest.builder().applyMutation(getSampledRequestsRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves the specified <a>WebACL</a>.
     * </p>
     *
     * @param getWebAclRequest
     * @return Result of the GetWebACL operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetWebACL
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default GetWebAclResponse getWebACL(GetWebAclRequest getWebAclRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafNonexistentItemException, AwsServiceException, SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves the specified <a>WebACL</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWebAclRequest.Builder} avoiding the need to
     * create one manually via {@link GetWebAclRequest#builder()}
     * </p>
     *
     * @param getWebAclRequest
     *        A {@link Consumer} that will call methods on {@link GetWebACLRequest.Builder} to create a request.
     * @return Result of the GetWebACL operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetWebACL
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default GetWebAclResponse getWebACL(Consumer<GetWebAclRequest.Builder> getWebAclRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafNonexistentItemException, AwsServiceException, SdkClientException, Wafv2Exception {
        return getWebACL(GetWebAclRequest.builder().applyMutation(getWebAclRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves the <a>WebACL</a> for the specified resource.
     * </p>
     *
     * @param getWebAclForResourceRequest
     * @return Result of the GetWebACLForResource operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafUnavailableEntityException
     *         AWS WAF couldn’t retrieve the resource that you requested. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetWebACLForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetWebACLForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default GetWebAclForResourceResponse getWebACLForResource(GetWebAclForResourceRequest getWebAclForResourceRequest)
            throws WafInternalErrorException, WafNonexistentItemException, WafInvalidParameterException,
            WafUnavailableEntityException, AwsServiceException, SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves the <a>WebACL</a> for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWebAclForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link GetWebAclForResourceRequest#builder()}
     * </p>
     *
     * @param getWebAclForResourceRequest
     *        A {@link Consumer} that will call methods on {@link GetWebACLForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the GetWebACLForResource operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafUnavailableEntityException
     *         AWS WAF couldn’t retrieve the resource that you requested. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.GetWebACLForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetWebACLForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default GetWebAclForResourceResponse getWebACLForResource(
            Consumer<GetWebAclForResourceRequest.Builder> getWebAclForResourceRequest) throws WafInternalErrorException,
            WafNonexistentItemException, WafInvalidParameterException, WafUnavailableEntityException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        return getWebACLForResource(GetWebAclForResourceRequest.builder().applyMutation(getWebAclForResourceRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves an array of managed rule groups that are available for you to use. This list includes all AWS managed
     * rule groups and the AWS Marketplace managed rule groups that you're subscribed to.
     * </p>
     *
     * @param listAvailableManagedRuleGroupsRequest
     * @return Result of the ListAvailableManagedRuleGroups operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListAvailableManagedRuleGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListAvailableManagedRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAvailableManagedRuleGroupsResponse listAvailableManagedRuleGroups(
            ListAvailableManagedRuleGroupsRequest listAvailableManagedRuleGroupsRequest) throws WafInternalErrorException,
            WafInvalidParameterException, AwsServiceException, SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves an array of managed rule groups that are available for you to use. This list includes all AWS managed
     * rule groups and the AWS Marketplace managed rule groups that you're subscribed to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAvailableManagedRuleGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAvailableManagedRuleGroupsRequest#builder()}
     * </p>
     *
     * @param listAvailableManagedRuleGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListAvailableManagedRuleGroupsRequest.Builder} to
     *        create a request.
     * @return Result of the ListAvailableManagedRuleGroups operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListAvailableManagedRuleGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListAvailableManagedRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAvailableManagedRuleGroupsResponse listAvailableManagedRuleGroups(
            Consumer<ListAvailableManagedRuleGroupsRequest.Builder> listAvailableManagedRuleGroupsRequest)
            throws WafInternalErrorException, WafInvalidParameterException, AwsServiceException, SdkClientException,
            Wafv2Exception {
        return listAvailableManagedRuleGroups(ListAvailableManagedRuleGroupsRequest.builder()
                .applyMutation(listAvailableManagedRuleGroupsRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves an array of <a>IPSetSummary</a> objects for the IP sets that you manage.
     * </p>
     *
     * @param listIpSetsRequest
     * @return Result of the ListIPSets operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListIPSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListIPSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIpSetsResponse listIPSets(ListIpSetsRequest listIpSetsRequest) throws WafInternalErrorException,
            WafInvalidParameterException, AwsServiceException, SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves an array of <a>IPSetSummary</a> objects for the IP sets that you manage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIpSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListIpSetsRequest#builder()}
     * </p>
     *
     * @param listIpSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListIPSetsRequest.Builder} to create a request.
     * @return Result of the ListIPSets operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListIPSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListIPSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIpSetsResponse listIPSets(Consumer<ListIpSetsRequest.Builder> listIpSetsRequest)
            throws WafInternalErrorException, WafInvalidParameterException, AwsServiceException, SdkClientException,
            Wafv2Exception {
        return listIPSets(ListIpSetsRequest.builder().applyMutation(listIpSetsRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves an array of your <a>LoggingConfiguration</a> objects.
     * </p>
     *
     * @param listLoggingConfigurationsRequest
     * @return Result of the ListLoggingConfigurations operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListLoggingConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListLoggingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLoggingConfigurationsResponse listLoggingConfigurations(
            ListLoggingConfigurationsRequest listLoggingConfigurationsRequest) throws WafInternalErrorException,
            WafInvalidParameterException, AwsServiceException, SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves an array of your <a>LoggingConfiguration</a> objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLoggingConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListLoggingConfigurationsRequest#builder()}
     * </p>
     *
     * @param listLoggingConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListLoggingConfigurationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListLoggingConfigurations operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListLoggingConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListLoggingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLoggingConfigurationsResponse listLoggingConfigurations(
            Consumer<ListLoggingConfigurationsRequest.Builder> listLoggingConfigurationsRequest)
            throws WafInternalErrorException, WafInvalidParameterException, AwsServiceException, SdkClientException,
            Wafv2Exception {
        return listLoggingConfigurations(ListLoggingConfigurationsRequest.builder()
                .applyMutation(listLoggingConfigurationsRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves an array of <a>RegexPatternSetSummary</a> objects for the regex pattern sets that you manage.
     * </p>
     *
     * @param listRegexPatternSetsRequest
     * @return Result of the ListRegexPatternSets operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListRegexPatternSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListRegexPatternSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRegexPatternSetsResponse listRegexPatternSets(ListRegexPatternSetsRequest listRegexPatternSetsRequest)
            throws WafInternalErrorException, WafInvalidParameterException, AwsServiceException, SdkClientException,
            Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves an array of <a>RegexPatternSetSummary</a> objects for the regex pattern sets that you manage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRegexPatternSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRegexPatternSetsRequest#builder()}
     * </p>
     *
     * @param listRegexPatternSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListRegexPatternSetsRequest.Builder} to create a
     *        request.
     * @return Result of the ListRegexPatternSets operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListRegexPatternSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListRegexPatternSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRegexPatternSetsResponse listRegexPatternSets(
            Consumer<ListRegexPatternSetsRequest.Builder> listRegexPatternSetsRequest) throws WafInternalErrorException,
            WafInvalidParameterException, AwsServiceException, SdkClientException, Wafv2Exception {
        return listRegexPatternSets(ListRegexPatternSetsRequest.builder().applyMutation(listRegexPatternSetsRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves an array of the Amazon Resource Names (ARNs) for the regional resources that are associated with the
     * specified web ACL. If you want the list of AWS CloudFront resources, use the AWS CloudFront call
     * <code>ListDistributionsByWebACLId</code>.
     * </p>
     *
     * @param listResourcesForWebAclRequest
     * @return Result of the ListResourcesForWebACL operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListResourcesForWebACL
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListResourcesForWebACL" target="_top">AWS
     *      API Documentation</a>
     */
    default ListResourcesForWebAclResponse listResourcesForWebACL(ListResourcesForWebAclRequest listResourcesForWebAclRequest)
            throws WafInternalErrorException, WafNonexistentItemException, WafInvalidParameterException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves an array of the Amazon Resource Names (ARNs) for the regional resources that are associated with the
     * specified web ACL. If you want the list of AWS CloudFront resources, use the AWS CloudFront call
     * <code>ListDistributionsByWebACLId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcesForWebAclRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourcesForWebAclRequest#builder()}
     * </p>
     *
     * @param listResourcesForWebAclRequest
     *        A {@link Consumer} that will call methods on {@link ListResourcesForWebACLRequest.Builder} to create a
     *        request.
     * @return Result of the ListResourcesForWebACL operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListResourcesForWebACL
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListResourcesForWebACL" target="_top">AWS
     *      API Documentation</a>
     */
    default ListResourcesForWebAclResponse listResourcesForWebACL(
            Consumer<ListResourcesForWebAclRequest.Builder> listResourcesForWebAclRequest) throws WafInternalErrorException,
            WafNonexistentItemException, WafInvalidParameterException, AwsServiceException, SdkClientException, Wafv2Exception {
        return listResourcesForWebACL(ListResourcesForWebAclRequest.builder().applyMutation(listResourcesForWebAclRequest)
                .build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves an array of <a>RuleGroupSummary</a> objects for the rule groups that you manage.
     * </p>
     *
     * @param listRuleGroupsRequest
     * @return Result of the ListRuleGroups operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListRuleGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListRuleGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRuleGroupsResponse listRuleGroups(ListRuleGroupsRequest listRuleGroupsRequest) throws WafInternalErrorException,
            WafInvalidParameterException, AwsServiceException, SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves an array of <a>RuleGroupSummary</a> objects for the rule groups that you manage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRuleGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRuleGroupsRequest#builder()}
     * </p>
     *
     * @param listRuleGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListRuleGroupsRequest.Builder} to create a request.
     * @return Result of the ListRuleGroups operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListRuleGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListRuleGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRuleGroupsResponse listRuleGroups(Consumer<ListRuleGroupsRequest.Builder> listRuleGroupsRequest)
            throws WafInternalErrorException, WafInvalidParameterException, AwsServiceException, SdkClientException,
            Wafv2Exception {
        return listRuleGroups(ListRuleGroupsRequest.builder().applyMutation(listRuleGroupsRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves the <a>TagInfoForResource</a> for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         AWS WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException,
            WafTagOperationException, WafTagOperationInternalErrorException, AwsServiceException, SdkClientException,
            Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves the <a>TagInfoForResource</a> for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         AWS WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafNonexistentItemException, WafTagOperationException,
            WafTagOperationInternalErrorException, AwsServiceException, SdkClientException, Wafv2Exception {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves an array of <a>WebACLSummary</a> objects for the web ACLs that you manage.
     * </p>
     *
     * @param listWebAcLsRequest
     * @return Result of the ListWebACLs operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListWebACLs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListWebACLs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWebAcLsResponse listWebACLs(ListWebAcLsRequest listWebAcLsRequest) throws WafInternalErrorException,
            WafInvalidParameterException, AwsServiceException, SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Retrieves an array of <a>WebACLSummary</a> objects for the web ACLs that you manage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWebAcLsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWebAcLsRequest#builder()}
     * </p>
     *
     * @param listWebAcLsRequest
     *        A {@link Consumer} that will call methods on {@link ListWebACLsRequest.Builder} to create a request.
     * @return Result of the ListWebACLs operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.ListWebACLs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListWebACLs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWebAcLsResponse listWebACLs(Consumer<ListWebAcLsRequest.Builder> listWebAcLsRequest)
            throws WafInternalErrorException, WafInvalidParameterException, AwsServiceException, SdkClientException,
            Wafv2Exception {
        return listWebACLs(ListWebAcLsRequest.builder().applyMutation(listWebAcLsRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Enables the specified <a>LoggingConfiguration</a>, to start logging from a web ACL, according to the
     * configuration provided.
     * </p>
     * <p>
     * You can access information about all traffic that AWS WAF inspects using the following steps:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Create an Amazon Kinesis Data Firehose.
     * </p>
     * <p>
     * Create the data firehose with a PUT source and in the region that you are operating. If you are capturing logs
     * for Amazon CloudFront, always create the firehose in US East (N. Virginia).
     * </p>
     * <note>
     * <p>
     * Do not create the data firehose using a <code>Kinesis stream</code> as your source.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * Associate that firehose to your web ACL using a <code>PutLoggingConfiguration</code> request.
     * </p>
     * </li>
     * </ol>
     * <p>
     * When you successfully enable logging using a <code>PutLoggingConfiguration</code> request, AWS WAF will create a
     * service linked role with the necessary permissions to write logs to the Amazon Kinesis Data Firehose. For more
     * information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging Web ACL
     * Traffic Information</a> in the <i>AWS WAF Developer Guide</i>.
     * </p>
     *
     * @param putLoggingConfigurationRequest
     * @return Result of the PutLoggingConfiguration operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws WafServiceLinkedRoleErrorException
     *         AWS WAF is not able to access the service linked role. This can be caused by a previous
     *         <code>PutLoggingConfiguration</code> request, which can lock the service linked role for about 20
     *         seconds. Please try your request again. The service linked role can also be locked by a previous
     *         <code>DeleteServiceLinkedRole</code> request, which can lock the role for 15 minutes or more. If you
     *         recently made a call to <code>DeleteServiceLinkedRole</code>, wait at least 15 minutes and try the
     *         request again. If you receive this same exception again, you will have to wait additional time until the
     *         role is unlocked.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.PutLoggingConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/PutLoggingConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default PutLoggingConfigurationResponse putLoggingConfiguration(PutLoggingConfigurationRequest putLoggingConfigurationRequest)
            throws WafInternalErrorException, WafNonexistentItemException, WafOptimisticLockException,
            WafServiceLinkedRoleErrorException, WafInvalidParameterException, AwsServiceException, SdkClientException,
            Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Enables the specified <a>LoggingConfiguration</a>, to start logging from a web ACL, according to the
     * configuration provided.
     * </p>
     * <p>
     * You can access information about all traffic that AWS WAF inspects using the following steps:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Create an Amazon Kinesis Data Firehose.
     * </p>
     * <p>
     * Create the data firehose with a PUT source and in the region that you are operating. If you are capturing logs
     * for Amazon CloudFront, always create the firehose in US East (N. Virginia).
     * </p>
     * <note>
     * <p>
     * Do not create the data firehose using a <code>Kinesis stream</code> as your source.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * Associate that firehose to your web ACL using a <code>PutLoggingConfiguration</code> request.
     * </p>
     * </li>
     * </ol>
     * <p>
     * When you successfully enable logging using a <code>PutLoggingConfiguration</code> request, AWS WAF will create a
     * service linked role with the necessary permissions to write logs to the Amazon Kinesis Data Firehose. For more
     * information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging Web ACL
     * Traffic Information</a> in the <i>AWS WAF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutLoggingConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link PutLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param putLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link PutLoggingConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the PutLoggingConfiguration operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws WafServiceLinkedRoleErrorException
     *         AWS WAF is not able to access the service linked role. This can be caused by a previous
     *         <code>PutLoggingConfiguration</code> request, which can lock the service linked role for about 20
     *         seconds. Please try your request again. The service linked role can also be locked by a previous
     *         <code>DeleteServiceLinkedRole</code> request, which can lock the role for 15 minutes or more. If you
     *         recently made a call to <code>DeleteServiceLinkedRole</code>, wait at least 15 minutes and try the
     *         request again. If you receive this same exception again, you will have to wait additional time until the
     *         role is unlocked.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.PutLoggingConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/PutLoggingConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default PutLoggingConfigurationResponse putLoggingConfiguration(
            Consumer<PutLoggingConfigurationRequest.Builder> putLoggingConfigurationRequest) throws WafInternalErrorException,
            WafNonexistentItemException, WafOptimisticLockException, WafServiceLinkedRoleErrorException,
            WafInvalidParameterException, AwsServiceException, SdkClientException, Wafv2Exception {
        return putLoggingConfiguration(PutLoggingConfigurationRequest.builder().applyMutation(putLoggingConfigurationRequest)
                .build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Associates tags with the specified AWS resource. Tags are key:value pairs that you can associate with AWS
     * resources. For example, the tag key might be "customer" and the tag value might be "companyA." You can specify
     * one or more tags to add to each container. You can add up to 50 tags to each AWS resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafLimitsExceededException
     *         AWS WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see
     *         <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         AWS WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafLimitsExceededException, WafNonexistentItemException, WafTagOperationException,
            WafTagOperationInternalErrorException, AwsServiceException, SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Associates tags with the specified AWS resource. Tags are key:value pairs that you can associate with AWS
     * resources. For example, the tag key might be "customer" and the tag value might be "companyA." You can specify
     * one or more tags to add to each container. You can add up to 50 tags to each AWS resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafLimitsExceededException
     *         AWS WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see
     *         <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         AWS WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafLimitsExceededException,
            WafNonexistentItemException, WafTagOperationException, WafTagOperationInternalErrorException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Disassociates tags from an AWS resource. Tags are key:value pairs that you can associate with AWS resources. For
     * example, the tag key might be "customer" and the tag value might be "companyA." You can specify one or more tags
     * to add to each container. You can add up to 50 tags to each AWS resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         AWS WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafNonexistentItemException, WafTagOperationException,
            WafTagOperationInternalErrorException, AwsServiceException, SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Disassociates tags from an AWS resource. Tags are key:value pairs that you can associate with AWS resources. For
     * example, the tag key might be "customer" and the tag value might be "companyA." You can specify one or more tags
     * to add to each container. You can add up to 50 tags to each AWS resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafTagOperationException
     *         An error occurred during the tagging operation. Retry your request.
     * @throws WafTagOperationInternalErrorException
     *         AWS WAF couldn’t perform your tagging operation because of an internal error. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException,
            WafTagOperationException, WafTagOperationInternalErrorException, AwsServiceException, SdkClientException,
            Wafv2Exception {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Updates the specified <a>IPSet</a>.
     * </p>
     *
     * @param updateIpSetRequest
     * @return Result of the UpdateIPSet operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafDuplicateItemException
     *         AWS WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an
     *         existing one.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws WafLimitsExceededException
     *         AWS WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see
     *         <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.UpdateIPSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateIpSetResponse updateIPSet(UpdateIpSetRequest updateIpSetRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafNonexistentItemException, WafDuplicateItemException, WafOptimisticLockException,
            WafLimitsExceededException, AwsServiceException, SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Updates the specified <a>IPSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIpSetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateIpSetRequest#builder()}
     * </p>
     *
     * @param updateIpSetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateIPSetRequest.Builder} to create a request.
     * @return Result of the UpdateIPSet operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafDuplicateItemException
     *         AWS WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an
     *         existing one.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws WafLimitsExceededException
     *         AWS WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see
     *         <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.UpdateIPSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateIpSetResponse updateIPSet(Consumer<UpdateIpSetRequest.Builder> updateIpSetRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException,
            WafDuplicateItemException, WafOptimisticLockException, WafLimitsExceededException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        return updateIPSet(UpdateIpSetRequest.builder().applyMutation(updateIpSetRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Updates the specified <a>RegexPatternSet</a>.
     * </p>
     *
     * @param updateRegexPatternSetRequest
     * @return Result of the UpdateRegexPatternSet operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafDuplicateItemException
     *         AWS WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an
     *         existing one.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws WafLimitsExceededException
     *         AWS WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see
     *         <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.UpdateRegexPatternSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateRegexPatternSet" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateRegexPatternSetResponse updateRegexPatternSet(UpdateRegexPatternSetRequest updateRegexPatternSetRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException,
            WafDuplicateItemException, WafOptimisticLockException, WafLimitsExceededException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Updates the specified <a>RegexPatternSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRegexPatternSetRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRegexPatternSetRequest#builder()}
     * </p>
     *
     * @param updateRegexPatternSetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRegexPatternSetRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateRegexPatternSet operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafDuplicateItemException
     *         AWS WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an
     *         existing one.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws WafLimitsExceededException
     *         AWS WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see
     *         <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.UpdateRegexPatternSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateRegexPatternSet" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateRegexPatternSetResponse updateRegexPatternSet(
            Consumer<UpdateRegexPatternSetRequest.Builder> updateRegexPatternSetRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafNonexistentItemException, WafDuplicateItemException, WafOptimisticLockException,
            WafLimitsExceededException, AwsServiceException, SdkClientException, Wafv2Exception {
        return updateRegexPatternSet(UpdateRegexPatternSetRequest.builder().applyMutation(updateRegexPatternSetRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Updates the specified <a>RuleGroup</a>.
     * </p>
     * <p>
     * A rule group defines a collection of rules to inspect and control web requests that you can use in a
     * <a>WebACL</a>. When you create a rule group, you define an immutable capacity limit. If you update a rule group,
     * you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity
     * requirements.
     * </p>
     *
     * @param updateRuleGroupRequest
     * @return Result of the UpdateRuleGroup operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafDuplicateItemException
     *         AWS WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an
     *         existing one.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws WafLimitsExceededException
     *         AWS WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see
     *         <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.
     * @throws WafUnavailableEntityException
     *         AWS WAF couldn’t retrieve the resource that you requested. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.UpdateRuleGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateRuleGroupResponse updateRuleGroup(UpdateRuleGroupRequest updateRuleGroupRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException,
            WafDuplicateItemException, WafOptimisticLockException, WafLimitsExceededException, WafUnavailableEntityException,
            AwsServiceException, SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Updates the specified <a>RuleGroup</a>.
     * </p>
     * <p>
     * A rule group defines a collection of rules to inspect and control web requests that you can use in a
     * <a>WebACL</a>. When you create a rule group, you define an immutable capacity limit. If you update a rule group,
     * you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity
     * requirements.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRuleGroupRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateRuleGroupRequest#builder()}
     * </p>
     *
     * @param updateRuleGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRuleGroupRequest.Builder} to create a request.
     * @return Result of the UpdateRuleGroup operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafDuplicateItemException
     *         AWS WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an
     *         existing one.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws WafLimitsExceededException
     *         AWS WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see
     *         <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.
     * @throws WafUnavailableEntityException
     *         AWS WAF couldn’t retrieve the resource that you requested. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.UpdateRuleGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateRuleGroupResponse updateRuleGroup(Consumer<UpdateRuleGroupRequest.Builder> updateRuleGroupRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException,
            WafDuplicateItemException, WafOptimisticLockException, WafLimitsExceededException, WafUnavailableEntityException,
            AwsServiceException, SdkClientException, Wafv2Exception {
        return updateRuleGroup(UpdateRuleGroupRequest.builder().applyMutation(updateRuleGroupRequest).build());
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Updates the specified <a>WebACL</a>.
     * </p>
     * <p>
     * A Web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action
     * defined (allow, block, or count) for requests that match the statement of the rule. In the Web ACL, you assign a
     * default action to take (allow, block) for any request that does not match any of the rules. The rules in a Web
     * ACL can be a combination of the types <a>Rule</a>, <a>RuleGroup</a>, and managed rule group. You can associate a
     * Web ACL with one or more AWS resources to protect. The resources can be Amazon CloudFront, an Amazon API Gateway
     * API, or an Application Load Balancer.
     * </p>
     *
     * @param updateWebAclRequest
     * @return Result of the UpdateWebACL operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafDuplicateItemException
     *         AWS WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an
     *         existing one.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws WafLimitsExceededException
     *         AWS WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see
     *         <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.
     * @throws WafInvalidResourceException
     *         AWS WAF couldn’t perform the operation because the resource that you requested isn’t valid. Check the
     *         resource, and try again.
     * @throws WafUnavailableEntityException
     *         AWS WAF couldn’t retrieve the resource that you requested. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.UpdateWebACL
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateWebAclResponse updateWebACL(UpdateWebAclRequest updateWebAclRequest) throws WafInternalErrorException,
            WafInvalidParameterException, WafNonexistentItemException, WafDuplicateItemException, WafOptimisticLockException,
            WafLimitsExceededException, WafInvalidResourceException, WafUnavailableEntityException, AwsServiceException,
            SdkClientException, Wafv2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information,
     * including how to migrate your AWS WAF resources from the prior release, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * Updates the specified <a>WebACL</a>.
     * </p>
     * <p>
     * A Web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action
     * defined (allow, block, or count) for requests that match the statement of the rule. In the Web ACL, you assign a
     * default action to take (allow, block) for any request that does not match any of the rules. The rules in a Web
     * ACL can be a combination of the types <a>Rule</a>, <a>RuleGroup</a>, and managed rule group. You can associate a
     * Web ACL with one or more AWS resources to protect. The resources can be Amazon CloudFront, an Amazon API Gateway
     * API, or an Application Load Balancer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWebAclRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateWebAclRequest#builder()}
     * </p>
     *
     * @param updateWebAclRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWebACLRequest.Builder} to create a request.
     * @return Result of the UpdateWebACL operation returned by the service.
     * @throws WafInternalErrorException
     *         Your request is valid, but AWS WAF couldn’t perform the operation because of a system problem. Retry your
     *         request.
     * @throws WafInvalidParameterException
     *         The operation failed because AWS WAF didn't recognize a parameter in the request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li>
     * @throws WafNonexistentItemException
     *         AWS WAF couldn’t perform the operation because your resource doesn’t exist.
     * @throws WafDuplicateItemException
     *         AWS WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an
     *         existing one.
     * @throws WafOptimisticLockException
     *         AWS WAF couldn’t save your changes because you tried to update or delete a resource that has changed
     *         since you last retrieved it. Get the resource again, make any changes you need to make to the new copy,
     *         and retry your operation.
     * @throws WafLimitsExceededException
     *         AWS WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum
     *         number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see
     *         <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.
     * @throws WafInvalidResourceException
     *         AWS WAF couldn’t perform the operation because the resource that you requested isn’t valid. Check the
     *         resource, and try again.
     * @throws WafUnavailableEntityException
     *         AWS WAF couldn’t retrieve the resource that you requested. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Wafv2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Wafv2Client.UpdateWebACL
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateWebAclResponse updateWebACL(Consumer<UpdateWebAclRequest.Builder> updateWebAclRequest)
            throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException,
            WafDuplicateItemException, WafOptimisticLockException, WafLimitsExceededException, WafInvalidResourceException,
            WafUnavailableEntityException, AwsServiceException, SdkClientException, Wafv2Exception {
        return updateWebACL(UpdateWebAclRequest.builder().applyMutation(updateWebAclRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("wafv2");
    }
}
