/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.FieldToMatch;
import software.amazon.awssdk.services.wafv2.model.TextTransformation;
import software.amazon.awssdk.services.wafv2.model.TextTransformationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class XssMatchStatement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, XssMatchStatement> {
    private static final SdkField<FieldToMatch> FIELD_TO_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(XssMatchStatement.getter(XssMatchStatement::fieldToMatch)).setter(XssMatchStatement.setter(Builder::fieldToMatch)).constructor(FieldToMatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldToMatch").build()}).build();
    private static final SdkField<List<TextTransformation>> TEXT_TRANSFORMATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(XssMatchStatement.getter(XssMatchStatement::textTransformations)).setter(XssMatchStatement.setter(Builder::textTransformations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextTransformations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TextTransformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_TO_MATCH_FIELD, TEXT_TRANSFORMATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final FieldToMatch fieldToMatch;
    private final List<TextTransformation> textTransformations;

    private XssMatchStatement(BuilderImpl builder) {
        this.fieldToMatch = builder.fieldToMatch;
        this.textTransformations = builder.textTransformations;
    }

    public FieldToMatch fieldToMatch() {
        return this.fieldToMatch;
    }

    public List<TextTransformation> textTransformations() {
        return this.textTransformations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldToMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.textTransformations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XssMatchStatement)) {
            return false;
        }
        XssMatchStatement other = (XssMatchStatement)obj;
        return Objects.equals(this.fieldToMatch(), other.fieldToMatch()) && Objects.equals(this.textTransformations(), other.textTransformations());
    }

    public String toString() {
        return ToString.builder((String)"XssMatchStatement").add("FieldToMatch", (Object)this.fieldToMatch()).add("TextTransformations", this.textTransformations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldToMatch": {
                return Optional.ofNullable(clazz.cast(this.fieldToMatch()));
            }
            case "TextTransformations": {
                return Optional.ofNullable(clazz.cast(this.textTransformations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<XssMatchStatement, T> g) {
        return obj -> g.apply((XssMatchStatement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FieldToMatch fieldToMatch;
        private List<TextTransformation> textTransformations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(XssMatchStatement model) {
            this.fieldToMatch(model.fieldToMatch);
            this.textTransformations(model.textTransformations);
        }

        public final FieldToMatch.Builder getFieldToMatch() {
            return this.fieldToMatch != null ? this.fieldToMatch.toBuilder() : null;
        }

        @Override
        public final Builder fieldToMatch(FieldToMatch fieldToMatch) {
            this.fieldToMatch = fieldToMatch;
            return this;
        }

        public final void setFieldToMatch(FieldToMatch.BuilderImpl fieldToMatch) {
            this.fieldToMatch = fieldToMatch != null ? fieldToMatch.build() : null;
        }

        public final Collection<TextTransformation.Builder> getTextTransformations() {
            return this.textTransformations != null ? (Collection)this.textTransformations.stream().map(TextTransformation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder textTransformations(Collection<TextTransformation> textTransformations) {
            this.textTransformations = TextTransformationsCopier.copy(textTransformations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textTransformations(TextTransformation ... textTransformations) {
            this.textTransformations(Arrays.asList(textTransformations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textTransformations(Consumer<TextTransformation.Builder> ... textTransformations) {
            this.textTransformations(Stream.of(textTransformations).map(c -> (TextTransformation)((TextTransformation.Builder)TextTransformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTextTransformations(Collection<TextTransformation.BuilderImpl> textTransformations) {
            this.textTransformations = TextTransformationsCopier.copyFromBuilder(textTransformations);
        }

        public XssMatchStatement build() {
            return new XssMatchStatement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, XssMatchStatement> {
        public Builder fieldToMatch(FieldToMatch var1);

        default public Builder fieldToMatch(Consumer<FieldToMatch.Builder> fieldToMatch) {
            return this.fieldToMatch((FieldToMatch)((FieldToMatch.Builder)FieldToMatch.builder().applyMutation(fieldToMatch)).build());
        }

        public Builder textTransformations(Collection<TextTransformation> var1);

        public Builder textTransformations(TextTransformation ... var1);

        public Builder textTransformations(Consumer<TextTransformation.Builder> ... var1);
    }
}

