/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.waf.model.GeoMatchConstraintType;
import software.amazon.awssdk.services.waf.model.GeoMatchConstraintValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeoMatchConstraint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeoMatchConstraint> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GeoMatchConstraint.getter(GeoMatchConstraint::typeAsString)).setter(GeoMatchConstraint.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GeoMatchConstraint.getter(GeoMatchConstraint::valueAsString)).setter(GeoMatchConstraint.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String value;

    private GeoMatchConstraint(BuilderImpl builder) {
        this.type = builder.type;
        this.value = builder.value;
    }

    public GeoMatchConstraintType type() {
        return GeoMatchConstraintType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public GeoMatchConstraintValue value() {
        return GeoMatchConstraintValue.fromValue(this.value);
    }

    public String valueAsString() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoMatchConstraint)) {
            return false;
        }
        GeoMatchConstraint other = (GeoMatchConstraint)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.valueAsString(), other.valueAsString());
    }

    public String toString() {
        return ToString.builder((String)"GeoMatchConstraint").add("Type", (Object)this.typeAsString()).add("Value", (Object)this.valueAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.valueAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeoMatchConstraint, T> g) {
        return obj -> g.apply((GeoMatchConstraint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(GeoMatchConstraint model) {
            this.type(model.type);
            this.value(model.value);
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GeoMatchConstraintType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getValueAsString() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public final Builder value(GeoMatchConstraintValue value) {
            this.value(value == null ? null : value.toString());
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public GeoMatchConstraint build() {
            return new GeoMatchConstraint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeoMatchConstraint> {
        public Builder type(String var1);

        public Builder type(GeoMatchConstraintType var1);

        public Builder value(String var1);

        public Builder value(GeoMatchConstraintValue var1);
    }
}

