/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.waf.model.ChangeAction;
import software.amazon.awssdk.services.waf.model.XssMatchTuple;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class XssMatchSetUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, XssMatchSetUpdate> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(XssMatchSetUpdate.getter(XssMatchSetUpdate::actionAsString)).setter(XssMatchSetUpdate.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<XssMatchTuple> XSS_MATCH_TUPLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("XssMatchTuple").getter(XssMatchSetUpdate.getter(XssMatchSetUpdate::xssMatchTuple)).setter(XssMatchSetUpdate.setter(Builder::xssMatchTuple)).constructor(XssMatchTuple::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XssMatchTuple").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, XSS_MATCH_TUPLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = XssMatchSetUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String action;
    private final XssMatchTuple xssMatchTuple;

    private XssMatchSetUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.xssMatchTuple = builder.xssMatchTuple;
    }

    public final ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final XssMatchTuple xssMatchTuple() {
        return this.xssMatchTuple;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.xssMatchTuple());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XssMatchSetUpdate)) {
            return false;
        }
        XssMatchSetUpdate other = (XssMatchSetUpdate)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.xssMatchTuple(), other.xssMatchTuple());
    }

    public final String toString() {
        return ToString.builder((String)"XssMatchSetUpdate").add("Action", (Object)this.actionAsString()).add("XssMatchTuple", (Object)this.xssMatchTuple()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "XssMatchTuple": {
                return Optional.ofNullable(clazz.cast(this.xssMatchTuple()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", ACTION_FIELD);
        map.put("XssMatchTuple", XSS_MATCH_TUPLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<XssMatchSetUpdate, T> g) {
        return obj -> g.apply((XssMatchSetUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private XssMatchTuple xssMatchTuple;

        private BuilderImpl() {
        }

        private BuilderImpl(XssMatchSetUpdate model) {
            this.action(model.action);
            this.xssMatchTuple(model.xssMatchTuple);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final XssMatchTuple.Builder getXssMatchTuple() {
            return this.xssMatchTuple != null ? this.xssMatchTuple.toBuilder() : null;
        }

        public final void setXssMatchTuple(XssMatchTuple.BuilderImpl xssMatchTuple) {
            this.xssMatchTuple = xssMatchTuple != null ? xssMatchTuple.build() : null;
        }

        @Override
        public final Builder xssMatchTuple(XssMatchTuple xssMatchTuple) {
            this.xssMatchTuple = xssMatchTuple;
            return this;
        }

        public XssMatchSetUpdate build() {
            return new XssMatchSetUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, XssMatchSetUpdate> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder xssMatchTuple(XssMatchTuple var1);

        default public Builder xssMatchTuple(Consumer<XssMatchTuple.Builder> xssMatchTuple) {
            return this.xssMatchTuple((XssMatchTuple)((XssMatchTuple.Builder)XssMatchTuple.builder().applyMutation(xssMatchTuple)).build());
        }
    }
}

