/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.regional;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.waf.regional.DefaultWafRegionalBaseClientBuilder;
import software.amazon.awssdk.services.waf.regional.DefaultWafRegionalClient;
import software.amazon.awssdk.services.waf.regional.WafRegionalClient;
import software.amazon.awssdk.services.waf.regional.WafRegionalClientBuilder;
import software.amazon.awssdk.services.waf.regional.WafRegionalServiceClientConfiguration;
import software.amazon.awssdk.services.waf.regional.endpoints.WafRegionalEndpointProvider;

@SdkInternalApi
final class DefaultWafRegionalClientBuilder
extends DefaultWafRegionalBaseClientBuilder<WafRegionalClientBuilder, WafRegionalClient>
implements WafRegionalClientBuilder {
    DefaultWafRegionalClientBuilder() {
    }

    @Override
    public DefaultWafRegionalClientBuilder endpointProvider(WafRegionalEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final WafRegionalClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultWafRegionalClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        WafRegionalServiceClientConfiguration serviceClientConfiguration = WafRegionalServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultWafRegionalClient(serviceClientConfiguration, clientConfiguration);
    }
}

