/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateByteMatchSetRequest extends WafRequest implements
        ToCopyableBuilder<UpdateByteMatchSetRequest.Builder, UpdateByteMatchSetRequest> {
    private static final SdkField<String> BYTE_MATCH_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ByteMatchSetId").getter(getter(UpdateByteMatchSetRequest::byteMatchSetId))
            .setter(setter(Builder::byteMatchSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ByteMatchSetId").build()).build();

    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeToken").getter(getter(UpdateByteMatchSetRequest::changeToken))
            .setter(setter(Builder::changeToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()).build();

    private static final SdkField<List<ByteMatchSetUpdate>> UPDATES_FIELD = SdkField
            .<List<ByteMatchSetUpdate>> builder(MarshallingType.LIST)
            .memberName("Updates")
            .getter(getter(UpdateByteMatchSetRequest::updates))
            .setter(setter(Builder::updates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Updates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ByteMatchSetUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(ByteMatchSetUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYTE_MATCH_SET_ID_FIELD,
            CHANGE_TOKEN_FIELD, UPDATES_FIELD));

    private final String byteMatchSetId;

    private final String changeToken;

    private final List<ByteMatchSetUpdate> updates;

    private UpdateByteMatchSetRequest(BuilderImpl builder) {
        super(builder);
        this.byteMatchSetId = builder.byteMatchSetId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
    }

    /**
     * <p>
     * The <code>ByteMatchSetId</code> of the <a>ByteMatchSet</a> that you want to update. <code>ByteMatchSetId</code>
     * is returned by <a>CreateByteMatchSet</a> and by <a>ListByteMatchSets</a>.
     * </p>
     * 
     * @return The <code>ByteMatchSetId</code> of the <a>ByteMatchSet</a> that you want to update.
     *         <code>ByteMatchSetId</code> is returned by <a>CreateByteMatchSet</a> and by <a>ListByteMatchSets</a>.
     */
    public final String byteMatchSetId() {
        return byteMatchSetId;
    }

    /**
     * <p>
     * The value returned by the most recent call to <a>GetChangeToken</a>.
     * </p>
     * 
     * @return The value returned by the most recent call to <a>GetChangeToken</a>.
     */
    public final String changeToken() {
        return changeToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Updates property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUpdates() {
        return updates != null && !(updates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ByteMatchSetUpdate</code> objects that you want to insert into or delete from a
     * <a>ByteMatchSet</a>. For more information, see the applicable data types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>ByteMatchSetUpdate</a>: Contains <code>Action</code> and <code>ByteMatchTuple</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ByteMatchTuple</a>: Contains <code>FieldToMatch</code>, <code>PositionalConstraint</code>,
     * <code>TargetString</code>, and <code>TextTransformation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUpdates} method.
     * </p>
     * 
     * @return An array of <code>ByteMatchSetUpdate</code> objects that you want to insert into or delete from a
     *         <a>ByteMatchSet</a>. For more information, see the applicable data types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a>ByteMatchSetUpdate</a>: Contains <code>Action</code> and <code>ByteMatchTuple</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>ByteMatchTuple</a>: Contains <code>FieldToMatch</code>, <code>PositionalConstraint</code>,
     *         <code>TargetString</code>, and <code>TextTransformation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
     *         </p>
     *         </li>
     */
    public final List<ByteMatchSetUpdate> updates() {
        return updates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(byteMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(changeToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasUpdates() ? updates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateByteMatchSetRequest)) {
            return false;
        }
        UpdateByteMatchSetRequest other = (UpdateByteMatchSetRequest) obj;
        return Objects.equals(byteMatchSetId(), other.byteMatchSetId()) && Objects.equals(changeToken(), other.changeToken())
                && hasUpdates() == other.hasUpdates() && Objects.equals(updates(), other.updates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateByteMatchSetRequest").add("ByteMatchSetId", byteMatchSetId())
                .add("ChangeToken", changeToken()).add("Updates", hasUpdates() ? updates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ByteMatchSetId":
            return Optional.ofNullable(clazz.cast(byteMatchSetId()));
        case "ChangeToken":
            return Optional.ofNullable(clazz.cast(changeToken()));
        case "Updates":
            return Optional.ofNullable(clazz.cast(updates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateByteMatchSetRequest, T> g) {
        return obj -> g.apply((UpdateByteMatchSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateByteMatchSetRequest> {
        /**
         * <p>
         * The <code>ByteMatchSetId</code> of the <a>ByteMatchSet</a> that you want to update.
         * <code>ByteMatchSetId</code> is returned by <a>CreateByteMatchSet</a> and by <a>ListByteMatchSets</a>.
         * </p>
         * 
         * @param byteMatchSetId
         *        The <code>ByteMatchSetId</code> of the <a>ByteMatchSet</a> that you want to update.
         *        <code>ByteMatchSetId</code> is returned by <a>CreateByteMatchSet</a> and by <a>ListByteMatchSets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byteMatchSetId(String byteMatchSetId);

        /**
         * <p>
         * The value returned by the most recent call to <a>GetChangeToken</a>.
         * </p>
         * 
         * @param changeToken
         *        The value returned by the most recent call to <a>GetChangeToken</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeToken(String changeToken);

        /**
         * <p>
         * An array of <code>ByteMatchSetUpdate</code> objects that you want to insert into or delete from a
         * <a>ByteMatchSet</a>. For more information, see the applicable data types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>ByteMatchSetUpdate</a>: Contains <code>Action</code> and <code>ByteMatchTuple</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>ByteMatchTuple</a>: Contains <code>FieldToMatch</code>, <code>PositionalConstraint</code>,
         * <code>TargetString</code>, and <code>TextTransformation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param updates
         *        An array of <code>ByteMatchSetUpdate</code> objects that you want to insert into or delete from a
         *        <a>ByteMatchSet</a>. For more information, see the applicable data types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a>ByteMatchSetUpdate</a>: Contains <code>Action</code> and <code>ByteMatchTuple</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>ByteMatchTuple</a>: Contains <code>FieldToMatch</code>, <code>PositionalConstraint</code>,
         *        <code>TargetString</code>, and <code>TextTransformation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updates(Collection<ByteMatchSetUpdate> updates);

        /**
         * <p>
         * An array of <code>ByteMatchSetUpdate</code> objects that you want to insert into or delete from a
         * <a>ByteMatchSet</a>. For more information, see the applicable data types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>ByteMatchSetUpdate</a>: Contains <code>Action</code> and <code>ByteMatchTuple</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>ByteMatchTuple</a>: Contains <code>FieldToMatch</code>, <code>PositionalConstraint</code>,
         * <code>TargetString</code>, and <code>TextTransformation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param updates
         *        An array of <code>ByteMatchSetUpdate</code> objects that you want to insert into or delete from a
         *        <a>ByteMatchSet</a>. For more information, see the applicable data types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a>ByteMatchSetUpdate</a>: Contains <code>Action</code> and <code>ByteMatchTuple</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>ByteMatchTuple</a>: Contains <code>FieldToMatch</code>, <code>PositionalConstraint</code>,
         *        <code>TargetString</code>, and <code>TextTransformation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updates(ByteMatchSetUpdate... updates);

        /**
         * <p>
         * An array of <code>ByteMatchSetUpdate</code> objects that you want to insert into or delete from a
         * <a>ByteMatchSet</a>. For more information, see the applicable data types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>ByteMatchSetUpdate</a>: Contains <code>Action</code> and <code>ByteMatchTuple</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>ByteMatchTuple</a>: Contains <code>FieldToMatch</code>, <code>PositionalConstraint</code>,
         * <code>TargetString</code>, and <code>TextTransformation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.waf.model.ByteMatchSetUpdate.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.waf.model.ByteMatchSetUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.waf.model.ByteMatchSetUpdate.Builder#build()} is called immediately
         * and its result is passed to {@link #updates(List<ByteMatchSetUpdate>)}.
         * 
         * @param updates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.waf.model.ByteMatchSetUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updates(java.util.Collection<ByteMatchSetUpdate>)
         */
        Builder updates(Consumer<ByteMatchSetUpdate.Builder>... updates);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WafRequest.BuilderImpl implements Builder {
        private String byteMatchSetId;

        private String changeToken;

        private List<ByteMatchSetUpdate> updates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateByteMatchSetRequest model) {
            super(model);
            byteMatchSetId(model.byteMatchSetId);
            changeToken(model.changeToken);
            updates(model.updates);
        }

        public final String getByteMatchSetId() {
            return byteMatchSetId;
        }

        public final void setByteMatchSetId(String byteMatchSetId) {
            this.byteMatchSetId = byteMatchSetId;
        }

        @Override
        public final Builder byteMatchSetId(String byteMatchSetId) {
            this.byteMatchSetId = byteMatchSetId;
            return this;
        }

        public final String getChangeToken() {
            return changeToken;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final List<ByteMatchSetUpdate.Builder> getUpdates() {
            List<ByteMatchSetUpdate.Builder> result = ByteMatchSetUpdatesCopier.copyToBuilder(this.updates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpdates(Collection<ByteMatchSetUpdate.BuilderImpl> updates) {
            this.updates = ByteMatchSetUpdatesCopier.copyFromBuilder(updates);
        }

        @Override
        public final Builder updates(Collection<ByteMatchSetUpdate> updates) {
            this.updates = ByteMatchSetUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(ByteMatchSetUpdate... updates) {
            updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(Consumer<ByteMatchSetUpdate.Builder>... updates) {
            updates(Stream.of(updates).map(c -> ByteMatchSetUpdate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateByteMatchSetRequest build() {
            return new UpdateByteMatchSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
