/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.waf.model.ChangeAction;
import software.amazon.awssdk.services.waf.model.SqlInjectionMatchTuple;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SqlInjectionMatchSetUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SqlInjectionMatchSetUpdate> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(SqlInjectionMatchSetUpdate.getter(SqlInjectionMatchSetUpdate::actionAsString)).setter(SqlInjectionMatchSetUpdate.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<SqlInjectionMatchTuple> SQL_INJECTION_MATCH_TUPLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SqlInjectionMatchTuple").getter(SqlInjectionMatchSetUpdate.getter(SqlInjectionMatchSetUpdate::sqlInjectionMatchTuple)).setter(SqlInjectionMatchSetUpdate.setter(Builder::sqlInjectionMatchTuple)).constructor(SqlInjectionMatchTuple::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlInjectionMatchTuple").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, SQL_INJECTION_MATCH_TUPLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String action;
    private final SqlInjectionMatchTuple sqlInjectionMatchTuple;

    private SqlInjectionMatchSetUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.sqlInjectionMatchTuple = builder.sqlInjectionMatchTuple;
    }

    public final ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final SqlInjectionMatchTuple sqlInjectionMatchTuple() {
        return this.sqlInjectionMatchTuple;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlInjectionMatchTuple());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqlInjectionMatchSetUpdate)) {
            return false;
        }
        SqlInjectionMatchSetUpdate other = (SqlInjectionMatchSetUpdate)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.sqlInjectionMatchTuple(), other.sqlInjectionMatchTuple());
    }

    public final String toString() {
        return ToString.builder((String)"SqlInjectionMatchSetUpdate").add("Action", (Object)this.actionAsString()).add("SqlInjectionMatchTuple", (Object)this.sqlInjectionMatchTuple()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "SqlInjectionMatchTuple": {
                return Optional.ofNullable(clazz.cast(this.sqlInjectionMatchTuple()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SqlInjectionMatchSetUpdate, T> g) {
        return obj -> g.apply((SqlInjectionMatchSetUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private SqlInjectionMatchTuple sqlInjectionMatchTuple;

        private BuilderImpl() {
        }

        private BuilderImpl(SqlInjectionMatchSetUpdate model) {
            this.action(model.action);
            this.sqlInjectionMatchTuple(model.sqlInjectionMatchTuple);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final SqlInjectionMatchTuple.Builder getSqlInjectionMatchTuple() {
            return this.sqlInjectionMatchTuple != null ? this.sqlInjectionMatchTuple.toBuilder() : null;
        }

        @Override
        public final Builder sqlInjectionMatchTuple(SqlInjectionMatchTuple sqlInjectionMatchTuple) {
            this.sqlInjectionMatchTuple = sqlInjectionMatchTuple;
            return this;
        }

        public final void setSqlInjectionMatchTuple(SqlInjectionMatchTuple.BuilderImpl sqlInjectionMatchTuple) {
            this.sqlInjectionMatchTuple = sqlInjectionMatchTuple != null ? sqlInjectionMatchTuple.build() : null;
        }

        public SqlInjectionMatchSetUpdate build() {
            return new SqlInjectionMatchSetUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SqlInjectionMatchSetUpdate> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder sqlInjectionMatchTuple(SqlInjectionMatchTuple var1);

        default public Builder sqlInjectionMatchTuple(Consumer<SqlInjectionMatchTuple.Builder> sqlInjectionMatchTuple) {
            return this.sqlInjectionMatchTuple((SqlInjectionMatchTuple)((SqlInjectionMatchTuple.Builder)SqlInjectionMatchTuple.builder().applyMutation(sqlInjectionMatchTuple)).build());
        }
    }
}

