/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGeoMatchSetRequest extends WafRequest implements
        ToCopyableBuilder<UpdateGeoMatchSetRequest.Builder, UpdateGeoMatchSetRequest> {
    private static final SdkField<String> GEO_MATCH_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeoMatchSetId").getter(getter(UpdateGeoMatchSetRequest::geoMatchSetId))
            .setter(setter(Builder::geoMatchSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoMatchSetId").build()).build();

    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeToken").getter(getter(UpdateGeoMatchSetRequest::changeToken)).setter(setter(Builder::changeToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()).build();

    private static final SdkField<List<GeoMatchSetUpdate>> UPDATES_FIELD = SdkField
            .<List<GeoMatchSetUpdate>> builder(MarshallingType.LIST)
            .memberName("Updates")
            .getter(getter(UpdateGeoMatchSetRequest::updates))
            .setter(setter(Builder::updates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Updates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GeoMatchSetUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(GeoMatchSetUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GEO_MATCH_SET_ID_FIELD,
            CHANGE_TOKEN_FIELD, UPDATES_FIELD));

    private final String geoMatchSetId;

    private final String changeToken;

    private final List<GeoMatchSetUpdate> updates;

    private UpdateGeoMatchSetRequest(BuilderImpl builder) {
        super(builder);
        this.geoMatchSetId = builder.geoMatchSetId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
    }

    /**
     * <p>
     * The <code>GeoMatchSetId</code> of the <a>GeoMatchSet</a> that you want to update. <code>GeoMatchSetId</code> is
     * returned by <a>CreateGeoMatchSet</a> and by <a>ListGeoMatchSets</a>.
     * </p>
     * 
     * @return The <code>GeoMatchSetId</code> of the <a>GeoMatchSet</a> that you want to update.
     *         <code>GeoMatchSetId</code> is returned by <a>CreateGeoMatchSet</a> and by <a>ListGeoMatchSets</a>.
     */
    public final String geoMatchSetId() {
        return geoMatchSetId;
    }

    /**
     * <p>
     * The value returned by the most recent call to <a>GetChangeToken</a>.
     * </p>
     * 
     * @return The value returned by the most recent call to <a>GetChangeToken</a>.
     */
    public final String changeToken() {
        return changeToken;
    }

    /**
     * Returns true if the Updates property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasUpdates() {
        return updates != null && !(updates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>GeoMatchSetUpdate</code> objects that you want to insert into or delete from an
     * <a>GeoMatchSet</a>. For more information, see the applicable data types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>GeoMatchSetUpdate</a>: Contains <code>Action</code> and <code>GeoMatchConstraint</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>GeoMatchConstraint</a>: Contains <code>Type</code> and <code>Value</code>
     * </p>
     * <p>
     * You can have only one <code>Type</code> and <code>Value</code> per <code>GeoMatchConstraint</code>. To add
     * multiple countries, include multiple <code>GeoMatchSetUpdate</code> objects in your request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUpdates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>GeoMatchSetUpdate</code> objects that you want to insert into or delete from an
     *         <a>GeoMatchSet</a>. For more information, see the applicable data types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a>GeoMatchSetUpdate</a>: Contains <code>Action</code> and <code>GeoMatchConstraint</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>GeoMatchConstraint</a>: Contains <code>Type</code> and <code>Value</code>
     *         </p>
     *         <p>
     *         You can have only one <code>Type</code> and <code>Value</code> per <code>GeoMatchConstraint</code>. To
     *         add multiple countries, include multiple <code>GeoMatchSetUpdate</code> objects in your request.
     *         </p>
     *         </li>
     */
    public final List<GeoMatchSetUpdate> updates() {
        return updates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(geoMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(changeToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasUpdates() ? updates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGeoMatchSetRequest)) {
            return false;
        }
        UpdateGeoMatchSetRequest other = (UpdateGeoMatchSetRequest) obj;
        return Objects.equals(geoMatchSetId(), other.geoMatchSetId()) && Objects.equals(changeToken(), other.changeToken())
                && hasUpdates() == other.hasUpdates() && Objects.equals(updates(), other.updates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGeoMatchSetRequest").add("GeoMatchSetId", geoMatchSetId())
                .add("ChangeToken", changeToken()).add("Updates", hasUpdates() ? updates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GeoMatchSetId":
            return Optional.ofNullable(clazz.cast(geoMatchSetId()));
        case "ChangeToken":
            return Optional.ofNullable(clazz.cast(changeToken()));
        case "Updates":
            return Optional.ofNullable(clazz.cast(updates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGeoMatchSetRequest, T> g) {
        return obj -> g.apply((UpdateGeoMatchSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateGeoMatchSetRequest> {
        /**
         * <p>
         * The <code>GeoMatchSetId</code> of the <a>GeoMatchSet</a> that you want to update. <code>GeoMatchSetId</code>
         * is returned by <a>CreateGeoMatchSet</a> and by <a>ListGeoMatchSets</a>.
         * </p>
         * 
         * @param geoMatchSetId
         *        The <code>GeoMatchSetId</code> of the <a>GeoMatchSet</a> that you want to update.
         *        <code>GeoMatchSetId</code> is returned by <a>CreateGeoMatchSet</a> and by <a>ListGeoMatchSets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geoMatchSetId(String geoMatchSetId);

        /**
         * <p>
         * The value returned by the most recent call to <a>GetChangeToken</a>.
         * </p>
         * 
         * @param changeToken
         *        The value returned by the most recent call to <a>GetChangeToken</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeToken(String changeToken);

        /**
         * <p>
         * An array of <code>GeoMatchSetUpdate</code> objects that you want to insert into or delete from an
         * <a>GeoMatchSet</a>. For more information, see the applicable data types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>GeoMatchSetUpdate</a>: Contains <code>Action</code> and <code>GeoMatchConstraint</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>GeoMatchConstraint</a>: Contains <code>Type</code> and <code>Value</code>
         * </p>
         * <p>
         * You can have only one <code>Type</code> and <code>Value</code> per <code>GeoMatchConstraint</code>. To add
         * multiple countries, include multiple <code>GeoMatchSetUpdate</code> objects in your request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param updates
         *        An array of <code>GeoMatchSetUpdate</code> objects that you want to insert into or delete from an
         *        <a>GeoMatchSet</a>. For more information, see the applicable data types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a>GeoMatchSetUpdate</a>: Contains <code>Action</code> and <code>GeoMatchConstraint</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>GeoMatchConstraint</a>: Contains <code>Type</code> and <code>Value</code>
         *        </p>
         *        <p>
         *        You can have only one <code>Type</code> and <code>Value</code> per <code>GeoMatchConstraint</code>. To
         *        add multiple countries, include multiple <code>GeoMatchSetUpdate</code> objects in your request.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updates(Collection<GeoMatchSetUpdate> updates);

        /**
         * <p>
         * An array of <code>GeoMatchSetUpdate</code> objects that you want to insert into or delete from an
         * <a>GeoMatchSet</a>. For more information, see the applicable data types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>GeoMatchSetUpdate</a>: Contains <code>Action</code> and <code>GeoMatchConstraint</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>GeoMatchConstraint</a>: Contains <code>Type</code> and <code>Value</code>
         * </p>
         * <p>
         * You can have only one <code>Type</code> and <code>Value</code> per <code>GeoMatchConstraint</code>. To add
         * multiple countries, include multiple <code>GeoMatchSetUpdate</code> objects in your request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param updates
         *        An array of <code>GeoMatchSetUpdate</code> objects that you want to insert into or delete from an
         *        <a>GeoMatchSet</a>. For more information, see the applicable data types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a>GeoMatchSetUpdate</a>: Contains <code>Action</code> and <code>GeoMatchConstraint</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>GeoMatchConstraint</a>: Contains <code>Type</code> and <code>Value</code>
         *        </p>
         *        <p>
         *        You can have only one <code>Type</code> and <code>Value</code> per <code>GeoMatchConstraint</code>. To
         *        add multiple countries, include multiple <code>GeoMatchSetUpdate</code> objects in your request.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updates(GeoMatchSetUpdate... updates);

        /**
         * <p>
         * An array of <code>GeoMatchSetUpdate</code> objects that you want to insert into or delete from an
         * <a>GeoMatchSet</a>. For more information, see the applicable data types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>GeoMatchSetUpdate</a>: Contains <code>Action</code> and <code>GeoMatchConstraint</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>GeoMatchConstraint</a>: Contains <code>Type</code> and <code>Value</code>
         * </p>
         * <p>
         * You can have only one <code>Type</code> and <code>Value</code> per <code>GeoMatchConstraint</code>. To add
         * multiple countries, include multiple <code>GeoMatchSetUpdate</code> objects in your request.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<GeoMatchSetUpdate>.Builder} avoiding the
         * need to create one manually via {@link List<GeoMatchSetUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GeoMatchSetUpdate>.Builder#build()} is called immediately
         * and its result is passed to {@link #updates(List<GeoMatchSetUpdate>)}.
         * 
         * @param updates
         *        a consumer that will call methods on {@link List<GeoMatchSetUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updates(List<GeoMatchSetUpdate>)
         */
        Builder updates(Consumer<GeoMatchSetUpdate.Builder>... updates);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WafRequest.BuilderImpl implements Builder {
        private String geoMatchSetId;

        private String changeToken;

        private List<GeoMatchSetUpdate> updates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGeoMatchSetRequest model) {
            super(model);
            geoMatchSetId(model.geoMatchSetId);
            changeToken(model.changeToken);
            updates(model.updates);
        }

        public final String getGeoMatchSetId() {
            return geoMatchSetId;
        }

        @Override
        public final Builder geoMatchSetId(String geoMatchSetId) {
            this.geoMatchSetId = geoMatchSetId;
            return this;
        }

        public final void setGeoMatchSetId(String geoMatchSetId) {
            this.geoMatchSetId = geoMatchSetId;
        }

        public final String getChangeToken() {
            return changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public final Collection<GeoMatchSetUpdate.Builder> getUpdates() {
            if (updates instanceof SdkAutoConstructList) {
                return null;
            }
            return updates != null ? updates.stream().map(GeoMatchSetUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder updates(Collection<GeoMatchSetUpdate> updates) {
            this.updates = GeoMatchSetUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(GeoMatchSetUpdate... updates) {
            updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(Consumer<GeoMatchSetUpdate.Builder>... updates) {
            updates(Stream.of(updates).map(c -> GeoMatchSetUpdate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUpdates(Collection<GeoMatchSetUpdate.BuilderImpl> updates) {
            this.updates = GeoMatchSetUpdatesCopier.copyFromBuilder(updates);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGeoMatchSetRequest build() {
            return new UpdateGeoMatchSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
