/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSubscribedRuleGroupsResponse extends WafResponse implements
        ToCopyableBuilder<ListSubscribedRuleGroupsResponse.Builder, ListSubscribedRuleGroupsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListSubscribedRuleGroupsResponse::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final SdkField<List<SubscribedRuleGroupSummary>> RULE_GROUPS_FIELD = SdkField
            .<List<SubscribedRuleGroupSummary>> builder(MarshallingType.LIST)
            .memberName("RuleGroups")
            .getter(getter(ListSubscribedRuleGroupsResponse::ruleGroups))
            .setter(setter(Builder::ruleGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SubscribedRuleGroupSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubscribedRuleGroupSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD,
            RULE_GROUPS_FIELD));

    private final String nextMarker;

    private final List<SubscribedRuleGroupSummary> ruleGroups;

    private ListSubscribedRuleGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.ruleGroups = builder.ruleGroups;
    }

    /**
     * <p>
     * If you have more objects than the number that you specified for <code>Limit</code> in the request, the response
     * includes a <code>NextMarker</code> value. To list more objects, submit another
     * <code>ListSubscribedRuleGroups</code> request, and specify the <code>NextMarker</code> value from the response in
     * the <code>NextMarker</code> value in the next request.
     * </p>
     * 
     * @return If you have more objects than the number that you specified for <code>Limit</code> in the request, the
     *         response includes a <code>NextMarker</code> value. To list more objects, submit another
     *         <code>ListSubscribedRuleGroups</code> request, and specify the <code>NextMarker</code> value from the
     *         response in the <code>NextMarker</code> value in the next request.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * Returns true if the RuleGroups property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRuleGroups() {
        return ruleGroups != null && !(ruleGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <a>RuleGroup</a> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRuleGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <a>RuleGroup</a> objects.
     */
    public final List<SubscribedRuleGroupSummary> ruleGroups() {
        return ruleGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleGroups() ? ruleGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSubscribedRuleGroupsResponse)) {
            return false;
        }
        ListSubscribedRuleGroupsResponse other = (ListSubscribedRuleGroupsResponse) obj;
        return Objects.equals(nextMarker(), other.nextMarker()) && hasRuleGroups() == other.hasRuleGroups()
                && Objects.equals(ruleGroups(), other.ruleGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSubscribedRuleGroupsResponse").add("NextMarker", nextMarker())
                .add("RuleGroups", hasRuleGroups() ? ruleGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "RuleGroups":
            return Optional.ofNullable(clazz.cast(ruleGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSubscribedRuleGroupsResponse, T> g) {
        return obj -> g.apply((ListSubscribedRuleGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSubscribedRuleGroupsResponse> {
        /**
         * <p>
         * If you have more objects than the number that you specified for <code>Limit</code> in the request, the
         * response includes a <code>NextMarker</code> value. To list more objects, submit another
         * <code>ListSubscribedRuleGroups</code> request, and specify the <code>NextMarker</code> value from the
         * response in the <code>NextMarker</code> value in the next request.
         * </p>
         * 
         * @param nextMarker
         *        If you have more objects than the number that you specified for <code>Limit</code> in the request, the
         *        response includes a <code>NextMarker</code> value. To list more objects, submit another
         *        <code>ListSubscribedRuleGroups</code> request, and specify the <code>NextMarker</code> value from the
         *        response in the <code>NextMarker</code> value in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * An array of <a>RuleGroup</a> objects.
         * </p>
         * 
         * @param ruleGroups
         *        An array of <a>RuleGroup</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroups(Collection<SubscribedRuleGroupSummary> ruleGroups);

        /**
         * <p>
         * An array of <a>RuleGroup</a> objects.
         * </p>
         * 
         * @param ruleGroups
         *        An array of <a>RuleGroup</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroups(SubscribedRuleGroupSummary... ruleGroups);

        /**
         * <p>
         * An array of <a>RuleGroup</a> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SubscribedRuleGroupSummary>.Builder}
         * avoiding the need to create one manually via {@link List<SubscribedRuleGroupSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SubscribedRuleGroupSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #ruleGroups(List<SubscribedRuleGroupSummary>)}.
         * 
         * @param ruleGroups
         *        a consumer that will call methods on {@link List<SubscribedRuleGroupSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleGroups(List<SubscribedRuleGroupSummary>)
         */
        Builder ruleGroups(Consumer<SubscribedRuleGroupSummary.Builder>... ruleGroups);
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private String nextMarker;

        private List<SubscribedRuleGroupSummary> ruleGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSubscribedRuleGroupsResponse model) {
            super(model);
            nextMarker(model.nextMarker);
            ruleGroups(model.ruleGroups);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<SubscribedRuleGroupSummary.Builder> getRuleGroups() {
            if (ruleGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return ruleGroups != null ? ruleGroups.stream().map(SubscribedRuleGroupSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ruleGroups(Collection<SubscribedRuleGroupSummary> ruleGroups) {
            this.ruleGroups = SubscribedRuleGroupSummariesCopier.copy(ruleGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroups(SubscribedRuleGroupSummary... ruleGroups) {
            ruleGroups(Arrays.asList(ruleGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroups(Consumer<SubscribedRuleGroupSummary.Builder>... ruleGroups) {
            ruleGroups(Stream.of(ruleGroups).map(c -> SubscribedRuleGroupSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRuleGroups(Collection<SubscribedRuleGroupSummary.BuilderImpl> ruleGroups) {
            this.ruleGroups = SubscribedRuleGroupSummariesCopier.copyFromBuilder(ruleGroups);
        }

        @Override
        public ListSubscribedRuleGroupsResponse build() {
            return new ListSubscribedRuleGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
