/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRulesResponse extends WafResponse implements
        ToCopyableBuilder<ListRulesResponse.Builder, ListRulesResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListRulesResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final SdkField<List<RuleSummary>> RULES_FIELD = SdkField
            .<List<RuleSummary>> builder(MarshallingType.LIST)
            .memberName("Rules")
            .getter(getter(ListRulesResponse::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NEXT_MARKER_FIELD, RULES_FIELD));

    private final String nextMarker;

    private final List<RuleSummary> rules;

    private ListRulesResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.rules = builder.rules;
    }

    /**
     * <p>
     * If you have more <code>Rules</code> than the number that you specified for <code>Limit</code> in the request, the
     * response includes a <code>NextMarker</code> value. To list more <code>Rules</code>, submit another
     * <code>ListRules</code> request, and specify the <code>NextMarker</code> value from the response in the
     * <code>NextMarker</code> value in the next request.
     * </p>
     * 
     * @return If you have more <code>Rules</code> than the number that you specified for <code>Limit</code> in the
     *         request, the response includes a <code>NextMarker</code> value. To list more <code>Rules</code>, submit
     *         another <code>ListRules</code> request, and specify the <code>NextMarker</code> value from the response
     *         in the <code>NextMarker</code> value in the next request.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * Returns true if the Rules property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <a>RuleSummary</a> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <a>RuleSummary</a> objects.
     */
    public final List<RuleSummary> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRulesResponse)) {
            return false;
        }
        ListRulesResponse other = (ListRulesResponse) obj;
        return Objects.equals(nextMarker(), other.nextMarker()) && hasRules() == other.hasRules()
                && Objects.equals(rules(), other.rules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRulesResponse").add("NextMarker", nextMarker()).add("Rules", hasRules() ? rules() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRulesResponse, T> g) {
        return obj -> g.apply((ListRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRulesResponse> {
        /**
         * <p>
         * If you have more <code>Rules</code> than the number that you specified for <code>Limit</code> in the request,
         * the response includes a <code>NextMarker</code> value. To list more <code>Rules</code>, submit another
         * <code>ListRules</code> request, and specify the <code>NextMarker</code> value from the response in the
         * <code>NextMarker</code> value in the next request.
         * </p>
         * 
         * @param nextMarker
         *        If you have more <code>Rules</code> than the number that you specified for <code>Limit</code> in the
         *        request, the response includes a <code>NextMarker</code> value. To list more <code>Rules</code>,
         *        submit another <code>ListRules</code> request, and specify the <code>NextMarker</code> value from the
         *        response in the <code>NextMarker</code> value in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * An array of <a>RuleSummary</a> objects.
         * </p>
         * 
         * @param rules
         *        An array of <a>RuleSummary</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<RuleSummary> rules);

        /**
         * <p>
         * An array of <a>RuleSummary</a> objects.
         * </p>
         * 
         * @param rules
         *        An array of <a>RuleSummary</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(RuleSummary... rules);

        /**
         * <p>
         * An array of <a>RuleSummary</a> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RuleSummary>.Builder} avoiding the need to
         * create one manually via {@link List<RuleSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RuleSummary>.Builder#build()} is called immediately and its
         * result is passed to {@link #rules(List<RuleSummary>)}.
         * 
         * @param rules
         *        a consumer that will call methods on {@link List<RuleSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(List<RuleSummary>)
         */
        Builder rules(Consumer<RuleSummary.Builder>... rules);
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private String nextMarker;

        private List<RuleSummary> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRulesResponse model) {
            super(model);
            nextMarker(model.nextMarker);
            rules(model.rules);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<RuleSummary.Builder> getRules() {
            if (rules instanceof SdkAutoConstructList) {
                return null;
            }
            return rules != null ? rules.stream().map(RuleSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<RuleSummary> rules) {
            this.rules = RuleSummariesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(RuleSummary... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<RuleSummary.Builder>... rules) {
            rules(Stream.of(rules).map(c -> RuleSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<RuleSummary.BuilderImpl> rules) {
            this.rules = RuleSummariesCopier.copyFromBuilder(rules);
        }

        @Override
        public ListRulesResponse build() {
            return new ListRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
