/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLoggingConfigurationsResponse extends WafResponse implements
        ToCopyableBuilder<ListLoggingConfigurationsResponse.Builder, ListLoggingConfigurationsResponse> {
    private static final SdkField<List<LoggingConfiguration>> LOGGING_CONFIGURATIONS_FIELD = SdkField
            .<List<LoggingConfiguration>> builder(MarshallingType.LIST)
            .memberName("LoggingConfigurations")
            .getter(getter(ListLoggingConfigurationsResponse::loggingConfigurations))
            .setter(setter(Builder::loggingConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LoggingConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoggingConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListLoggingConfigurationsResponse::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGGING_CONFIGURATIONS_FIELD,
            NEXT_MARKER_FIELD));

    private final List<LoggingConfiguration> loggingConfigurations;

    private final String nextMarker;

    private ListLoggingConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.loggingConfigurations = builder.loggingConfigurations;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * Returns true if the LoggingConfigurations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasLoggingConfigurations() {
        return loggingConfigurations != null && !(loggingConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <a>LoggingConfiguration</a> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLoggingConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <a>LoggingConfiguration</a> objects.
     */
    public final List<LoggingConfiguration> loggingConfigurations() {
        return loggingConfigurations;
    }

    /**
     * <p>
     * If you have more <code>LoggingConfigurations</code> than the number that you specified for <code>Limit</code> in
     * the request, the response includes a <code>NextMarker</code> value. To list more
     * <code>LoggingConfigurations</code>, submit another <code>ListLoggingConfigurations</code> request, and specify
     * the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.
     * </p>
     * 
     * @return If you have more <code>LoggingConfigurations</code> than the number that you specified for
     *         <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more
     *         <code>LoggingConfigurations</code>, submit another <code>ListLoggingConfigurations</code> request, and
     *         specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the
     *         next request.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLoggingConfigurations() ? loggingConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLoggingConfigurationsResponse)) {
            return false;
        }
        ListLoggingConfigurationsResponse other = (ListLoggingConfigurationsResponse) obj;
        return hasLoggingConfigurations() == other.hasLoggingConfigurations()
                && Objects.equals(loggingConfigurations(), other.loggingConfigurations())
                && Objects.equals(nextMarker(), other.nextMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLoggingConfigurationsResponse")
                .add("LoggingConfigurations", hasLoggingConfigurations() ? loggingConfigurations() : null)
                .add("NextMarker", nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoggingConfigurations":
            return Optional.ofNullable(clazz.cast(loggingConfigurations()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLoggingConfigurationsResponse, T> g) {
        return obj -> g.apply((ListLoggingConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListLoggingConfigurationsResponse> {
        /**
         * <p>
         * An array of <a>LoggingConfiguration</a> objects.
         * </p>
         * 
         * @param loggingConfigurations
         *        An array of <a>LoggingConfiguration</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfigurations(Collection<LoggingConfiguration> loggingConfigurations);

        /**
         * <p>
         * An array of <a>LoggingConfiguration</a> objects.
         * </p>
         * 
         * @param loggingConfigurations
         *        An array of <a>LoggingConfiguration</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfigurations(LoggingConfiguration... loggingConfigurations);

        /**
         * <p>
         * An array of <a>LoggingConfiguration</a> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LoggingConfiguration>.Builder} avoiding the
         * need to create one manually via {@link List<LoggingConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LoggingConfiguration>.Builder#build()} is called immediately
         * and its result is passed to {@link #loggingConfigurations(List<LoggingConfiguration>)}.
         * 
         * @param loggingConfigurations
         *        a consumer that will call methods on {@link List<LoggingConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingConfigurations(List<LoggingConfiguration>)
         */
        Builder loggingConfigurations(Consumer<LoggingConfiguration.Builder>... loggingConfigurations);

        /**
         * <p>
         * If you have more <code>LoggingConfigurations</code> than the number that you specified for <code>Limit</code>
         * in the request, the response includes a <code>NextMarker</code> value. To list more
         * <code>LoggingConfigurations</code>, submit another <code>ListLoggingConfigurations</code> request, and
         * specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next
         * request.
         * </p>
         * 
         * @param nextMarker
         *        If you have more <code>LoggingConfigurations</code> than the number that you specified for
         *        <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more
         *        <code>LoggingConfigurations</code>, submit another <code>ListLoggingConfigurations</code> request, and
         *        specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in
         *        the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private List<LoggingConfiguration> loggingConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLoggingConfigurationsResponse model) {
            super(model);
            loggingConfigurations(model.loggingConfigurations);
            nextMarker(model.nextMarker);
        }

        public final Collection<LoggingConfiguration.Builder> getLoggingConfigurations() {
            if (loggingConfigurations instanceof SdkAutoConstructList) {
                return null;
            }
            return loggingConfigurations != null ? loggingConfigurations.stream().map(LoggingConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder loggingConfigurations(Collection<LoggingConfiguration> loggingConfigurations) {
            this.loggingConfigurations = LoggingConfigurationsCopier.copy(loggingConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loggingConfigurations(LoggingConfiguration... loggingConfigurations) {
            loggingConfigurations(Arrays.asList(loggingConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loggingConfigurations(Consumer<LoggingConfiguration.Builder>... loggingConfigurations) {
            loggingConfigurations(Stream.of(loggingConfigurations)
                    .map(c -> LoggingConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLoggingConfigurations(Collection<LoggingConfiguration.BuilderImpl> loggingConfigurations) {
            this.loggingConfigurations = LoggingConfigurationsCopier.copyFromBuilder(loggingConfigurations);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public ListLoggingConfigurationsResponse build() {
            return new ListLoggingConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
