/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIpSetsResponse extends WafResponse implements
        ToCopyableBuilder<ListIpSetsResponse.Builder, ListIpSetsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListIpSetsResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final SdkField<List<IPSetSummary>> IP_SETS_FIELD = SdkField
            .<List<IPSetSummary>> builder(MarshallingType.LIST)
            .memberName("IPSets")
            .getter(getter(ListIpSetsResponse::ipSets))
            .setter(setter(Builder::ipSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IPSetSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(IPSetSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD,
            IP_SETS_FIELD));

    private final String nextMarker;

    private final List<IPSetSummary> ipSets;

    private ListIpSetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.ipSets = builder.ipSets;
    }

    /**
     * <p>
     * To list more <code>IPSet</code> objects, submit another <code>ListIPSets</code> request, and in the next request
     * use the <code>NextMarker</code> response value as the <code>NextMarker</code> value.
     * </p>
     * 
     * @return To list more <code>IPSet</code> objects, submit another <code>ListIPSets</code> request, and in the next
     *         request use the <code>NextMarker</code> response value as the <code>NextMarker</code> value.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * Returns true if the IPSets property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasIpSets() {
        return ipSets != null && !(ipSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <a>IPSetSummary</a> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpSets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <a>IPSetSummary</a> objects.
     */
    public final List<IPSetSummary> ipSets() {
        return ipSets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpSets() ? ipSets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIpSetsResponse)) {
            return false;
        }
        ListIpSetsResponse other = (ListIpSetsResponse) obj;
        return Objects.equals(nextMarker(), other.nextMarker()) && hasIpSets() == other.hasIpSets()
                && Objects.equals(ipSets(), other.ipSets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIpSetsResponse").add("NextMarker", nextMarker())
                .add("IPSets", hasIpSets() ? ipSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "IPSets":
            return Optional.ofNullable(clazz.cast(ipSets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIpSetsResponse, T> g) {
        return obj -> g.apply((ListIpSetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListIpSetsResponse> {
        /**
         * <p>
         * To list more <code>IPSet</code> objects, submit another <code>ListIPSets</code> request, and in the next
         * request use the <code>NextMarker</code> response value as the <code>NextMarker</code> value.
         * </p>
         * 
         * @param nextMarker
         *        To list more <code>IPSet</code> objects, submit another <code>ListIPSets</code> request, and in the
         *        next request use the <code>NextMarker</code> response value as the <code>NextMarker</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * An array of <a>IPSetSummary</a> objects.
         * </p>
         * 
         * @param ipSets
         *        An array of <a>IPSetSummary</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipSets(Collection<IPSetSummary> ipSets);

        /**
         * <p>
         * An array of <a>IPSetSummary</a> objects.
         * </p>
         * 
         * @param ipSets
         *        An array of <a>IPSetSummary</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipSets(IPSetSummary... ipSets);

        /**
         * <p>
         * An array of <a>IPSetSummary</a> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IPSetSummary>.Builder} avoiding the need to
         * create one manually via {@link List<IPSetSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IPSetSummary>.Builder#build()} is called immediately and its
         * result is passed to {@link #ipSets(List<IPSetSummary>)}.
         * 
         * @param ipSets
         *        a consumer that will call methods on {@link List<IPSetSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipSets(List<IPSetSummary>)
         */
        Builder ipSets(Consumer<IPSetSummary.Builder>... ipSets);
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private String nextMarker;

        private List<IPSetSummary> ipSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListIpSetsResponse model) {
            super(model);
            nextMarker(model.nextMarker);
            ipSets(model.ipSets);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<IPSetSummary.Builder> getIpSets() {
            if (ipSets instanceof SdkAutoConstructList) {
                return null;
            }
            return ipSets != null ? ipSets.stream().map(IPSetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipSets(Collection<IPSetSummary> ipSets) {
            this.ipSets = IPSetSummariesCopier.copy(ipSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipSets(IPSetSummary... ipSets) {
            ipSets(Arrays.asList(ipSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipSets(Consumer<IPSetSummary.Builder>... ipSets) {
            ipSets(Stream.of(ipSets).map(c -> IPSetSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpSets(Collection<IPSetSummary.BuilderImpl> ipSets) {
            this.ipSets = IPSetSummariesCopier.copyFromBuilder(ipSets);
        }

        @Override
        public ListIpSetsResponse build() {
            return new ListIpSetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
