/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is <b>AWS WAF Classic</b> documentation. For more information, see <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the
 * developer guide.
 * </p>
 * <p>
 * <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the
 * latest version, AWS WAF has a single set of endpoints for regional and global use.
 * </p>
 * </note>
 * <p>
 * Contains one or more countries that AWS WAF will search for.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeoMatchSet implements SdkPojo, Serializable, ToCopyableBuilder<GeoMatchSet.Builder, GeoMatchSet> {
    private static final SdkField<String> GEO_MATCH_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeoMatchSetId").getter(getter(GeoMatchSet::geoMatchSetId)).setter(setter(Builder::geoMatchSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoMatchSetId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GeoMatchSet::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<GeoMatchConstraint>> GEO_MATCH_CONSTRAINTS_FIELD = SdkField
            .<List<GeoMatchConstraint>> builder(MarshallingType.LIST)
            .memberName("GeoMatchConstraints")
            .getter(getter(GeoMatchSet::geoMatchConstraints))
            .setter(setter(Builder::geoMatchConstraints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoMatchConstraints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GeoMatchConstraint> builder(MarshallingType.SDK_POJO)
                                            .constructor(GeoMatchConstraint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GEO_MATCH_SET_ID_FIELD,
            NAME_FIELD, GEO_MATCH_CONSTRAINTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String geoMatchSetId;

    private final String name;

    private final List<GeoMatchConstraint> geoMatchConstraints;

    private GeoMatchSet(BuilderImpl builder) {
        this.geoMatchSetId = builder.geoMatchSetId;
        this.name = builder.name;
        this.geoMatchConstraints = builder.geoMatchConstraints;
    }

    /**
     * <p>
     * The <code>GeoMatchSetId</code> for an <code>GeoMatchSet</code>. You use <code>GeoMatchSetId</code> to get
     * information about a <code>GeoMatchSet</code> (see <a>GeoMatchSet</a>), update a <code>GeoMatchSet</code> (see
     * <a>UpdateGeoMatchSet</a>), insert a <code>GeoMatchSet</code> into a <code>Rule</code> or delete one from a
     * <code>Rule</code> (see <a>UpdateRule</a>), and delete a <code>GeoMatchSet</code> from AWS WAF (see
     * <a>DeleteGeoMatchSet</a>).
     * </p>
     * <p>
     * <code>GeoMatchSetId</code> is returned by <a>CreateGeoMatchSet</a> and by <a>ListGeoMatchSets</a>.
     * </p>
     * 
     * @return The <code>GeoMatchSetId</code> for an <code>GeoMatchSet</code>. You use <code>GeoMatchSetId</code> to get
     *         information about a <code>GeoMatchSet</code> (see <a>GeoMatchSet</a>), update a <code>GeoMatchSet</code>
     *         (see <a>UpdateGeoMatchSet</a>), insert a <code>GeoMatchSet</code> into a <code>Rule</code> or delete one
     *         from a <code>Rule</code> (see <a>UpdateRule</a>), and delete a <code>GeoMatchSet</code> from AWS WAF (see
     *         <a>DeleteGeoMatchSet</a>).</p>
     *         <p>
     *         <code>GeoMatchSetId</code> is returned by <a>CreateGeoMatchSet</a> and by <a>ListGeoMatchSets</a>.
     */
    public final String geoMatchSetId() {
        return geoMatchSetId;
    }

    /**
     * <p>
     * A friendly name or description of the <a>GeoMatchSet</a>. You can't change the name of an
     * <code>GeoMatchSet</code> after you create it.
     * </p>
     * 
     * @return A friendly name or description of the <a>GeoMatchSet</a>. You can't change the name of an
     *         <code>GeoMatchSet</code> after you create it.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns true if the GeoMatchConstraints property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasGeoMatchConstraints() {
        return geoMatchConstraints != null && !(geoMatchConstraints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <a>GeoMatchConstraint</a> objects, which contain the country that you want AWS WAF to search for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGeoMatchConstraints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <a>GeoMatchConstraint</a> objects, which contain the country that you want AWS WAF to search
     *         for.
     */
    public final List<GeoMatchConstraint> geoMatchConstraints() {
        return geoMatchConstraints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(geoMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasGeoMatchConstraints() ? geoMatchConstraints() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoMatchSet)) {
            return false;
        }
        GeoMatchSet other = (GeoMatchSet) obj;
        return Objects.equals(geoMatchSetId(), other.geoMatchSetId()) && Objects.equals(name(), other.name())
                && hasGeoMatchConstraints() == other.hasGeoMatchConstraints()
                && Objects.equals(geoMatchConstraints(), other.geoMatchConstraints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeoMatchSet").add("GeoMatchSetId", geoMatchSetId()).add("Name", name())
                .add("GeoMatchConstraints", hasGeoMatchConstraints() ? geoMatchConstraints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GeoMatchSetId":
            return Optional.ofNullable(clazz.cast(geoMatchSetId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "GeoMatchConstraints":
            return Optional.ofNullable(clazz.cast(geoMatchConstraints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeoMatchSet, T> g) {
        return obj -> g.apply((GeoMatchSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeoMatchSet> {
        /**
         * <p>
         * The <code>GeoMatchSetId</code> for an <code>GeoMatchSet</code>. You use <code>GeoMatchSetId</code> to get
         * information about a <code>GeoMatchSet</code> (see <a>GeoMatchSet</a>), update a <code>GeoMatchSet</code> (see
         * <a>UpdateGeoMatchSet</a>), insert a <code>GeoMatchSet</code> into a <code>Rule</code> or delete one from a
         * <code>Rule</code> (see <a>UpdateRule</a>), and delete a <code>GeoMatchSet</code> from AWS WAF (see
         * <a>DeleteGeoMatchSet</a>).
         * </p>
         * <p>
         * <code>GeoMatchSetId</code> is returned by <a>CreateGeoMatchSet</a> and by <a>ListGeoMatchSets</a>.
         * </p>
         * 
         * @param geoMatchSetId
         *        The <code>GeoMatchSetId</code> for an <code>GeoMatchSet</code>. You use <code>GeoMatchSetId</code> to
         *        get information about a <code>GeoMatchSet</code> (see <a>GeoMatchSet</a>), update a
         *        <code>GeoMatchSet</code> (see <a>UpdateGeoMatchSet</a>), insert a <code>GeoMatchSet</code> into a
         *        <code>Rule</code> or delete one from a <code>Rule</code> (see <a>UpdateRule</a>), and delete a
         *        <code>GeoMatchSet</code> from AWS WAF (see <a>DeleteGeoMatchSet</a>).</p>
         *        <p>
         *        <code>GeoMatchSetId</code> is returned by <a>CreateGeoMatchSet</a> and by <a>ListGeoMatchSets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geoMatchSetId(String geoMatchSetId);

        /**
         * <p>
         * A friendly name or description of the <a>GeoMatchSet</a>. You can't change the name of an
         * <code>GeoMatchSet</code> after you create it.
         * </p>
         * 
         * @param name
         *        A friendly name or description of the <a>GeoMatchSet</a>. You can't change the name of an
         *        <code>GeoMatchSet</code> after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An array of <a>GeoMatchConstraint</a> objects, which contain the country that you want AWS WAF to search for.
         * </p>
         * 
         * @param geoMatchConstraints
         *        An array of <a>GeoMatchConstraint</a> objects, which contain the country that you want AWS WAF to
         *        search for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geoMatchConstraints(Collection<GeoMatchConstraint> geoMatchConstraints);

        /**
         * <p>
         * An array of <a>GeoMatchConstraint</a> objects, which contain the country that you want AWS WAF to search for.
         * </p>
         * 
         * @param geoMatchConstraints
         *        An array of <a>GeoMatchConstraint</a> objects, which contain the country that you want AWS WAF to
         *        search for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geoMatchConstraints(GeoMatchConstraint... geoMatchConstraints);

        /**
         * <p>
         * An array of <a>GeoMatchConstraint</a> objects, which contain the country that you want AWS WAF to search for.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GeoMatchConstraint>.Builder} avoiding the
         * need to create one manually via {@link List<GeoMatchConstraint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GeoMatchConstraint>.Builder#build()} is called immediately
         * and its result is passed to {@link #geoMatchConstraints(List<GeoMatchConstraint>)}.
         * 
         * @param geoMatchConstraints
         *        a consumer that will call methods on {@link List<GeoMatchConstraint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geoMatchConstraints(List<GeoMatchConstraint>)
         */
        Builder geoMatchConstraints(Consumer<GeoMatchConstraint.Builder>... geoMatchConstraints);
    }

    static final class BuilderImpl implements Builder {
        private String geoMatchSetId;

        private String name;

        private List<GeoMatchConstraint> geoMatchConstraints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GeoMatchSet model) {
            geoMatchSetId(model.geoMatchSetId);
            name(model.name);
            geoMatchConstraints(model.geoMatchConstraints);
        }

        public final String getGeoMatchSetId() {
            return geoMatchSetId;
        }

        @Override
        public final Builder geoMatchSetId(String geoMatchSetId) {
            this.geoMatchSetId = geoMatchSetId;
            return this;
        }

        public final void setGeoMatchSetId(String geoMatchSetId) {
            this.geoMatchSetId = geoMatchSetId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<GeoMatchConstraint.Builder> getGeoMatchConstraints() {
            if (geoMatchConstraints instanceof SdkAutoConstructList) {
                return null;
            }
            return geoMatchConstraints != null ? geoMatchConstraints.stream().map(GeoMatchConstraint::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder geoMatchConstraints(Collection<GeoMatchConstraint> geoMatchConstraints) {
            this.geoMatchConstraints = GeoMatchConstraintsCopier.copy(geoMatchConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geoMatchConstraints(GeoMatchConstraint... geoMatchConstraints) {
            geoMatchConstraints(Arrays.asList(geoMatchConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geoMatchConstraints(Consumer<GeoMatchConstraint.Builder>... geoMatchConstraints) {
            geoMatchConstraints(Stream.of(geoMatchConstraints).map(c -> GeoMatchConstraint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setGeoMatchConstraints(Collection<GeoMatchConstraint.BuilderImpl> geoMatchConstraints) {
            this.geoMatchConstraints = GeoMatchConstraintsCopier.copyFromBuilder(geoMatchConstraints);
        }

        @Override
        public GeoMatchSet build() {
            return new GeoMatchSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
