/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response to a <code>CreateXssMatchSet</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateXssMatchSetResponse extends WafResponse implements
        ToCopyableBuilder<CreateXssMatchSetResponse.Builder, CreateXssMatchSetResponse> {
    private static final SdkField<XssMatchSet> XSS_MATCH_SET_FIELD = SdkField.<XssMatchSet> builder(MarshallingType.SDK_POJO)
            .memberName("XssMatchSet").getter(getter(CreateXssMatchSetResponse::xssMatchSet))
            .setter(setter(Builder::xssMatchSet)).constructor(XssMatchSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XssMatchSet").build()).build();

    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeToken").getter(getter(CreateXssMatchSetResponse::changeToken))
            .setter(setter(Builder::changeToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(XSS_MATCH_SET_FIELD,
            CHANGE_TOKEN_FIELD));

    private final XssMatchSet xssMatchSet;

    private final String changeToken;

    private CreateXssMatchSetResponse(BuilderImpl builder) {
        super(builder);
        this.xssMatchSet = builder.xssMatchSet;
        this.changeToken = builder.changeToken;
    }

    /**
     * <p>
     * An <a>XssMatchSet</a>.
     * </p>
     * 
     * @return An <a>XssMatchSet</a>.
     */
    public final XssMatchSet xssMatchSet() {
        return xssMatchSet;
    }

    /**
     * <p>
     * The <code>ChangeToken</code> that you used to submit the <code>CreateXssMatchSet</code> request. You can also use
     * this value to query the status of the request. For more information, see <a>GetChangeTokenStatus</a>.
     * </p>
     * 
     * @return The <code>ChangeToken</code> that you used to submit the <code>CreateXssMatchSet</code> request. You can
     *         also use this value to query the status of the request. For more information, see
     *         <a>GetChangeTokenStatus</a>.
     */
    public final String changeToken() {
        return changeToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(xssMatchSet());
        hashCode = 31 * hashCode + Objects.hashCode(changeToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateXssMatchSetResponse)) {
            return false;
        }
        CreateXssMatchSetResponse other = (CreateXssMatchSetResponse) obj;
        return Objects.equals(xssMatchSet(), other.xssMatchSet()) && Objects.equals(changeToken(), other.changeToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateXssMatchSetResponse").add("XssMatchSet", xssMatchSet()).add("ChangeToken", changeToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "XssMatchSet":
            return Optional.ofNullable(clazz.cast(xssMatchSet()));
        case "ChangeToken":
            return Optional.ofNullable(clazz.cast(changeToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateXssMatchSetResponse, T> g) {
        return obj -> g.apply((CreateXssMatchSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateXssMatchSetResponse> {
        /**
         * <p>
         * An <a>XssMatchSet</a>.
         * </p>
         * 
         * @param xssMatchSet
         *        An <a>XssMatchSet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xssMatchSet(XssMatchSet xssMatchSet);

        /**
         * <p>
         * An <a>XssMatchSet</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link XssMatchSet.Builder} avoiding the need to create
         * one manually via {@link XssMatchSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link XssMatchSet.Builder#build()} is called immediately and its result
         * is passed to {@link #xssMatchSet(XssMatchSet)}.
         * 
         * @param xssMatchSet
         *        a consumer that will call methods on {@link XssMatchSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #xssMatchSet(XssMatchSet)
         */
        default Builder xssMatchSet(Consumer<XssMatchSet.Builder> xssMatchSet) {
            return xssMatchSet(XssMatchSet.builder().applyMutation(xssMatchSet).build());
        }

        /**
         * <p>
         * The <code>ChangeToken</code> that you used to submit the <code>CreateXssMatchSet</code> request. You can also
         * use this value to query the status of the request. For more information, see <a>GetChangeTokenStatus</a>.
         * </p>
         * 
         * @param changeToken
         *        The <code>ChangeToken</code> that you used to submit the <code>CreateXssMatchSet</code> request. You
         *        can also use this value to query the status of the request. For more information, see
         *        <a>GetChangeTokenStatus</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeToken(String changeToken);
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private XssMatchSet xssMatchSet;

        private String changeToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateXssMatchSetResponse model) {
            super(model);
            xssMatchSet(model.xssMatchSet);
            changeToken(model.changeToken);
        }

        public final XssMatchSet.Builder getXssMatchSet() {
            return xssMatchSet != null ? xssMatchSet.toBuilder() : null;
        }

        @Override
        public final Builder xssMatchSet(XssMatchSet xssMatchSet) {
            this.xssMatchSet = xssMatchSet;
            return this;
        }

        public final void setXssMatchSet(XssMatchSet.BuilderImpl xssMatchSet) {
            this.xssMatchSet = xssMatchSet != null ? xssMatchSet.build() : null;
        }

        public final String getChangeToken() {
            return changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        @Override
        public CreateXssMatchSetResponse build() {
            return new CreateXssMatchSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
