/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSizeConstraintSetResponse extends WafResponse implements
        ToCopyableBuilder<CreateSizeConstraintSetResponse.Builder, CreateSizeConstraintSetResponse> {
    private static final SdkField<SizeConstraintSet> SIZE_CONSTRAINT_SET_FIELD = SdkField
            .<SizeConstraintSet> builder(MarshallingType.SDK_POJO).memberName("SizeConstraintSet")
            .getter(getter(CreateSizeConstraintSetResponse::sizeConstraintSet)).setter(setter(Builder::sizeConstraintSet))
            .constructor(SizeConstraintSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeConstraintSet").build()).build();

    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeToken").getter(getter(CreateSizeConstraintSetResponse::changeToken))
            .setter(setter(Builder::changeToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIZE_CONSTRAINT_SET_FIELD,
            CHANGE_TOKEN_FIELD));

    private final SizeConstraintSet sizeConstraintSet;

    private final String changeToken;

    private CreateSizeConstraintSetResponse(BuilderImpl builder) {
        super(builder);
        this.sizeConstraintSet = builder.sizeConstraintSet;
        this.changeToken = builder.changeToken;
    }

    /**
     * <p>
     * A <a>SizeConstraintSet</a> that contains no <code>SizeConstraint</code> objects.
     * </p>
     * 
     * @return A <a>SizeConstraintSet</a> that contains no <code>SizeConstraint</code> objects.
     */
    public final SizeConstraintSet sizeConstraintSet() {
        return sizeConstraintSet;
    }

    /**
     * <p>
     * The <code>ChangeToken</code> that you used to submit the <code>CreateSizeConstraintSet</code> request. You can
     * also use this value to query the status of the request. For more information, see <a>GetChangeTokenStatus</a>.
     * </p>
     * 
     * @return The <code>ChangeToken</code> that you used to submit the <code>CreateSizeConstraintSet</code> request.
     *         You can also use this value to query the status of the request. For more information, see
     *         <a>GetChangeTokenStatus</a>.
     */
    public final String changeToken() {
        return changeToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sizeConstraintSet());
        hashCode = 31 * hashCode + Objects.hashCode(changeToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSizeConstraintSetResponse)) {
            return false;
        }
        CreateSizeConstraintSetResponse other = (CreateSizeConstraintSetResponse) obj;
        return Objects.equals(sizeConstraintSet(), other.sizeConstraintSet())
                && Objects.equals(changeToken(), other.changeToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSizeConstraintSetResponse").add("SizeConstraintSet", sizeConstraintSet())
                .add("ChangeToken", changeToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SizeConstraintSet":
            return Optional.ofNullable(clazz.cast(sizeConstraintSet()));
        case "ChangeToken":
            return Optional.ofNullable(clazz.cast(changeToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSizeConstraintSetResponse, T> g) {
        return obj -> g.apply((CreateSizeConstraintSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateSizeConstraintSetResponse> {
        /**
         * <p>
         * A <a>SizeConstraintSet</a> that contains no <code>SizeConstraint</code> objects.
         * </p>
         * 
         * @param sizeConstraintSet
         *        A <a>SizeConstraintSet</a> that contains no <code>SizeConstraint</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeConstraintSet(SizeConstraintSet sizeConstraintSet);

        /**
         * <p>
         * A <a>SizeConstraintSet</a> that contains no <code>SizeConstraint</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link SizeConstraintSet.Builder} avoiding the need to
         * create one manually via {@link SizeConstraintSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link SizeConstraintSet.Builder#build()} is called immediately and its
         * result is passed to {@link #sizeConstraintSet(SizeConstraintSet)}.
         * 
         * @param sizeConstraintSet
         *        a consumer that will call methods on {@link SizeConstraintSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sizeConstraintSet(SizeConstraintSet)
         */
        default Builder sizeConstraintSet(Consumer<SizeConstraintSet.Builder> sizeConstraintSet) {
            return sizeConstraintSet(SizeConstraintSet.builder().applyMutation(sizeConstraintSet).build());
        }

        /**
         * <p>
         * The <code>ChangeToken</code> that you used to submit the <code>CreateSizeConstraintSet</code> request. You
         * can also use this value to query the status of the request. For more information, see
         * <a>GetChangeTokenStatus</a>.
         * </p>
         * 
         * @param changeToken
         *        The <code>ChangeToken</code> that you used to submit the <code>CreateSizeConstraintSet</code> request.
         *        You can also use this value to query the status of the request. For more information, see
         *        <a>GetChangeTokenStatus</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeToken(String changeToken);
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private SizeConstraintSet sizeConstraintSet;

        private String changeToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSizeConstraintSetResponse model) {
            super(model);
            sizeConstraintSet(model.sizeConstraintSet);
            changeToken(model.changeToken);
        }

        public final SizeConstraintSet.Builder getSizeConstraintSet() {
            return sizeConstraintSet != null ? sizeConstraintSet.toBuilder() : null;
        }

        @Override
        public final Builder sizeConstraintSet(SizeConstraintSet sizeConstraintSet) {
            this.sizeConstraintSet = sizeConstraintSet;
            return this;
        }

        public final void setSizeConstraintSet(SizeConstraintSet.BuilderImpl sizeConstraintSet) {
            this.sizeConstraintSet = sizeConstraintSet != null ? sizeConstraintSet.build() : null;
        }

        public final String getChangeToken() {
            return changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        @Override
        public CreateSizeConstraintSetResponse build() {
            return new CreateSizeConstraintSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
