/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum WafActionType {
    BLOCK("BLOCK"),
    ALLOW("ALLOW"),
    COUNT("COUNT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private WafActionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WafActionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(WafActionType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WafActionType> knownValues() {
        return Stream.of(WafActionType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

