/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is <b>AWS WAF Classic</b> documentation. For more information, see <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the
 * developer guide.
 * </p>
 * <p>
 * <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the
 * latest version, AWS WAF has a single set of endpoints for regional and global use.
 * </p>
 * </note>
 * <p>
 * A complex type that contains <code>XssMatchTuple</code> objects, which specify the parts of web requests that you
 * want AWS WAF to inspect for cross-site scripting attacks and, if you want AWS WAF to inspect a header, the name of
 * the header. If a <code>XssMatchSet</code> contains more than one <code>XssMatchTuple</code> object, a request needs
 * to include cross-site scripting attacks in only one of the specified parts of the request to be considered a match.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class XssMatchSet implements SdkPojo, Serializable, ToCopyableBuilder<XssMatchSet.Builder, XssMatchSet> {
    private static final SdkField<String> XSS_MATCH_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(XssMatchSet::xssMatchSetId)).setter(setter(Builder::xssMatchSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XssMatchSetId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(XssMatchSet::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<XssMatchTuple>> XSS_MATCH_TUPLES_FIELD = SdkField
            .<List<XssMatchTuple>> builder(MarshallingType.LIST)
            .getter(getter(XssMatchSet::xssMatchTuples))
            .setter(setter(Builder::xssMatchTuples))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XssMatchTuples").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<XssMatchTuple> builder(MarshallingType.SDK_POJO)
                                            .constructor(XssMatchTuple::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(XSS_MATCH_SET_ID_FIELD,
            NAME_FIELD, XSS_MATCH_TUPLES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String xssMatchSetId;

    private final String name;

    private final List<XssMatchTuple> xssMatchTuples;

    private XssMatchSet(BuilderImpl builder) {
        this.xssMatchSetId = builder.xssMatchSetId;
        this.name = builder.name;
        this.xssMatchTuples = builder.xssMatchTuples;
    }

    /**
     * <p>
     * A unique identifier for an <code>XssMatchSet</code>. You use <code>XssMatchSetId</code> to get information about
     * an <code>XssMatchSet</code> (see <a>GetXssMatchSet</a>), update an <code>XssMatchSet</code> (see
     * <a>UpdateXssMatchSet</a>), insert an <code>XssMatchSet</code> into a <code>Rule</code> or delete one from a
     * <code>Rule</code> (see <a>UpdateRule</a>), and delete an <code>XssMatchSet</code> from AWS WAF (see
     * <a>DeleteXssMatchSet</a>).
     * </p>
     * <p>
     * <code>XssMatchSetId</code> is returned by <a>CreateXssMatchSet</a> and by <a>ListXssMatchSets</a>.
     * </p>
     * 
     * @return A unique identifier for an <code>XssMatchSet</code>. You use <code>XssMatchSetId</code> to get
     *         information about an <code>XssMatchSet</code> (see <a>GetXssMatchSet</a>), update an
     *         <code>XssMatchSet</code> (see <a>UpdateXssMatchSet</a>), insert an <code>XssMatchSet</code> into a
     *         <code>Rule</code> or delete one from a <code>Rule</code> (see <a>UpdateRule</a>), and delete an
     *         <code>XssMatchSet</code> from AWS WAF (see <a>DeleteXssMatchSet</a>).</p>
     *         <p>
     *         <code>XssMatchSetId</code> is returned by <a>CreateXssMatchSet</a> and by <a>ListXssMatchSets</a>.
     */
    public String xssMatchSetId() {
        return xssMatchSetId;
    }

    /**
     * <p>
     * The name, if any, of the <code>XssMatchSet</code>.
     * </p>
     * 
     * @return The name, if any, of the <code>XssMatchSet</code>.
     */
    public String name() {
        return name;
    }

    /**
     * Returns true if the XssMatchTuples property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasXssMatchTuples() {
        return xssMatchTuples != null && !(xssMatchTuples instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the parts of web requests that you want to inspect for cross-site scripting attacks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasXssMatchTuples()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the parts of web requests that you want to inspect for cross-site scripting attacks.
     */
    public List<XssMatchTuple> xssMatchTuples() {
        return xssMatchTuples;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(xssMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(xssMatchTuples());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XssMatchSet)) {
            return false;
        }
        XssMatchSet other = (XssMatchSet) obj;
        return Objects.equals(xssMatchSetId(), other.xssMatchSetId()) && Objects.equals(name(), other.name())
                && Objects.equals(xssMatchTuples(), other.xssMatchTuples());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("XssMatchSet").add("XssMatchSetId", xssMatchSetId()).add("Name", name())
                .add("XssMatchTuples", xssMatchTuples()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "XssMatchSetId":
            return Optional.ofNullable(clazz.cast(xssMatchSetId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "XssMatchTuples":
            return Optional.ofNullable(clazz.cast(xssMatchTuples()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<XssMatchSet, T> g) {
        return obj -> g.apply((XssMatchSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, XssMatchSet> {
        /**
         * <p>
         * A unique identifier for an <code>XssMatchSet</code>. You use <code>XssMatchSetId</code> to get information
         * about an <code>XssMatchSet</code> (see <a>GetXssMatchSet</a>), update an <code>XssMatchSet</code> (see
         * <a>UpdateXssMatchSet</a>), insert an <code>XssMatchSet</code> into a <code>Rule</code> or delete one from a
         * <code>Rule</code> (see <a>UpdateRule</a>), and delete an <code>XssMatchSet</code> from AWS WAF (see
         * <a>DeleteXssMatchSet</a>).
         * </p>
         * <p>
         * <code>XssMatchSetId</code> is returned by <a>CreateXssMatchSet</a> and by <a>ListXssMatchSets</a>.
         * </p>
         * 
         * @param xssMatchSetId
         *        A unique identifier for an <code>XssMatchSet</code>. You use <code>XssMatchSetId</code> to get
         *        information about an <code>XssMatchSet</code> (see <a>GetXssMatchSet</a>), update an
         *        <code>XssMatchSet</code> (see <a>UpdateXssMatchSet</a>), insert an <code>XssMatchSet</code> into a
         *        <code>Rule</code> or delete one from a <code>Rule</code> (see <a>UpdateRule</a>), and delete an
         *        <code>XssMatchSet</code> from AWS WAF (see <a>DeleteXssMatchSet</a>).</p>
         *        <p>
         *        <code>XssMatchSetId</code> is returned by <a>CreateXssMatchSet</a> and by <a>ListXssMatchSets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xssMatchSetId(String xssMatchSetId);

        /**
         * <p>
         * The name, if any, of the <code>XssMatchSet</code>.
         * </p>
         * 
         * @param name
         *        The name, if any, of the <code>XssMatchSet</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the parts of web requests that you want to inspect for cross-site scripting attacks.
         * </p>
         * 
         * @param xssMatchTuples
         *        Specifies the parts of web requests that you want to inspect for cross-site scripting attacks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xssMatchTuples(Collection<XssMatchTuple> xssMatchTuples);

        /**
         * <p>
         * Specifies the parts of web requests that you want to inspect for cross-site scripting attacks.
         * </p>
         * 
         * @param xssMatchTuples
         *        Specifies the parts of web requests that you want to inspect for cross-site scripting attacks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xssMatchTuples(XssMatchTuple... xssMatchTuples);

        /**
         * <p>
         * Specifies the parts of web requests that you want to inspect for cross-site scripting attacks.
         * </p>
         * This is a convenience that creates an instance of the {@link List<XssMatchTuple>.Builder} avoiding the need
         * to create one manually via {@link List<XssMatchTuple>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<XssMatchTuple>.Builder#build()} is called immediately and
         * its result is passed to {@link #xssMatchTuples(List<XssMatchTuple>)}.
         * 
         * @param xssMatchTuples
         *        a consumer that will call methods on {@link List<XssMatchTuple>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #xssMatchTuples(List<XssMatchTuple>)
         */
        Builder xssMatchTuples(Consumer<XssMatchTuple.Builder>... xssMatchTuples);
    }

    static final class BuilderImpl implements Builder {
        private String xssMatchSetId;

        private String name;

        private List<XssMatchTuple> xssMatchTuples = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(XssMatchSet model) {
            xssMatchSetId(model.xssMatchSetId);
            name(model.name);
            xssMatchTuples(model.xssMatchTuples);
        }

        public final String getXssMatchSetId() {
            return xssMatchSetId;
        }

        @Override
        public final Builder xssMatchSetId(String xssMatchSetId) {
            this.xssMatchSetId = xssMatchSetId;
            return this;
        }

        public final void setXssMatchSetId(String xssMatchSetId) {
            this.xssMatchSetId = xssMatchSetId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<XssMatchTuple.Builder> getXssMatchTuples() {
            return xssMatchTuples != null ? xssMatchTuples.stream().map(XssMatchTuple::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder xssMatchTuples(Collection<XssMatchTuple> xssMatchTuples) {
            this.xssMatchTuples = XssMatchTuplesCopier.copy(xssMatchTuples);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder xssMatchTuples(XssMatchTuple... xssMatchTuples) {
            xssMatchTuples(Arrays.asList(xssMatchTuples));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder xssMatchTuples(Consumer<XssMatchTuple.Builder>... xssMatchTuples) {
            xssMatchTuples(Stream.of(xssMatchTuples).map(c -> XssMatchTuple.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setXssMatchTuples(Collection<XssMatchTuple.BuilderImpl> xssMatchTuples) {
            this.xssMatchTuples = XssMatchTuplesCopier.copyFromBuilder(xssMatchTuples);
        }

        @Override
        public XssMatchSet build() {
            return new XssMatchSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
