/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRegexMatchSetRequest extends WafRequest implements
        ToCopyableBuilder<UpdateRegexMatchSetRequest.Builder, UpdateRegexMatchSetRequest> {
    private static final SdkField<String> REGEX_MATCH_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateRegexMatchSetRequest::regexMatchSetId)).setter(setter(Builder::regexMatchSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexMatchSetId").build()).build();

    private static final SdkField<List<RegexMatchSetUpdate>> UPDATES_FIELD = SdkField
            .<List<RegexMatchSetUpdate>> builder(MarshallingType.LIST)
            .getter(getter(UpdateRegexMatchSetRequest::updates))
            .setter(setter(Builder::updates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Updates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RegexMatchSetUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegexMatchSetUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateRegexMatchSetRequest::changeToken)).setter(setter(Builder::changeToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGEX_MATCH_SET_ID_FIELD,
            UPDATES_FIELD, CHANGE_TOKEN_FIELD));

    private final String regexMatchSetId;

    private final List<RegexMatchSetUpdate> updates;

    private final String changeToken;

    private UpdateRegexMatchSetRequest(BuilderImpl builder) {
        super(builder);
        this.regexMatchSetId = builder.regexMatchSetId;
        this.updates = builder.updates;
        this.changeToken = builder.changeToken;
    }

    /**
     * <p>
     * The <code>RegexMatchSetId</code> of the <a>RegexMatchSet</a> that you want to update.
     * <code>RegexMatchSetId</code> is returned by <a>CreateRegexMatchSet</a> and by <a>ListRegexMatchSets</a>.
     * </p>
     * 
     * @return The <code>RegexMatchSetId</code> of the <a>RegexMatchSet</a> that you want to update.
     *         <code>RegexMatchSetId</code> is returned by <a>CreateRegexMatchSet</a> and by <a>ListRegexMatchSets</a>.
     */
    public String regexMatchSetId() {
        return regexMatchSetId;
    }

    /**
     * Returns true if the Updates property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUpdates() {
        return updates != null && !(updates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>RegexMatchSetUpdate</code> objects that you want to insert into or delete from a
     * <a>RegexMatchSet</a>. For more information, see <a>RegexMatchTuple</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUpdates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>RegexMatchSetUpdate</code> objects that you want to insert into or delete from a
     *         <a>RegexMatchSet</a>. For more information, see <a>RegexMatchTuple</a>.
     */
    public List<RegexMatchSetUpdate> updates() {
        return updates;
    }

    /**
     * <p>
     * The value returned by the most recent call to <a>GetChangeToken</a>.
     * </p>
     * 
     * @return The value returned by the most recent call to <a>GetChangeToken</a>.
     */
    public String changeToken() {
        return changeToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(regexMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(updates());
        hashCode = 31 * hashCode + Objects.hashCode(changeToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRegexMatchSetRequest)) {
            return false;
        }
        UpdateRegexMatchSetRequest other = (UpdateRegexMatchSetRequest) obj;
        return Objects.equals(regexMatchSetId(), other.regexMatchSetId()) && Objects.equals(updates(), other.updates())
                && Objects.equals(changeToken(), other.changeToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateRegexMatchSetRequest").add("RegexMatchSetId", regexMatchSetId()).add("Updates", updates())
                .add("ChangeToken", changeToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegexMatchSetId":
            return Optional.ofNullable(clazz.cast(regexMatchSetId()));
        case "Updates":
            return Optional.ofNullable(clazz.cast(updates()));
        case "ChangeToken":
            return Optional.ofNullable(clazz.cast(changeToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRegexMatchSetRequest, T> g) {
        return obj -> g.apply((UpdateRegexMatchSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRegexMatchSetRequest> {
        /**
         * <p>
         * The <code>RegexMatchSetId</code> of the <a>RegexMatchSet</a> that you want to update.
         * <code>RegexMatchSetId</code> is returned by <a>CreateRegexMatchSet</a> and by <a>ListRegexMatchSets</a>.
         * </p>
         * 
         * @param regexMatchSetId
         *        The <code>RegexMatchSetId</code> of the <a>RegexMatchSet</a> that you want to update.
         *        <code>RegexMatchSetId</code> is returned by <a>CreateRegexMatchSet</a> and by
         *        <a>ListRegexMatchSets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexMatchSetId(String regexMatchSetId);

        /**
         * <p>
         * An array of <code>RegexMatchSetUpdate</code> objects that you want to insert into or delete from a
         * <a>RegexMatchSet</a>. For more information, see <a>RegexMatchTuple</a>.
         * </p>
         * 
         * @param updates
         *        An array of <code>RegexMatchSetUpdate</code> objects that you want to insert into or delete from a
         *        <a>RegexMatchSet</a>. For more information, see <a>RegexMatchTuple</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updates(Collection<RegexMatchSetUpdate> updates);

        /**
         * <p>
         * An array of <code>RegexMatchSetUpdate</code> objects that you want to insert into or delete from a
         * <a>RegexMatchSet</a>. For more information, see <a>RegexMatchTuple</a>.
         * </p>
         * 
         * @param updates
         *        An array of <code>RegexMatchSetUpdate</code> objects that you want to insert into or delete from a
         *        <a>RegexMatchSet</a>. For more information, see <a>RegexMatchTuple</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updates(RegexMatchSetUpdate... updates);

        /**
         * <p>
         * An array of <code>RegexMatchSetUpdate</code> objects that you want to insert into or delete from a
         * <a>RegexMatchSet</a>. For more information, see <a>RegexMatchTuple</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RegexMatchSetUpdate>.Builder} avoiding the
         * need to create one manually via {@link List<RegexMatchSetUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RegexMatchSetUpdate>.Builder#build()} is called immediately
         * and its result is passed to {@link #updates(List<RegexMatchSetUpdate>)}.
         * 
         * @param updates
         *        a consumer that will call methods on {@link List<RegexMatchSetUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updates(List<RegexMatchSetUpdate>)
         */
        Builder updates(Consumer<RegexMatchSetUpdate.Builder>... updates);

        /**
         * <p>
         * The value returned by the most recent call to <a>GetChangeToken</a>.
         * </p>
         * 
         * @param changeToken
         *        The value returned by the most recent call to <a>GetChangeToken</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeToken(String changeToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WafRequest.BuilderImpl implements Builder {
        private String regexMatchSetId;

        private List<RegexMatchSetUpdate> updates = DefaultSdkAutoConstructList.getInstance();

        private String changeToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRegexMatchSetRequest model) {
            super(model);
            regexMatchSetId(model.regexMatchSetId);
            updates(model.updates);
            changeToken(model.changeToken);
        }

        public final String getRegexMatchSetId() {
            return regexMatchSetId;
        }

        @Override
        public final Builder regexMatchSetId(String regexMatchSetId) {
            this.regexMatchSetId = regexMatchSetId;
            return this;
        }

        public final void setRegexMatchSetId(String regexMatchSetId) {
            this.regexMatchSetId = regexMatchSetId;
        }

        public final Collection<RegexMatchSetUpdate.Builder> getUpdates() {
            return updates != null ? updates.stream().map(RegexMatchSetUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder updates(Collection<RegexMatchSetUpdate> updates) {
            this.updates = RegexMatchSetUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(RegexMatchSetUpdate... updates) {
            updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(Consumer<RegexMatchSetUpdate.Builder>... updates) {
            updates(Stream.of(updates).map(c -> RegexMatchSetUpdate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUpdates(Collection<RegexMatchSetUpdate.BuilderImpl> updates) {
            this.updates = RegexMatchSetUpdatesCopier.copyFromBuilder(updates);
        }

        public final String getChangeToken() {
            return changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRegexMatchSetRequest build() {
            return new UpdateRegexMatchSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
