/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIpSetRequest extends WafRequest implements
        ToCopyableBuilder<UpdateIpSetRequest.Builder, UpdateIpSetRequest> {
    private static final SdkField<String> IP_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateIpSetRequest::ipSetId)).setter(setter(Builder::ipSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPSetId").build()).build();

    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateIpSetRequest::changeToken)).setter(setter(Builder::changeToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()).build();

    private static final SdkField<List<IPSetUpdate>> UPDATES_FIELD = SdkField
            .<List<IPSetUpdate>> builder(MarshallingType.LIST)
            .getter(getter(UpdateIpSetRequest::updates))
            .setter(setter(Builder::updates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Updates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IPSetUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(IPSetUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_SET_ID_FIELD,
            CHANGE_TOKEN_FIELD, UPDATES_FIELD));

    private final String ipSetId;

    private final String changeToken;

    private final List<IPSetUpdate> updates;

    private UpdateIpSetRequest(BuilderImpl builder) {
        super(builder);
        this.ipSetId = builder.ipSetId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
    }

    /**
     * <p>
     * The <code>IPSetId</code> of the <a>IPSet</a> that you want to update. <code>IPSetId</code> is returned by
     * <a>CreateIPSet</a> and by <a>ListIPSets</a>.
     * </p>
     * 
     * @return The <code>IPSetId</code> of the <a>IPSet</a> that you want to update. <code>IPSetId</code> is returned by
     *         <a>CreateIPSet</a> and by <a>ListIPSets</a>.
     */
    public String ipSetId() {
        return ipSetId;
    }

    /**
     * <p>
     * The value returned by the most recent call to <a>GetChangeToken</a>.
     * </p>
     * 
     * @return The value returned by the most recent call to <a>GetChangeToken</a>.
     */
    public String changeToken() {
        return changeToken;
    }

    /**
     * Returns true if the Updates property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUpdates() {
        return updates != null && !(updates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>IPSetUpdate</code> objects that you want to insert into or delete from an <a>IPSet</a>. For
     * more information, see the applicable data types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>IPSetUpdate</a>: Contains <code>Action</code> and <code>IPSetDescriptor</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>IPSetDescriptor</a>: Contains <code>Type</code> and <code>Value</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can insert a maximum of 1000 addresses in a single request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUpdates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>IPSetUpdate</code> objects that you want to insert into or delete from an <a>IPSet</a>.
     *         For more information, see the applicable data types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a>IPSetUpdate</a>: Contains <code>Action</code> and <code>IPSetDescriptor</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>IPSetDescriptor</a>: Contains <code>Type</code> and <code>Value</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can insert a maximum of 1000 addresses in a single request.
     */
    public List<IPSetUpdate> updates() {
        return updates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ipSetId());
        hashCode = 31 * hashCode + Objects.hashCode(changeToken());
        hashCode = 31 * hashCode + Objects.hashCode(updates());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIpSetRequest)) {
            return false;
        }
        UpdateIpSetRequest other = (UpdateIpSetRequest) obj;
        return Objects.equals(ipSetId(), other.ipSetId()) && Objects.equals(changeToken(), other.changeToken())
                && Objects.equals(updates(), other.updates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateIpSetRequest").add("IPSetId", ipSetId()).add("ChangeToken", changeToken())
                .add("Updates", updates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IPSetId":
            return Optional.ofNullable(clazz.cast(ipSetId()));
        case "ChangeToken":
            return Optional.ofNullable(clazz.cast(changeToken()));
        case "Updates":
            return Optional.ofNullable(clazz.cast(updates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIpSetRequest, T> g) {
        return obj -> g.apply((UpdateIpSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateIpSetRequest> {
        /**
         * <p>
         * The <code>IPSetId</code> of the <a>IPSet</a> that you want to update. <code>IPSetId</code> is returned by
         * <a>CreateIPSet</a> and by <a>ListIPSets</a>.
         * </p>
         * 
         * @param ipSetId
         *        The <code>IPSetId</code> of the <a>IPSet</a> that you want to update. <code>IPSetId</code> is returned
         *        by <a>CreateIPSet</a> and by <a>ListIPSets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipSetId(String ipSetId);

        /**
         * <p>
         * The value returned by the most recent call to <a>GetChangeToken</a>.
         * </p>
         * 
         * @param changeToken
         *        The value returned by the most recent call to <a>GetChangeToken</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeToken(String changeToken);

        /**
         * <p>
         * An array of <code>IPSetUpdate</code> objects that you want to insert into or delete from an <a>IPSet</a>. For
         * more information, see the applicable data types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>IPSetUpdate</a>: Contains <code>Action</code> and <code>IPSetDescriptor</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>IPSetDescriptor</a>: Contains <code>Type</code> and <code>Value</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can insert a maximum of 1000 addresses in a single request.
         * </p>
         * 
         * @param updates
         *        An array of <code>IPSetUpdate</code> objects that you want to insert into or delete from an
         *        <a>IPSet</a>. For more information, see the applicable data types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a>IPSetUpdate</a>: Contains <code>Action</code> and <code>IPSetDescriptor</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>IPSetDescriptor</a>: Contains <code>Type</code> and <code>Value</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can insert a maximum of 1000 addresses in a single request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updates(Collection<IPSetUpdate> updates);

        /**
         * <p>
         * An array of <code>IPSetUpdate</code> objects that you want to insert into or delete from an <a>IPSet</a>. For
         * more information, see the applicable data types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>IPSetUpdate</a>: Contains <code>Action</code> and <code>IPSetDescriptor</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>IPSetDescriptor</a>: Contains <code>Type</code> and <code>Value</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can insert a maximum of 1000 addresses in a single request.
         * </p>
         * 
         * @param updates
         *        An array of <code>IPSetUpdate</code> objects that you want to insert into or delete from an
         *        <a>IPSet</a>. For more information, see the applicable data types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a>IPSetUpdate</a>: Contains <code>Action</code> and <code>IPSetDescriptor</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>IPSetDescriptor</a>: Contains <code>Type</code> and <code>Value</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can insert a maximum of 1000 addresses in a single request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updates(IPSetUpdate... updates);

        /**
         * <p>
         * An array of <code>IPSetUpdate</code> objects that you want to insert into or delete from an <a>IPSet</a>. For
         * more information, see the applicable data types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>IPSetUpdate</a>: Contains <code>Action</code> and <code>IPSetDescriptor</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>IPSetDescriptor</a>: Contains <code>Type</code> and <code>Value</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can insert a maximum of 1000 addresses in a single request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IPSetUpdate>.Builder} avoiding the need to
         * create one manually via {@link List<IPSetUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IPSetUpdate>.Builder#build()} is called immediately and its
         * result is passed to {@link #updates(List<IPSetUpdate>)}.
         * 
         * @param updates
         *        a consumer that will call methods on {@link List<IPSetUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updates(List<IPSetUpdate>)
         */
        Builder updates(Consumer<IPSetUpdate.Builder>... updates);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WafRequest.BuilderImpl implements Builder {
        private String ipSetId;

        private String changeToken;

        private List<IPSetUpdate> updates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIpSetRequest model) {
            super(model);
            ipSetId(model.ipSetId);
            changeToken(model.changeToken);
            updates(model.updates);
        }

        public final String getIpSetId() {
            return ipSetId;
        }

        @Override
        public final Builder ipSetId(String ipSetId) {
            this.ipSetId = ipSetId;
            return this;
        }

        public final void setIpSetId(String ipSetId) {
            this.ipSetId = ipSetId;
        }

        public final String getChangeToken() {
            return changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public final Collection<IPSetUpdate.Builder> getUpdates() {
            return updates != null ? updates.stream().map(IPSetUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder updates(Collection<IPSetUpdate> updates) {
            this.updates = IPSetUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(IPSetUpdate... updates) {
            updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(Consumer<IPSetUpdate.Builder>... updates) {
            updates(Stream.of(updates).map(c -> IPSetUpdate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUpdates(Collection<IPSetUpdate.BuilderImpl> updates) {
            this.updates = IPSetUpdatesCopier.copyFromBuilder(updates);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIpSetRequest build() {
            return new UpdateIpSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
