/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is <b>AWS WAF Classic</b> documentation. For more information, see <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the
 * developer guide.
 * </p>
 * <p>
 * <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the
 * latest version, AWS WAF has a single set of endpoints for regional and global use.
 * </p>
 * </note>
 * <p>
 * A complex type that contains <code>SqlInjectionMatchTuple</code> objects, which specify the parts of web requests
 * that you want AWS WAF to inspect for snippets of malicious SQL code and, if you want AWS WAF to inspect a header, the
 * name of the header. If a <code>SqlInjectionMatchSet</code> contains more than one <code>SqlInjectionMatchTuple</code>
 * object, a request needs to include snippets of SQL code in only one of the specified parts of the request to be
 * considered a match.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SqlInjectionMatchSet implements SdkPojo, Serializable,
        ToCopyableBuilder<SqlInjectionMatchSet.Builder, SqlInjectionMatchSet> {
    private static final SdkField<String> SQL_INJECTION_MATCH_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SqlInjectionMatchSet::sqlInjectionMatchSetId)).setter(setter(Builder::sqlInjectionMatchSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlInjectionMatchSetId").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SqlInjectionMatchSet::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<SqlInjectionMatchTuple>> SQL_INJECTION_MATCH_TUPLES_FIELD = SdkField
            .<List<SqlInjectionMatchTuple>> builder(MarshallingType.LIST)
            .getter(getter(SqlInjectionMatchSet::sqlInjectionMatchTuples))
            .setter(setter(Builder::sqlInjectionMatchTuples))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlInjectionMatchTuples").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SqlInjectionMatchTuple> builder(MarshallingType.SDK_POJO)
                                            .constructor(SqlInjectionMatchTuple::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SQL_INJECTION_MATCH_SET_ID_FIELD, NAME_FIELD, SQL_INJECTION_MATCH_TUPLES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sqlInjectionMatchSetId;

    private final String name;

    private final List<SqlInjectionMatchTuple> sqlInjectionMatchTuples;

    private SqlInjectionMatchSet(BuilderImpl builder) {
        this.sqlInjectionMatchSetId = builder.sqlInjectionMatchSetId;
        this.name = builder.name;
        this.sqlInjectionMatchTuples = builder.sqlInjectionMatchTuples;
    }

    /**
     * <p>
     * A unique identifier for a <code>SqlInjectionMatchSet</code>. You use <code>SqlInjectionMatchSetId</code> to get
     * information about a <code>SqlInjectionMatchSet</code> (see <a>GetSqlInjectionMatchSet</a>), update a
     * <code>SqlInjectionMatchSet</code> (see <a>UpdateSqlInjectionMatchSet</a>), insert a
     * <code>SqlInjectionMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see
     * <a>UpdateRule</a>), and delete a <code>SqlInjectionMatchSet</code> from AWS WAF (see
     * <a>DeleteSqlInjectionMatchSet</a>).
     * </p>
     * <p>
     * <code>SqlInjectionMatchSetId</code> is returned by <a>CreateSqlInjectionMatchSet</a> and by
     * <a>ListSqlInjectionMatchSets</a>.
     * </p>
     * 
     * @return A unique identifier for a <code>SqlInjectionMatchSet</code>. You use <code>SqlInjectionMatchSetId</code>
     *         to get information about a <code>SqlInjectionMatchSet</code> (see <a>GetSqlInjectionMatchSet</a>), update
     *         a <code>SqlInjectionMatchSet</code> (see <a>UpdateSqlInjectionMatchSet</a>), insert a
     *         <code>SqlInjectionMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see
     *         <a>UpdateRule</a>), and delete a <code>SqlInjectionMatchSet</code> from AWS WAF (see
     *         <a>DeleteSqlInjectionMatchSet</a>).</p>
     *         <p>
     *         <code>SqlInjectionMatchSetId</code> is returned by <a>CreateSqlInjectionMatchSet</a> and by
     *         <a>ListSqlInjectionMatchSets</a>.
     */
    public String sqlInjectionMatchSetId() {
        return sqlInjectionMatchSetId;
    }

    /**
     * <p>
     * The name, if any, of the <code>SqlInjectionMatchSet</code>.
     * </p>
     * 
     * @return The name, if any, of the <code>SqlInjectionMatchSet</code>.
     */
    public String name() {
        return name;
    }

    /**
     * Returns true if the SqlInjectionMatchTuples property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSqlInjectionMatchTuples() {
        return sqlInjectionMatchTuples != null && !(sqlInjectionMatchTuples instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the parts of web requests that you want to inspect for snippets of malicious SQL code.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSqlInjectionMatchTuples()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the parts of web requests that you want to inspect for snippets of malicious SQL code.
     */
    public List<SqlInjectionMatchTuple> sqlInjectionMatchTuples() {
        return sqlInjectionMatchTuples;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sqlInjectionMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sqlInjectionMatchTuples());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqlInjectionMatchSet)) {
            return false;
        }
        SqlInjectionMatchSet other = (SqlInjectionMatchSet) obj;
        return Objects.equals(sqlInjectionMatchSetId(), other.sqlInjectionMatchSetId()) && Objects.equals(name(), other.name())
                && Objects.equals(sqlInjectionMatchTuples(), other.sqlInjectionMatchTuples());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SqlInjectionMatchSet").add("SqlInjectionMatchSetId", sqlInjectionMatchSetId())
                .add("Name", name()).add("SqlInjectionMatchTuples", sqlInjectionMatchTuples()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SqlInjectionMatchSetId":
            return Optional.ofNullable(clazz.cast(sqlInjectionMatchSetId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SqlInjectionMatchTuples":
            return Optional.ofNullable(clazz.cast(sqlInjectionMatchTuples()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SqlInjectionMatchSet, T> g) {
        return obj -> g.apply((SqlInjectionMatchSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SqlInjectionMatchSet> {
        /**
         * <p>
         * A unique identifier for a <code>SqlInjectionMatchSet</code>. You use <code>SqlInjectionMatchSetId</code> to
         * get information about a <code>SqlInjectionMatchSet</code> (see <a>GetSqlInjectionMatchSet</a>), update a
         * <code>SqlInjectionMatchSet</code> (see <a>UpdateSqlInjectionMatchSet</a>), insert a
         * <code>SqlInjectionMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see
         * <a>UpdateRule</a>), and delete a <code>SqlInjectionMatchSet</code> from AWS WAF (see
         * <a>DeleteSqlInjectionMatchSet</a>).
         * </p>
         * <p>
         * <code>SqlInjectionMatchSetId</code> is returned by <a>CreateSqlInjectionMatchSet</a> and by
         * <a>ListSqlInjectionMatchSets</a>.
         * </p>
         * 
         * @param sqlInjectionMatchSetId
         *        A unique identifier for a <code>SqlInjectionMatchSet</code>. You use
         *        <code>SqlInjectionMatchSetId</code> to get information about a <code>SqlInjectionMatchSet</code> (see
         *        <a>GetSqlInjectionMatchSet</a>), update a <code>SqlInjectionMatchSet</code> (see
         *        <a>UpdateSqlInjectionMatchSet</a>), insert a <code>SqlInjectionMatchSet</code> into a
         *        <code>Rule</code> or delete one from a <code>Rule</code> (see <a>UpdateRule</a>), and delete a
         *        <code>SqlInjectionMatchSet</code> from AWS WAF (see <a>DeleteSqlInjectionMatchSet</a>).</p>
         *        <p>
         *        <code>SqlInjectionMatchSetId</code> is returned by <a>CreateSqlInjectionMatchSet</a> and by
         *        <a>ListSqlInjectionMatchSets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlInjectionMatchSetId(String sqlInjectionMatchSetId);

        /**
         * <p>
         * The name, if any, of the <code>SqlInjectionMatchSet</code>.
         * </p>
         * 
         * @param name
         *        The name, if any, of the <code>SqlInjectionMatchSet</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the parts of web requests that you want to inspect for snippets of malicious SQL code.
         * </p>
         * 
         * @param sqlInjectionMatchTuples
         *        Specifies the parts of web requests that you want to inspect for snippets of malicious SQL code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlInjectionMatchTuples(Collection<SqlInjectionMatchTuple> sqlInjectionMatchTuples);

        /**
         * <p>
         * Specifies the parts of web requests that you want to inspect for snippets of malicious SQL code.
         * </p>
         * 
         * @param sqlInjectionMatchTuples
         *        Specifies the parts of web requests that you want to inspect for snippets of malicious SQL code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlInjectionMatchTuples(SqlInjectionMatchTuple... sqlInjectionMatchTuples);

        /**
         * <p>
         * Specifies the parts of web requests that you want to inspect for snippets of malicious SQL code.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SqlInjectionMatchTuple>.Builder} avoiding
         * the need to create one manually via {@link List<SqlInjectionMatchTuple>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SqlInjectionMatchTuple>.Builder#build()} is called
         * immediately and its result is passed to {@link #sqlInjectionMatchTuples(List<SqlInjectionMatchTuple>)}.
         * 
         * @param sqlInjectionMatchTuples
         *        a consumer that will call methods on {@link List<SqlInjectionMatchTuple>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqlInjectionMatchTuples(List<SqlInjectionMatchTuple>)
         */
        Builder sqlInjectionMatchTuples(Consumer<SqlInjectionMatchTuple.Builder>... sqlInjectionMatchTuples);
    }

    static final class BuilderImpl implements Builder {
        private String sqlInjectionMatchSetId;

        private String name;

        private List<SqlInjectionMatchTuple> sqlInjectionMatchTuples = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SqlInjectionMatchSet model) {
            sqlInjectionMatchSetId(model.sqlInjectionMatchSetId);
            name(model.name);
            sqlInjectionMatchTuples(model.sqlInjectionMatchTuples);
        }

        public final String getSqlInjectionMatchSetId() {
            return sqlInjectionMatchSetId;
        }

        @Override
        public final Builder sqlInjectionMatchSetId(String sqlInjectionMatchSetId) {
            this.sqlInjectionMatchSetId = sqlInjectionMatchSetId;
            return this;
        }

        public final void setSqlInjectionMatchSetId(String sqlInjectionMatchSetId) {
            this.sqlInjectionMatchSetId = sqlInjectionMatchSetId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<SqlInjectionMatchTuple.Builder> getSqlInjectionMatchTuples() {
            return sqlInjectionMatchTuples != null ? sqlInjectionMatchTuples.stream().map(SqlInjectionMatchTuple::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sqlInjectionMatchTuples(Collection<SqlInjectionMatchTuple> sqlInjectionMatchTuples) {
            this.sqlInjectionMatchTuples = SqlInjectionMatchTuplesCopier.copy(sqlInjectionMatchTuples);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqlInjectionMatchTuples(SqlInjectionMatchTuple... sqlInjectionMatchTuples) {
            sqlInjectionMatchTuples(Arrays.asList(sqlInjectionMatchTuples));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqlInjectionMatchTuples(Consumer<SqlInjectionMatchTuple.Builder>... sqlInjectionMatchTuples) {
            sqlInjectionMatchTuples(Stream.of(sqlInjectionMatchTuples)
                    .map(c -> SqlInjectionMatchTuple.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSqlInjectionMatchTuples(Collection<SqlInjectionMatchTuple.BuilderImpl> sqlInjectionMatchTuples) {
            this.sqlInjectionMatchTuples = SqlInjectionMatchTuplesCopier.copyFromBuilder(sqlInjectionMatchTuples);
        }

        @Override
        public SqlInjectionMatchSet build() {
            return new SqlInjectionMatchSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
