/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is <b>AWS WAF Classic</b> documentation. For more information, see <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the
 * developer guide.
 * </p>
 * <p>
 * <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the
 * latest version, AWS WAF has a single set of endpoints for regional and global use.
 * </p>
 * </note>
 * <p>
 * In an <a>UpdateRegexPatternSet</a> request, <code>RegexPatternSetUpdate</code> specifies whether to insert or delete
 * a <code>RegexPatternString</code> and includes the settings for the <code>RegexPatternString</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegexPatternSetUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<RegexPatternSetUpdate.Builder, RegexPatternSetUpdate> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegexPatternSetUpdate::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> REGEX_PATTERN_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegexPatternSetUpdate::regexPatternString)).setter(setter(Builder::regexPatternString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexPatternString").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            REGEX_PATTERN_STRING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private final String regexPatternString;

    private RegexPatternSetUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.regexPatternString = builder.regexPatternString;
    }

    /**
     * <p>
     * Specifies whether to insert or delete a <code>RegexPatternString</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies whether to insert or delete a <code>RegexPatternString</code>.
     * @see ChangeAction
     */
    public ChangeAction action() {
        return ChangeAction.fromValue(action);
    }

    /**
     * <p>
     * Specifies whether to insert or delete a <code>RegexPatternString</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies whether to insert or delete a <code>RegexPatternString</code>.
     * @see ChangeAction
     */
    public String actionAsString() {
        return action;
    }

    /**
     * <p>
     * Specifies the regular expression (regex) pattern that you want AWS WAF to search for, such as
     * <code>B[a@]dB[o0]t</code>.
     * </p>
     * 
     * @return Specifies the regular expression (regex) pattern that you want AWS WAF to search for, such as
     *         <code>B[a@]dB[o0]t</code>.
     */
    public String regexPatternString() {
        return regexPatternString;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(regexPatternString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegexPatternSetUpdate)) {
            return false;
        }
        RegexPatternSetUpdate other = (RegexPatternSetUpdate) obj;
        return Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(regexPatternString(), other.regexPatternString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RegexPatternSetUpdate").add("Action", actionAsString())
                .add("RegexPatternString", regexPatternString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "RegexPatternString":
            return Optional.ofNullable(clazz.cast(regexPatternString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegexPatternSetUpdate, T> g) {
        return obj -> g.apply((RegexPatternSetUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegexPatternSetUpdate> {
        /**
         * <p>
         * Specifies whether to insert or delete a <code>RegexPatternString</code>.
         * </p>
         * 
         * @param action
         *        Specifies whether to insert or delete a <code>RegexPatternString</code>.
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(String action);

        /**
         * <p>
         * Specifies whether to insert or delete a <code>RegexPatternString</code>.
         * </p>
         * 
         * @param action
         *        Specifies whether to insert or delete a <code>RegexPatternString</code>.
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(ChangeAction action);

        /**
         * <p>
         * Specifies the regular expression (regex) pattern that you want AWS WAF to search for, such as
         * <code>B[a@]dB[o0]t</code>.
         * </p>
         * 
         * @param regexPatternString
         *        Specifies the regular expression (regex) pattern that you want AWS WAF to search for, such as
         *        <code>B[a@]dB[o0]t</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexPatternString(String regexPatternString);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private String regexPatternString;

        private BuilderImpl() {
        }

        private BuilderImpl(RegexPatternSetUpdate model) {
            action(model.action);
            regexPatternString(model.regexPatternString);
        }

        public final String getAction() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getRegexPatternString() {
            return regexPatternString;
        }

        @Override
        public final Builder regexPatternString(String regexPatternString) {
            this.regexPatternString = regexPatternString;
            return this;
        }

        public final void setRegexPatternString(String regexPatternString) {
            this.regexPatternString = regexPatternString;
        }

        @Override
        public RegexPatternSetUpdate build() {
            return new RegexPatternSetUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
