/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRegexPatternSetsResponse extends WafResponse implements
        ToCopyableBuilder<ListRegexPatternSetsResponse.Builder, ListRegexPatternSetsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListRegexPatternSetsResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final SdkField<List<RegexPatternSetSummary>> REGEX_PATTERN_SETS_FIELD = SdkField
            .<List<RegexPatternSetSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListRegexPatternSetsResponse::regexPatternSets))
            .setter(setter(Builder::regexPatternSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexPatternSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RegexPatternSetSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegexPatternSetSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD,
            REGEX_PATTERN_SETS_FIELD));

    private final String nextMarker;

    private final List<RegexPatternSetSummary> regexPatternSets;

    private ListRegexPatternSetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.regexPatternSets = builder.regexPatternSets;
    }

    /**
     * <p>
     * If you have more <code>RegexPatternSet</code> objects than the number that you specified for <code>Limit</code>
     * in the request, the response includes a <code>NextMarker</code> value. To list more <code>RegexPatternSet</code>
     * objects, submit another <code>ListRegexPatternSets</code> request, and specify the <code>NextMarker</code> value
     * from the response in the <code>NextMarker</code> value in the next request.
     * </p>
     * 
     * @return If you have more <code>RegexPatternSet</code> objects than the number that you specified for
     *         <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more
     *         <code>RegexPatternSet</code> objects, submit another <code>ListRegexPatternSets</code> request, and
     *         specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the
     *         next request.
     */
    public String nextMarker() {
        return nextMarker;
    }

    /**
     * Returns true if the RegexPatternSets property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRegexPatternSets() {
        return regexPatternSets != null && !(regexPatternSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <a>RegexPatternSetSummary</a> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRegexPatternSets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <a>RegexPatternSetSummary</a> objects.
     */
    public List<RegexPatternSetSummary> regexPatternSets() {
        return regexPatternSets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(regexPatternSets());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRegexPatternSetsResponse)) {
            return false;
        }
        ListRegexPatternSetsResponse other = (ListRegexPatternSetsResponse) obj;
        return Objects.equals(nextMarker(), other.nextMarker()) && Objects.equals(regexPatternSets(), other.regexPatternSets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListRegexPatternSetsResponse").add("NextMarker", nextMarker())
                .add("RegexPatternSets", regexPatternSets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "RegexPatternSets":
            return Optional.ofNullable(clazz.cast(regexPatternSets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRegexPatternSetsResponse, T> g) {
        return obj -> g.apply((ListRegexPatternSetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRegexPatternSetsResponse> {
        /**
         * <p>
         * If you have more <code>RegexPatternSet</code> objects than the number that you specified for
         * <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more
         * <code>RegexPatternSet</code> objects, submit another <code>ListRegexPatternSets</code> request, and specify
         * the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.
         * </p>
         * 
         * @param nextMarker
         *        If you have more <code>RegexPatternSet</code> objects than the number that you specified for
         *        <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more
         *        <code>RegexPatternSet</code> objects, submit another <code>ListRegexPatternSets</code> request, and
         *        specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in
         *        the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * An array of <a>RegexPatternSetSummary</a> objects.
         * </p>
         * 
         * @param regexPatternSets
         *        An array of <a>RegexPatternSetSummary</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexPatternSets(Collection<RegexPatternSetSummary> regexPatternSets);

        /**
         * <p>
         * An array of <a>RegexPatternSetSummary</a> objects.
         * </p>
         * 
         * @param regexPatternSets
         *        An array of <a>RegexPatternSetSummary</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexPatternSets(RegexPatternSetSummary... regexPatternSets);

        /**
         * <p>
         * An array of <a>RegexPatternSetSummary</a> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RegexPatternSetSummary>.Builder} avoiding
         * the need to create one manually via {@link List<RegexPatternSetSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RegexPatternSetSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #regexPatternSets(List<RegexPatternSetSummary>)}.
         * 
         * @param regexPatternSets
         *        a consumer that will call methods on {@link List<RegexPatternSetSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regexPatternSets(List<RegexPatternSetSummary>)
         */
        Builder regexPatternSets(Consumer<RegexPatternSetSummary.Builder>... regexPatternSets);
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private String nextMarker;

        private List<RegexPatternSetSummary> regexPatternSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRegexPatternSetsResponse model) {
            super(model);
            nextMarker(model.nextMarker);
            regexPatternSets(model.regexPatternSets);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<RegexPatternSetSummary.Builder> getRegexPatternSets() {
            return regexPatternSets != null ? regexPatternSets.stream().map(RegexPatternSetSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder regexPatternSets(Collection<RegexPatternSetSummary> regexPatternSets) {
            this.regexPatternSets = RegexPatternSetSummariesCopier.copy(regexPatternSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexPatternSets(RegexPatternSetSummary... regexPatternSets) {
            regexPatternSets(Arrays.asList(regexPatternSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexPatternSets(Consumer<RegexPatternSetSummary.Builder>... regexPatternSets) {
            regexPatternSets(Stream.of(regexPatternSets).map(c -> RegexPatternSetSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRegexPatternSets(Collection<RegexPatternSetSummary.BuilderImpl> regexPatternSets) {
            this.regexPatternSets = RegexPatternSetSummariesCopier.copyFromBuilder(regexPatternSets);
        }

        @Override
        public ListRegexPatternSetsResponse build() {
            return new ListRegexPatternSetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
