/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRuleResponse extends WafResponse implements ToCopyableBuilder<GetRuleResponse.Builder, GetRuleResponse> {
    private static final SdkField<Rule> RULE_FIELD = SdkField.<Rule> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetRuleResponse::rule)).setter(setter(Builder::rule)).constructor(Rule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_FIELD));

    private final Rule rule;

    private GetRuleResponse(BuilderImpl builder) {
        super(builder);
        this.rule = builder.rule;
    }

    /**
     * <p>
     * Information about the <a>Rule</a> that you specified in the <code>GetRule</code> request. For more information,
     * see the following topics:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>Rule</a>: Contains <code>MetricName</code>, <code>Name</code>, an array of <code>Predicate</code> objects, and
     * <code>RuleId</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>Predicate</a>: Each <code>Predicate</code> object contains <code>DataId</code>, <code>Negated</code>, and
     * <code>Type</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return Information about the <a>Rule</a> that you specified in the <code>GetRule</code> request. For more
     *         information, see the following topics:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a>Rule</a>: Contains <code>MetricName</code>, <code>Name</code>, an array of <code>Predicate</code>
     *         objects, and <code>RuleId</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>Predicate</a>: Each <code>Predicate</code> object contains <code>DataId</code>, <code>Negated</code>,
     *         and <code>Type</code>
     *         </p>
     *         </li>
     */
    public Rule rule() {
        return rule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(rule());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRuleResponse)) {
            return false;
        }
        GetRuleResponse other = (GetRuleResponse) obj;
        return Objects.equals(rule(), other.rule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetRuleResponse").add("Rule", rule()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Rule":
            return Optional.ofNullable(clazz.cast(rule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRuleResponse, T> g) {
        return obj -> g.apply((GetRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRuleResponse> {
        /**
         * <p>
         * Information about the <a>Rule</a> that you specified in the <code>GetRule</code> request. For more
         * information, see the following topics:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>Rule</a>: Contains <code>MetricName</code>, <code>Name</code>, an array of <code>Predicate</code> objects,
         * and <code>RuleId</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>Predicate</a>: Each <code>Predicate</code> object contains <code>DataId</code>, <code>Negated</code>, and
         * <code>Type</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param rule
         *        Information about the <a>Rule</a> that you specified in the <code>GetRule</code> request. For more
         *        information, see the following topics:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a>Rule</a>: Contains <code>MetricName</code>, <code>Name</code>, an array of <code>Predicate</code>
         *        objects, and <code>RuleId</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>Predicate</a>: Each <code>Predicate</code> object contains <code>DataId</code>,
         *        <code>Negated</code>, and <code>Type</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rule(Rule rule);

        /**
         * <p>
         * Information about the <a>Rule</a> that you specified in the <code>GetRule</code> request. For more
         * information, see the following topics:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>Rule</a>: Contains <code>MetricName</code>, <code>Name</code>, an array of <code>Predicate</code> objects,
         * and <code>RuleId</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>Predicate</a>: Each <code>Predicate</code> object contains <code>DataId</code>, <code>Negated</code>, and
         * <code>Type</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link Rule.Builder} avoiding the need to create one
         * manually via {@link Rule#builder()}.
         *
         * When the {@link Consumer} completes, {@link Rule.Builder#build()} is called immediately and its result is
         * passed to {@link #rule(Rule)}.
         * 
         * @param rule
         *        a consumer that will call methods on {@link Rule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rule(Rule)
         */
        default Builder rule(Consumer<Rule.Builder> rule) {
            return rule(Rule.builder().applyMutation(rule).build());
        }
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private Rule rule;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRuleResponse model) {
            super(model);
            rule(model.rule);
        }

        public final Rule.Builder getRule() {
            return rule != null ? rule.toBuilder() : null;
        }

        @Override
        public final Builder rule(Rule rule) {
            this.rule = rule;
            return this;
        }

        public final void setRule(Rule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public GetRuleResponse build() {
            return new GetRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
