/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRateBasedRuleManagedKeysResponse extends WafResponse implements
        ToCopyableBuilder<GetRateBasedRuleManagedKeysResponse.Builder, GetRateBasedRuleManagedKeysResponse> {
    private static final SdkField<List<String>> MANAGED_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetRateBasedRuleManagedKeysResponse::managedKeys))
            .setter(setter(Builder::managedKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetRateBasedRuleManagedKeysResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_KEYS_FIELD,
            NEXT_MARKER_FIELD));

    private final List<String> managedKeys;

    private final String nextMarker;

    private GetRateBasedRuleManagedKeysResponse(BuilderImpl builder) {
        super(builder);
        this.managedKeys = builder.managedKeys;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * Returns true if the ManagedKeys property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasManagedKeys() {
        return managedKeys != null && !(managedKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of IP addresses that currently are blocked by the specified <a>RateBasedRule</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasManagedKeys()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of IP addresses that currently are blocked by the specified <a>RateBasedRule</a>.
     */
    public List<String> managedKeys() {
        return managedKeys;
    }

    /**
     * <p>
     * A null value and not currently used.
     * </p>
     * 
     * @return A null value and not currently used.
     */
    public String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(managedKeys());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRateBasedRuleManagedKeysResponse)) {
            return false;
        }
        GetRateBasedRuleManagedKeysResponse other = (GetRateBasedRuleManagedKeysResponse) obj;
        return Objects.equals(managedKeys(), other.managedKeys()) && Objects.equals(nextMarker(), other.nextMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetRateBasedRuleManagedKeysResponse").add("ManagedKeys", managedKeys())
                .add("NextMarker", nextMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManagedKeys":
            return Optional.ofNullable(clazz.cast(managedKeys()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRateBasedRuleManagedKeysResponse, T> g) {
        return obj -> g.apply((GetRateBasedRuleManagedKeysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRateBasedRuleManagedKeysResponse> {
        /**
         * <p>
         * An array of IP addresses that currently are blocked by the specified <a>RateBasedRule</a>.
         * </p>
         * 
         * @param managedKeys
         *        An array of IP addresses that currently are blocked by the specified <a>RateBasedRule</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedKeys(Collection<String> managedKeys);

        /**
         * <p>
         * An array of IP addresses that currently are blocked by the specified <a>RateBasedRule</a>.
         * </p>
         * 
         * @param managedKeys
         *        An array of IP addresses that currently are blocked by the specified <a>RateBasedRule</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedKeys(String... managedKeys);

        /**
         * <p>
         * A null value and not currently used.
         * </p>
         * 
         * @param nextMarker
         *        A null value and not currently used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private List<String> managedKeys = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRateBasedRuleManagedKeysResponse model) {
            super(model);
            managedKeys(model.managedKeys);
            nextMarker(model.nextMarker);
        }

        public final Collection<String> getManagedKeys() {
            return managedKeys;
        }

        @Override
        public final Builder managedKeys(Collection<String> managedKeys) {
            this.managedKeys = ManagedKeysCopier.copy(managedKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedKeys(String... managedKeys) {
            managedKeys(Arrays.asList(managedKeys));
            return this;
        }

        public final void setManagedKeys(Collection<String> managedKeys) {
            this.managedKeys = ManagedKeysCopier.copy(managedKeys);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public GetRateBasedRuleManagedKeysResponse build() {
            return new GetRateBasedRuleManagedKeysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
