/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGeoMatchSetResponse extends WafResponse implements
        ToCopyableBuilder<GetGeoMatchSetResponse.Builder, GetGeoMatchSetResponse> {
    private static final SdkField<GeoMatchSet> GEO_MATCH_SET_FIELD = SdkField.<GeoMatchSet> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetGeoMatchSetResponse::geoMatchSet)).setter(setter(Builder::geoMatchSet))
            .constructor(GeoMatchSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoMatchSet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GEO_MATCH_SET_FIELD));

    private final GeoMatchSet geoMatchSet;

    private GetGeoMatchSetResponse(BuilderImpl builder) {
        super(builder);
        this.geoMatchSet = builder.geoMatchSet;
    }

    /**
     * <p>
     * Information about the <a>GeoMatchSet</a> that you specified in the <code>GetGeoMatchSet</code> request. This
     * includes the <code>Type</code>, which for a <code>GeoMatchContraint</code> is always <code>Country</code>, as
     * well as the <code>Value</code>, which is the identifier for a specific country.
     * </p>
     * 
     * @return Information about the <a>GeoMatchSet</a> that you specified in the <code>GetGeoMatchSet</code> request.
     *         This includes the <code>Type</code>, which for a <code>GeoMatchContraint</code> is always
     *         <code>Country</code>, as well as the <code>Value</code>, which is the identifier for a specific country.
     */
    public GeoMatchSet geoMatchSet() {
        return geoMatchSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(geoMatchSet());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGeoMatchSetResponse)) {
            return false;
        }
        GetGeoMatchSetResponse other = (GetGeoMatchSetResponse) obj;
        return Objects.equals(geoMatchSet(), other.geoMatchSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetGeoMatchSetResponse").add("GeoMatchSet", geoMatchSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GeoMatchSet":
            return Optional.ofNullable(clazz.cast(geoMatchSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGeoMatchSetResponse, T> g) {
        return obj -> g.apply((GetGeoMatchSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetGeoMatchSetResponse> {
        /**
         * <p>
         * Information about the <a>GeoMatchSet</a> that you specified in the <code>GetGeoMatchSet</code> request. This
         * includes the <code>Type</code>, which for a <code>GeoMatchContraint</code> is always <code>Country</code>, as
         * well as the <code>Value</code>, which is the identifier for a specific country.
         * </p>
         * 
         * @param geoMatchSet
         *        Information about the <a>GeoMatchSet</a> that you specified in the <code>GetGeoMatchSet</code>
         *        request. This includes the <code>Type</code>, which for a <code>GeoMatchContraint</code> is always
         *        <code>Country</code>, as well as the <code>Value</code>, which is the identifier for a specific
         *        country.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geoMatchSet(GeoMatchSet geoMatchSet);

        /**
         * <p>
         * Information about the <a>GeoMatchSet</a> that you specified in the <code>GetGeoMatchSet</code> request. This
         * includes the <code>Type</code>, which for a <code>GeoMatchContraint</code> is always <code>Country</code>, as
         * well as the <code>Value</code>, which is the identifier for a specific country.
         * </p>
         * This is a convenience that creates an instance of the {@link GeoMatchSet.Builder} avoiding the need to create
         * one manually via {@link GeoMatchSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link GeoMatchSet.Builder#build()} is called immediately and its result
         * is passed to {@link #geoMatchSet(GeoMatchSet)}.
         * 
         * @param geoMatchSet
         *        a consumer that will call methods on {@link GeoMatchSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geoMatchSet(GeoMatchSet)
         */
        default Builder geoMatchSet(Consumer<GeoMatchSet.Builder> geoMatchSet) {
            return geoMatchSet(GeoMatchSet.builder().applyMutation(geoMatchSet).build());
        }
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private GeoMatchSet geoMatchSet;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGeoMatchSetResponse model) {
            super(model);
            geoMatchSet(model.geoMatchSet);
        }

        public final GeoMatchSet.Builder getGeoMatchSet() {
            return geoMatchSet != null ? geoMatchSet.toBuilder() : null;
        }

        @Override
        public final Builder geoMatchSet(GeoMatchSet geoMatchSet) {
            this.geoMatchSet = geoMatchSet;
            return this;
        }

        public final void setGeoMatchSet(GeoMatchSet.BuilderImpl geoMatchSet) {
            this.geoMatchSet = geoMatchSet != null ? geoMatchSet.build() : null;
        }

        @Override
        public GetGeoMatchSetResponse build() {
            return new GetGeoMatchSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
