/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteWebAclRequest extends WafRequest implements
        ToCopyableBuilder<DeleteWebAclRequest.Builder, DeleteWebAclRequest> {
    private static final SdkField<String> WEB_ACL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteWebAclRequest::webACLId)).setter(setter(Builder::webACLId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACLId").build()).build();

    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteWebAclRequest::changeToken)).setter(setter(Builder::changeToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_ACL_ID_FIELD,
            CHANGE_TOKEN_FIELD));

    private final String webACLId;

    private final String changeToken;

    private DeleteWebAclRequest(BuilderImpl builder) {
        super(builder);
        this.webACLId = builder.webACLId;
        this.changeToken = builder.changeToken;
    }

    /**
     * <p>
     * The <code>WebACLId</code> of the <a>WebACL</a> that you want to delete. <code>WebACLId</code> is returned by
     * <a>CreateWebACL</a> and by <a>ListWebACLs</a>.
     * </p>
     * 
     * @return The <code>WebACLId</code> of the <a>WebACL</a> that you want to delete. <code>WebACLId</code> is returned
     *         by <a>CreateWebACL</a> and by <a>ListWebACLs</a>.
     */
    public String webACLId() {
        return webACLId;
    }

    /**
     * <p>
     * The value returned by the most recent call to <a>GetChangeToken</a>.
     * </p>
     * 
     * @return The value returned by the most recent call to <a>GetChangeToken</a>.
     */
    public String changeToken() {
        return changeToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(webACLId());
        hashCode = 31 * hashCode + Objects.hashCode(changeToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteWebAclRequest)) {
            return false;
        }
        DeleteWebAclRequest other = (DeleteWebAclRequest) obj;
        return Objects.equals(webACLId(), other.webACLId()) && Objects.equals(changeToken(), other.changeToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteWebAclRequest").add("WebACLId", webACLId()).add("ChangeToken", changeToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebACLId":
            return Optional.ofNullable(clazz.cast(webACLId()));
        case "ChangeToken":
            return Optional.ofNullable(clazz.cast(changeToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteWebAclRequest, T> g) {
        return obj -> g.apply((DeleteWebAclRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteWebAclRequest> {
        /**
         * <p>
         * The <code>WebACLId</code> of the <a>WebACL</a> that you want to delete. <code>WebACLId</code> is returned by
         * <a>CreateWebACL</a> and by <a>ListWebACLs</a>.
         * </p>
         * 
         * @param webACLId
         *        The <code>WebACLId</code> of the <a>WebACL</a> that you want to delete. <code>WebACLId</code> is
         *        returned by <a>CreateWebACL</a> and by <a>ListWebACLs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webACLId(String webACLId);

        /**
         * <p>
         * The value returned by the most recent call to <a>GetChangeToken</a>.
         * </p>
         * 
         * @param changeToken
         *        The value returned by the most recent call to <a>GetChangeToken</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeToken(String changeToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WafRequest.BuilderImpl implements Builder {
        private String webACLId;

        private String changeToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteWebAclRequest model) {
            super(model);
            webACLId(model.webACLId);
            changeToken(model.changeToken);
        }

        public final String getWebACLId() {
            return webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        public final String getChangeToken() {
            return changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteWebAclRequest build() {
            return new DeleteWebAclRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
