/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRegexPatternSetResponse extends WafResponse implements
        ToCopyableBuilder<CreateRegexPatternSetResponse.Builder, CreateRegexPatternSetResponse> {
    private static final SdkField<RegexPatternSet> REGEX_PATTERN_SET_FIELD = SdkField
            .<RegexPatternSet> builder(MarshallingType.SDK_POJO).getter(getter(CreateRegexPatternSetResponse::regexPatternSet))
            .setter(setter(Builder::regexPatternSet)).constructor(RegexPatternSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexPatternSet").build()).build();

    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRegexPatternSetResponse::changeToken)).setter(setter(Builder::changeToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGEX_PATTERN_SET_FIELD,
            CHANGE_TOKEN_FIELD));

    private final RegexPatternSet regexPatternSet;

    private final String changeToken;

    private CreateRegexPatternSetResponse(BuilderImpl builder) {
        super(builder);
        this.regexPatternSet = builder.regexPatternSet;
        this.changeToken = builder.changeToken;
    }

    /**
     * <p>
     * A <a>RegexPatternSet</a> that contains no objects.
     * </p>
     * 
     * @return A <a>RegexPatternSet</a> that contains no objects.
     */
    public RegexPatternSet regexPatternSet() {
        return regexPatternSet;
    }

    /**
     * <p>
     * The <code>ChangeToken</code> that you used to submit the <code>CreateRegexPatternSet</code> request. You can also
     * use this value to query the status of the request. For more information, see <a>GetChangeTokenStatus</a>.
     * </p>
     * 
     * @return The <code>ChangeToken</code> that you used to submit the <code>CreateRegexPatternSet</code> request. You
     *         can also use this value to query the status of the request. For more information, see
     *         <a>GetChangeTokenStatus</a>.
     */
    public String changeToken() {
        return changeToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(regexPatternSet());
        hashCode = 31 * hashCode + Objects.hashCode(changeToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRegexPatternSetResponse)) {
            return false;
        }
        CreateRegexPatternSetResponse other = (CreateRegexPatternSetResponse) obj;
        return Objects.equals(regexPatternSet(), other.regexPatternSet()) && Objects.equals(changeToken(), other.changeToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateRegexPatternSetResponse").add("RegexPatternSet", regexPatternSet())
                .add("ChangeToken", changeToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegexPatternSet":
            return Optional.ofNullable(clazz.cast(regexPatternSet()));
        case "ChangeToken":
            return Optional.ofNullable(clazz.cast(changeToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRegexPatternSetResponse, T> g) {
        return obj -> g.apply((CreateRegexPatternSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateRegexPatternSetResponse> {
        /**
         * <p>
         * A <a>RegexPatternSet</a> that contains no objects.
         * </p>
         * 
         * @param regexPatternSet
         *        A <a>RegexPatternSet</a> that contains no objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexPatternSet(RegexPatternSet regexPatternSet);

        /**
         * <p>
         * A <a>RegexPatternSet</a> that contains no objects.
         * </p>
         * This is a convenience that creates an instance of the {@link RegexPatternSet.Builder} avoiding the need to
         * create one manually via {@link RegexPatternSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link RegexPatternSet.Builder#build()} is called immediately and its
         * result is passed to {@link #regexPatternSet(RegexPatternSet)}.
         * 
         * @param regexPatternSet
         *        a consumer that will call methods on {@link RegexPatternSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regexPatternSet(RegexPatternSet)
         */
        default Builder regexPatternSet(Consumer<RegexPatternSet.Builder> regexPatternSet) {
            return regexPatternSet(RegexPatternSet.builder().applyMutation(regexPatternSet).build());
        }

        /**
         * <p>
         * The <code>ChangeToken</code> that you used to submit the <code>CreateRegexPatternSet</code> request. You can
         * also use this value to query the status of the request. For more information, see
         * <a>GetChangeTokenStatus</a>.
         * </p>
         * 
         * @param changeToken
         *        The <code>ChangeToken</code> that you used to submit the <code>CreateRegexPatternSet</code> request.
         *        You can also use this value to query the status of the request. For more information, see
         *        <a>GetChangeTokenStatus</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeToken(String changeToken);
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private RegexPatternSet regexPatternSet;

        private String changeToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRegexPatternSetResponse model) {
            super(model);
            regexPatternSet(model.regexPatternSet);
            changeToken(model.changeToken);
        }

        public final RegexPatternSet.Builder getRegexPatternSet() {
            return regexPatternSet != null ? regexPatternSet.toBuilder() : null;
        }

        @Override
        public final Builder regexPatternSet(RegexPatternSet regexPatternSet) {
            this.regexPatternSet = regexPatternSet;
            return this;
        }

        public final void setRegexPatternSet(RegexPatternSet.BuilderImpl regexPatternSet) {
            this.regexPatternSet = regexPatternSet != null ? regexPatternSet.build() : null;
        }

        public final String getChangeToken() {
            return changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        @Override
        public CreateRegexPatternSetResponse build() {
            return new CreateRegexPatternSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
