/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIpSetResponse extends WafResponse implements
        ToCopyableBuilder<CreateIpSetResponse.Builder, CreateIpSetResponse> {
    private static final SdkField<IPSet> IP_SET_FIELD = SdkField.<IPSet> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateIpSetResponse::ipSet)).setter(setter(Builder::ipSet)).constructor(IPSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPSet").build()).build();

    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateIpSetResponse::changeToken)).setter(setter(Builder::changeToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_SET_FIELD,
            CHANGE_TOKEN_FIELD));

    private final IPSet ipSet;

    private final String changeToken;

    private CreateIpSetResponse(BuilderImpl builder) {
        super(builder);
        this.ipSet = builder.ipSet;
        this.changeToken = builder.changeToken;
    }

    /**
     * <p>
     * The <a>IPSet</a> returned in the <code>CreateIPSet</code> response.
     * </p>
     * 
     * @return The <a>IPSet</a> returned in the <code>CreateIPSet</code> response.
     */
    public IPSet ipSet() {
        return ipSet;
    }

    /**
     * <p>
     * The <code>ChangeToken</code> that you used to submit the <code>CreateIPSet</code> request. You can also use this
     * value to query the status of the request. For more information, see <a>GetChangeTokenStatus</a>.
     * </p>
     * 
     * @return The <code>ChangeToken</code> that you used to submit the <code>CreateIPSet</code> request. You can also
     *         use this value to query the status of the request. For more information, see <a>GetChangeTokenStatus</a>.
     */
    public String changeToken() {
        return changeToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ipSet());
        hashCode = 31 * hashCode + Objects.hashCode(changeToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIpSetResponse)) {
            return false;
        }
        CreateIpSetResponse other = (CreateIpSetResponse) obj;
        return Objects.equals(ipSet(), other.ipSet()) && Objects.equals(changeToken(), other.changeToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateIpSetResponse").add("IPSet", ipSet()).add("ChangeToken", changeToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IPSet":
            return Optional.ofNullable(clazz.cast(ipSet()));
        case "ChangeToken":
            return Optional.ofNullable(clazz.cast(changeToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIpSetResponse, T> g) {
        return obj -> g.apply((CreateIpSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateIpSetResponse> {
        /**
         * <p>
         * The <a>IPSet</a> returned in the <code>CreateIPSet</code> response.
         * </p>
         * 
         * @param ipSet
         *        The <a>IPSet</a> returned in the <code>CreateIPSet</code> response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipSet(IPSet ipSet);

        /**
         * <p>
         * The <a>IPSet</a> returned in the <code>CreateIPSet</code> response.
         * </p>
         * This is a convenience that creates an instance of the {@link IPSet.Builder} avoiding the need to create one
         * manually via {@link IPSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link IPSet.Builder#build()} is called immediately and its result is
         * passed to {@link #ipSet(IPSet)}.
         * 
         * @param ipSet
         *        a consumer that will call methods on {@link IPSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipSet(IPSet)
         */
        default Builder ipSet(Consumer<IPSet.Builder> ipSet) {
            return ipSet(IPSet.builder().applyMutation(ipSet).build());
        }

        /**
         * <p>
         * The <code>ChangeToken</code> that you used to submit the <code>CreateIPSet</code> request. You can also use
         * this value to query the status of the request. For more information, see <a>GetChangeTokenStatus</a>.
         * </p>
         * 
         * @param changeToken
         *        The <code>ChangeToken</code> that you used to submit the <code>CreateIPSet</code> request. You can
         *        also use this value to query the status of the request. For more information, see
         *        <a>GetChangeTokenStatus</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeToken(String changeToken);
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private IPSet ipSet;

        private String changeToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIpSetResponse model) {
            super(model);
            ipSet(model.ipSet);
            changeToken(model.changeToken);
        }

        public final IPSet.Builder getIpSet() {
            return ipSet != null ? ipSet.toBuilder() : null;
        }

        @Override
        public final Builder ipSet(IPSet ipSet) {
            this.ipSet = ipSet;
            return this;
        }

        public final void setIpSet(IPSet.BuilderImpl ipSet) {
            this.ipSet = ipSet != null ? ipSet.build() : null;
        }

        public final String getChangeToken() {
            return changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        @Override
        public CreateIpSetResponse build() {
            return new CreateIpSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
