/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is <b>AWS WAF Classic</b> documentation. For more information, see <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the
 * developer guide.
 * </p>
 * <p>
 * <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the
 * latest version, AWS WAF has a single set of endpoints for regional and global use.
 * </p>
 * </note>
 * <p>
 * In a <a>GetByteMatchSet</a> request, <code>ByteMatchSet</code> is a complex type that contains the
 * <code>ByteMatchSetId</code> and <code>Name</code> of a <code>ByteMatchSet</code>, and the values that you specified
 * when you updated the <code>ByteMatchSet</code>.
 * </p>
 * <p>
 * A complex type that contains <code>ByteMatchTuple</code> objects, which specify the parts of web requests that you
 * want AWS WAF to inspect and the values that you want AWS WAF to search for. If a <code>ByteMatchSet</code> contains
 * more than one <code>ByteMatchTuple</code> object, a request needs to match the settings in only one
 * <code>ByteMatchTuple</code> to be considered a match.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ByteMatchSet implements SdkPojo, Serializable, ToCopyableBuilder<ByteMatchSet.Builder, ByteMatchSet> {
    private static final SdkField<String> BYTE_MATCH_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ByteMatchSet::byteMatchSetId)).setter(setter(Builder::byteMatchSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ByteMatchSetId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ByteMatchSet::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<ByteMatchTuple>> BYTE_MATCH_TUPLES_FIELD = SdkField
            .<List<ByteMatchTuple>> builder(MarshallingType.LIST)
            .getter(getter(ByteMatchSet::byteMatchTuples))
            .setter(setter(Builder::byteMatchTuples))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ByteMatchTuples").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ByteMatchTuple> builder(MarshallingType.SDK_POJO)
                                            .constructor(ByteMatchTuple::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYTE_MATCH_SET_ID_FIELD,
            NAME_FIELD, BYTE_MATCH_TUPLES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String byteMatchSetId;

    private final String name;

    private final List<ByteMatchTuple> byteMatchTuples;

    private ByteMatchSet(BuilderImpl builder) {
        this.byteMatchSetId = builder.byteMatchSetId;
        this.name = builder.name;
        this.byteMatchTuples = builder.byteMatchTuples;
    }

    /**
     * <p>
     * The <code>ByteMatchSetId</code> for a <code>ByteMatchSet</code>. You use <code>ByteMatchSetId</code> to get
     * information about a <code>ByteMatchSet</code> (see <a>GetByteMatchSet</a>), update a <code>ByteMatchSet</code>
     * (see <a>UpdateByteMatchSet</a>), insert a <code>ByteMatchSet</code> into a <code>Rule</code> or delete one from a
     * <code>Rule</code> (see <a>UpdateRule</a>), and delete a <code>ByteMatchSet</code> from AWS WAF (see
     * <a>DeleteByteMatchSet</a>).
     * </p>
     * <p>
     * <code>ByteMatchSetId</code> is returned by <a>CreateByteMatchSet</a> and by <a>ListByteMatchSets</a>.
     * </p>
     * 
     * @return The <code>ByteMatchSetId</code> for a <code>ByteMatchSet</code>. You use <code>ByteMatchSetId</code> to
     *         get information about a <code>ByteMatchSet</code> (see <a>GetByteMatchSet</a>), update a
     *         <code>ByteMatchSet</code> (see <a>UpdateByteMatchSet</a>), insert a <code>ByteMatchSet</code> into a
     *         <code>Rule</code> or delete one from a <code>Rule</code> (see <a>UpdateRule</a>), and delete a
     *         <code>ByteMatchSet</code> from AWS WAF (see <a>DeleteByteMatchSet</a>).</p>
     *         <p>
     *         <code>ByteMatchSetId</code> is returned by <a>CreateByteMatchSet</a> and by <a>ListByteMatchSets</a>.
     */
    public String byteMatchSetId() {
        return byteMatchSetId;
    }

    /**
     * <p>
     * A friendly name or description of the <a>ByteMatchSet</a>. You can't change <code>Name</code> after you create a
     * <code>ByteMatchSet</code>.
     * </p>
     * 
     * @return A friendly name or description of the <a>ByteMatchSet</a>. You can't change <code>Name</code> after you
     *         create a <code>ByteMatchSet</code>.
     */
    public String name() {
        return name;
    }

    /**
     * Returns true if the ByteMatchTuples property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasByteMatchTuples() {
        return byteMatchTuples != null && !(byteMatchTuples instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search
     * for in web requests, the location in requests that you want AWS WAF to search, and other settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasByteMatchTuples()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to
     *         search for in web requests, the location in requests that you want AWS WAF to search, and other settings.
     */
    public List<ByteMatchTuple> byteMatchTuples() {
        return byteMatchTuples;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(byteMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(byteMatchTuples());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByteMatchSet)) {
            return false;
        }
        ByteMatchSet other = (ByteMatchSet) obj;
        return Objects.equals(byteMatchSetId(), other.byteMatchSetId()) && Objects.equals(name(), other.name())
                && Objects.equals(byteMatchTuples(), other.byteMatchTuples());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ByteMatchSet").add("ByteMatchSetId", byteMatchSetId()).add("Name", name())
                .add("ByteMatchTuples", byteMatchTuples()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ByteMatchSetId":
            return Optional.ofNullable(clazz.cast(byteMatchSetId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ByteMatchTuples":
            return Optional.ofNullable(clazz.cast(byteMatchTuples()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ByteMatchSet, T> g) {
        return obj -> g.apply((ByteMatchSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ByteMatchSet> {
        /**
         * <p>
         * The <code>ByteMatchSetId</code> for a <code>ByteMatchSet</code>. You use <code>ByteMatchSetId</code> to get
         * information about a <code>ByteMatchSet</code> (see <a>GetByteMatchSet</a>), update a
         * <code>ByteMatchSet</code> (see <a>UpdateByteMatchSet</a>), insert a <code>ByteMatchSet</code> into a
         * <code>Rule</code> or delete one from a <code>Rule</code> (see <a>UpdateRule</a>), and delete a
         * <code>ByteMatchSet</code> from AWS WAF (see <a>DeleteByteMatchSet</a>).
         * </p>
         * <p>
         * <code>ByteMatchSetId</code> is returned by <a>CreateByteMatchSet</a> and by <a>ListByteMatchSets</a>.
         * </p>
         * 
         * @param byteMatchSetId
         *        The <code>ByteMatchSetId</code> for a <code>ByteMatchSet</code>. You use <code>ByteMatchSetId</code>
         *        to get information about a <code>ByteMatchSet</code> (see <a>GetByteMatchSet</a>), update a
         *        <code>ByteMatchSet</code> (see <a>UpdateByteMatchSet</a>), insert a <code>ByteMatchSet</code> into a
         *        <code>Rule</code> or delete one from a <code>Rule</code> (see <a>UpdateRule</a>), and delete a
         *        <code>ByteMatchSet</code> from AWS WAF (see <a>DeleteByteMatchSet</a>).</p>
         *        <p>
         *        <code>ByteMatchSetId</code> is returned by <a>CreateByteMatchSet</a> and by <a>ListByteMatchSets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byteMatchSetId(String byteMatchSetId);

        /**
         * <p>
         * A friendly name or description of the <a>ByteMatchSet</a>. You can't change <code>Name</code> after you
         * create a <code>ByteMatchSet</code>.
         * </p>
         * 
         * @param name
         *        A friendly name or description of the <a>ByteMatchSet</a>. You can't change <code>Name</code> after
         *        you create a <code>ByteMatchSet</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to
         * search for in web requests, the location in requests that you want AWS WAF to search, and other settings.
         * </p>
         * 
         * @param byteMatchTuples
         *        Specifies the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF
         *        to search for in web requests, the location in requests that you want AWS WAF to search, and other
         *        settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byteMatchTuples(Collection<ByteMatchTuple> byteMatchTuples);

        /**
         * <p>
         * Specifies the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to
         * search for in web requests, the location in requests that you want AWS WAF to search, and other settings.
         * </p>
         * 
         * @param byteMatchTuples
         *        Specifies the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF
         *        to search for in web requests, the location in requests that you want AWS WAF to search, and other
         *        settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byteMatchTuples(ByteMatchTuple... byteMatchTuples);

        /**
         * <p>
         * Specifies the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to
         * search for in web requests, the location in requests that you want AWS WAF to search, and other settings.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ByteMatchTuple>.Builder} avoiding the need
         * to create one manually via {@link List<ByteMatchTuple>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ByteMatchTuple>.Builder#build()} is called immediately and
         * its result is passed to {@link #byteMatchTuples(List<ByteMatchTuple>)}.
         * 
         * @param byteMatchTuples
         *        a consumer that will call methods on {@link List<ByteMatchTuple>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #byteMatchTuples(List<ByteMatchTuple>)
         */
        Builder byteMatchTuples(Consumer<ByteMatchTuple.Builder>... byteMatchTuples);
    }

    static final class BuilderImpl implements Builder {
        private String byteMatchSetId;

        private String name;

        private List<ByteMatchTuple> byteMatchTuples = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ByteMatchSet model) {
            byteMatchSetId(model.byteMatchSetId);
            name(model.name);
            byteMatchTuples(model.byteMatchTuples);
        }

        public final String getByteMatchSetId() {
            return byteMatchSetId;
        }

        @Override
        public final Builder byteMatchSetId(String byteMatchSetId) {
            this.byteMatchSetId = byteMatchSetId;
            return this;
        }

        public final void setByteMatchSetId(String byteMatchSetId) {
            this.byteMatchSetId = byteMatchSetId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<ByteMatchTuple.Builder> getByteMatchTuples() {
            return byteMatchTuples != null ? byteMatchTuples.stream().map(ByteMatchTuple::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder byteMatchTuples(Collection<ByteMatchTuple> byteMatchTuples) {
            this.byteMatchTuples = ByteMatchTuplesCopier.copy(byteMatchTuples);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder byteMatchTuples(ByteMatchTuple... byteMatchTuples) {
            byteMatchTuples(Arrays.asList(byteMatchTuples));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder byteMatchTuples(Consumer<ByteMatchTuple.Builder>... byteMatchTuples) {
            byteMatchTuples(Stream.of(byteMatchTuples).map(c -> ByteMatchTuple.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setByteMatchTuples(Collection<ByteMatchTuple.BuilderImpl> byteMatchTuples) {
            this.byteMatchTuples = ByteMatchTuplesCopier.copyFromBuilder(byteMatchTuples);
        }

        @Override
        public ByteMatchSet build() {
            return new ByteMatchSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
