/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to update a <a>SqlInjectionMatchSet</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSqlInjectionMatchSetRequest extends WafRequest implements
        ToCopyableBuilder<UpdateSqlInjectionMatchSetRequest.Builder, UpdateSqlInjectionMatchSetRequest> {
    private static final SdkField<String> SQL_INJECTION_MATCH_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateSqlInjectionMatchSetRequest::sqlInjectionMatchSetId))
            .setter(setter(Builder::sqlInjectionMatchSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlInjectionMatchSetId").build())
            .build();

    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateSqlInjectionMatchSetRequest::changeToken)).setter(setter(Builder::changeToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()).build();

    private static final SdkField<List<SqlInjectionMatchSetUpdate>> UPDATES_FIELD = SdkField
            .<List<SqlInjectionMatchSetUpdate>> builder(MarshallingType.LIST)
            .getter(getter(UpdateSqlInjectionMatchSetRequest::updates))
            .setter(setter(Builder::updates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Updates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SqlInjectionMatchSetUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(SqlInjectionMatchSetUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SQL_INJECTION_MATCH_SET_ID_FIELD, CHANGE_TOKEN_FIELD, UPDATES_FIELD));

    private final String sqlInjectionMatchSetId;

    private final String changeToken;

    private final List<SqlInjectionMatchSetUpdate> updates;

    private UpdateSqlInjectionMatchSetRequest(BuilderImpl builder) {
        super(builder);
        this.sqlInjectionMatchSetId = builder.sqlInjectionMatchSetId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
    }

    /**
     * <p>
     * The <code>SqlInjectionMatchSetId</code> of the <code>SqlInjectionMatchSet</code> that you want to update.
     * <code>SqlInjectionMatchSetId</code> is returned by <a>CreateSqlInjectionMatchSet</a> and by
     * <a>ListSqlInjectionMatchSets</a>.
     * </p>
     * 
     * @return The <code>SqlInjectionMatchSetId</code> of the <code>SqlInjectionMatchSet</code> that you want to update.
     *         <code>SqlInjectionMatchSetId</code> is returned by <a>CreateSqlInjectionMatchSet</a> and by
     *         <a>ListSqlInjectionMatchSets</a>.
     */
    public String sqlInjectionMatchSetId() {
        return sqlInjectionMatchSetId;
    }

    /**
     * <p>
     * The value returned by the most recent call to <a>GetChangeToken</a>.
     * </p>
     * 
     * @return The value returned by the most recent call to <a>GetChangeToken</a>.
     */
    public String changeToken() {
        return changeToken;
    }

    /**
     * Returns true if the Updates property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUpdates() {
        return updates != null && !(updates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>SqlInjectionMatchSetUpdate</code> objects that you want to insert into or delete from a
     * <a>SqlInjectionMatchSet</a>. For more information, see the applicable data types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>SqlInjectionMatchSetUpdate</a>: Contains <code>Action</code> and <code>SqlInjectionMatchTuple</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>SqlInjectionMatchTuple</a>: Contains <code>FieldToMatch</code> and <code>TextTransformation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUpdates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>SqlInjectionMatchSetUpdate</code> objects that you want to insert into or delete from a
     *         <a>SqlInjectionMatchSet</a>. For more information, see the applicable data types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a>SqlInjectionMatchSetUpdate</a>: Contains <code>Action</code> and <code>SqlInjectionMatchTuple</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>SqlInjectionMatchTuple</a>: Contains <code>FieldToMatch</code> and <code>TextTransformation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
     *         </p>
     *         </li>
     */
    public List<SqlInjectionMatchSetUpdate> updates() {
        return updates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sqlInjectionMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(changeToken());
        hashCode = 31 * hashCode + Objects.hashCode(updates());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSqlInjectionMatchSetRequest)) {
            return false;
        }
        UpdateSqlInjectionMatchSetRequest other = (UpdateSqlInjectionMatchSetRequest) obj;
        return Objects.equals(sqlInjectionMatchSetId(), other.sqlInjectionMatchSetId())
                && Objects.equals(changeToken(), other.changeToken()) && Objects.equals(updates(), other.updates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateSqlInjectionMatchSetRequest").add("SqlInjectionMatchSetId", sqlInjectionMatchSetId())
                .add("ChangeToken", changeToken()).add("Updates", updates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SqlInjectionMatchSetId":
            return Optional.ofNullable(clazz.cast(sqlInjectionMatchSetId()));
        case "ChangeToken":
            return Optional.ofNullable(clazz.cast(changeToken()));
        case "Updates":
            return Optional.ofNullable(clazz.cast(updates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSqlInjectionMatchSetRequest, T> g) {
        return obj -> g.apply((UpdateSqlInjectionMatchSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSqlInjectionMatchSetRequest> {
        /**
         * <p>
         * The <code>SqlInjectionMatchSetId</code> of the <code>SqlInjectionMatchSet</code> that you want to update.
         * <code>SqlInjectionMatchSetId</code> is returned by <a>CreateSqlInjectionMatchSet</a> and by
         * <a>ListSqlInjectionMatchSets</a>.
         * </p>
         * 
         * @param sqlInjectionMatchSetId
         *        The <code>SqlInjectionMatchSetId</code> of the <code>SqlInjectionMatchSet</code> that you want to
         *        update. <code>SqlInjectionMatchSetId</code> is returned by <a>CreateSqlInjectionMatchSet</a> and by
         *        <a>ListSqlInjectionMatchSets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlInjectionMatchSetId(String sqlInjectionMatchSetId);

        /**
         * <p>
         * The value returned by the most recent call to <a>GetChangeToken</a>.
         * </p>
         * 
         * @param changeToken
         *        The value returned by the most recent call to <a>GetChangeToken</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeToken(String changeToken);

        /**
         * <p>
         * An array of <code>SqlInjectionMatchSetUpdate</code> objects that you want to insert into or delete from a
         * <a>SqlInjectionMatchSet</a>. For more information, see the applicable data types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>SqlInjectionMatchSetUpdate</a>: Contains <code>Action</code> and <code>SqlInjectionMatchTuple</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>SqlInjectionMatchTuple</a>: Contains <code>FieldToMatch</code> and <code>TextTransformation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param updates
         *        An array of <code>SqlInjectionMatchSetUpdate</code> objects that you want to insert into or delete
         *        from a <a>SqlInjectionMatchSet</a>. For more information, see the applicable data types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a>SqlInjectionMatchSetUpdate</a>: Contains <code>Action</code> and
         *        <code>SqlInjectionMatchTuple</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>SqlInjectionMatchTuple</a>: Contains <code>FieldToMatch</code> and <code>TextTransformation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updates(Collection<SqlInjectionMatchSetUpdate> updates);

        /**
         * <p>
         * An array of <code>SqlInjectionMatchSetUpdate</code> objects that you want to insert into or delete from a
         * <a>SqlInjectionMatchSet</a>. For more information, see the applicable data types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>SqlInjectionMatchSetUpdate</a>: Contains <code>Action</code> and <code>SqlInjectionMatchTuple</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>SqlInjectionMatchTuple</a>: Contains <code>FieldToMatch</code> and <code>TextTransformation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param updates
         *        An array of <code>SqlInjectionMatchSetUpdate</code> objects that you want to insert into or delete
         *        from a <a>SqlInjectionMatchSet</a>. For more information, see the applicable data types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a>SqlInjectionMatchSetUpdate</a>: Contains <code>Action</code> and
         *        <code>SqlInjectionMatchTuple</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>SqlInjectionMatchTuple</a>: Contains <code>FieldToMatch</code> and <code>TextTransformation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updates(SqlInjectionMatchSetUpdate... updates);

        /**
         * <p>
         * An array of <code>SqlInjectionMatchSetUpdate</code> objects that you want to insert into or delete from a
         * <a>SqlInjectionMatchSet</a>. For more information, see the applicable data types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>SqlInjectionMatchSetUpdate</a>: Contains <code>Action</code> and <code>SqlInjectionMatchTuple</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>SqlInjectionMatchTuple</a>: Contains <code>FieldToMatch</code> and <code>TextTransformation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<SqlInjectionMatchSetUpdate>.Builder}
         * avoiding the need to create one manually via {@link List<SqlInjectionMatchSetUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SqlInjectionMatchSetUpdate>.Builder#build()} is called
         * immediately and its result is passed to {@link #updates(List<SqlInjectionMatchSetUpdate>)}.
         * 
         * @param updates
         *        a consumer that will call methods on {@link List<SqlInjectionMatchSetUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updates(List<SqlInjectionMatchSetUpdate>)
         */
        Builder updates(Consumer<SqlInjectionMatchSetUpdate.Builder>... updates);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WafRequest.BuilderImpl implements Builder {
        private String sqlInjectionMatchSetId;

        private String changeToken;

        private List<SqlInjectionMatchSetUpdate> updates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSqlInjectionMatchSetRequest model) {
            super(model);
            sqlInjectionMatchSetId(model.sqlInjectionMatchSetId);
            changeToken(model.changeToken);
            updates(model.updates);
        }

        public final String getSqlInjectionMatchSetId() {
            return sqlInjectionMatchSetId;
        }

        @Override
        public final Builder sqlInjectionMatchSetId(String sqlInjectionMatchSetId) {
            this.sqlInjectionMatchSetId = sqlInjectionMatchSetId;
            return this;
        }

        public final void setSqlInjectionMatchSetId(String sqlInjectionMatchSetId) {
            this.sqlInjectionMatchSetId = sqlInjectionMatchSetId;
        }

        public final String getChangeToken() {
            return changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public final Collection<SqlInjectionMatchSetUpdate.Builder> getUpdates() {
            return updates != null ? updates.stream().map(SqlInjectionMatchSetUpdate::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder updates(Collection<SqlInjectionMatchSetUpdate> updates) {
            this.updates = SqlInjectionMatchSetUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(SqlInjectionMatchSetUpdate... updates) {
            updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(Consumer<SqlInjectionMatchSetUpdate.Builder>... updates) {
            updates(Stream.of(updates).map(c -> SqlInjectionMatchSetUpdate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUpdates(Collection<SqlInjectionMatchSetUpdate.BuilderImpl> updates) {
            this.updates = SqlInjectionMatchSetUpdatesCopier.copyFromBuilder(updates);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSqlInjectionMatchSetRequest build() {
            return new UpdateSqlInjectionMatchSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
