/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRateBasedRuleRequest extends WafRequest implements
        ToCopyableBuilder<UpdateRateBasedRuleRequest.Builder, UpdateRateBasedRuleRequest> {
    private static final SdkField<String> RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateRateBasedRuleRequest::ruleId)).setter(setter(Builder::ruleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()).build();

    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateRateBasedRuleRequest::changeToken)).setter(setter(Builder::changeToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()).build();

    private static final SdkField<List<RuleUpdate>> UPDATES_FIELD = SdkField
            .<List<RuleUpdate>> builder(MarshallingType.LIST)
            .getter(getter(UpdateRateBasedRuleRequest::updates))
            .setter(setter(Builder::updates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Updates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> RATE_LIMIT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(UpdateRateBasedRuleRequest::rateLimit)).setter(setter(Builder::rateLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RateLimit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ID_FIELD,
            CHANGE_TOKEN_FIELD, UPDATES_FIELD, RATE_LIMIT_FIELD));

    private final String ruleId;

    private final String changeToken;

    private final List<RuleUpdate> updates;

    private final Long rateLimit;

    private UpdateRateBasedRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ruleId = builder.ruleId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
        this.rateLimit = builder.rateLimit;
    }

    /**
     * <p>
     * The <code>RuleId</code> of the <code>RateBasedRule</code> that you want to update. <code>RuleId</code> is
     * returned by <code>CreateRateBasedRule</code> and by <a>ListRateBasedRules</a>.
     * </p>
     * 
     * @return The <code>RuleId</code> of the <code>RateBasedRule</code> that you want to update. <code>RuleId</code> is
     *         returned by <code>CreateRateBasedRule</code> and by <a>ListRateBasedRules</a>.
     */
    public String ruleId() {
        return ruleId;
    }

    /**
     * <p>
     * The value returned by the most recent call to <a>GetChangeToken</a>.
     * </p>
     * 
     * @return The value returned by the most recent call to <a>GetChangeToken</a>.
     */
    public String changeToken() {
        return changeToken;
    }

    /**
     * Returns true if the Updates property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUpdates() {
        return updates != null && !(updates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>RuleUpdate</code> objects that you want to insert into or delete from a <a>RateBasedRule</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUpdates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>RuleUpdate</code> objects that you want to insert into or delete from a
     *         <a>RateBasedRule</a>.
     */
    public List<RuleUpdate> updates() {
        return updates;
    }

    /**
     * <p>
     * The maximum number of requests, which have an identical value in the field specified by the <code>RateKey</code>,
     * allowed in a five-minute period. If the number of requests exceeds the <code>RateLimit</code> and the other
     * predicates specified in the rule are also met, AWS WAF triggers the action that is specified for this rule.
     * </p>
     * 
     * @return The maximum number of requests, which have an identical value in the field specified by the
     *         <code>RateKey</code>, allowed in a five-minute period. If the number of requests exceeds the
     *         <code>RateLimit</code> and the other predicates specified in the rule are also met, AWS WAF triggers the
     *         action that is specified for this rule.
     */
    public Long rateLimit() {
        return rateLimit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(changeToken());
        hashCode = 31 * hashCode + Objects.hashCode(updates());
        hashCode = 31 * hashCode + Objects.hashCode(rateLimit());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRateBasedRuleRequest)) {
            return false;
        }
        UpdateRateBasedRuleRequest other = (UpdateRateBasedRuleRequest) obj;
        return Objects.equals(ruleId(), other.ruleId()) && Objects.equals(changeToken(), other.changeToken())
                && Objects.equals(updates(), other.updates()) && Objects.equals(rateLimit(), other.rateLimit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateRateBasedRuleRequest").add("RuleId", ruleId()).add("ChangeToken", changeToken())
                .add("Updates", updates()).add("RateLimit", rateLimit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleId":
            return Optional.ofNullable(clazz.cast(ruleId()));
        case "ChangeToken":
            return Optional.ofNullable(clazz.cast(changeToken()));
        case "Updates":
            return Optional.ofNullable(clazz.cast(updates()));
        case "RateLimit":
            return Optional.ofNullable(clazz.cast(rateLimit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRateBasedRuleRequest, T> g) {
        return obj -> g.apply((UpdateRateBasedRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRateBasedRuleRequest> {
        /**
         * <p>
         * The <code>RuleId</code> of the <code>RateBasedRule</code> that you want to update. <code>RuleId</code> is
         * returned by <code>CreateRateBasedRule</code> and by <a>ListRateBasedRules</a>.
         * </p>
         * 
         * @param ruleId
         *        The <code>RuleId</code> of the <code>RateBasedRule</code> that you want to update. <code>RuleId</code>
         *        is returned by <code>CreateRateBasedRule</code> and by <a>ListRateBasedRules</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleId(String ruleId);

        /**
         * <p>
         * The value returned by the most recent call to <a>GetChangeToken</a>.
         * </p>
         * 
         * @param changeToken
         *        The value returned by the most recent call to <a>GetChangeToken</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeToken(String changeToken);

        /**
         * <p>
         * An array of <code>RuleUpdate</code> objects that you want to insert into or delete from a
         * <a>RateBasedRule</a>.
         * </p>
         * 
         * @param updates
         *        An array of <code>RuleUpdate</code> objects that you want to insert into or delete from a
         *        <a>RateBasedRule</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updates(Collection<RuleUpdate> updates);

        /**
         * <p>
         * An array of <code>RuleUpdate</code> objects that you want to insert into or delete from a
         * <a>RateBasedRule</a>.
         * </p>
         * 
         * @param updates
         *        An array of <code>RuleUpdate</code> objects that you want to insert into or delete from a
         *        <a>RateBasedRule</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updates(RuleUpdate... updates);

        /**
         * <p>
         * An array of <code>RuleUpdate</code> objects that you want to insert into or delete from a
         * <a>RateBasedRule</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RuleUpdate>.Builder} avoiding the need to
         * create one manually via {@link List<RuleUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RuleUpdate>.Builder#build()} is called immediately and its
         * result is passed to {@link #updates(List<RuleUpdate>)}.
         * 
         * @param updates
         *        a consumer that will call methods on {@link List<RuleUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updates(List<RuleUpdate>)
         */
        Builder updates(Consumer<RuleUpdate.Builder>... updates);

        /**
         * <p>
         * The maximum number of requests, which have an identical value in the field specified by the
         * <code>RateKey</code>, allowed in a five-minute period. If the number of requests exceeds the
         * <code>RateLimit</code> and the other predicates specified in the rule are also met, AWS WAF triggers the
         * action that is specified for this rule.
         * </p>
         * 
         * @param rateLimit
         *        The maximum number of requests, which have an identical value in the field specified by the
         *        <code>RateKey</code>, allowed in a five-minute period. If the number of requests exceeds the
         *        <code>RateLimit</code> and the other predicates specified in the rule are also met, AWS WAF triggers
         *        the action that is specified for this rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rateLimit(Long rateLimit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WafRequest.BuilderImpl implements Builder {
        private String ruleId;

        private String changeToken;

        private List<RuleUpdate> updates = DefaultSdkAutoConstructList.getInstance();

        private Long rateLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRateBasedRuleRequest model) {
            super(model);
            ruleId(model.ruleId);
            changeToken(model.changeToken);
            updates(model.updates);
            rateLimit(model.rateLimit);
        }

        public final String getRuleId() {
            return ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        public final String getChangeToken() {
            return changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public final Collection<RuleUpdate.Builder> getUpdates() {
            return updates != null ? updates.stream().map(RuleUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder updates(Collection<RuleUpdate> updates) {
            this.updates = RuleUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(RuleUpdate... updates) {
            updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(Consumer<RuleUpdate.Builder>... updates) {
            updates(Stream.of(updates).map(c -> RuleUpdate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUpdates(Collection<RuleUpdate.BuilderImpl> updates) {
            this.updates = RuleUpdatesCopier.copyFromBuilder(updates);
        }

        public final Long getRateLimit() {
            return rateLimit;
        }

        @Override
        public final Builder rateLimit(Long rateLimit) {
            this.rateLimit = rateLimit;
            return this;
        }

        public final void setRateLimit(Long rateLimit) {
            this.rateLimit = rateLimit;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRateBasedRuleRequest build() {
            return new UpdateRateBasedRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
