/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the part of a web request that you want to inspect the size of and indicates whether you want to add the
 * specification to a <a>SizeConstraintSet</a> or delete it from a <code>SizeConstraintSet</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SizeConstraintSetUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<SizeConstraintSetUpdate.Builder, SizeConstraintSetUpdate> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SizeConstraintSetUpdate::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<SizeConstraint> SIZE_CONSTRAINT_FIELD = SdkField
            .<SizeConstraint> builder(MarshallingType.SDK_POJO).getter(getter(SizeConstraintSetUpdate::sizeConstraint))
            .setter(setter(Builder::sizeConstraint)).constructor(SizeConstraint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeConstraint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            SIZE_CONSTRAINT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private final SizeConstraint sizeConstraint;

    private SizeConstraintSetUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.sizeConstraint = builder.sizeConstraint;
    }

    /**
     * <p>
     * Specify <code>INSERT</code> to add a <a>SizeConstraintSetUpdate</a> to a <a>SizeConstraintSet</a>. Use
     * <code>DELETE</code> to remove a <code>SizeConstraintSetUpdate</code> from a <code>SizeConstraintSet</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specify <code>INSERT</code> to add a <a>SizeConstraintSetUpdate</a> to a <a>SizeConstraintSet</a>. Use
     *         <code>DELETE</code> to remove a <code>SizeConstraintSetUpdate</code> from a
     *         <code>SizeConstraintSet</code>.
     * @see ChangeAction
     */
    public ChangeAction action() {
        return ChangeAction.fromValue(action);
    }

    /**
     * <p>
     * Specify <code>INSERT</code> to add a <a>SizeConstraintSetUpdate</a> to a <a>SizeConstraintSet</a>. Use
     * <code>DELETE</code> to remove a <code>SizeConstraintSetUpdate</code> from a <code>SizeConstraintSet</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specify <code>INSERT</code> to add a <a>SizeConstraintSetUpdate</a> to a <a>SizeConstraintSet</a>. Use
     *         <code>DELETE</code> to remove a <code>SizeConstraintSetUpdate</code> from a
     *         <code>SizeConstraintSet</code>.
     * @see ChangeAction
     */
    public String actionAsString() {
        return action;
    }

    /**
     * <p>
     * Specifies a constraint on the size of a part of the web request. AWS WAF uses the <code>Size</code>,
     * <code>ComparisonOperator</code>, and <code>FieldToMatch</code> to build an expression in the form of "
     * <code>Size</code> <code>ComparisonOperator</code> size in bytes of <code>FieldToMatch</code>". If that expression
     * is true, the <code>SizeConstraint</code> is considered to match.
     * </p>
     * 
     * @return Specifies a constraint on the size of a part of the web request. AWS WAF uses the <code>Size</code>,
     *         <code>ComparisonOperator</code>, and <code>FieldToMatch</code> to build an expression in the form of "
     *         <code>Size</code> <code>ComparisonOperator</code> size in bytes of <code>FieldToMatch</code>". If that
     *         expression is true, the <code>SizeConstraint</code> is considered to match.
     */
    public SizeConstraint sizeConstraint() {
        return sizeConstraint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sizeConstraint());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SizeConstraintSetUpdate)) {
            return false;
        }
        SizeConstraintSetUpdate other = (SizeConstraintSetUpdate) obj;
        return Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(sizeConstraint(), other.sizeConstraint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SizeConstraintSetUpdate").add("Action", actionAsString())
                .add("SizeConstraint", sizeConstraint()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "SizeConstraint":
            return Optional.ofNullable(clazz.cast(sizeConstraint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SizeConstraintSetUpdate, T> g) {
        return obj -> g.apply((SizeConstraintSetUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SizeConstraintSetUpdate> {
        /**
         * <p>
         * Specify <code>INSERT</code> to add a <a>SizeConstraintSetUpdate</a> to a <a>SizeConstraintSet</a>. Use
         * <code>DELETE</code> to remove a <code>SizeConstraintSetUpdate</code> from a <code>SizeConstraintSet</code>.
         * </p>
         * 
         * @param action
         *        Specify <code>INSERT</code> to add a <a>SizeConstraintSetUpdate</a> to a <a>SizeConstraintSet</a>. Use
         *        <code>DELETE</code> to remove a <code>SizeConstraintSetUpdate</code> from a
         *        <code>SizeConstraintSet</code>.
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(String action);

        /**
         * <p>
         * Specify <code>INSERT</code> to add a <a>SizeConstraintSetUpdate</a> to a <a>SizeConstraintSet</a>. Use
         * <code>DELETE</code> to remove a <code>SizeConstraintSetUpdate</code> from a <code>SizeConstraintSet</code>.
         * </p>
         * 
         * @param action
         *        Specify <code>INSERT</code> to add a <a>SizeConstraintSetUpdate</a> to a <a>SizeConstraintSet</a>. Use
         *        <code>DELETE</code> to remove a <code>SizeConstraintSetUpdate</code> from a
         *        <code>SizeConstraintSet</code>.
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(ChangeAction action);

        /**
         * <p>
         * Specifies a constraint on the size of a part of the web request. AWS WAF uses the <code>Size</code>,
         * <code>ComparisonOperator</code>, and <code>FieldToMatch</code> to build an expression in the form of "
         * <code>Size</code> <code>ComparisonOperator</code> size in bytes of <code>FieldToMatch</code>". If that
         * expression is true, the <code>SizeConstraint</code> is considered to match.
         * </p>
         * 
         * @param sizeConstraint
         *        Specifies a constraint on the size of a part of the web request. AWS WAF uses the <code>Size</code>,
         *        <code>ComparisonOperator</code>, and <code>FieldToMatch</code> to build an expression in the form of "
         *        <code>Size</code> <code>ComparisonOperator</code> size in bytes of <code>FieldToMatch</code>". If that
         *        expression is true, the <code>SizeConstraint</code> is considered to match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeConstraint(SizeConstraint sizeConstraint);

        /**
         * <p>
         * Specifies a constraint on the size of a part of the web request. AWS WAF uses the <code>Size</code>,
         * <code>ComparisonOperator</code>, and <code>FieldToMatch</code> to build an expression in the form of "
         * <code>Size</code> <code>ComparisonOperator</code> size in bytes of <code>FieldToMatch</code>". If that
         * expression is true, the <code>SizeConstraint</code> is considered to match.
         * </p>
         * This is a convenience that creates an instance of the {@link SizeConstraint.Builder} avoiding the need to
         * create one manually via {@link SizeConstraint#builder()}.
         *
         * When the {@link Consumer} completes, {@link SizeConstraint.Builder#build()} is called immediately and its
         * result is passed to {@link #sizeConstraint(SizeConstraint)}.
         * 
         * @param sizeConstraint
         *        a consumer that will call methods on {@link SizeConstraint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sizeConstraint(SizeConstraint)
         */
        default Builder sizeConstraint(Consumer<SizeConstraint.Builder> sizeConstraint) {
            return sizeConstraint(SizeConstraint.builder().applyMutation(sizeConstraint).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private SizeConstraint sizeConstraint;

        private BuilderImpl() {
        }

        private BuilderImpl(SizeConstraintSetUpdate model) {
            action(model.action);
            sizeConstraint(model.sizeConstraint);
        }

        public final String getActionAsString() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final SizeConstraint.Builder getSizeConstraint() {
            return sizeConstraint != null ? sizeConstraint.toBuilder() : null;
        }

        @Override
        public final Builder sizeConstraint(SizeConstraint sizeConstraint) {
            this.sizeConstraint = sizeConstraint;
            return this;
        }

        public final void setSizeConstraint(SizeConstraint.BuilderImpl sizeConstraint) {
            this.sizeConstraint = sizeConstraint != null ? sizeConstraint.build() : null;
        }

        @Override
        public SizeConstraintSetUpdate build() {
            return new SizeConstraintSetUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
