/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * In an <a>UpdateRegexMatchSet</a> request, <code>RegexMatchSetUpdate</code> specifies whether to insert or delete a
 * <a>RegexMatchTuple</a> and includes the settings for the <code>RegexMatchTuple</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegexMatchSetUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<RegexMatchSetUpdate.Builder, RegexMatchSetUpdate> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegexMatchSetUpdate::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<RegexMatchTuple> REGEX_MATCH_TUPLE_FIELD = SdkField
            .<RegexMatchTuple> builder(MarshallingType.SDK_POJO).getter(getter(RegexMatchSetUpdate::regexMatchTuple))
            .setter(setter(Builder::regexMatchTuple)).constructor(RegexMatchTuple::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexMatchTuple").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            REGEX_MATCH_TUPLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private final RegexMatchTuple regexMatchTuple;

    private RegexMatchSetUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.regexMatchTuple = builder.regexMatchTuple;
    }

    /**
     * <p>
     * Specifies whether to insert or delete a <a>RegexMatchTuple</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies whether to insert or delete a <a>RegexMatchTuple</a>.
     * @see ChangeAction
     */
    public ChangeAction action() {
        return ChangeAction.fromValue(action);
    }

    /**
     * <p>
     * Specifies whether to insert or delete a <a>RegexMatchTuple</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies whether to insert or delete a <a>RegexMatchTuple</a>.
     * @see ChangeAction
     */
    public String actionAsString() {
        return action;
    }

    /**
     * <p>
     * Information about the part of a web request that you want AWS WAF to inspect and the identifier of the regular
     * expression (regex) pattern that you want AWS WAF to search for. If you specify <code>DELETE</code> for the value
     * of <code>Action</code>, the <code>RegexMatchTuple</code> values must exactly match the values in the
     * <code>RegexMatchTuple</code> that you want to delete from the <code>RegexMatchSet</code>.
     * </p>
     * 
     * @return Information about the part of a web request that you want AWS WAF to inspect and the identifier of the
     *         regular expression (regex) pattern that you want AWS WAF to search for. If you specify
     *         <code>DELETE</code> for the value of <code>Action</code>, the <code>RegexMatchTuple</code> values must
     *         exactly match the values in the <code>RegexMatchTuple</code> that you want to delete from the
     *         <code>RegexMatchSet</code>.
     */
    public RegexMatchTuple regexMatchTuple() {
        return regexMatchTuple;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(regexMatchTuple());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegexMatchSetUpdate)) {
            return false;
        }
        RegexMatchSetUpdate other = (RegexMatchSetUpdate) obj;
        return Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(regexMatchTuple(), other.regexMatchTuple());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RegexMatchSetUpdate").add("Action", actionAsString()).add("RegexMatchTuple", regexMatchTuple())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "RegexMatchTuple":
            return Optional.ofNullable(clazz.cast(regexMatchTuple()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegexMatchSetUpdate, T> g) {
        return obj -> g.apply((RegexMatchSetUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegexMatchSetUpdate> {
        /**
         * <p>
         * Specifies whether to insert or delete a <a>RegexMatchTuple</a>.
         * </p>
         * 
         * @param action
         *        Specifies whether to insert or delete a <a>RegexMatchTuple</a>.
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(String action);

        /**
         * <p>
         * Specifies whether to insert or delete a <a>RegexMatchTuple</a>.
         * </p>
         * 
         * @param action
         *        Specifies whether to insert or delete a <a>RegexMatchTuple</a>.
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(ChangeAction action);

        /**
         * <p>
         * Information about the part of a web request that you want AWS WAF to inspect and the identifier of the
         * regular expression (regex) pattern that you want AWS WAF to search for. If you specify <code>DELETE</code>
         * for the value of <code>Action</code>, the <code>RegexMatchTuple</code> values must exactly match the values
         * in the <code>RegexMatchTuple</code> that you want to delete from the <code>RegexMatchSet</code>.
         * </p>
         * 
         * @param regexMatchTuple
         *        Information about the part of a web request that you want AWS WAF to inspect and the identifier of the
         *        regular expression (regex) pattern that you want AWS WAF to search for. If you specify
         *        <code>DELETE</code> for the value of <code>Action</code>, the <code>RegexMatchTuple</code> values must
         *        exactly match the values in the <code>RegexMatchTuple</code> that you want to delete from the
         *        <code>RegexMatchSet</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexMatchTuple(RegexMatchTuple regexMatchTuple);

        /**
         * <p>
         * Information about the part of a web request that you want AWS WAF to inspect and the identifier of the
         * regular expression (regex) pattern that you want AWS WAF to search for. If you specify <code>DELETE</code>
         * for the value of <code>Action</code>, the <code>RegexMatchTuple</code> values must exactly match the values
         * in the <code>RegexMatchTuple</code> that you want to delete from the <code>RegexMatchSet</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link RegexMatchTuple.Builder} avoiding the need to
         * create one manually via {@link RegexMatchTuple#builder()}.
         *
         * When the {@link Consumer} completes, {@link RegexMatchTuple.Builder#build()} is called immediately and its
         * result is passed to {@link #regexMatchTuple(RegexMatchTuple)}.
         * 
         * @param regexMatchTuple
         *        a consumer that will call methods on {@link RegexMatchTuple.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regexMatchTuple(RegexMatchTuple)
         */
        default Builder regexMatchTuple(Consumer<RegexMatchTuple.Builder> regexMatchTuple) {
            return regexMatchTuple(RegexMatchTuple.builder().applyMutation(regexMatchTuple).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private RegexMatchTuple regexMatchTuple;

        private BuilderImpl() {
        }

        private BuilderImpl(RegexMatchSetUpdate model) {
            action(model.action);
            regexMatchTuple(model.regexMatchTuple);
        }

        public final String getActionAsString() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final RegexMatchTuple.Builder getRegexMatchTuple() {
            return regexMatchTuple != null ? regexMatchTuple.toBuilder() : null;
        }

        @Override
        public final Builder regexMatchTuple(RegexMatchTuple regexMatchTuple) {
            this.regexMatchTuple = regexMatchTuple;
            return this;
        }

        public final void setRegexMatchTuple(RegexMatchTuple.BuilderImpl regexMatchTuple) {
            this.regexMatchTuple = regexMatchTuple != null ? regexMatchTuple.build() : null;
        }

        @Override
        public RegexMatchSetUpdate build() {
            return new RegexMatchSetUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
