/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListByteMatchSetsResponse extends WafResponse implements
        ToCopyableBuilder<ListByteMatchSetsResponse.Builder, ListByteMatchSetsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListByteMatchSetsResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final SdkField<List<ByteMatchSetSummary>> BYTE_MATCH_SETS_FIELD = SdkField
            .<List<ByteMatchSetSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListByteMatchSetsResponse::byteMatchSets))
            .setter(setter(Builder::byteMatchSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ByteMatchSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ByteMatchSetSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ByteMatchSetSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD,
            BYTE_MATCH_SETS_FIELD));

    private final String nextMarker;

    private final List<ByteMatchSetSummary> byteMatchSets;

    private ListByteMatchSetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.byteMatchSets = builder.byteMatchSets;
    }

    /**
     * <p>
     * If you have more <code>ByteMatchSet</code> objects than the number that you specified for <code>Limit</code> in
     * the request, the response includes a <code>NextMarker</code> value. To list more <code>ByteMatchSet</code>
     * objects, submit another <code>ListByteMatchSets</code> request, and specify the <code>NextMarker</code> value
     * from the response in the <code>NextMarker</code> value in the next request.
     * </p>
     * 
     * @return If you have more <code>ByteMatchSet</code> objects than the number that you specified for
     *         <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more
     *         <code>ByteMatchSet</code> objects, submit another <code>ListByteMatchSets</code> request, and specify the
     *         <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.
     */
    public String nextMarker() {
        return nextMarker;
    }

    /**
     * Returns true if the ByteMatchSets property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasByteMatchSets() {
        return byteMatchSets != null && !(byteMatchSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <a>ByteMatchSetSummary</a> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasByteMatchSets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <a>ByteMatchSetSummary</a> objects.
     */
    public List<ByteMatchSetSummary> byteMatchSets() {
        return byteMatchSets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(byteMatchSets());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListByteMatchSetsResponse)) {
            return false;
        }
        ListByteMatchSetsResponse other = (ListByteMatchSetsResponse) obj;
        return Objects.equals(nextMarker(), other.nextMarker()) && Objects.equals(byteMatchSets(), other.byteMatchSets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListByteMatchSetsResponse").add("NextMarker", nextMarker())
                .add("ByteMatchSets", byteMatchSets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "ByteMatchSets":
            return Optional.ofNullable(clazz.cast(byteMatchSets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListByteMatchSetsResponse, T> g) {
        return obj -> g.apply((ListByteMatchSetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListByteMatchSetsResponse> {
        /**
         * <p>
         * If you have more <code>ByteMatchSet</code> objects than the number that you specified for <code>Limit</code>
         * in the request, the response includes a <code>NextMarker</code> value. To list more <code>ByteMatchSet</code>
         * objects, submit another <code>ListByteMatchSets</code> request, and specify the <code>NextMarker</code> value
         * from the response in the <code>NextMarker</code> value in the next request.
         * </p>
         * 
         * @param nextMarker
         *        If you have more <code>ByteMatchSet</code> objects than the number that you specified for
         *        <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more
         *        <code>ByteMatchSet</code> objects, submit another <code>ListByteMatchSets</code> request, and specify
         *        the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * An array of <a>ByteMatchSetSummary</a> objects.
         * </p>
         * 
         * @param byteMatchSets
         *        An array of <a>ByteMatchSetSummary</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byteMatchSets(Collection<ByteMatchSetSummary> byteMatchSets);

        /**
         * <p>
         * An array of <a>ByteMatchSetSummary</a> objects.
         * </p>
         * 
         * @param byteMatchSets
         *        An array of <a>ByteMatchSetSummary</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byteMatchSets(ByteMatchSetSummary... byteMatchSets);

        /**
         * <p>
         * An array of <a>ByteMatchSetSummary</a> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ByteMatchSetSummary>.Builder} avoiding the
         * need to create one manually via {@link List<ByteMatchSetSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ByteMatchSetSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #byteMatchSets(List<ByteMatchSetSummary>)}.
         * 
         * @param byteMatchSets
         *        a consumer that will call methods on {@link List<ByteMatchSetSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #byteMatchSets(List<ByteMatchSetSummary>)
         */
        Builder byteMatchSets(Consumer<ByteMatchSetSummary.Builder>... byteMatchSets);
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private String nextMarker;

        private List<ByteMatchSetSummary> byteMatchSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListByteMatchSetsResponse model) {
            super(model);
            nextMarker(model.nextMarker);
            byteMatchSets(model.byteMatchSets);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<ByteMatchSetSummary.Builder> getByteMatchSets() {
            return byteMatchSets != null ? byteMatchSets.stream().map(ByteMatchSetSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder byteMatchSets(Collection<ByteMatchSetSummary> byteMatchSets) {
            this.byteMatchSets = ByteMatchSetSummariesCopier.copy(byteMatchSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder byteMatchSets(ByteMatchSetSummary... byteMatchSets) {
            byteMatchSets(Arrays.asList(byteMatchSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder byteMatchSets(Consumer<ByteMatchSetSummary.Builder>... byteMatchSets) {
            byteMatchSets(Stream.of(byteMatchSets).map(c -> ByteMatchSetSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setByteMatchSets(Collection<ByteMatchSetSummary.BuilderImpl> byteMatchSets) {
            this.byteMatchSets = ByteMatchSetSummariesCopier.copyFromBuilder(byteMatchSets);
        }

        @Override
        public ListByteMatchSetsResponse build() {
            return new ListByteMatchSetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
