/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWebAclResponse extends WafResponse implements
        ToCopyableBuilder<GetWebAclResponse.Builder, GetWebAclResponse> {
    private static final SdkField<WebACL> WEB_ACL_FIELD = SdkField.<WebACL> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetWebAclResponse::webACL)).setter(setter(Builder::webACL)).constructor(WebACL::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACL").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_ACL_FIELD));

    private final WebACL webACL;

    private GetWebAclResponse(BuilderImpl builder) {
        super(builder);
        this.webACL = builder.webACL;
    }

    /**
     * <p>
     * Information about the <a>WebACL</a> that you specified in the <code>GetWebACL</code> request. For more
     * information, see the following topics:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>WebACL</a>: Contains <code>DefaultAction</code>, <code>MetricName</code>, <code>Name</code>, an array of
     * <code>Rule</code> objects, and <code>WebACLId</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DefaultAction</code> (Data type is <a>WafAction</a>): Contains <code>Type</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Rules</code>: Contains an array of <code>ActivatedRule</code> objects, which contain <code>Action</code>,
     * <code>Priority</code>, and <code>RuleId</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Action</code>: Contains <code>Type</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return Information about the <a>WebACL</a> that you specified in the <code>GetWebACL</code> request. For more
     *         information, see the following topics:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a>WebACL</a>: Contains <code>DefaultAction</code>, <code>MetricName</code>, <code>Name</code>, an array
     *         of <code>Rule</code> objects, and <code>WebACLId</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DefaultAction</code> (Data type is <a>WafAction</a>): Contains <code>Type</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Rules</code>: Contains an array of <code>ActivatedRule</code> objects, which contain
     *         <code>Action</code>, <code>Priority</code>, and <code>RuleId</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Action</code>: Contains <code>Type</code>
     *         </p>
     *         </li>
     */
    public WebACL webACL() {
        return webACL;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(webACL());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWebAclResponse)) {
            return false;
        }
        GetWebAclResponse other = (GetWebAclResponse) obj;
        return Objects.equals(webACL(), other.webACL());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetWebAclResponse").add("WebACL", webACL()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebACL":
            return Optional.ofNullable(clazz.cast(webACL()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWebAclResponse, T> g) {
        return obj -> g.apply((GetWebAclResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetWebAclResponse> {
        /**
         * <p>
         * Information about the <a>WebACL</a> that you specified in the <code>GetWebACL</code> request. For more
         * information, see the following topics:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>WebACL</a>: Contains <code>DefaultAction</code>, <code>MetricName</code>, <code>Name</code>, an array of
         * <code>Rule</code> objects, and <code>WebACLId</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DefaultAction</code> (Data type is <a>WafAction</a>): Contains <code>Type</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Rules</code>: Contains an array of <code>ActivatedRule</code> objects, which contain
         * <code>Action</code>, <code>Priority</code>, and <code>RuleId</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Action</code>: Contains <code>Type</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param webACL
         *        Information about the <a>WebACL</a> that you specified in the <code>GetWebACL</code> request. For more
         *        information, see the following topics:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a>WebACL</a>: Contains <code>DefaultAction</code>, <code>MetricName</code>, <code>Name</code>, an
         *        array of <code>Rule</code> objects, and <code>WebACLId</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DefaultAction</code> (Data type is <a>WafAction</a>): Contains <code>Type</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Rules</code>: Contains an array of <code>ActivatedRule</code> objects, which contain
         *        <code>Action</code>, <code>Priority</code>, and <code>RuleId</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Action</code>: Contains <code>Type</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webACL(WebACL webACL);

        /**
         * <p>
         * Information about the <a>WebACL</a> that you specified in the <code>GetWebACL</code> request. For more
         * information, see the following topics:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>WebACL</a>: Contains <code>DefaultAction</code>, <code>MetricName</code>, <code>Name</code>, an array of
         * <code>Rule</code> objects, and <code>WebACLId</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DefaultAction</code> (Data type is <a>WafAction</a>): Contains <code>Type</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Rules</code>: Contains an array of <code>ActivatedRule</code> objects, which contain
         * <code>Action</code>, <code>Priority</code>, and <code>RuleId</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Action</code>: Contains <code>Type</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link WebACL.Builder} avoiding the need to create one
         * manually via {@link WebACL#builder()}.
         *
         * When the {@link Consumer} completes, {@link WebACL.Builder#build()} is called immediately and its result is
         * passed to {@link #webACL(WebACL)}.
         * 
         * @param webACL
         *        a consumer that will call methods on {@link WebACL.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webACL(WebACL)
         */
        default Builder webACL(Consumer<WebACL.Builder> webACL) {
            return webACL(WebACL.builder().applyMutation(webACL).build());
        }
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private WebACL webACL;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWebAclResponse model) {
            super(model);
            webACL(model.webACL);
        }

        public final WebACL.Builder getWebACL() {
            return webACL != null ? webACL.toBuilder() : null;
        }

        @Override
        public final Builder webACL(WebACL webACL) {
            this.webACL = webACL;
            return this;
        }

        public final void setWebACL(WebACL.BuilderImpl webACL) {
            this.webACL = webACL != null ? webACL.build() : null;
        }

        @Override
        public GetWebAclResponse build() {
            return new GetWebAclResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
