/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class GeoMatchSetUpdatesCopier {
    static List<GeoMatchSetUpdate> copy(Collection<GeoMatchSetUpdate> geoMatchSetUpdatesParam) {
        if (geoMatchSetUpdatesParam == null || geoMatchSetUpdatesParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<GeoMatchSetUpdate> geoMatchSetUpdatesParamCopy = new ArrayList<>(geoMatchSetUpdatesParam);
        return Collections.unmodifiableList(geoMatchSetUpdatesParamCopy);
    }

    static List<GeoMatchSetUpdate> copyFromBuilder(Collection<? extends GeoMatchSetUpdate.Builder> geoMatchSetUpdatesParam) {
        if (geoMatchSetUpdatesParam == null) {
            return null;
        }
        return copy(geoMatchSetUpdatesParam.stream().map(GeoMatchSetUpdate.Builder::build).collect(toList()));
    }
}
